#cs ----------------------------------------------------------------------------
Copyright  2006-2007 CreatoR's Lab (G.Sandler).

Descriptions: KeyBoard and Mouse cleaner
Requirement(s): Files; BASSMOD.dll, KM_Cleaner_Snd.xm, Icon.ico, KM_Cleaner_Lang.lng.
AutoIt Version: 3.2.8.1 and higher
#ce ----------------------------------------------------------------------------

#NoTrayIcon
#include <Guiconstants.au3>
#include <Date.au3>
#include <Misc.au3>
#include <File.au3>
Opt("GuiOnEventMode", 1)
Opt("ExpandVarStrings", 1)
Opt("WinTitleMatchMode", 4)
Opt("GUIResizeMode", 802)

If @OSVersion = "WIN_95" Or (@OSVersion = "WIN_NT4" And @OSServicePack <> "Service Pack 6") Then
	MsgBox(262144+16, "Error", _
	"This program can not be run under <Windows 95> or <Windows NT4 (without SP6)> platform, sorry.@LF@@LF@OK   --->   EXIT", 30)
	Exit
EndIf

;========================================================================

#Region ------ Global Declaration and Settings ------
Global $Temp_Dir = _TempFile(@TempDir, "~KM_Cleaner_")
DirCreate($Temp_Dir)

FileInstall("Resources\KM_Cleaner_Snd.xm", $Temp_Dir & "\", 1)
FileInstall("Resources\BASSMOD.dll", $Temp_Dir & "\", 1)
FileInstall("Resources\KM_Cleaner_Lang.lng", @ScriptDir & "\KM_Cleaner_Lang.lng")

Global $DTM_SETFORMAT = 0x1005
If @UNICODE Then $DTM_SETFORMAT = 0x1032

Global $XS_n			= -1
Global $Dll_Handle 		= -1
Global $DllPath 		= $Temp_Dir & "\BASSMOD.dll"
Global $SoundPath 		= $Temp_Dir & "\KM_Cleaner_Snd.xm"
Global $SoundPaused		= False

Global $LangsList		= ""
Global $LngSectIsExists	= 0
Global $Translate_Combo
Global $Lang_Label
Global $TimeRem_Label

Global $BackColor = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "BackColor")
If StringLeft($BackColor, 2) <> "0x" Then $BackColor = 0xFFFFFF

Global $IconFile = "Icon.ico"
If @Compiled Then $IconFile = @ScriptFullPath

Global $ShowPrefs = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "ShowPrefs")
Global $IsOnTop = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "OnTop")

Global $LangFile = @ScriptDir & "\KM_Cleaner_Lang.lng"
$LngReadSectVar = IniRead($LangFile, "Info", "Language Section", "")
$LngSectionName = "Translation_$LngReadSectVar$"

Global $PlaySoundRead = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "PlaySound")
If @error <> 0 Then $PlaySoundRead = 1
	
Global $SaveSettingsRead = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Save Settings")

Global $MsgBox = _Translation($LangFile)

$LngSectArr = IniReadSectionNames($LangFile)
If IsArray($LngSectArr) Then
	For $i = 1 To $LngSectArr[0]
		If IniReadSection($LangFile, $LngSectArr[$i]) <> @error And StringLeft($LngSectArr[$i], 12) = "Translation_" Then
			$LangsList &= StringReplace($LngSectArr[$i], "Translation_", "") & "|"
			$LngSectIsExists = 1
		EndIf
	Next
EndIf

Global $AppVersion = "1.2"
Global $AppName = StringReplace($MsgBox[1], "%Ver", "v" & $AppVersion)
#EndRegion Global Declaration and Settings
;

#Region ------ Gui Creation Part ------
$Gui = GuiCreate($AppName, 335, 420, -1, -1, $WS_SYSMENU, $WS_EX_TOPMOST+$WS_EX_APPWINDOW+$WS_EX_CLIENTEDGE)
GUISetBkColor($BackColor)
GUISetOnEvent(-3, "ExitScript")
GUIRegisterMsg(0x0201, "DRAG_COMMAND")

GUISetIcon($IconFile, 0, $Gui)

GUICtrlCreateIcon($IconFile, 0, 10, 60, -1, -1, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetState(-1, 128)

$Main_Label = GUICtrlCreateLabel($MsgBox[2], 25, 5, 280, 50, 1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 10, 600, 0, "Georgia")

$Time_Label = GUICtrlCreateLabel($MsgBox[3], 70, 63, 55, -1, -1, $GUI_WS_EX_PARENTDRAG)

$TimeDelim = _GetTimeDelim(_NowTime(5))
$TimeRem_Label = GUICtrlCreateLabel($MsgBox[4] & "00$TimeDelim$00$TimeDelim$00", 120, 130, 150, -1, -1, $GUI_WS_EX_PARENTDRAG)

$Progress = GUICtrlCreateProgress(20, 150, 290, 15)
GUICtrlSetState(-1, 128)

$TimeCtrl = GUICtrlCreateDate("", 130, 60, 100, 20, $DTS_TIMEFORMAT)
GUICtrlSetState(-1, $GUI_FOCUS)

GuiCtrlSendMsg($TimeCtrl, $DTM_SETFORMAT, 0, "HH:mm:ss")

$Prefs_Button = GUICtrlCreateButton($MsgBox[21], 15, 170, 130, 23)
GUICtrlSetOnEvent(-1, "MainEvents")

If $ShowPrefs = 1 Then GUICtrlSetData($Prefs_Button, $MsgBox[22])


;-----Preferences-----

$Prefs_Group = GUICtrlCreateGroup($MsgBox[19], 15, 215, 300, 160)

$Transp_Slider_Label = GUICtrlCreateLabel($MsgBox[18], 25, 237, 90, -1, -1, $GUI_WS_EX_PARENTDRAG)
$Transp_Slider = GUICtrlCreateSlider(115, 235, 190)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetLimit(-1, 200, 1)
GUICtrlSetBkColor($Transp_Slider, $BackColor)

$SliderPos = GUICtrlRead($Transp_Slider)
$RegReadSldrPos = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Transparent")
If $RegReadSldrPos <> "" Then GUICtrlSetData($Transp_Slider, $RegReadSldrPos)

If $LngSectIsExists = 1 Then
	$Lang_Label = GUICtrlCreateLabel($MsgBox[17], 25, 276, 60, -1, -1, $GUI_WS_EX_PARENTDRAG)
	$Translate_Combo = GUICtrlCreateCombo("", 100, 273, 130, -1, $CBS_DROPDOWNLIST)
	GUICtrlSetData(-1, $LangsList, IniRead($LangFile, "Info", "Language Section", ""))
	GUICtrlSetOnEvent(-1, "MainEvents")
EndIf

$Color_Choose_Button = GUICtrlCreateButton("", 260, 320, 40, 40, $BS_ICON)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, $MsgBox[15], "...", 1, 1)
GUICtrlSetImage(-1, "mspaint.exe", 0)

_XPStyleToggle(1)

$SoundPlay_CheckBox = GUICtrlCreateCheckbox($MsgBox[20], 25, 300, 230)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetFont(-1, 8, 400)
GUICtrlSetTip(-1, $MsgBox[20])

If $PlaySoundRead = 1 Then
	GUICtrlSetState(-1, 1)
	$Dll_Handle = BASSMOD_Open($DllPath, $SoundPath, 1024+4, 60)
EndIf

$SetOnTop_CheckBox = GUICtrlCreateCheckbox($MsgBox[23], 25, 320, 230)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetFont(-1, 8, 400)
GUICtrlSetTip(-1, $MsgBox[23])

$SaveSettings_CheckBox = GUICtrlCreateCheckbox($MsgBox[24], 25, 340, 230)
GUICtrlSetFont(-1, 8, 400)
GUICtrlSetTip(-1, $MsgBox[25])
If $SaveSettingsRead = 1 Then GUICtrlSetState(-1, 1)

_XPStyleToggle(0)

$Ok_Button = GUICtrlCreateButton($MsgBox[5], 90, 100, 70, 23, $BS_DEFPUSHBUTTON)
GUICtrlSetOnEvent(-1, "MainEvents")

$Exit_Button = GUICtrlCreateButton($MsgBox[6], 190, 100, 70, 23)
GUICtrlSetOnEvent(-1, "ExitScript")
#EndRegion -----Gui Creation Part-----
;

#Region ------ Startup Settings ------
If $IsOnTop = 0 Then
	WinSetOnTop($Gui, "", 0)
Else
	GUICtrlSetState($SetOnTop_CheckBox, 1)
EndIf

If $ShowPrefs = 0 Then
	$NewRetPos = _TogglePrefs(1)
	WinMove($Gui, "", $NewRetPos[0], (@DesktopHeight/2) - ($NewRetPos[1]/2))
EndIf

_CheckBkColor($BackColor)

WinSetTrans($Gui, "", 0)
GUISetState()

For $i = 0 To 255-GUICtrlRead($Transp_Slider) Step 2
	WinSetTrans($Gui, "", $i)
Next

_ReduceMemory(@AutoItPID)
#EndRegion -----Startup Settings-----
;

While 1
	Sleep(10)
	If $SliderPos <> GUICtrlRead($Transp_Slider) And GUICtrlRead($Transp_Slider) > 0 Then
		$SliderPos = GUICtrlRead($Transp_Slider)
		WinSetTrans($AppName, "", 255-GUICtrlRead($Transp_Slider))
	EndIf
WEnd

Func MainEvents()
	Switch @GUI_CtrlId
		Case $Ok_Button
			$SetTime = GUICtrlRead($TimeCtrl)
			$NowTime = _NowTime(5)
			$TimeToClean = _TimeRemained($SetTime, $NowTime)
			$Ask = 6
			
			If _TimeToSecs($TimeToClean, $TimeDelim) > 7200 Then
				$sMsg = StringReplace($MsgBox[8], "%ST", $SetTime)
				$sMsg = StringReplace($sMsg, "%NT", $NowTime)
				$sMsg = StringReplace($sMsg, "%TTC", $TimeToClean)
				
				$CheckBox_Text = -1
				If GUICtrlRead($SaveSettings_CheckBox) = 1 Then
					$Alert_On_Cleaning = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Alert On Long Time Cleaning")
					If @error <> 0 Or $Alert_On_Cleaning = "" Then $CheckBox_Text = $MsgBox[30]
				EndIf
				
				If $CheckBox_Text <> -1 Or GUICtrlRead($SaveSettings_CheckBox) <> 1 Then _
					$Ask = _GuiMsgBox(256+48, 2, $MsgBox[7], $sMsg, 520, 100, $CheckBox_Text, -1, $Gui, $MsgBox[28], $MsgBox[29])
			EndIf
			
			$CheckBitAnd = BitAND($Ask, 8)
			
			If $Ask - $CheckBitAnd = 6 Then
				$PosOfMouse = MouseGetPos()
				$X = @DesktopWidth/2
				$Y = (@DesktopHeight/2) + 33
				$Message = _CleanProc($SetTime)
				ToolTip("")
				MouseMove($X, $Y, 1)
				GUICtrlSetData($Main_Label, $MsgBox[2])
				GUICtrlSetData($TimeRem_Label, $MsgBox[4] & "00$TimeDelim$00$TimeDelim$00")
				_CheckBkColor($BackColor)
				_GuiMsgBox(64, 1, $MsgBox[10], $MsgBox[11] & " ($Message$ ;-) )", 380, 120, -1, -1, $Gui, $MsgBox[26])
				_Refresh_Gui($Gui)
			EndIf
			
			If $CheckBitAnd = 8 Then RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", _
				"Alert On Long Time Cleaning", "REG_SZ", 0)
		Case $Color_Choose_Button
			$ColorVar = _ChooseColor(2, $BackColor, 2, $Gui)
			If Not @error Then
				$BackColor = $ColorVar
				GUISetBkColor($BackColor)
				GUICtrlSetBkColor($Transp_Slider, $BackColor)
				_CheckBkColor($BackColor)
				RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "BackColor", "REG_SZ", $ColorVar)
			EndIf
		Case $Translate_Combo
			If $LngSectIsExists = 1 Then
				$LngRead = GUICtrlRead($Translate_Combo)
				$LngSectionName = "Translation_$LngRead$"
				$OldTitle = $AppName
				$MsgBox = _Translation($LangFile)
				$AppName = StringReplace($MsgBox[1], "%Ver", "v" & $AppVersion)
				WinSetTitle($OldTitle, "", $AppName)
				GUICtrlSetData($Main_Label, $MsgBox[2])
				GUICtrlSetData($Time_Label, $MsgBox[3])
				GUICtrlSetData($TimeRem_Label, $MsgBox[4] & "00$TimeDelim$00$TimeDelim$00")
				GUICtrlSetData($Ok_Button, $MsgBox[5])
				GUICtrlSetData($Exit_Button, $MsgBox[6])
				GUICtrlSetTip($Color_Choose_Button, $MsgBox[15], "...", 1, 1)
				GUICtrlSetData($Lang_Label, $MsgBox[17])
				GUICtrlSetData($Transp_Slider_Label, $MsgBox[18])
				GUICtrlSetData($Prefs_Group, $MsgBox[19])
				GUICtrlSetData($SoundPlay_CheckBox, $MsgBox[20])
				GUICtrlSetTip($SoundPlay_CheckBox, $MsgBox[20])
				GUICtrlSetData($Prefs_Button, $MsgBox[22])
				GUICtrlSetData($SetOnTop_CheckBox, $MsgBox[23])
				GUICtrlSetTip($SetOnTop_CheckBox, $MsgBox[23])
				GUICtrlSetData($SaveSettings_CheckBox, $MsgBox[24])
				GUICtrlSetTip($SaveSettings_CheckBox, $MsgBox[25])
			EndIf
		Case $Transp_Slider
			$SliderPos = GUICtrlRead($Transp_Slider)
			If $SliderPos > 0 Then WinSetTrans($AppName, "", 255-$SliderPos)
		Case $Prefs_Button
			_TogglePrefs($ShowPrefs)
		Case $SetOnTop_CheckBox
			If GUICtrlRead($SetOnTop_CheckBox) = 1 Then
				WinSetOnTop($Gui, "", 1)
				$IsOnTop = 1
			Else
				WinSetOnTop($Gui, "", 0)
				$IsOnTop = 0
			EndIf
		Case $SoundPlay_CheckBox
			If GUICtrlRead($SoundPlay_CheckBox) = 1 Then
				If $SoundPaused Then
					BASSMOD_Play($Dll_Handle)
					$SoundPaused = False
				Else
					$Dll_Handle = BASSMOD_Open($DllPath, $SoundPath, 1024+4, 60)
				EndIf
			Else
				BASSMOD_Pause($Dll_Handle)
				$SoundPaused = True
			EndIf
	EndSwitch
	_ReduceMemory(@AutoItPID)
EndFunc

Func _CleanProc($DTime)
	BlockInput(1)
	
	Local $TaskMgrWasExec = ProcessExists("taskmgr.exe")
	Local $TaskMgrTitle = _GetTaskMgrTitle()
	Local $TaskMgrWasShown = _WinIsVisible($TaskMgrTitle)
	
	If $TaskMgrWasShown Then WinClose($TaskMgrTitle)
	
	ToolTip($MsgBox[12], 0, 0, $MsgBox[13], 1)
	GUICtrlSetData($TimeRem_Label, $MsgBox[4] & _TimeRemained($DTime, _NowTime(5)))
	GUICtrlSetData($Main_Label, $MsgBox[16])
	GUICtrlSetColor($Main_Label, 0x0036FF)
	
	Local $XBefore = 160
	Local $YBefore = 70
	MouseMove($XBefore, $YBefore)
	
	Local $TimeEquelNow = 0
	Local $sNow = _TimeRemained($DTime, _NowTime(5))
	Local $SecondsTotalRemained = _TimeToSecs($sNow, $TimeDelim)
	Local $Delim = 100 / $SecondsTotalRemained
	Local $Prgrs = 100
	
	GUICtrlSetData($Progress, $Prgrs)
	
	While 1
		$Prgrs -= $Delim
		GUICtrlSetData($TimeRem_Label, $MsgBox[4] & _TimeRemained($DTime, _NowTime(5)))
		GUICtrlSetData($Progress, $Prgrs)
		If GUICtrlRead($Progress) = 0 Then $Prgrs = 100
		Sleep(1000)
		$XAfter = MouseGetPos(0)
		$YAfter = MouseGetPos(1)
		If $XAfter <> $XBefore Or $YAfter <> $YBefore Or _WinIsVisible($TaskMgrTitle) Then ExitLoop
		If _NowTime(5) = $DTime Then
			$TimeEquelNow = 1
			ExitLoop
		EndIf
	WEnd
	
	GUICtrlSetData($Progress, 0)
	
	Local $Message = $MsgBox[9]
	If Not $TimeEquelNow Then $Message = $MsgBox[14]
	
	While Not _WinIsVisible($Gui)
		Sleep(10)
	WEnd
	
	$CheckTMProcExists = ProcessExists("taskmgr.exe")
	$TaskMgrTitle = _GetTaskMgrTitle()
	
	If $TaskMgrWasExec And Not $CheckTMProcExists Then Run("taskmgr.exe")
	If Not $TaskMgrWasExec And WinExists($TaskMgrTitle) Then WinClose($TaskMgrTitle)
	
	If $TaskMgrWasShown Then
		WinSetState($TaskMgrTitle, "", @SW_SHOW)
		GUISetState(@SW_RESTORE, $Gui)
	ElseIf $CheckTMProcExists And _WinIsVisible($TaskMgrTitle) Then
		WinSetState($TaskMgrTitle, "", @SW_MINIMIZE)
		GUISetState(@SW_RESTORE, $Gui)
	EndIf
	
	GUICtrlSetState($Main_Label, $Gui_HIDE)
	GUICtrlSetState($Main_Label, $Gui_SHOW)
	GUICtrlSetState($Progress, $GUI_HIDE)
	GUICtrlSetState($Progress, $GUI_SHOW)
	
	BlockInput(0)
	_ReduceMemory(@AutoItPID)
	Return $Message
EndFunc

Func _Translation($LangFile)
	Local $TrnsCount = 30
	Local $MsgBox[$TrnsCount+1]
	$MsgBox[1] = "KeyBoard and mouse Cleaner"
	$MsgBox[2] = "In what time you like to finish the cleaning of Keyboard and Mouse?"
	$MsgBox[3] = "Time:"
	$MsgBox[4] = "Remained: "
	$MsgBox[5] = "Clean"
	$MsgBox[6] = "Exit"
	$MsgBox[7] = "Attention"
	$MsgBox[8] = "The time that you set (%ST) is much later then 'Now' time (%NT),\n" & _
	"Are you sure that you want to clean so long? (%TTC) :)"
	$MsgBox[9] = "Time is out"
	$MsgBox[10] = "Complete..."
	$MsgBox[11] = "The cleaning is finished"
	$MsgBox[12] = "Now you can clean your KeyBoard and Mouse!\nIf you like to stop the cleaning, " & _
	"just press these hotkeys:\nCTRL+ALT+DELETE"
	$MsgBox[13] = "Start Cleaning..."
	$MsgBox[14] = "You decided to stop the cleaning"
	$MsgBox[15] = "Choose background color"
	$MsgBox[16] = "Clean your mouse and Keyboard... don't worry, the computer is OK! ;)"
	$MsgBox[17] = "Language:"
	$MsgBox[18] = "Transparent:"
	$MsgBox[19] = "Preferences"
	$MsgBox[20] = "Play Sound"
	$MsgBox[21] = "Show Options"
	$MsgBox[22] = "Hide Options"
	$MsgBox[23] = "Set On Top"
	$MsgBox[24] = "Remember Settings"
	$MsgBox[25] = "Set this checkbox to save program settings in Windows's Registry"
	$MsgBox[26] = "OK"
	$MsgBox[27] = "Cancel"
	$MsgBox[28] = "Yes"
	$MsgBox[29] = "No"
	$MsgBox[30] = "Do not ask again"
	
	For $iTr = 1 To $TrnsCount
		$MsgBox[$iTr] = StringReplace(IniRead($LangFile, $LngSectionName, "0" & $iTr, $MsgBox[$iTr]), "\n", @CRLF)
	Next
	Return $MsgBox
EndFunc

Func _TogglePrefs($ShowPrefsMode)
	Local $HeightPos = 245
	Local $DataMsg = $MsgBox[21]
	Local $STATE = $GUI_HIDE
	
	If $ShowPrefsMode = 0 Then
		$ShowPrefs = 1
		$HeightPos = 425
		$DataMsg = $MsgBox[22]
		$STATE = $GUI_SHOW
	Else
		$ShowPrefs = 0
	EndIf
	
	GUICtrlSetData($Prefs_Button, $DataMsg)
	
	Local $GetGuiPos = WinGetPos($Gui)
	WinMove($Gui, "", $GetGuiPos[0], $GetGuiPos[1], 339, $HeightPos)
	_ReduceMemory(@AutoItPID)
	Local $RetPos[2] = [$GetGuiPos[0], $HeightPos]
	Return $RetPos
EndFunc

Func _CheckBkColor($BackColor)
	If $BackColor = 0x000000 Then
		$CtrlColor = 0xFFFFFF
	Else
		$CtrlColor = 0x000000
	EndIf
	
	GUICtrlSetColor($Main_Label, $CtrlColor)
	GUICtrlSetColor($Time_Label, $CtrlColor)
	GUICtrlSetColor($TimeRem_Label, $CtrlColor)
	GUICtrlSetColor($Transp_Slider_Label, $CtrlColor)
	GUICtrlSetColor($Lang_Label, $CtrlColor)
	
	GUICtrlSetColor($SoundPlay_CheckBox, $CtrlColor)
	GUICtrlSetColor($SetOnTop_CheckBox, $CtrlColor)
	GUICtrlSetColor($SaveSettings_CheckBox, $CtrlColor)
	
	_ReduceMemory(@AutoItPID)
EndFunc

Func _GuiMsgBox($IcoType,$Butt_Num,$Title,$Text,$Width,$Height,$CB_Text=-1,$Timer=-1,$hWnd=0,$B1Text=-1,$B2Text=-1,$ExStyle=-1)
	Local $Yes_Button, $No_Button, $OK_Button, $CheckBox=-1, $Gui_MsgBox, $GuiHeight = $Height
	Local $TitleType = $WS_CAPTION+$WS_POPUP, $Gui_Msg, $ReturnVal = 0
	Local $DefButton, $DefButtonText = $B1Text, $Counter
	Local $MessageBeep = -1, $Icon_Id = 102
	
	Local $Old_Opt_GOEM = Opt('GuiOnEventMode', 0)
	Local $Old_Opt_GCOE = Opt('GUICloseOnESC', 0)
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_DISABLE)
	If $Butt_Num = 1 Then $TitleType += $WS_SYSMENU
	If $CB_Text <> -1 Then $GuiHeight += 25
	
	If $B1Text = -1 Then $B1Text = 'OK'
	If $B2Text = -1 Then $B2Text = 'Cancel'
	
	$Gui_MsgBox = GuiCreate($Title, $Width, $GuiHeight, -1, -1, $TitleType, $ExStyle, $hWnd)
	
	Select
		Case $IcoType = 16 Or $IcoType = 16 + 256
			$Icon_Id = 103
			$MessageBeep = 0x00000010
		Case $IcoType = 32 Or $IcoType = 32 + 256
			$Icon_Id = 102
			$MessageBeep = 0x00000020
		Case $IcoType = 48 Or $IcoType = 48 + 256
			$Icon_Id = 101
			$MessageBeep = 0x00000030
		Case $IcoType = 64 Or $IcoType = 64 + 256
			$Icon_Id = 104
			$MessageBeep = 0x00000040
	EndSelect
	
	GUICtrlCreateIcon('user32.dll', $Icon_Id, 10, 10)
	GUICtrlSetState(-1, 128)
	GUICtrlCreateLabel($Text, 70, 15, $Width-80, $Height-50, -1, $GUI_WS_EX_PARENTDRAG)
	
	Select
		Case $Butt_Num = 2
			$Yes_Button = GUICtrlCreateButton($B1Text, ($Width/2)-90, $Height-35, 70, 20, $BS_DEFPUSHBUTTON)
			$DefButton = $Yes_Button
			
			Local $SecButtDeffStyle = 0
			If BitAND($IcoType, 256) Then $SecButtDeffStyle = $BS_DEFPUSHBUTTON
			
			$No_Button = GUICtrlCreateButton($B2Text, ($Width/2)+20, $Height-35, 70, 20, $SecButtDeffStyle)
			If BitAND($IcoType, 256) Then $DefButton = $No_Button
		Case Else
			$OK_Button = GUICtrlCreateButton($B1Text, ($Width-70)/2, $Height-35, 70, 20)
			GUICtrlSetState($OK_Button, $GUI_ONTOP)
			$DefButton = $OK_Button
	EndSelect
	
	If $CB_Text <> -1 Then $CheckBox = GUICtrlCreateCheckbox($CB_Text, 15, $Height-10)
	GuiSetState(@SW_SHOW, $Gui_MsgBox)
	DllCall ("user32.dll", "int", "MessageBeep", "int", $MessageBeep)
	
	If $Timer > 0 Then
		$Counter = $Timer
		$Timer = TimerInit()
		$DefButtonText = GUICtrlRead($DefButton)
		GUICtrlSetData($DefButton, $DefButtonText & ' (' & $Counter & ')')
	EndIf
	
	While 1
		$Gui_Msg = GUIGetMsg()
		
		If $Timer > 0 And TimerDiff($Timer) >= 1000 Then
			$Timer = TimerInit()
			$Counter -= 1
			GUICtrlSetData($DefButton, $DefButtonText & ' (' & $Counter & ')')
			If $Counter < 0 Then $Gui_Msg = $DefButton
		EndIf
		
		Select
			Case $Butt_Num = 2 And $Gui_Msg = $Yes_Button
				$ReturnVal = 6
				ExitLoop
			Case $Butt_Num = 2 And $Gui_Msg = $No_Button
				$ReturnVal = 7
				ExitLoop
			Case $Gui_Msg = -3 Or ($Gui_Msg = $OK_Button And $Butt_Num <> 2)
				$ReturnVal = 1
				ExitLoop
		EndSelect
	Wend
	
	If GUICtrlRead($CheckBox) = 1 Then $ReturnVal += 8
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Gui_MsgBox)
	If IsHWnd($hWnd) Then GUISwitch($hWnd)
	Opt('GuiOnEventMode', $Old_Opt_GOEM)
	Opt('GUICloseOnESC', $Old_Opt_GCOE)
	Return $ReturnVal
EndFunc

Func _MsgBox($MsgBoxType, $MsgBoxTitle, $MsgBoxText, $hWnd)
	Local $sRet = DllCall("user32.dll", "int", "MessageBox", "hwnd", $hWnd, _
		"str", $MsgBoxText, "str", $MsgBoxTitle, "int", $MsgBoxType)
	Return $sRet[0]
EndFunc

Func _TimeRemained($DestTime, $Time)
	Local $DestSecs = _TimeToSecs($DestTime, $TimeDelim)
	Local $NowSecs = _TimeToSecs($Time, $TimeDelim)
	Local $TotalSecs = 0
	If $DestSecs > $NowSecs Then
		$TotalSecs = $DestSecs - $NowSecs
		$Remained = _SecsToTime($TotalSecs, $TimeDelim)
	ElseIf $NowSecs > $DestSecs Then
		$TotalSecs = _TimeMinusSecs(23 & $TimeDelim & 59 & $TimeDelim & 59, ($NowSecs - $DestSecs), $TimeDelim)
		$Remained = $TotalSecs
	ElseIf $NowSecs = $DestSecs Then
		$TotalSecs = $NowSecs
		$Remained = _SecsToTime($TotalSecs, $TimeDelim)
	EndIf
	Return $Remained
EndFunc

Func _TimeToSecs($sTime, $sDelim=":")
	Local $iCountSecs = 0
	Local $avTimeArr = StringSplit($sTime, $sDelim, 1)
	If UBound($avTimeArr) > 3 Then
		If Number($avTimeArr[1] * 3600) <> 0 Then $iCountSecs = $avTimeArr[1] * 3600
		If Number($avTimeArr[2] * 60) <> 0 Then $iCountSecs += $avTimeArr[2] * 60
		If $avTimeArr[3] <> 0 Then $iCountSecs += $avTimeArr[3]
	EndIf
	Return $iCountSecs
EndFunc

Func _SecsToTime($iTicks, $Delim=":")
	Local $iHours, $iMins, $iSecs
	If Number($iTicks) >= 0 Then
		$iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		$iMins = Int($iTicks / 60)
		$iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = "0" & $iHours
		If StringLen($iMins) = 1 Then $iMins = "0" & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = "0" & $iSecs
		Return $iHours & $Delim & $iMins & $Delim & $iSecs
	EndIf
	Return SetError(1, 0, "00" & $Delim & "00" & $Delim & "00")
EndFunc

Func _TimeMinusSecs($TimeN, $Secs, $sDelim=":")
	Return _SecsToTime(((_TimeToSecs($TimeN, $sDelim) + 1) - $Secs), $sDelim)
EndFunc

Func _GetTimeDelim($NowTime)
	Local $TDelim = RegRead("HKEY_CURRENT_USER\Control Panel\International", "sTime")
	If $TDelim = "" And StringLen($NowTime) >= 1 Then
		Local $StrngArr = StringSplit($NowTime, "")
		For $i = 1 To $StrngArr[0]
			If Not Number($StrngArr[$i]) Then $TDelim &= $StrngArr[$i]
			If $TDelim <> "" And Number($StrngArr[$i]) Then ExitLoop
		Next
	ElseIf $TDelim = "" Then
		$TDelim = ":"
	EndIf
	Return $TDelim
EndFunc

Func _GetTaskMgrTitle()
	Local $sRetTitle
	Local $sTitle_Pattern = "[CLASS:#32770; REGEXPTITLE:(?i)(.*?)Windows]"
	Local $TaskMgr_PID = ProcessExists("taskmgr.exe")
	If $TaskMgr_PID > 0 Then $sRetTitle = _WinGetTitleByPID($TaskMgr_PID)
	If $sRetTitle > 0 And WinExists($sRetTitle) Then Return $sRetTitle
	
	$sRetTitle = WinGetTitle($sTitle_Pattern)
	If $sRetTitle > 0 And WinExists($sRetTitle) Then Return $sRetTitle
	
	Return $sTitle_Pattern
EndFunc

Func _WinIsVisible($Title, $Text="")
	Return BitAND(WinGetState($Title, $Text), 2)
EndFunc

Func _WinGetTitleByPID($iPID, $nArray = 1)
    If IsString($iPID) Then $iPID = ProcessExists($iPID)
    Local $aWList = WinList(), $sHold
    For $i = 1 To $aWList[0][0]
        If WinGetProcess($aWList[$i][1]) = $iPID And _
            BitAND(WinGetState($aWList[$i][1]), 2) Then
            If $nArray Then Return $aWList[$i][0]
            $sHold &= $aWList[$i][0] & Chr(1)
        EndIf
    Next
    If $sHold Then Return StringSplit(StringTrimRight($sHold, 1), Chr(1))
    Return SetError(1, 0, 0)
EndFunc

Func _Refresh_Gui($hWnd)
	ControlClick($hWnd, "", $Prefs_Button, "Left", 2)
EndFunc

Func _ReduceMemory($i_PID = -1)
	Local $ai_Return
	If $i_PID <> - 1 Then
		Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
		$ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
		DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
	Else
		$ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	EndIf
	Return $ai_Return[0]
EndFunc

Func _XPStyleToggle($OnOff = 1)
	If Not StringInStr(@OSTYPE, "WIN32_NT") Then Return 0
	If $OnOff Then
        $XS_n = DllCall("uxtheme.dll", "int", "GetThemeAppProperties")
        DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 0)
        Return 1
    ElseIf IsArray($XS_n) Then
        DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", $XS_n[0])
        $XS_n = ""
        Return 1
    EndIf
    Return 0
EndFunc

Func BASSMOD_Open($DllPath, $sPath, $Flag = 0, $Amplify = 50)
	If Not FileExists($DllPath) Then Return SetError(1, 0, -1)
	
	Local $BassModDll = DllOpen($DllPath)
	If $BassModDll = -1 Then Return -1
	
	Local $BASSMOD_Init = DllCall($BassModDll, "int", "BASSMOD_Init", _
		"int", -1, _  ;  (-1   )
		"long", 44100, _  ;  
		"long", 0)       ;   
	If Not $BASSMOD_Init[0] Then Return SetError(2, 0, -1)
	Local $FName = DllStructCreate("char[255]")
	DllStructSetData($FName, 1, $sPath)
	Local $iLoad = DllCall($BassModDll, "int", "BASSMOD_MusicLoad", "int", False, _  ;    
		"ptr", DllStructGetPtr($FName), _ ;    
		"long", 0, _   ;    
		"long", 0, _   ;   (0 -  )
		"long", $Flag) ;  
	$FName = 0
	If Not $iLoad[0] Then Return SetError(3, 0, -1)
	DllCall($BassModDll, "int", "BASSMOD_MusicSetAmplify", "long", $Amplify) ; Amplify level: (min = 0; max = 100; default 50)
	BASSMOD_Play($BassModDll)
	If @error Then Return SetError(4, 0, -1)
	Return $BassModDll
EndFunc

Func BASSMOD_Play($BassModDll)
	If $BassModDll = -1 Then Return 0
	Local $iPlay = DllCall($BassModDll, "int", "BASSMOD_MusicPlay")
	If Not $iPlay[0] Then Return SetError(1, 0, -1)
	Return $iPlay[0]
EndFunc

Func BASSMOD_Pause($BassModDll)
	If $BassModDll = -1 Then Return 0
	DllCall($BassModDll, "int", "BASSMOD_MusicPause")
EndFunc

Func BASSMOD_Close($BassModDll)
	If $BassModDll = -1 Then Return 0
	DllCall($BassModDll, "int", "BASSMOD_Free") ;   
	DllClose($BassModDll)
EndFunc

Func DRAG_COMMAND($HWnd, $vMsg, $wParam, $lParam)
	If BitAND(WinGetState($HWnd), 32) Then Return $GUI_RUNDEFMSG
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $HWnd, "int", 0x0112, "int", 0xF009, "int", 0)
EndFunc

Func ExitScript()
	$Step = -3
	$SoundIsPlaying = GUICtrlRead($SoundPlay_CheckBox) = 1
	If $SoundIsPlaying Then $Step = -8
	For $i = 255-$SliderPos To 0 Step $Step
		WinSetTrans($Gui, "", $i)
		If $SoundIsPlaying Then
			$VolPos = $i
			If $VolPos > 100 Then $VolPos = ($i - ($i - 100))
			SoundSetWaveVolume($VolPos)
			Sleep(1)
		EndIf
	Next
	
	GUISetState(@SW_HIDE, $Gui)
	If $SoundIsPlaying Then
		BASSMOD_Close($Dll_Handle)
		SoundSetWaveVolume(100)
		$PlaySound = 1
	Else
		$PlaySound = 0
	EndIf
	
	If GUICtrlRead($SaveSettings_CheckBox) <> 1 Then
		RegDelete("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner")
		IniWrite($LangFile, "Info", "Language Section", "English")
	Else
		RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Save Settings", "REG_SZ", 1)
		RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "PlaySound", "REG_SZ", $PlaySound)
		
		$RegReadTrans = RegRead("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Transparent")
		If $SliderPos > 0 Or $RegReadTrans > 0 Then _
			RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "Transparent", "REG_SZ", $SliderPos)
		
		RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "ShowPrefs", "REG_SZ", $ShowPrefs)
		RegWrite("HKEY_CURRENT_USER\Software\KeybMouse_Cleaner", "OnTop", "REG_SZ", $IsOnTop)
		
		IniWrite($LangFile, "Info", "Language Section", GUICtrlRead($Translate_Combo))
	EndIf
	
	DirRemove($Temp_Dir, 1)
	Exit
EndFunc
