#include-once

Global $Last_Catched_IE_URL = ''
Global $Last_Catched_OP_URL = ''
Global $Last_Catched_FF_URL = ''
Global $Monitor_Detected[3] = [False, 0, 0]
Global $DDE_IN_USE			= False

Func Monitor_Proc($hWnd, $uiMsg, $idEvent, $dwTime)
	If @InetGetActive Or $Timer_Proc_Download <> 0 Or $DDE_IN_USE Then Return
	Local $IE_Monitor = IE_Monitor()
	
	If Not @error And $IE_Monitor[0] <> '' And $IE_Monitor[0] <> $Last_Catched_IE_URL Then
		$Last_Catched_IE_URL = $IE_Monitor[0]
		$Monitor_Detected[0] = $IE_Monitor[0]
		$Monitor_Detected[1] = StringStripWS(StringLeft($IE_Monitor[1], StringInStr($IE_Monitor[1], "-", 0, -1)-1), 3)
		$Monitor_Detected[2] = "Internet Explorer"
		Return
	EndIf
	
	Local $Opera_Monitor = Opera_Monitor()
	
	If Not @error And $Opera_Monitor[0] <> '' And $Opera_Monitor[0] <> $Last_Catched_OP_URL Then
		$Last_Catched_OP_URL = $Opera_Monitor[0]
		$Monitor_Detected[0] = $Opera_Monitor[0]
		$Monitor_Detected[1] = $Opera_Monitor[1]
		$Monitor_Detected[2] = "Opera Browser"
	EndIf
	
	Local $FF_Monitor = FireFox_Monitor()
	
	If Not @error And $FF_Monitor[0] <> '' And $FF_Monitor[0] <> $Last_Catched_FF_URL Then
		$Last_Catched_FF_URL = $FF_Monitor[0]
		$Monitor_Detected[0] = $FF_Monitor[0]
		$Monitor_Detected[1] = $FF_Monitor[1]
		$Monitor_Detected[2] = "Firefox Browser"
	EndIf
EndFunc

Func IE_Monitor()
	If Not ProcessExists('iexplore.exe') Then Return SetError(1, 0, '')
	Local $IE_Win_List_Arr = WinList('[CLASS:IEFrame]')
	Local $Current_Edit_Content = '', $GetClassList
	
	For $i = 1 To UBound($IE_Win_List_Arr)-1
		$Current_Edit_Content = ControlGetText($IE_Win_List_Arr[$i][1], '', 'Edit1')
		$GetClassList = WinGetClassList($IE_Win_List_Arr[$i][1])
		If IsWatchYT_URL($Current_Edit_Content) And StringInStr($GetClassList, "MacromediaFlashPlayerActiveX") Then
			Local $Ret_URL_And_Title[2] = [$Current_Edit_Content, $IE_Win_List_Arr[$i][0]]
			Return $Ret_URL_And_Title
		EndIf
	Next
	Return SetError(1, 0, '')
EndFunc

Func Opera_Monitor()
	If Not ProcessExists('Opera.exe') Then Return SetError(1, 0, '')
	Local $Get_Opera_URL = OpenGetURL('', -1, 1, "Opera")
	If @error Or Not IsArray($Get_Opera_URL) Then Return SetError(2, 0, '')
	
	$Get_Opera_URL[1] = _StringStripChars($Get_Opera_URL[1], '"', 3)
	If IsWatchYT_URL($Get_Opera_URL[1]) Then
		Local $Ret_URL_And_Title[2] = [$Get_Opera_URL[1], _GetMidleString($Get_Opera_URL[2], '"Opera - \[', '\]"')]
		Return $Ret_URL_And_Title
	EndIf
	
	Return SetError(3, 0, '')
EndFunc

Func FireFox_Monitor()
	If Not ProcessExists('Firefox.exe') Then Return SetError(1, 0, '')
	Local $Get_FF_URL = OpenGetURL('', -1, 1, "Firefox")
	If @error Or Not IsArray($Get_FF_URL) Then Return SetError(2, 0, '')
	
	$Get_FF_URL[1] = _StringStripChars($Get_FF_URL[1], '"', 3)
	If IsWatchYT_URL($Get_FF_URL[1]) Then
		Local $Ret_URL_And_Title[2] = [$Get_FF_URL[1], $Get_FF_URL[2]]
		Return $Ret_URL_And_Title
	EndIf
	
	Return SetError(3, 0, '')
EndFunc

;===============================================================================
;
; Function Name:  OpenGetURL()
;
; Parameter(s):		$sURL			[optional] Address of page to open,
;									if this is empty string (default), then returned Url from address field of particular tab.
;					$hWin			[optional] Number of tab:
;										-1 = Current tab.
;										0 = New tab (when opening).
;					$RetType 		[optional] Definds returned value:
;										0 = String with Title and URL address.
;										1 = Array with 3 elements...
;											[0] = Title
;											[1] = URL address
;											[2] = String with Title And URL address.
;					$Server			[optional] Serever to open/get Url in/from.
;					$iWait			[optional] Waiting Timeout in milliseconds, on overload will return an error.
;
; Requirement(s):	None
; Return Value(s):	On Success -  See 'Parameter(s)'.
;					On Failure -  Empty string and set @error as following:
;						1 = Error to open Dll (user32.dll)
;						2 = Error Initializing DDE (@extended include more details about the returned value from DllCall).
;						3 = Othe DDE Errors (@extended include more details about the returned value from DllCall).
; Author(s):        amel27
;
;=====================================================================
Func OpenGetURL($sURL = "", $hWin = -1, $RetType = 0, $Server="IExplore", $iWait = 10000)
	Local $iRet, $iErr, $uIdInst = DllStructCreate("int")
	Local $hServer[1], $hTopic[1], $hItem[1], $hConv[1], $hData[1], $sData[1]
	Local $sTopic = "WWW_OpenURL", $sItem = $sURL & ',,0x' & Hex($hWin)
	If $sURL = '' Then
		$sTopic = "WWW_GetWindowInfo"
		$sItem = "0x" & Hex($hWin)
	EndIf
	Local $hDll = DllOpen("user32.dll")
	If $hDll=-1 Then Return SetError(1, 0, "") ; Error to open Dll
	$iRet = DllCall("user32.dll", "int", "DdeInitialize", "ptr", DllStructGetPtr($uIdInst), "ptr", 0, "int", 0, "int", 0)
	If $iRet[0] Then Return SetError(2, $iRet[0], "") ; Error Initializing DDE
	$hServer = DllCall($hDll, "int", "DdeCreateStringHandle", "int", DllStructGetData($uIdInst,1), "str", $Server, "int", 1004)
	If $hServer[0] Then
		$hTopic = DllCall($hDll, "int", "DdeCreateStringHandle", "int", DllStructGetData($uIdInst,1), "str", $sTopic, "int", 1004)
		If $hTopic[0] Then
			$hItem = DllCall($hDll, "int", "DdeCreateStringHandle", "int", DllStructGetData($uIdInst,1), "str", $sItem, "int", 1004)
			If $hItem[0] Then
				$hConv = DllCall($hDll, "int", "DdeConnect", "int", _
					DllStructGetData($uIdInst,1), "int", $hServer[0], "int", $hTopic[0], "int", 0)
				If $hConv[0] Then
					$hData = DllCall($hDll, "int", "DdeClientTransaction", "ptr", 0, "int", 0, _
						"int", $hConv[0], "int", $hItem[0], "int", 1, "int", 0x20B0, "int", $iWait, "ptr", 0)
					If $hData[0] Then $sData = DllCall($hDll, "str", "DdeAccessData", "int", $hData[0], "ptr", 0)
				EndIf
			EndIf
		EndIf
	EndIf
	$iErr = DllCall($hDll, "int", "DdeGetLastError", "int", DllStructGetData($uIdInst, 1))
	If $hData[0] Then DllCall($hDll, "int", "DdeFreeDataHandle", "int", $hData[0])
	If $hConv[0] Then DllCall($hDll, "int", "DdeFreeDataHandle", "int", $hConv[0])
	If $hItem[0] Then DllCall($hDll, "int", "DdeFreeDataHandle", "int", $hItem[0])
	If $hTopic[0] Then DllCall($hDll, "int", "DdeFreeDataHandle", "int", $hTopic[0])
	If $hServer[0] Then DllCall($hDll, "int", "DdeFreeDataHandle", "int", $hServer[0])
	If $iErr[0] Then Return SetError(3, $iErr[0], "") ; Othe DDE Errors
	DllCall($hDll, "int", "DdeUninitialize", "int", DllStructGetData($uIdInst, 1))
	DllClose($hDll)
	
	If StringRight($sData[0], 3) = ',""' Then $sData[0] = StringTrimRight($sData[0], 3)
	If $sURL = '' Then $sURL = StringRegExpReplace($sData[0], '^"([^"]*?)".*','"\1"')
	
	If $RetType = 1 Then
		Local $iRetTitle = StringReplace(StringTrimLeft($sData[0], StringLen($sURL)+1), '\"', '"')
		Local $RetURL[3] = [StringReplace($sData[0], '\"', '"'), $sURL, $iRetTitle]
		Return $RetURL
	EndIf
	
	Return $sURL
EndFunc