#include-once

Func _Utf8ToAnsi($Utf8String)
	Local $len = StringLen($Utf8String)
	Local $buf = DllStructCreate("byte[" & $len*2 & "];byte[2]")
	Local $ret = DllCall("Kernel32.dll", "int", "MultiByteToWideChar", _
		"int", 65001, "int", 0, _
		"str", $Utf8String, "int", -1, _
		"ptr", DllStructGetPtr($buf), "int", $len*2+2)
	Local $out = DllStructCreate("char[" & $len & "];char")
	$ret = DllCall("kernel32.dll", "int", "WideCharToMultiByte", _
		"int", 0, "int", 0, _
		"ptr", DllStructGetPtr($buf), "int", -1, _
		"ptr", DllStructGetPtr($out), "int", $len+1, _
		"int", 0, "int", 0)
	Return DllStructGetData($out, 1)
EndFunc

Func _Utf8ToUnicode($Utf8String)
	Local $BufferSize = StringLen($Utf8String) * 2
	Local $Buffer = DllStructCreate("byte[" & $BufferSize & "]")
	Local $Return = DllCall("Kernel32.dll", "int", "MultiByteToWideChar", _
		"int", 65001, _
		"int", 0, _
		"str", $Utf8String, _
		"int", StringLen($Utf8String), _
		"ptr", DllStructGetPtr($Buffer), _
		"int", $BufferSize)
	Local $UnicodeBinary = DllStructGetData($Buffer, 1)
	Local $UnicodeHex1 = StringReplace($UnicodeBinary, "0x", "")
	Local $UnicodeString, $UnicodeHex2, $UnicodeHex3
	For $i = 1 To StringLen($UnicodeHex1) Step 4
		$UnicodeHex2 = StringMid($UnicodeHex1, $i, 4)
		$UnicodeHex3 = StringMid($UnicodeHex2, 3, 2) & StringMid($UnicodeHex2, 1, 2)
		$UnicodeString &= ChrW(Dec($UnicodeHex3))
	Next
	$Buffer = 0
	Return $UnicodeString
EndFunc

Func StringToUTF($String)
	Dim $sResult = "", $Code
	Local $VarUTFArr = StringSplit($String, "")
	
	For $i = 1 To UBound($VarUTFArr)-1
		$Code = Asc($VarUTFArr[$i])
		Select
			Case $Code >= 192 And $Code <= 239
				$VarUTFArr[$i] = Chr(208) & Chr($Code - 48)
			Case $Code >= 240 And $Code <= 255
				$VarUTFArr[$i] = Chr(209) & Chr($Code - 112)
			Case $Code = 168
				$VarUTFArr[$i] = Chr(208) & Chr(129)
			Case $Code = 184
				$VarUTFArr[$i] = Chr(209) & Chr(145)
			Case Else
				$VarUTFArr[$i] = Chr($Code)
		EndSelect
		
		$sResult &= $VarUTFArr[$i]
	Next
	Return $sResult
EndFunc

Func _StringIsUTF8Format($sString)
	Local $sAsc, $sLen = StringLen($sString), $sExt = $sLen
	
	For $i = 1 To $sLen
		$sAsc = Asc(StringMid($sString, $i, 1))
		If Not BitAND($sAsc, 0x80) Then
			$sExt = 0
		ElseIf Not BitXOR(BitAND($sAsc, 0xE0), 0xC0) Then
			$sExt = 1
		ElseIf Not (BitXOR(BitAND($sAsc, 0xF0), 0xE0)) Then
			$sExt = 2
		ElseIf Not BitXOR(BitAND($sAsc, 0xF8), 0xF0) Then
			$sExt = 3
		EndIf
		
		If $i + $sExt > $sLen Then Return False
		
		For $j = $i + 1 To $i + $sExt
			$sAsc = Asc(StringMid($sString, $j, 1))
			If BitXOR(BitAND($sAsc, 0xC0), 0x80) Then Return False
		Next
		$i += $sExt
	Next
	
	Return True
EndFunc

Func _StringToHexURL($String)
	Local $StrArray = StringSplit($String, "")
	Local $RetString = ""
	
	For $i = 1 To UBound($StrArray)-1
		If Not StringRegExp($StrArray[$i], '(?i)[-a-z]|\.|-|_') Then $StrArray[$i] = "%" & Hex(Asc($StrArray[$i]), 2)
		$RetString &= $StrArray[$i]
	Next
	Return $RetString
EndFunc

Func _HexURLToString($URLHex)
	Local $StrArray = StringSplit($URLHex, "")
	Local $RetString = "", $iDec
	Local $Ubound = UBound($StrArray)
	
	For $i = 1 To $Ubound-1
		If $StrArray[$i] = "%" And $i+2 <= $Ubound-1 Then
			$i += 2
			$iDec = Dec($StrArray[$i-1] & $StrArray[$i])
			If Not @error Then
				$RetString &= Chr($iDec)
			Else
				$RetString &= $StrArray[$i-2]
			EndIf
		Else
			$RetString &= $StrArray[$i]
		EndIf
	Next
	Return $RetString
EndFunc

Func _URLEncode($UnicodeURL)
	Local $BinaryString = StringReplace(StringToBinary($UnicodeURL, 4), '0x', '', 1)
	Local $UniBinLen = StringLen($BinaryString)
	Local $EncodedString, $UniBinChar
	
	For $i = 1 To $UniBinLen Step 2
		$UniBinChar = StringMid($BinaryString, $i, 2)
		If StringRegExp(BinaryToString('0x' & $UniBinChar, 4), '(?i)[a-zA-Z0-9]|-|_|\.') Then
			$EncodedString &= BinaryToString('0x' & $UniBinChar)
		Else
			$EncodedString &= '%' & $UniBinChar
		EndIf
	Next
	Return $EncodedString
EndFunc
