#include-once

;Thanks to Diamond for the round shape of this "About dialog" and the BASSMOD examples! ;)

Func About_Box($HWnd, $AppName, $Version, $Temp_Dir, $Img_Path="")
	If WinIsVisible($HWnd) And Not WinActive($HWnd) Then Return
	Local $Old_GOEM = Opt("GuiOnEventMode", 0)
	
	FileInstall("Resources\BASSMOD.dll", $Temp_Dir & "\")
	FileInstall("Resources\About_Sound.xm", $Temp_Dir & "\")
	Local $Dll_Handle = BASSMOD_Open($Temp_Dir & "\BASSMOD.dll", $Temp_Dir & "\About_Sound.xm", 1024+4, 80)
	
	Local $ExStyle = -1
	Local $Width = 480
	Local $Height = 480
	
	If WinIsVisible($HWnd) Then
		Local $Parent_Pos = WinGetPos($HWnd)
		Local $xParent = $Parent_Pos[0] + ($Parent_Pos[2]-$Width) / 2
		Local $yParent = ($Parent_Pos[1] + ($Parent_Pos[3]-$Height) / 2) - 20
	Else
		Local $xParent = -1
		Local $yParent = -1
		$ExStyle = $WS_EX_APPWINDOW
	EndIf
	
	Local $GuiHelp = GUICreate("About - " & $AppName, $Width+1, $Height+1, $xParent, $yParent, $WS_POPUP, $ExStyle, $HWnd)
	GUISetBkColor(0xFFFFFF)
	
	Local $PictureCtrl = GUICtrlCreatePic($Img_Path, 85, 130, 306, 106)
	GUICtrlSetTip(-1, "Visit YouTube Home Page [www.youtube.com]")
	GUICtrlSetCursor(-1, 0)
	
	$About_Home_Label = GUICtrlCreateLabel("Home", 395, 215, 40, 15)
	GUICtrlSetColor(-1, 0x808080)
	GUICtrlSetState(-1, $GUI_HIDE)
	
	Local $GraphicHelp = GUICtrlCreateGraphic(0, 50, 0, 0)
	GUICtrlSetState(-1, 128)
	
	DRAW_BACKGROUND($GraphicHelp)
	_GuiRoundCorners($GuiHelp, 0, 50, $Width, $Width)
	
	Local $AppVer_Label = GUICtrlCreateLabel($Version, 180, 90, $Width-360, 20, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 14, 800, 4)
	
	GUICtrlCreateGraphic(30, 245, $Width-60, 3, $SS_ETCHEDFRAME+$SS_CENTER)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $Thanks_Label = GUICtrlCreateLabel("Thanks:" & @LF & _
		"* To AutoIt Developers!" & @LF & _
		"* To all AutoIt community!" & @LF & _
		"* Special Thanks to Dhilip89 for helping me understanding how realy TCP/HTTP funcs works!", _
		50, 255, $Width-100, 85, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlSetColor(-1, 0x009797)
	
	GUICtrlCreateGraphic(50, 345, $Width-100, 3, $SS_ETCHEDFRAME+$SS_CENTER)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $WWW_Label = GUICtrlCreateLabel("www: ", 145, 350, 50, 15, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlSetColor(-1, 0x0000FF)
	
	Local $Web_Label = GUICtrlCreateLabel("creator-lab.ucoz.ru", 195, 351, 110, 15, $SS_CENTER)
	GUICtrlSetTip(-1, "Visit Author's Home Page [www.creator-lab.ucoz.ru]")
	GUICtrlSetFont(-1, 9, 800, 4)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetColor(-1, 0x676767)
	
	GUICtrlCreateGraphic(75, 370, $Width-150, 3, $SS_ETCHEDFRAME+$SS_CENTER)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $Author_Label = GUICtrlCreateLabel($CopyRight_String, 100, 385, $Width-200, 15, $SS_CENTER)
	GUICtrlSetFont(-1, 8, 800)
	GUICtrlSetState(-1, 128)
	
	Local $Close_About_Button = GUICtrlCreateButton("Close", 190, 420, $Width-380, 20, $SS_CENTER)
	
	For $i = $AppVer_Label To $Web_Label+1
		GUICtrlSetBkColor($i, 0xFFFFFF)
	Next
	
	GUISetState(@SW_DISABLE, $Hwnd)
	GUISetState(@SW_SHOW, $GuiHelp)
	
	If Not WinIsVisible($HWnd) Then
		Sleep(100)
		TraySetState(2)
	EndIf
	
	While 1
		HoverLabelProc($HoverLinkMark, $Web_Label, "SetColorProc", 0x0000FF, 0x676767, $GuiHelp)
		HoverLabelProc($HoverAboutPicMark, $PictureCtrl, "SetElementStateProc", $GUI_SHOW, $GUI_HIDE, $GuiHelp, $About_Home_Label)
		Switch GUIGetMsg()
			Case -3, $Close_About_Button
				ExitLoop
			Case $PictureCtrl
				ClickHandlerProc($PictureCtrl, "http://youtube.com", $GuiHelp)
			Case $Web_Label
				ClickHandlerProc($Web_Label, "http://creator-lab.ucoz.ru", $GuiHelp)
		EndSwitch
	WEnd
	
	Opt("GuiOnEventMode", $Old_GOEM)
	
	If Not WinIsVisible($HWnd) Then TraySetState(1)
	GUISetState(@SW_ENABLE, $HWnd)
	GUIDelete($GuiHelp)
	GUISwitch($HWnd)
	
	BASSMOD_Close($Dll_Handle)
EndFunc

Func DRAW_BACKGROUND($CtrlID)
	Local $GrArr[10] = [212, 219, 226, 231, 235, 238, 241, 242, 243, 247]
	Local $iShift = 430, $x = 0
	Local $iColor, $j = 0
	GUICtrlSetGraphic($CtrlID, $GUI_GR_PENSIZE, 2)
	For $i = 0 To 19
	If $i > 9 Then 
		$j = 19 - $i
		$iColor = "0x" & Hex($GrArr[$j]-($i-5), 2) & Hex($GrArr[$j]-($i-5), 2) & Hex($GrArr[$j]-($i-5), 2)
	Else
		$j = $i
		$iColor = "0x" & Hex($GrArr[$j],2) & Hex($GrArr[$j], 2) & Hex($GrArr[$j], 2)
	EndIf
		For $q = 1 To 2
			GUICtrlSetGraphic($CtrlID, $GUI_GR_COLOR, $iColor, 0xFFFFFF)
			GUICtrlSetGraphic($CtrlID, $GUI_GR_ELLIPSE, $x, $x, $iShift+50, $iShift)
			If IsInt($i / 2) Then $x += 1
			$iShift -= 1
		Next
	Next
EndFunc

Func _GuiRoundCorners($HWnd, $i_x1, $i_y1, $i_x3, $i_y3)
	Local $WinPos = WinGetPos($HWnd)
	Local $RetVal1 = DllCall("gdi32.dll", "long", "CreateRoundRectRgn", _
		"long", $i_x1, "long", $i_y1, "long", $WinPos[2], "long", $WinPos[3], "long", $i_x3,  "long", $i_y3)
	If $RetVal1[0] Then
		Local $RetVal2 = DllCall("user32.dll", "long", "SetWindowRgn", "hwnd", $HWnd, "long", $RetVal1[0], "int", 1)
		If $RetVal2[0] Then
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return 0
	EndIf
EndFunc

Func BASSMOD_Open($DllPath, $sPath, $Flag = 0, $Amplify = 50)
	If Not FileExists($DllPath) Then Return SetError(1)
	
	Local $BassModDll = DllOpen($dllPath)
	If $BassModDll = -1 Then Return -1
	
	Local $init = DllCall($BassModDll, "int", "BASSMOD_Init", "int", -1, _  ;   (-1   )
							"long", 44100, _  ;  
							"long", 0)       ;   
	If Not $init[0] Then Return SetError(2)
	Local $FName = DllStructCreate("char[255]")
	DllStructSetData($FName, 1, $sPath)
	Local $load = DllCall($BassModDll, "int", "BASSMOD_MusicLoad", "int", False, _  ;    
							"ptr", DllStructGetPtr($FName), _ ;    
							"long", 0, _   ;    
							"long", 0, _   ;   (0 -  )
							"long", $Flag) ;  
	$FName = 0
	If Not $Load[0] Then Return SetError(3)
	DllCall($BassModDll, "int", "BASSMOD_MusicSetAmplify", "long", $Amplify) ; Amplify level: (min = 0; max = 100; default 50)
	Local $Play = DllCall($BassModDll, "int", "BASSMOD_MusicPlay")
	If Not $Play[0] Then Return SetError(4)
	Return $BassModDll
EndFunc   ;==>BASSMOD_Open

Func BASSMOD_Close($BassModDll)
	Local $ret = DllCall($BassModDll, "int", "BASSMOD_Free") ;   
	DllClose($BassModDll)
	Return $ret[0] ;<- bool
EndFunc   ;==>BASSMOD_Close
