#include-once

Global $INETSPEED = 0, $INETGETBYTESREAD = 0, $INETGETSIZE = 0, $INETTIMESTAMP = 0, $TIMERSTART = 0
Global $Inet_Display_Size = 0

;        (,   ) -     (b/s).
Func _InetGetSpeed($Bytes)
	If @InetGetActive Then
        If $InetTimeStamp Then
            Local $Ticks = TimerDiff($InetTimeStamp)
            If $Ticks > 0 Then $InetSpeed = ($Bytes-$InetGetBytesRead)*1000 / $Ticks
        EndIf
        $InetGetBytesRead = $Bytes
        $InetTimeStamp = TimerInit()
    Else
        $InetTimeStamp = 0
        $InetGetBytesRead = 0
        $InetSpeed = 0
    EndIf
	If $InetSpeed < 0 Then $InetSpeed = 0
	Return $InetSpeed
EndFunc

;     (           ).
Func _GetAverageSpeed($Bytes)
	Return $Bytes*1000 / TimerDiff($TIMERSTART)
EndFunc

;       (           ).
Func _InetGetRemained($Bytes, $TotalBytesSize, $SpeedByBytes)
	Local $RemainedSecs = ($TotalBytesSize - $Bytes) / $SpeedByBytes
	If Number($RemainedSecs) < 0 Then Return 0
	Return $RemainedSecs
EndFunc

;     (     )
Func _InetGetPrecent($Bytes, $TotalBytesSize)
	Return 100 / ($TotalBytesSize / $Bytes)
EndFunc

;        (    ).
Func _SecsToTime($iTicks, $Delim=":")
	If Number($iTicks) >= 0 Then
		Local $iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		Local $iMins = Int($iTicks / 60)
		Local $iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = "0" & $iHours
		If StringLen($iMins) = 1 Then $iMins = "0" & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = "0" & $iSecs
		Return $iHours & $Delim & $iMins & $Delim & $iSecs
	Else
		Return SetError(1, 0, "00" & $Delim & "00" & $Delim & "00")
	EndIf
EndFunc

Func _InetIsNotConnected($sPing_Host="youtube.com", $iPing_TimeOut=1000)
	Local Const $INTERNET_CONNECTION_MODEM 			= 0x1
	Local Const $INTERNET_CONNECTION_LAN 			= 0x2
	Local Const $INTERNET_CONNECTION_PROXY 			= 0x4
	Local Const $INTERNET_CONNECTION_MODEM_BUSY 	= 0x8
	Local Const $INTERNET_RAS_INSTALLED 			= 0x10
	Local Const $INTERNET_CONNECTION_OFFLINE 		= 0x20
	Local Const $INTERNET_CONNECTION_CONFIGURED 	= 0x40
	
	;For 3.2.10.0 the next line should be used
	;Local $aRetConnectedState = DllCall("WinInet.dll", "int", "InternetGetConnectedState", "int*", 0, "int", 0)
	Local $aRetConnectedState = DllCall("WinInet.dll", "int", "InternetGetConnectedState", "int_ptr", 0, "int", 0)
	Local $iRetState = 0
	
	If UBound($aRetConnectedState) > 0 And $aRetConnectedState[0] Then
		If BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_MODEM) Or _
			BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_LAN) Or _
			BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_PROXY) Or _
			BitAND($aRetConnectedState[1], $INTERNET_RAS_INSTALLED) Then $iRetState = 1
		
		If BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_MODEM_BUSY) Or _
			BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_OFFLINE) Or _
			BitAND($aRetConnectedState[1], $INTERNET_CONNECTION_CONFIGURED) Or _
			BitAND($aRetConnectedState[1], BitOR($INTERNET_CONNECTION_LAN, $INTERNET_RAS_INSTALLED)) Then $iRetState = 0
	Else
		$iRetState = 0
	Endif
	
	If $iRetState = 0 Then
		Local $iPingCheck = Ping($sPing_Host, $iPing_TimeOut)
		If $iPingCheck > 0 Then $iRetState = 1
	EndIf
	
	Return Not $iRetState
EndFunc
