#include-once

Global $Temp_Dir					= SetTempDir()

Global $AppVer 						= "v1.0 RC 2"
Global $AppName 					= "YouTube Download Center"
Global $ConfigFile					= StringTrimRight(@ScriptFullPath, 3) & "ini"

Global $CopyRight_String			= "Copyright  2007-2008 G.Sandler. All rights reserved."

Global $YouTube_ImgPath 			= $Temp_Dir & "\YouTube_Img.gif"
Global $YouTube_IconPath 			= $Temp_Dir & "\YT_Icon.ico"
Global $YouTube_Anim_1_IconPath 	= $Temp_Dir & "\YT_Icon_Down_1.ico"
Global $YouTube_Anim_2_IconPath 	= $Temp_Dir & "\YT_Icon_Down_2.ico"
Global $YouTube_Item_IconPath 		= $Temp_Dir & "\YT_Icon_Item.ico"
Global $YT_Img_Not_Available		= $Temp_Dir & "\Not_Availible_Img.jpg"
Global $Load_Avi_Path				= $Temp_Dir & "\Load.avi"
Global $Clicked_Sound_Path			= $Temp_Dir & "\Clicked.wav"
Global $Done_Sound_Path				= $Temp_Dir & "\Done.wav"
Global $Log_File_Path				= @ScriptDir & "\YT_DC_Log.log"

;Global $InetConnect_ObjError 		= ObjEvent("AutoIt.Error", "InetGetErrFunc")
Global $oMainErrHandler 			= ObjEvent("AutoIt.Error", "Main_COM_Events_Func")
Global $App_Main_Hwnd				= 0
Global $Watch_Video_GUI				= 0
Global $Preview_GUI					= 0
Global $Search_GUI					= 0
Global $Search_ListView 			= 0
Global $Search_Current_Page			= 0
Global $Timer_Proc_Download 		= 0
Global $iTimer_Download 			= 0
Global $Timer_Proc_Monitor 			= 0
Global $iTimer_Monitor	 			= 0
Global $DoubleClicked				= False

Global $StatusTimer 				= -1
Global $DefaultWaitTime 			= 3 ;Seconds
Global $StatusWaitTime 				= $DefaultWaitTime
Global $RefreshDataRate 			= 1000 ;M'seconds

Global $LogDownloadFileName			= ""
Global $LastLogDownloadedName		= ""

Global $HoverPicMark				= 1
Global $HoverAboutPicMark			= 1
Global $HoverAuthorMark 			= 1
Global $HoverExampleMark 			= 1
Global $HoverLinkMark				= 1
Global $AnimateIconMark				= 1

Global Const $WM_NOTIFY				= 0x004E
Global Const $SC_MOVE 				= 0xF010
Global Const $SC_SIZE 				= 0xF000
Global Const $WM_SYSCOMMAND  		= 0x0112
Global Const $WM_EXITSIZEMOVE 		= 0x232
Global Const $WM_GETMINMAXINFO		= 0x24
Global Const $WM_LBUTTONDOWN 		= 0x0201

Func _TempFile($s_DirectoryName = @TempDir, $s_FilePrefix = "~", $s_FileExtension = ".tmp", $i_RandomLength = 7)
	Local $s_TempName
	; Check parameters
	If Not FileExists($s_DirectoryName) Then $s_DirectoryName = @TempDir   ; First reset to default temp dir
	If Not FileExists($s_DirectoryName) Then $s_DirectoryName = @ScriptDir ; Still wrong then set to Scriptdir
	; add trailing \ for directory name
	If StringRight($s_DirectoryName, 1) <> "\" Then $s_DirectoryName &= "\"
	;
	Do
		$s_TempName = ""
		While StringLen($s_TempName) < $i_RandomLength
			$s_TempName &= Chr(Random(97, 122, 1))
		WEnd
		$s_TempName = $s_DirectoryName & $s_FilePrefix & $s_TempName & $s_FileExtension
	Until Not FileExists($s_TempName)

	Return $s_TempName
EndFunc

Func SetTempDir()
	Local $Temp_Dir = _TempFile(@TempDir, "~YT_Downloader_", "")
	
	If Not DirCreate($Temp_Dir) Then
		$Temp_Dir = _TempFile(@ScriptDir, "~YT_Downloader_", "")
		DirCreate($Temp_Dir)
	EndIf
	
	Return $Temp_Dir
EndFunc

Func OnAutoItExit()
	DirRemove($Temp_Dir, 1)
	_HTTPClose()
	Run(@ComSpec & ' /c ping -n 1 localhost > nul & RMDIR /s /q "' & $Temp_Dir & '"', '', @SW_HIDE)
EndFunc
