#include-once

Func Preview_Info_Dialog($YT_URL, $AppName, $YT_Img_Not_Availible, $YouTube_IconPath, $hWnd=0)
	Local $OldOpt = Opt("GuiOnEventMode", 0)
	WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $Clip_Content = ClipGet()
	If $YT_URL = "" And IsWatchYT_URL($Clip_Content) Then $YT_URL = $Clip_Content
	
	Local $Preview_Info_GUI = GUICreate($AppName & " - Video Info Tool", 600, 580, -1, -1, _
		$WS_MINIMIZEBOX+$WS_SYSMENU, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW+$DS_SETFOREGROUND, $hWnd)
	GUISwitch($Preview_Info_GUI)
	GUISetBkColor(0xFFFFFF)
	
	GUICtrlCreateGroup("YouTube URL", 20, 20, 560, 90)
	Local $YT_URL_Input = GUICtrlCreateInput($YT_URL, 30, 40, 540, 20)
	Local $Submit_Button = GUICtrlCreateButton("Submit", 30, 80, 70, 20, $BS_DEFPUSHBUTTON)
	GUICtrlSetTip(-1, "Get the information")
	
	Local $Copy_Button = GUICtrlCreateButton("Copy", 105, 80, 50, 20)
	GUICtrlSetTip(-1, "Copy Target Download Link to ClipBoard")
	
	GUICtrlCreateLabel("Target Download Link:", 160, 65, 120, 15)
	Local $Target_Down_URL_Input = GUICtrlCreateInput("", 160, 80, 410, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateGroup("Main Info", 20, 120, 560, 280)
	GUICtrlCreateLabel("Video Name / Title:", 30, 140)
	Local $VideoName_Input = GUICtrlCreateInput("", 30, 160, 380, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Duration:", 440, 140)
	Local $Duration_Input = GUICtrlCreateInput("", 440, 160, 130, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Publisher:", 30, 190)
	Local $From_Input = GUICtrlCreateInput("", 30, 210, 120, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Views:", 160, 190)
	Local $Views_Input = GUICtrlCreateInput("", 160, 210, 120, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Average Rating:", 290, 190)
	Local $Rating_Input = GUICtrlCreateInput("", 290, 210, 120, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Category:", 440, 190)
	Local $Category_Input = GUICtrlCreateInput("", 440, 210, 130, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Keywords:", 30, 240)
	Local $Keywords_Input = GUICtrlCreateInput("", 30, 260, 250, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Added:", 290, 240)
	Local $Added_Input = GUICtrlCreateInput("", 290, 260, 120, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Updated:", 440, 240)
	Local $Updated_Input = GUICtrlCreateInput("", 440, 260, 130, 20, $ES_READONLY+$ES_LEFT+$ES_AUTOHSCROLL)
	
	GUICtrlCreateLabel("Descriptions:", 30, 300)
	Local $Descriptions_Edit = GUICtrlCreateEdit("", 30, 320, 540, 60, BitOr($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
	
	GUICtrlCreateGroup("Preview Thumbnails", 20, 405, 560, 120)
	
	Local $Thumbs_PicArr[5], $Pic_Left = 40
	
	For $i = 1 To 4
		$Thumbs_PicArr[$i] = GUICtrlCreatePic($YT_Img_Not_Availible, $Pic_Left, 425, 100, 90)
		$Pic_Left += 140
	Next
	
	Local $Prev_Info_StatusBar = _GUICtrlStatusBarCreate($Preview_Info_GUI, "", "")
	_GUICtrlStatusBarSetSimple($Prev_Info_StatusBar, True)
	_GUICtrlStatusBarSetIcon($Prev_Info_StatusBar, 255, $YouTube_IconPath, 0)
	
	GUISetState(@SW_SHOW, $Preview_Info_GUI)
	
	If $YT_URL <> "" Then
		For $i = $YT_URL_Input To $Descriptions_Edit
			GUICtrlSetState($i, $GUI_DISABLE)
		Next
		
		SetStatusData("Please wait, Getting Info...", -1, $Prev_Info_StatusBar)
		
		Local $RetNum = SetInfoProc($YT_URL, $Prev_Info_StatusBar, $VideoName_Input, _
			$Descriptions_Edit, $Thumbs_PicArr, $AppName, $Preview_Info_GUI)
		
		For $i = $YT_URL_Input To $Descriptions_Edit
			GUICtrlSetState($i, $GUI_ENABLE)
		Next
		
		If $RetNum <> -1 Then SetStatusData("", -1, $Prev_Info_StatusBar)
	EndIf
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $Submit_Button
				$YT_URL = GUICtrlRead($YT_URL_Input)
				
				If $YT_URL = "" Then
					SetStatusData("Please type URL", 3, $Prev_Info_StatusBar)
					ContinueLoop
				EndIf
				
				For $i = $YT_URL_Input To $Descriptions_Edit
					GUICtrlSetState($i, $GUI_DISABLE)
				Next
				
				SetStatusData("Please wait, Getting Info...", -1, $Prev_Info_StatusBar)
				
				$RetNum = SetInfoProc($YT_URL, $Prev_Info_StatusBar, $VideoName_Input, _
					$Descriptions_Edit, $Thumbs_PicArr, $AppName, $Preview_Info_GUI)
				
				If $RetNum < 4 And $RetNum <> -1 Then
					For $i = $RetNum To 4
						GUICtrlSetImage($Thumbs_PicArr[$i], $YT_Img_Not_Availible)
					Next
				EndIf
				
				For $i = $YT_URL_Input To $Descriptions_Edit
					GUICtrlSetState($i, $GUI_ENABLE)
				Next
				
				If $RetNum <> -1 Then
					SetStatusData("", -1, $Prev_Info_StatusBar)
				Else
					Local $Info_Count = 1
					
					GUICtrlSetData($VideoName_Input-3, "")
					
					For $i = $VideoName_Input To $Descriptions_Edit Step 2
						GUICtrlSetData($i, "")
						$Info_Count += 1
						If $Info_Count >= 12 Then ExitLoop
					Next
					
					For $i = 1 To 4
						GUICtrlSetImage($Thumbs_PicArr[$i], $YT_Img_Not_Availible)
					Next
				EndIf
			Case $Copy_Button
				ClipPut(GUICtrlRead($Target_Down_URL_Input))
		EndSwitch
		
		If $StatusTimer <> -1 And TimerDiff($StatusTimer) >= $StatusWaitTime*1000 Then SetStatusData("", -1, $Prev_Info_StatusBar)
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Preview_Info_GUI)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $OldOpt)
EndFunc

Func SetInfoProc($YT_URL, $Prev_Info_StatusBar, $VideoName_Input, $Descriptions_Edit, $Thumbs_PicArr, $AppName, $hWnd)
	Local $VideoInfoArr = GetYouTubeVideoInfo($YT_URL)
	
	Switch @error
		Case 1
			If _InetIsNotConnected() Then
				Local $ConnectErrMsg = "Please make sure that you are connected to the internet"
				_MsgBox(16, $AppName & " - No Internet Connection", $ConnectErrMsg, $hWnd)
				SetStatusData("", -1, $Prev_Info_StatusBar)
			Else
				SetStatusData("Fail To Get Info (Might be an Incorrect URL / ID)", 5, $Prev_Info_StatusBar)
			EndIf
			
			Return -1
		Case 2
			SetStatusData("This video has been removed!", 5, $Prev_Info_StatusBar)
			Return -1
		Case 3
			SetStatusData("Information about this video not availble yet, possibly video was uploaded recently)", _
				8, $Prev_Info_StatusBar)
			Return -1
		Case 4
			SetStatusData("Invalid ID!", 5, $Prev_Info_StatusBar)
			Return -1
	EndSwitch
	
	Local $Info_Count = 1
	Local $ThumbsArr = $VideoInfoArr[11], $ImagesAdded = 1
	
	GUICtrlSetData($VideoName_Input-3, $VideoInfoArr[0])
	GUICtrlSendMsg($VideoName_Input-3, $EM_SETSEL, 0, 0)
	
	For $i = $VideoName_Input To $Descriptions_Edit Step 2
		GUICtrlSetData($i, $VideoInfoArr[$Info_Count])
		GUICtrlSendMsg($i, $EM_SETSEL, 0, 0)
		
		$Info_Count += 1
		If $Info_Count >= 12 Then ExitLoop
	Next
	
	For $i = 0 To UBound($ThumbsArr)-1
		If $i > 3 Then ExitLoop
		
		If @InetGetActive Then
			RunWait(@AutoItExe & ' /AutoIt3ExecuteLine "InetGet(''' & $ThumbsArr[$i] & ''', ''' & @TempDir & '\YT_Thumb.jpg'', 1)"')
		Else
			InetGet($ThumbsArr[$i], @TempDir & "\YT_Thumb.jpg", 1)
		EndIf
		
		If FileExists(@TempDir & "\YT_Thumb.jpg") Then
			$ImagesAdded += 1
			GUICtrlSetImage($Thumbs_PicArr[$i+1], @TempDir & "\YT_Thumb.jpg")
			FileDelete(@TempDir & "\YT_Thumb.jpg")
		EndIf
	Next
	
	Return $ImagesAdded
EndFunc
