#include-once

TCPStartup()

Global Const $HTTPUserAgent	= "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0"
Global Const $HTTP_TCP_Port	= 80
Global Const $Limit_TimeOut	= 10000
Global Const $Main_YT_Host	= "www.youtube.com"
Global $LAST_SOCKET	= -1

Global $Use_Proxy = 0
Global $HttpProxy_Address = ""
Global $HttpProxy_UserName = ""
Global $HttpProxy_Password = ""
Global $HttpProxy_Port = "8080"

Func GetYouTubeDownloadData($YT_URL, $RetType=0)
	Local $Video_ID = GetYT_ID($YT_URL)
	Local $Host = $Main_YT_Host
	Local $Page = '/v/' & $Video_ID
	
	Local $Respones_Check = _HTTPGetRespones($Host, $Page)
	Switch @error
		Case 1
			Return SetError(1) ;Can not Connect to the TCP
		Case 2
			Return SetError(3, 'This video has been removed', '')
	EndSwitch
	
	Local $URL_Value = Get_URL_Value($Respones_Check)
	If $URL_Value = '' Then Return SetError(2, 0, '') ;The url contained a malformed video id
	
	$Respones_Check = _HTTPGetRespones($Host, '/get_video?video_id=' & $Video_ID & '&t=' & $URL_Value)
	Switch @error
		Case 1
			Return SetError(1) ;Can not Connect to the TCP
		Case 2
			Return SetError(3, 'This video has been removed', '')
	EndSwitch
	
	Local $Ret_Url = StringStripWS(_GetMidleString($Respones_Check, 'Location: ', '\n'), 3)
	If $Ret_Url = '' Then Return SetError(2, 0, '') ;The url contained a malformed video id / Other errror
	
	;If video does not downloaded, try to remove the following block (If StringInStr(...) Then ... EndIf)
	If StringInStr($Ret_Url, "origin=") Then
		Local $sOrigin_Prefix = StringRegExpReplace($Ret_Url, ".*origin=(.*?)&.*", "\1")
		Local $sSignature_Value = StringRegExpReplace($Ret_Url, ".*origin=.*?(&.*)$", "\1")
		
		$Ret_Url = "http://" & $sOrigin_Prefix & "/get_video?video_id=" & $Video_ID & $sSignature_Value
	EndIf
	
	If $RetType = 1 Then Return $Ret_Url
	
	$Host = StringRegExpReplace($Ret_Url, 'http://|www.', '')
	$Page = StringTrimLeft($Host, StringInStr($Host, '/')-1)
	$Host = StringLeft($Host, StringInStr($Host, '/')-1)
	
	Local $File_Size = 0
	If $RetType = 0 Then
		Local $Size_Respones = _HTTPGetRespones($Host, $Page)
		If StringInStr($Size_Respones, '200 OK') Then
			$File_Size = StringStripWS(_GetMidleString($Size_Respones, 'Content-Length: ', '\n'), 3)
		Else
			$File_Size = InetGetSize($Ret_Url)
		EndIf
		If $File_Size <= 0 Then $File_Size = InetGetSize($YT_URL)
	EndIf
	
	Local $Video_Name = ''
	Local $SearchForName = _HTTPGetSource('gdata.youtube.com', '/feeds/videos/' & $Video_ID)
	
	If Not StringInStr($SearchForName, 'Invalid Id') Then
		$Video_Name = _GetMidleString($SearchForName, "<media:title type='plain'>", "</media:title>")
	Else
		$Video_Name = 'YouTube_Video'
	EndIf
	If StringStripWS($Video_Name, 8) = '' Then $Video_Name = 'YouTube_Video'
	
	Local $RetArr[4] = [$Ret_Url, $Video_Name & '.flv', $File_Size, $URL_Value]
	Return $RetArr
EndFunc

Func GetYouTubeVideoInfo($YT_URL)
	Local $Video_ID = GetYT_ID($YT_URL)
	
	Local $FeedsSource = _HTTPGetSource('gdata.youtube.com', '/feeds/videos/' & $Video_ID)
	If @error = 1 Then Return SetError(1, 0, '')
	If StringInStr($FeedsSource, 'Video not found') Then
		Local $URL_Value = Get_URL_Value(-1, $YT_URL)
		_HTTPGetRespones($Main_YT_Host, '/get_video?video_id=' & $Video_ID & '&t=' & $URL_Value)
		If @error Then Return SetError(2, 0, '')
		Return SetError(3, 0, '')
	EndIf
	If StringInStr($FeedsSource, 'Invalid Id') Then Return SetError(4, 0, '')
	
	Local $Ret_Info_Arr[12]
	
	Local $URL_Value = Get_URL_Value(-1, $YT_URL)
	Local $Respones_Check = _HTTPGetRespones($Main_YT_Host, '/get_video?video_id=' & $Video_ID & '&t=' & $URL_Value)
	
	Local $Video_URL = StringStripWS(_GetMidleString($Respones_Check, 'Location: ', '\n'), 3)
	
	;If video does not downloaded, try to remove the following block (If StringInStr(...) Then ... EndIf)
	If StringInStr($Video_URL, "origin=") Then
		Local $sOrigin_Prefix = StringRegExpReplace($Video_URL, ".*origin=(.*?)&.*", "\1")
		Local $sSignature_Value = StringRegExpReplace($Video_URL, ".*origin=.*?(&.*)$", "\1")
		
		$Video_URL = "http://" & $sOrigin_Prefix & "/get_video?video_id=" & $Video_ID & $sSignature_Value
	EndIf
	
	$Ret_Info_Arr[0] = $Video_URL
	
	$Ret_Info_Arr[1] = _GetMidleString($FeedsSource, "<media:title type='plain'>", "</media:title>")
	If $Ret_Info_Arr[1] = "" Then $Ret_Info_Arr[1] = "N/A"
	
	$Ret_Info_Arr[2] = _GetMidleString($FeedsSource, "<yt:duration seconds='", "'/>")
	If $Ret_Info_Arr[2] = "" Then
		$Ret_Info_Arr[2] = "N/A"
	Else
		$Ret_Info_Arr[2] = _SecsToTime(StringRegExpReplace($Ret_Info_Arr[2], '[^0-9]', ''))
	EndIf
	
	$Ret_Info_Arr[3] = _GetMidleString($FeedsSource, "<author><name>", "</name>")
	If $Ret_Info_Arr[3] = "" Then $Ret_Info_Arr[3] = "N/A"
	
	$Ret_Info_Arr[4] = _GetMidleString($FeedsSource, "<yt:statistics viewCount='", "'/>")
	If $Ret_Info_Arr[4] = "" Then
		$Ret_Info_Arr[4] = "N/A"
	Else
		$Ret_Info_Arr[4] = _GetComasNumber(StringRegExpReplace($Ret_Info_Arr[4], '[^0-9]', ''))
	EndIf
	
	$Ret_Info_Arr[5] = _GetMidleString($FeedsSource, "<gd:rating min=.*?average='", "'/>")
	If $Ret_Info_Arr[5] = "" Then $Ret_Info_Arr[5] = "N/A"
	
	$Ret_Info_Arr[6] = _GetMidleString($FeedsSource, "<media:category label='.*?' scheme='.*?'>", "</media:category>")
	If $Ret_Info_Arr[6] = "" Then $Ret_Info_Arr[6] = "N/A"
	
	$Ret_Info_Arr[7] = _GetMidleString($FeedsSource, "<media:keywords>", "</media:keywords>")
	If $Ret_Info_Arr[7] = "" Then $Ret_Info_Arr[7] = "N/A"
	
	$Ret_Info_Arr[8] = _GetMidleString($FeedsSource, "<published>", "</published>")
	If $Ret_Info_Arr[8] = "" Then
		$Ret_Info_Arr[8] = "N/A"
	Else
		$Ret_Info_Arr[8] = StringRegExpReplace(StringReplace($Ret_Info_Arr[8], 'T', ', '), '\.(.*?)Z', '')
	EndIf
	
	$Ret_Info_Arr[9] = _GetMidleString($FeedsSource, "<updated>", "</updated>")
	If $Ret_Info_Arr[9] = "" Then
		$Ret_Info_Arr[9] = "N/A"
	Else
		$Ret_Info_Arr[9] = StringRegExpReplace(StringReplace($Ret_Info_Arr[9], 'T', ', '), '\.(.*?)Z', '')
	EndIf
	
	$Ret_Info_Arr[10] = _GetMidleString($FeedsSource, "<media:description type='plain'>", "</media:description>")
	If $Ret_Info_Arr[10] = "" Then $Ret_Info_Arr[10] = "N/A"
	
	$Ret_Info_Arr[11] = _GetMidleString($FeedsSource, "<media:thumbnail url='", "'", -1, 1)
	
	For $i = 0 To 10
		$Ret_Info_Arr[$i] = Correct_Content(_Utf8ToUnicode($Ret_Info_Arr[$i]), 2)
	Next
	
	Return $Ret_Info_Arr
EndFunc

Func GetYT_ID($Full_URL)
	Local $Ret_ID = _GetMidleString($Full_URL, '\?v=', '&')
	If $Ret_ID = '' Then $Ret_ID = _GetMidleString($Full_URL, '\?v=', '=')
	If $Ret_ID = '' Then $Ret_ID = _GetMidleString($Full_URL, '\?v=', '$')
	If $Ret_ID = '' Then Return $Full_URL
	Return $Ret_ID
EndFunc

Func GetYouTubeURLData($ID)
	If IsYouTubeURL($ID) Then
		Local $RetArr[3] = [$ID, StringTrimLeft($ID, StringInStr($ID, "=", 0, -1))]
		Return $RetArr
	EndIf
	
	Local $RetArr[2] = ["http://youtube.com/watch?v=" & $ID, $ID]
	Return $RetArr
EndFunc

Func Get_URL_Value($Resp=-1, $URL=-1)
	If $Resp = -1 And $URL <> -1 Then
		Local $rVideo_ID = GetYT_ID($URL)
		Local $rHost = $Main_YT_Host
		Local $rPage = "/v/" & $rVideo_ID
		
		$Resp = _HTTPGetRespones($rHost, $rPage)
		Switch @error
			Case 1
				Return SetError(1) ;Can not Connect to the TCP
			Case 2
				Return SetError(2, "This video has been removed", "")
		EndSwitch
	EndIf
	
	Local $Location_URL = StringStripWS(_GetMidleString($Resp, 'Location:', '\n'), 3)
	Local $URL_Value = _GetMidleString($Location_URL, '&t=', '$')
	If $URL_Value = '' Then $URL_Value = _GetMidleString($Location_URL, '&t=', '\?')
	If $URL_Value = '' Then $URL_Value = _GetMidleString($Location_URL, '&t=', '&')
	If $URL_Value = '' Then $URL_Value = _GetMidleString($Location_URL, '&t=', '=')
	Return $URL_Value
EndFunc

Func IsWatchYT_URL($URL)
	$URL = StringRegExpReplace($URL, '\A.*?//|www\.', '', 2)
	Return StringLeft($URL, 18) = 'youtube.com/watch?'
EndFunc

Func IsYouTubeURL($URL)
	$URL = StringRegExpReplace($URL, '\A.*?//|www\.', '', 2)
	Return StringLeft($URL, 7) = 'youtube'
EndFunc

Func IsYouTubeID($ID)
	Return StringLen($ID) <= 12
EndFunc

Func SetAppProxy_Proc()
	Switch $Use_Proxy
		Case 1 ;Direct access
			HttpSetProxy(1)
		Case 2 ;Set Proxy
			HttpSetProxy(2, $HttpProxy_Address & ":" & $HttpProxy_Port, $HttpProxy_UserName, $HttpProxy_Password)
		Case Else ;IE Settings
			HttpSetProxy(0)
	EndSwitch
EndFunc

Func _HTTPGetSource($Host, $Page)
	Local $Recv = '', $RcvBytes = 1024
	Local $Socket = _HTTPConnect($Host)
	
	_HTTPGet($Host, $Page, $Socket)
	If @error Then Return SetError(1, 0, '')
	
	Local $iTimer = TimerInit()
	
	While 1
		$CurrentLine = TCPRecv($Socket, $RcvBytes)
		If @error <> 0 Or TimerDiff($iTimer) >= $Limit_TimeOut Then ExitLoop
		If $CurrentLine <> '' Then $Recv &= $CurrentLine
	WEnd
	
	Return $Recv
EndFunc

Func _HTTPConnect($Host)
	Local $Name_To_IP = TCPNameToIP($Host)
	Local $Socket = TCPConnect($Name_To_IP, $HTTP_TCP_Port)
	
	If $Socket = -1 Then
		TCPCloseSocket($Socket)
		Return SetError(1, 0, "")
	EndIf
	
	$LAST_SOCKET = $Socket
	Return $Socket
EndFunc

Func _HTTPGetRespones($Host, $Page)
	Local $Socket = _HTTPConnect($Host)
	If @error Then Return SetError(1, 0, "")
	
	_HTTPHead($Host, $Page, $Socket)
	
	Local $Recv = "", $CurrentRecv, $iTimer = TimerInit()
	
	While 1
		$CurrentRecv = TCPRecv($Socket, 16)
		If @error <> 0 Or TimerDiff($iTimer) >= $Limit_TimeOut Then ExitLoop
		If $CurrentRecv <> "" Then $Recv &= $CurrentRecv
	WEnd
	
	If StringInStr($Recv, "HTTP/1.1 410 Gone") Then Return SetError(2, 0, "")
	
	Return $Recv
EndFunc

Func _HTTPHead($Host, $Page, $Socket)
	Local $Command = "HEAD " & $Page & " HTTP/1.1" & @CRLF
	$Command &= "Host: " & $Host & @CRLF
	$Command &= "User-Agent: " & $HTTPUserAgent & @CRLF
	$Command &= "Connection: close" & @CRLF & @CRLF
	
	Local $BytesSent = TCPSend($Socket, $Command)
	If $BytesSent = 0 Then Return SetError(2, @error, 0)
	Return $BytesSent
EndFunc

Func _HTTPGet($Host, $Page, $Socket)
	Local $Command = "GET " & $Page & " HTTP/1.1" & @CRLF
	$Command &= "Host: " & $Host & @CRLF
	$Command &= "User-Agent: " & $HTTPUserAgent & @CRLF
	$Command &= "Connection: close" & @CRLF & @CRLF
	
	Local $BytesSent = TCPSend($Socket, $Command)
	If $BytesSent = 0 Then Return SetError(1, @error, 0)
	Return $BytesSent
EndFunc

Func _HTTPClose()
	If $LAST_SOCKET <> -1 Then TCPCloseSocket($LAST_SOCKET)
	TCPShutdown()
	Return 1
EndFunc
