; ==============================================================================
;	AutoIt (v3.2.8.1) Source Code for:
;	
;	<YouTube Video Download Center> allows you to download YouTube videos,
;	search videos, and get extended information about YouTube Videos!
;	
;	by G.Sandler (a.k.a CreatoR), CreatoR's Lab (http://creator-lab.ucoz.ru)
; ==============================================================================
;

#Region Includes and Options
#NoTrayIcon
#include <GUIConstants.au3>
#include <Constants.au3>
#include <GUIStatusBar.au3>
#include <GUICombo.au3>
#include <Resources\Main.au3>
#include <Resources\DllCallBack.au3>
#include <Resources\FileSelectFolder.au3>
#include <Resources\Browser_Monitor_Module.au3>
#include <Resources\InetGetFuncs.au3>
#include <Resources\Encoding.au3>
#include <Resources\YT_HTTP.au3>
#include <Resources\Preview_Info.au3>
#include <Resources\Help.au3>

Opt("GuiOnEventMode", 1)
Opt("RunErrorsFatal", 0)
Opt("TrayMenuMode", 1)
Opt("TrayOnEventMode", 1)
Opt("GUIResizeMode", 802)

HotKeySet("{F1}", "CallAbout")
#EndRegion Includes and Options
;

;Command Line Options
If StringInStr($CmdLineRaw, '/Silent') And _GetCmdLine('/YT_URL_ID=') <> '' Then SilentDownload()

#Region Global Variables / Options / FileInstalls
FileInstall("Resources\YouTube_Img.gif", 		$Temp_Dir & "\", 1)
FileInstall("Resources\YT_Icon.ico", 			$Temp_Dir & "\", 1)
FileInstall("Resources\YT_Icon_Down_1.ico", 	$Temp_Dir & "\", 1)
FileInstall("Resources\YT_Icon_Down_2.ico", 	$Temp_Dir & "\", 1)
FileInstall("Resources\YT_Icon_Item.ico", 		$Temp_Dir & "\", 1)
FileInstall("Resources\Not_Availible_Img.jpg", 	$Temp_Dir & "\", 1)
FileInstall("Resources\Load.avi", 				$Temp_Dir & "\", 1)
FileInstall("Resources\Done.wav", 				$Temp_Dir & "\", 1)
FileInstall("Resources\Clicked.wav", 			$Temp_Dir & "\", 1)

Global $Play_Done_Sound			= IniRead($ConfigFile, "Main Prefs", "Play Sound When Finish Downloading", 1)
Global $AutoRenameFile			= IniRead($ConfigFile, "Main Prefs", "Autorename Existing Videos", 1)
Global $ReloadFromInet			= IniRead($ConfigFile, "Main Prefs", "Get File From Local Cache", 1)
Global $WriteLog_When_Download	= IniRead($ConfigFile, "Main Prefs", "Write Log When Downloading Video", 1)
Global $Show_Details			= IniRead($ConfigFile, "Main Prefs", "Show Details", 0)
Global $Download_With_Def_Brows	= IniRead($ConfigFile, "Main Prefs", "Download With Default Browser", 0)
Global $LastDownloadedName		= IniRead($ConfigFile, "Main Prefs", "Last Downloaded Video Name", "")
Global $LastDownloadPath 		= IniRead($ConfigFile, "Main Prefs", "Last Download Path", _GetMyVideosPath())
Global $LastUsedDownPath 		= $LastDownloadPath
Global $CallEventOnComplDown	= IniRead($ConfigFile, "Main Prefs", "Call Event When Complete Downloading", "No Special Event")
Global $Monitor_Browsers		= IniRead($ConfigFile, "Main Prefs", "Monitor Browsers", 0)
Global $Animate_Tray_Icon		= IniRead($ConfigFile, "Main Prefs", "Animate Tray Icon When Monitoring", 0)
Global $Minimize_To_Tray		= IniRead($ConfigFile, "Main Prefs", "Minimize To Tray", 0)

Global $URLsHistory				= IniRead($ConfigFile, "URLs History", "Data", "")
Global $LastHistoryURL			= IniRead($ConfigFile, "URLs History", "Last URL", "")

Global $SearchDefaultSortBy		= IniRead($ConfigFile, "Search Prefs", "Default Sort By", "Relevance")
Global $FeelingLucky			= IniRead($ConfigFile, "Search Prefs", "Feeling Lucky", 0)
Global $SearchKeyWordsHistory	= IniRead($ConfigFile, "Search Prefs", "Search History Data", "")
Global $LastSearchKeyWords		= IniRead($ConfigFile, "Search Prefs", "Last Search KeyWords", "")

Global $Use_Proxy 				= IniRead($ConfigFile, "Proxy Prefs", "Proxy Settings", 0)
Global $HttpProxy_Address 		= IniRead($ConfigFile, "Proxy Prefs", "Proxy Address", "")
Global $HttpProxy_UserName 		= IniRead($ConfigFile, "Proxy Prefs", "Proxy User Name", "")
Global $HttpProxy_Password 		= IniRead($ConfigFile, "Proxy Prefs", "Proxy Password", "")
Global $HttpProxy_Port 			= IniRead($ConfigFile, "Proxy Prefs", "Proxy Port", "8080")

SetAppProxy_Proc()
#EndRegion Global Variables / Options / FileInstalls
;

#Region Tray Creation Part
TraySetOnEvent($TRAY_EVENT_PRIMARYUP, "TrayMainEvents")
TraySetClick(16)
TraySetToolTip($AppName & " - " & $AppVer)

Global Const $About_TrayItem = TrayCreateItem("About")
TrayItemSetOnEvent(-1, "TrayMainEvents")

TrayCreateItem("")

Global Const $Monitor_Browser_TrayItem = TrayCreateItem("Monitor Browsers (!) [IE / Opera Supported]")
TrayItemSetOnEvent(-1, "TrayMainEvents")

Global Const $Exit_TrayItem = TrayCreateItem("Exit Programm")
TrayItemSetOnEvent(-1, "TrayMainEvents")
#EndRegion Tray Creation Part
;

#Region GUI Creation Part
Global Const $GUI = GUICreate($AppName & " - " & $AppVer, 500, 570, -1, -1, $WS_MINIMIZEBOX+$WS_SYSMENU, $WS_EX_CLIENTEDGE)
$App_Main_Hwnd = $GUI
GUIRegisterMsg($WM_LBUTTONDOWN, "DRAG_COMMAND")
GUISetOnEvent($GUI_EVENT_CLOSE, "MainEvents")
GUISetOnEvent($GUI_EVENT_MINIMIZE, "MainEvents")

GUISetBkColor(0xFFFFFF)
GUISetIcon($YouTube_IconPath)
#EndRegion GUI Creation Part
;

#Region Main Menu
Global Const $Options_Menu 	= GUICtrlCreateMenu("Options")
Global Const $Tools_Menu 	= GUICtrlCreateMenu("Tools")
Global Const $Edit_Menu 	= GUICtrlCreateMenu("Edit")
Global Const $Help_Menu 	= GUICtrlCreateMenu("Help")

;Options Menu
Global Const $Play_Done_Sound_MenuItem = GUICtrlCreateMenuItem("Play Sound When Finish Downloading", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $Play_Done_Sound = 1 Then GUICtrlSetState(-1, 1)

Global Const $AutoRenExistsVideo_MenuItem = GUICtrlCreateMenuItem("AutoRename Existing Video Files", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $AutoRenameFile = 1 Then GUICtrlSetState(-1, 1)

Global Const $ReloadFromInet_MenuItem = GUICtrlCreateMenuItem("Get File From Local Cache If Available", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $ReloadFromInet = 0 Then GUICtrlSetState(-1, 1)

Global Const $SetProxy_MenuItem = GUICtrlCreateMenuItem("Set Proxy Settings...", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Options_Menu)

Global Const $WriteLog_When_Down_MenuItem = GUICtrlCreateMenuItem("Write Log File When Downloading", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $WriteLog_When_Download = 1 Then GUICtrlSetState(-1, 1)

Global Const $Open_Log_File_MenuItem = GUICtrlCreateMenuItem("Open Log File...", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

Global Const $Clear_Log_File_MenuItem = GUICtrlCreateMenuItem("Clean Log File...", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Options_Menu)

Global Const $Animate_Tray_MenuItem = GUICtrlCreateMenuItem("Animate Tray Icon When Downloading " & _
	"(only when minimized to tray)", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $Animate_Tray_Icon = 1 Then GUICtrlSetState(-1, 1)

Global Const $Minimize_To_Tray_MenuItem = GUICtrlCreateMenuItem("Minimize To Tray", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $Minimize_To_Tray = 1 Then GUICtrlSetState(-1, 1)

GUICtrlCreateMenuItem("", $Options_Menu)

Global Const $Exit_MenuItem = GUICtrlCreateMenuItem("Exit The Program", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

;Tools Menu
Global Const $Info_Tool_MenuItem = GUICtrlCreateMenuItem("Get Video Info Tool...", $Tools_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

Global Const $Search_Tool_MenuItem = GUICtrlCreateMenuItem("Search Videos Tool...", $Tools_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Tools_Menu)

Global Const $When_Complete_Down_MenuItem = GUICtrlCreateMenuItem("When Complete Download...", $Tools_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Tools_Menu)

Global Const $Monitor_Browser_MenuItem = GUICtrlCreateMenuItem("Monitor Browsers (!) " & _
	"[Supported; IE / Firefox / Opera]", $Tools_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $Monitor_Browsers = 1 Then
	GUICtrlSetState(-1, 1)
	InitializeCallBack("Monitor_Proc", $Timer_Proc_Monitor, $iTimer_Monitor, 1500)
EndIf

;Edit Menu
Global Const $Clear_Current_URL_MenuItem = GUICtrlCreateMenuItem("Clear Current URL From History", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Edit_Menu)

Global Const $Clear_URLs_History_MenuItem = GUICtrlCreateMenuItem("Clear URLs History", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

Global Const $Clear_Search_History_MenuItem = GUICtrlCreateMenuItem("Clear Search History", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")


;Help Menu
Global Const $About_MenuItem = GUICtrlCreateMenuItem("About Program...	(F1)", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

Global Const $CheckUpdates_MenuItem = GUICtrlCreateMenuItem("Check Updates", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

Global Const $VisitAppTopic_MenuItem = GUICtrlCreateMenuItem("AutoItScript Forum Discussions About YTDC", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Help_Menu)

Global Const $Find_VideoPlayer_MenuItem = GUICtrlCreateMenuItem("Find Player For Downloaded YouTube Videos..", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

#EndRegion Main Menu
;

#Region Main Controls
Global Const $YouTube_Pic = GUICtrlCreatePic($YouTube_ImgPath, 10, 10, 306, 106)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Visit YouTube Home Page [http://youtube.com]")
GUICtrlSetCursor(-1, 0)

Global Const $Home_Label = GUICtrlCreateLabel("Home", 325, 15, -1, 15)
GUICtrlSetColor(-1, 0x808080)
GUICtrlSetState(-1, $GUI_HIDE)

Global Const $Author_Label = GUICtrlCreateLabel("by G.Sandler a.k.a CreatoR", 320, 98, 133, 15)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "http://creator-lab.ucoz.ru", "Visit Author's Home Page", 0, 1)
GUICtrlSetColor(-1, 0x808080)
GUICtrlSetFont(-1, 8, 800, 2)
GUICtrlSetCursor(-1, 0)

Global Const $Search_Button = GUICtrlCreateButton("Search Videos...", 390, 135, 90, 20, $BS_DEFPUSHBUTTON)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateLabel("Please type YouTube URL or Video ID:", 20, 140)
Global Const $URL_Combo = GUICtrlCreateCombo("", 20, 160, 310, 20)
SetURLsData()

Global Const $Show_Info_Button = GUICtrlCreateButton("Get Info", 335, 160, 50, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Show Detailed Information about the Video from this URL")

Global Const $OpenLinkInBrowser_Button = GUICtrlCreateButton("Open In Browser", 390, 160, 90, 20)
GUICtrlSetTip(-1, "Open URL in Browser... [Popups a menu with options]")

Global Const $Dummy_Context_Menu = GUICtrlCreateDummy()
Global Const $Open_In_Context_Menu = GUICtrlCreateContextMenu($Dummy_Context_Menu)
Global Const $Open_In_Deff_Browser_Item = GUICtrlCreateMenuItem("Open in Default Browser", $Open_In_Context_Menu)
Global Const $Open_In_IE_Item = GUICtrlCreateMenuItem("Open in Internet Explorer", $Open_In_Context_Menu)
Global Const $Open_In_Opera_Item = GUICtrlCreateMenuItem("Open in Opera Browser", $Open_In_Context_Menu)
Global Const $Open_In_FF_Item = GUICtrlCreateMenuItem("Open in FireFox Browser", $Open_In_Context_Menu)

For $i = $OpenLinkInBrowser_Button To $Open_In_FF_Item
	GUICtrlSetOnEvent($i, "MainEvents")
Next

Global Const $Example_Label = GUICtrlCreateLabel("Example: http://youtube.com/watch?v=LM-GVBVgegA", 20, 183)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "James Blunt - Goodbye my lover - music video" & @LF & "* Click to use this URL", "Example Video Name", 1, 1)
GUICtrlSetColor(-1, 0xFF8000)
GUICtrlSetCursor(-1, 0)

Global Const $PathToDownloads_Label = GUICtrlCreateLabel("Path to save Downloaded Videos:", 20, 205, -1, 15)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Click to Open the path")
GUICtrlSetColor(-1, 0x808080)
GUICtrlSetCursor(-1, 0)

Global Const $SelectPath_Button = GUICtrlCreateButton("...", 460, 227, 16, 16)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Select Destination Path for Downloaded Videos")
Global Const $DownloadPath_Input = GUICtrlCreateInput($LastDownloadPath, _
	20, 225, 460, 20, $WS_CLIPSIBLINGS+$ES_AUTOHSCROLL, $WS_EX_DLGMODALFRAME)
GUICtrlSetTip($DownloadPath_Input, $LastUsedDownPath)
If _GetCmdLine('/Path=') <> '' Then GUICtrlSetData($DownloadPath_Input, _StringStripChars(_GetCmdLine('/Path='), '"', 3))

Global Const $Download_Button = GUICtrlCreateButton("Download", 20, 260, 70, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetState(-1, $GUI_DEFBUTTON)

Global Const $Down_With_Def_Brows_CB = GUICtrlCreateCheckbox("Download with Default Browser", 100, 260)
If $Download_With_Def_Brows = 1 Then GUICtrlSetState(-1, 1)

Global Const $ShowHideDetails_Label = GUICtrlCreateLabel("Hide Details", 400, 262, 75)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetFont(-1, 9, 400, 4)
GUICtrlSetColor(-1, 0x0000FF)
GUICtrlSetCursor(-1, 0)
#EndRegion Main Controls
;

GUICtrlCreateLabel("", 10, 330, 480, 3, $SS_ETCHEDFRAME, $GUI_WS_EX_PARENTDRAG) ;Draw Line

#Region Details Controls
Global Const $ChangeName_Button = GUICtrlCreateButton("Change...", 410, 337, 70, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Change Video Name")
GUICtrlSetState(-1, $GUI_HIDE)

GUICtrlCreateLabel("Downloading:", 20, 340, 180, 15, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 9, 800)
Global Const $Downloading_Data_Edit = GUICtrlCreateEdit("", 240, 340, 160, 17, $ES_READONLY+$ES_AUTOHSCROLL, 0x990)
GUICtrlSetState(-1, 128)
GUICtrlSetColor(-1, 0xFF0000)
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUICtrlSetFont(-1, 9, 800)

GUICtrlCreateLabel("File Size:", 20, 370, 180, 15, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 9, 800)
Global Const $Size_Data_Label = GUICtrlCreateLabel("", 240, 370, 300)
GUICtrlSetState(-1, 128)

GUICtrlCreateLabel("Download Speed (kb/s):", 20, 400, 180, 15, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 9, 800)
Global Const $Speed_Data_Label = GUICtrlCreateLabel("", 240, 400, 300)
GUICtrlSetState(-1, 128)

GUICtrlCreateLabel("Approximately remained Time:", 20, 430, 180, 15, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 9, 800)
Global Const $Remained_Data_Label = GUICtrlCreateLabel("", 240, 430, 300)
GUICtrlSetState(-1, 128)

GUICtrlCreateLabel("Ready:", 20, 460, 180, 15, -1, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetFont(-1, 9, 800)
Global Const $Ready_Data_Label = GUICtrlCreateLabel("", 240, 460, 300, 17)
GUICtrlSetState(-1, 128)
#EndRegion Details Controls
;

Global Const $StatusBar = _GUICtrlStatusBarCreate($GUI, "", "")
_GUICtrlStatusBarSetSimple($StatusBar)
_GUICtrlStatusBarSetIcon($StatusBar, 255, "Shell32.dll", 221)
_GUICtrlStatusBarSetUnicode($StatusBar)

If $Show_Details = 0 Then
	$GuiRetCoords = ToggleDetailsProc(1, 0)
	If IsArray($GuiRetCoords) Then WinMove($GUI, "", $GuiRetCoords[0], $GuiRetCoords[1])
EndIf

_ReduceMemory(@AutoItPID)
GUISetState(@SW_SHOW, $GUI)

While 1
	Sleep(100)
	
	If $StatusTimer <> -1 And TimerDiff($StatusTimer) >= $StatusWaitTime*1000 Then SetStatusData("")
	
	HoverLabelProc($HoverPicMark, $YouTube_Pic, "SetElementStateProc", $GUI_SHOW, $GUI_HIDE, $GUI, $Home_Label)
	HoverLabelProc($HoverAuthorMark, $Author_Label, "SetColorProc", 0x0000FF, 0x808080, $GUI)
	HoverLabelProc($HoverExampleMark, $Example_Label, "SetColorProc", 0x0000FF, 0xFF8000, $GUI)
	
	If WinActive($GUI) Then
		HotKeySet("{F1}", "CallAbout")
	Else
		HotKeySet("{F1}")
	EndIf
	
	If $Monitor_Detected[0] <> False And $Timer_Proc_Download = 0 And $Monitor_Detected[0] <> GUICtrlRead($URL_Combo) Then
		If WinIsVisible("About - " & $AppName) Then WinWaitClose("About - " & $AppName)
		
		Local $Download_URL = $Monitor_Detected[0]
		$Monitor_Detected[0] = False
		
		Local $WasMinimized = 0
		If Not WinIsVisible($GUI) Then
			$WasMinimized = 1
			TraySetState(2)
			GUISetState(@SW_SHOW, $GUI)
			Sleep(100)
		EndIf
		WinActivate($GUI)
		
		Local $Ask_Download = _MsgBox(36, "Attention", _
			"Detected YouTube URL (From: " & $Monitor_Detected[2] & "), would you like to download this video?" & @LF &	@LF & _
			"[" & _UTF8ToAnsi($Monitor_Detected[1]) & "]" & @LF & _
			"[" & $Download_URL & "]" & @LF & @LF & @LF & _
			"Hint: You can turn off the monitoring for YouTube Urls from menu <Options>.", $GUI)
		If $Ask_Download = 6 Then
			WinActivate($GUI)
			ControlSetText($App_Main_Hwnd, "", $URL_Combo, $Download_URL)
			Sleep(100)
			ControlClick($App_Main_Hwnd, "", $Download_Button)
		ElseIf $WasMinimized Then
			GUISetState(@SW_HIDE, $GUI)
			TraySetState(1)
		EndIf
	EndIf
	
	If $DDE_IN_USE = True Then
		Sleep(3000)
		$DDE_IN_USE = False
	EndIf
	
	If $LastUsedDownPath <> GUICtrlRead($DownloadPath_Input) Then
		$LastUsedDownPath = GUICtrlRead($DownloadPath_Input)
		GUICtrlSetTip($DownloadPath_Input, $LastUsedDownPath)
	EndIf
WEnd

Func MainEvents()
	If Not @InetGetActive Then SetStatusData("")
	
	Switch @GUI_CtrlId
		Case $GUI_EVENT_CLOSE, $Exit_MenuItem
			Quit(1)
		Case $GUI_EVENT_MINIMIZE
			If $Minimize_To_Tray = 1 Then
				GUISetState(@SW_HIDE, $GUI)
				
				If Not @InetGetActive Then
					TraySetIcon($YouTube_IconPath)
				ElseIf $Animate_Tray_Icon = 1 Then
					TraySetIcon($YouTube_Anim_1_IconPath)
				Else
					TraySetIcon($YouTube_IconPath)
				EndIf
				TraySetState(1)
				TraySetToolTip($AppName & " - " & $AppVer)
			EndIf
		Case $About_MenuItem
			CallAbout()
		Case $CheckUpdates_MenuItem
			ShellExecute("http://creator-lab.ucoz.ru/load/2-1-0-24")
		Case $VisitAppTopic_MenuItem
			ShellExecute("http://www.autoitscript.com/forum/index.php?s=&showtopic=55809&view=findpost&p=423396")
		Case $Find_VideoPlayer_MenuItem
			ShellExecute("http://www.google.com/search?hl=en&lr=&q=Flv+Player&btnG=Search")
		Case $Play_Done_Sound_MenuItem
			SetMenuItemData(@GUI_CtrlId, $Play_Done_Sound)
		Case $AutoRenExistsVideo_MenuItem
			SetMenuItemData(@GUI_CtrlId, $AutoRenameFile)
		Case $ReloadFromInet_MenuItem
			SetMenuItemData(@GUI_CtrlId, $ReloadFromInet)
		Case $SetProxy_MenuItem
			SetAppProxy_Dialog($GUI)
		Case $WriteLog_When_Down_MenuItem
			SetMenuItemData(@GUI_CtrlId, $WriteLog_When_Download)
		Case $Open_Log_File_MenuItem
			If FileExists($Log_File_Path) Then
				_Execute($Log_File_Path)
			Else
				SetStatusData("Log file not exists yet", 5)
			EndIf
		Case $Clear_Log_File_MenuItem
			If FileExists($Log_File_Path) Then
				Local $AskClean = _MsgBox(52, $AppName & " - Attention", "Are you sure, clean the content of Log File?", $GUI)
				If $AskClean = 6 Then FileClose(FileOpen($Log_File_Path, 2))
			Else
				SetStatusData("Log file not exists yet", 5)
			EndIf
		Case $Clear_Current_URL_MenuItem
			Local $Current_URL = ControlGetText($GUI, "", $URL_Combo)
			Local $Current_Index = _GUICtrlComboGetCurSel($URL_Combo)
			If $Current_Index <> $CB_ERR Then _GUICtrlComboDeleteString($URL_Combo, $Current_Index)
			If IsWatchYT_URL($Current_URL) Then ControlSetText($GUI, "", $URL_Combo, $Current_URL)
			$LastHistoryURL = $Current_URL
			$URLsHistory = _GUICtrlComboGetList($URL_Combo)
			$URLsHistory = _StringStripChars(DeleteDuplicatesInStr($URLsHistory), "|", 3)
		Case $Clear_URLs_History_MenuItem
			Local $Current_URL = ControlGetText($GUI, "", $URL_Combo)
			_GUICtrlComboResetContent($URL_Combo)
			If IsWatchYT_URL($Current_URL) Then ControlSetText($GUI, "", $URL_Combo, $Current_URL)
			$LastHistoryURL = $Current_URL
			$URLsHistory = ""
		Case $Clear_Search_History_MenuItem
			$SearchKeyWordsHistory = ""
			$LastSearchKeyWords = ""
		Case $Monitor_Browser_MenuItem
			ToggleMonitoringState($Monitor_Browser_MenuItem)
		Case $Animate_Tray_MenuItem
			SetMenuItemData(@GUI_CtrlId, $Animate_Tray_Icon)
		Case $Minimize_To_Tray_MenuItem
			SetMenuItemData(@GUI_CtrlId, $Minimize_To_Tray)
		Case $YouTube_Pic
			ClickHandlerProc($YouTube_Pic, "http://youtube.com", $GUI)
		Case $PathToDownloads_Label
			Local $PathToDownloads = GUICtrlRead($DownloadPath_Input)
			If Not StringInStr($PathToDownloads, ":") Then $PathToDownloads = @WorkingDir & "\" & $PathToDownloads
			
			If $PathToDownloads = "" Then
				SetStatusData("Please Type/Select Path")
				Return
			ElseIf Not PathIsReady($PathToDownloads) Or Not PathIsDir($PathToDownloads) Then
				SetStatusData("Path not exists / Not Valid")
				Return
			EndIf
			
			SoundPlay($Clicked_Sound_Path, 0)
			If Not StringInStr('\/', StringMid($PathToDownloads, 3, 1)) Then _
				$PathToDownloads = StringReplace($PathToDownloads, ":", ":\", 1)
			
			Local $ExplorerLine = ''
			If $LastDownloadedName <> '' And FileExists($PathToDownloads & '\' & $LastDownloadedName) Then _
				$ExplorerLine = '", /Select, "' & $PathToDownloads & '\' & $LastDownloadedName & '"'
			
			Run('Explorer.exe "' & $PathToDownloads & $ExplorerLine, $PathToDownloads)
		Case $Search_Button, $Search_Tool_MenuItem
			Search_Dialog($GUI)
		Case $Show_Info_Button, $Info_Tool_MenuItem
			Local $InputURL = ControlGetText($GUI, "", $URL_Combo)
			Preview_Info_Dialog($InputURL, $AppName, $YT_Img_Not_Available, $YouTube_IconPath, $GUI)
		Case $When_Complete_Down_MenuItem
			OnCompleteDownloadDialog($GUI)
		Case $OpenLinkInBrowser_Button
			ShowMenu($GUI, $Open_In_Context_Menu)
		Case $Open_In_Deff_Browser_Item, $Open_In_IE_Item, $Open_In_Opera_Item, $Open_In_FF_Item
			$DDE_IN_USE = True
			Local $InputURL = ControlGetText($GUI, "", $URL_Combo)
			
			If Not IsWatchYT_URL($InputURL) Then
				Local $StatusData = "Can not Open, this is not YouTube Video URL!"
				If $InputURL = "" Then $StatusData = "Please type URL"
				SetStatusData($StatusData)
				Return
			EndIf
			
			Switch @GUI_CtrlId
				Case $Open_In_Deff_Browser_Item
					_Execute($InputURL)
					$Last_Catched_IE_URL = $InputURL
					$Last_Catched_OP_URL = $InputURL
				Case $Open_In_IE_Item
					_Execute('iexplore.exe', $InputURL, @SystemDir)
					If @error Then
						SetStatusData("There was an error to open URL, check your Internet Exlorer.", 7)
					Else
						$Last_Catched_IE_URL = $InputURL
					EndIf
				Case $Open_In_Opera_Item
					OpenUrlInOpera($InputURL)
					If @error Then
						SetStatusData("There was an error to open URL, parhaps the Opera Browser not installed.", 8)
					Else
						$Last_Catched_OP_URL = $InputURL
					EndIf
				Case $Open_In_FF_Item
					_Execute('firefox.exe', $InputURL)
					If @error Then
						SetStatusData("There was an error to open URL, parhaps the FireFox Browser not installed.", 7)
					Else
						$Last_Catched_FF_URL = $InputURL
					EndIf
			EndSwitch
		Case $Example_Label
			SoundPlay($Clicked_Sound_Path, 0)
			ControlSetText($GUI, "", $URL_Combo, StringTrimLeft(GUICtrlRead($Example_Label), StringLen("Example: ")))
		Case $SelectPath_Button
			Local $InitDir = GUICtrlRead($DownloadPath_Input)
			Local $SavePath = _FileSelectFolder('Please select Folder to save Downloaded Videos', _
				0, $BIF_NEWDIALOGSTYLE+$BIF_RETURNONLYFSDIRS, $InitDir, $GUI)
			If Not @error Then GUICtrlSetData($DownloadPath_Input, $SavePath)
		Case $Author_Label
			ClickHandlerProc($Author_Label, "http://creator-lab.ucoz.ru", $GUI)
		Case $ShowHideDetails_Label
			ToggleDetailsProc(0)
		Case $Download_Button
			Local $InputURL = ControlGetText($GUI, "", $URL_Combo)
			
			If $InputURL = "" Then
				SetStatusData("Please type URL")
				Return
			EndIf
			
			If GUICtrlRead($Down_With_Def_Brows_CB) = 1 Then
				$DDE_IN_USE = True
				Local $Download_URL = GetYouTubeDownloadData($InputURL, 1)
				
				If Not @error And $Download_URL <> '' Then
					_Execute($Download_URL)
				Else
					Local $Video_ID = GetYT_ID($InputURL)
					_Execute("http://cache.googlevideo.com/get_video?video_id=" & $Video_ID)
				EndIf
				
				Return
			EndIf
			
			Local $Download_Path = GUICtrlRead($DownloadPath_Input)
			
			If $Download_Path = "" Then
				SetStatusData("Please type Path to downloaded videos", 4)
				Return
			ElseIf Not PathIsReady($Download_Path) Or Not PathIsDir($Download_Path) Then
				If Not DirCreate($Download_Path) Then
					SetStatusData("Can not Create Download Dir, please type a correct Path to downloaded videos", 4)
					Return
				EndIf
			EndIf
			
			If Not StringInStr($URLsHistory, $InputURL) Then
				_GUICtrlComboAddString($URL_Combo, $InputURL)
				$URLsHistory &= "|" & $InputURL
			EndIf
			
			ToggleEnableElements(1)
			SetStatusData("Please wait...")
			WriteToLog("Collecting Download Information...")
			
			Local $DownloadInfoArr = GetYouTubeDownloadData($InputURL)
			
			Switch @error
				Case 1, 2
					If _InetIsNotConnected() Then
						Local $ConnectErrMsg = "Please make sure that you are connected to the internet"
						WriteToLog("No Internet Connection - " & $ConnectErrMsg)
						SetStatusData("")
						_MsgBox(16, $AppName & " - No Internet Connection", $ConnectErrMsg, $GUI)
					Else
						WriteToLog("The URL contained a malformed video id / Incorrect ID")
						SetStatusData("The URL contained a malformed video id / Incorrect ID", 5)
					EndIf
					ToggleEnableElements(0)
					Return
				Case 3
					WriteToLog("This video has been removed")
					SetStatusData("This video has been removed", 5)
					ToggleEnableElements(0)
					Return
				Case 4
					WriteToLog("Error: Unknown error (" & @error & ")")
					SetStatusData("Error: Unknown error (" & @error & ")", 3)
					ToggleEnableElements(0)
					Return
			EndSwitch
			
			Local $DestPath_Drive = StringLeft($Download_Path, 1) & ":"
			Local $DestPath_FreeSpace = DriveSpaceFree($DestPath_Drive)
			
			If $DestPath_FreeSpace < Int($DownloadInfoArr[2] / 1024 / 1024) Then
				Local $Err_NoSpace_Data = "Error: There is no anouth space on drive <" & _
					$DestPath_Drive & "> [Required: " & _GetDisplaySize($DownloadInfoArr[2]) & "]"
				
				WriteToLog($Err_NoSpace_Data)
				
				SetStatusData($Err_NoSpace_Data, 10)
				ToggleEnableElements(0)
				
				Return
			EndIf
			
			Local $DownloadFileName = $DownloadInfoArr[1]
			$DownloadFileName = _StrReplaceUnsupported($DownloadFileName)
			
			If $AutoRenameFile = 1 Then $DownloadFileName = _GetNewFileName($DownloadFileName, $Download_Path)
			
			$LogDownloadFileName = $DownloadFileName
			$DownloadFileName = _UTF8ToUnicode($DownloadFileName)
			
			WriteToLog("Start Downloading of [" & $LogDownloadFileName & "]")
			InetGet($DownloadInfoArr[0], $Download_Path & "\" & $DownloadFileName, Number($ReloadFromInet < 1), 1)
			
			While Not @InetGetActive
				Sleep(10)
			WEnd
			
			ToggleDetailsProc(2, 0)
			Sleep(10)
			ToggleEnableElements(0)
			
			$LastDownloadPath = $Download_Path
			$LastDownloadedName = $DownloadFileName
			$LastLogDownloadedName = $LogDownloadFileName
			$Inet_Display_Size = _GetDisplaySize($DownloadInfoArr[2])
			$INETGETSIZE = $DownloadInfoArr[2]
			$TIMERSTART = TimerInit()
			
			InitializeCallBack("DownloadProc", $Timer_Proc_Download, $iTimer_Download, $RefreshDataRate)
			SetStatusData("Downloading...", -1)
			TrayItemSetState($Monitor_Browser_TrayItem, 128)
			GUICtrlSetState($Monitor_Browser_MenuItem, 128)
			GUICtrlSetState($Download_Button, 64)
			GUICtrlSetData($Download_Button, "Abort")
			GUICtrlSetOnEvent($Download_Button, "AbortDownload")
			GUICtrlSetData($Downloading_Data_Edit, $LastDownloadedName)
			GUICtrlSetState($Downloading_Data_Edit, 64)
			GUICtrlSetState($ChangeName_Button, $GUI_SHOW)
			GUICtrlSetOnEvent($ChangeName_Button, "ChangeNameProc")
			
			Local $InetSetSize = _GetDisplaySize($INETGETSIZE, 1)
			If $INETGETSIZE <= 0 Then $InetSetSize = "NA"
			GUICtrlSetData($Size_Data_Label, $InetSetSize)
			
			If $LastDownloadedName = "YouTube_Video.flv" Then
				Local $URL_ID = StringTrimLeft($InputURL, StringInStr($InputURL, '=', 0, -1))
				Local $Host_URL = $Main_YT_Host
				Local $Page = "/results?search_query=" & $URL_ID & "&search=Search"
				
				Local $SearchSource = _HTTPGetSource($Host_URL, $Page)
				Local $Titles_Array = StringRegExp($SearchSource, _
					'(?i)<a href=".*" ><img src=".*".*class=".*" title="(.*)" alt=".*"></a>', 3)
				
				If IsArray($Titles_Array) Then
					WriteToLog("Changing Video name to [" & $Titles_Array[0] & ".flv" & "]...")
					ControlSetText($GUI, "", $Downloading_Data_Edit, $Titles_Array[0] & ".flv")
				EndIf
			EndIf
	EndSwitch
	
	_ReduceMemory(@AutoItPID)
EndFunc

Func TrayMainEvents()
	Switch @TRAY_ID
		Case $About_TrayItem
			CallAbout()
		Case $Monitor_Browser_TrayItem
			ToggleMonitoringState($Monitor_Browser_TrayItem)
		Case $Exit_TrayItem
			Quit(1)
		Case $TRAY_EVENT_PRIMARYUP
			TraySetState(2)
			GUISetState(@SW_SHOW, $GUI)
			WinActivate($GUI)
			If Not WinActive($GUI) Then
				Sleep(100)
				WinActivate($GUI)
			EndIf
	EndSwitch
EndFunc

Func CallAbout()
	HotKeySet("{F1}")
	About_Box($GUI, $AppName, $AppVer, $Temp_Dir, $YouTube_ImgPath)
	HotKeySet("{F1}", "CallAbout")
EndFunc

Func ClickHandlerProc($CtrlID, $URL, $hWnd, $SetCtrlID=-1)
	Local $GetCurInfo = GUIGetCursorInfo($hWnd)
	While $GetCurInfo[2] = 1
		$GetCurInfo = GUIGetCursorInfo($hWnd)
		Sleep(10)
	WEnd
	If $GetCurInfo[4] = $CtrlID Or ($SetCtrlID <> -1 And $GetCurInfo[4] = $SetCtrlID) Then
		SoundPlay($Clicked_Sound_Path, 0)
		_Execute($URL)
	EndIf
EndFunc

Func HoverLabelProc(ByRef $HoverMark, $CtrlID, $CallFuncProc='', $Param_1='', $Param_2='', $hWnd=0, $SetCtrlID=-1)
	Local $GetCurInfo = GUIGetCursorInfo($hWnd)
	If Not IsArray($GetCurInfo) Then Return
	
	If $HoverMark = 1 And $GetCurInfo[4] = $CtrlID Then
		If $SetCtrlID <> -1 Then $CtrlID = $SetCtrlID
		Call($CallFuncProc, $CtrlID, $Param_1)
		$HoverMark = 0
	ElseIf $HoverMark = 0 And $GetCurInfo[4] <> $CtrlID Then
		If $SetCtrlID <> -1 Then $CtrlID = $SetCtrlID
		Call($CallFuncProc, $CtrlID, $Param_2)
		$HoverMark = 1
	EndIf
EndFunc

Func SetMenuItemData($CtrlID, ByRef $OptionData)
	If GUICtrlRead($CtrlID) = 65 Then
		GUICtrlSetState($CtrlID, 4)
		$OptionData = 0
	Else
		GUICtrlSetState($CtrlID, 1)
		$OptionData = 1
	EndIf
EndFunc

Func SetColorProc($CtrlID, $Color)
	GUICtrlSetColor($CtrlID, $Color)
EndFunc

Func SetElementStateProc($CtrlID, $State)
	GUICtrlSetState($CtrlID, $State)
EndFunc

Func SetStatusData($sData="", $WaitTime=3, $hStatusBar=-1)
	Local $Local_StatusBar = $StatusBar
	If $hStatusBar <> -1 Then $Local_StatusBar = $hStatusBar
	
	If $sData = "" Then
		$StatusTimer = -1
		$StatusWaitTime = $DefaultWaitTime
		_GUICtrlStatusBarSetText($Local_StatusBar, "", 255)
	Else
		If $WaitTime <> -1 Then $StatusTimer = TimerInit()
		If $WaitTime <> -1 And $WaitTime <> 0 And $WaitTime <> $StatusWaitTime Then $StatusWaitTime = $WaitTime
		If $WaitTime = -1 Then $StatusTimer = -1
		
		Local $iCode = 65001
		;If _StringIsUTF8Format($sData) Then $iCode = 65001 ;Not needed? o_O
		
		_GUICtrlStatusBarSetTextEx($Local_StatusBar, $sData, 255, $iCode)
	EndIf
EndFunc

Func SetURLsData()
	$URLsHistory = DeleteDuplicatesInStr($URLsHistory)
	If $URLsHistory <> "" Then GUICtrlSetData($URL_Combo, $URLsHistory, $LastHistoryURL)
	If Not StringInStr($URLsHistory, $LastHistoryURL) Then ControlSetText($GUI, "", $URL_Combo, $LastHistoryURL)
	
	If _GetCmdLine('/YT_URL_ID=') <> '' Then
		Local $CmdLineURL = _GetCmdLine('/YT_URL_ID=', '/Path=')
		If IsWatchYT_URL($CmdLineURL) Then GUICtrlSetData($URL_Combo, $CmdLineURL, $CmdLineURL)
		Return
	EndIf
	
	Local $ClipGetData = ClipGet()
	If IsWatchYT_URL($ClipGetData) And ControlGetText($GUI, "", $URL_Combo) = "" Then _
		GUICtrlSetData($URL_Combo, $ClipGetData, $ClipGetData)
EndFunc

Func PathIsDir($sPath)
	Return StringInStr(FileGetAttrib($sPath & "\"), "D") > 0
EndFunc

Func PathIsReady($sPath)
	Return DriveStatus(StringLeft($sPath, 1) & ":") = "READY"
EndFunc

Func DownloadProc($hWnd, $uiMsg, $idEvent, $dwTime)
	Local $StatusBar_GetText = _GUICtrlStatusBarGetText($StatusBar, 255)
	Local $ShowHideDet_Label_Text = GUICtrlRead($ShowHideDetails_Label, 1)
	
	Local $InetGetBytesRead = @InetGetBytesRead
	Local $SpeedByBytes = _InetGetSpeed($InetGetBytesRead)
	Local $RemainedTime = _SecsToTime(Round(_InetGetRemained($InetGetBytesRead, $INETGETSIZE, $SpeedByBytes)))
	Local $GetDownPrecent = Round(_InetGetPrecent($InetGetBytesRead, $INETGETSIZE), 1) & "%"
	If StringLeft($GetDownPrecent, 1) = "-" Then $GetDownPrecent = "NA"
	
	Local $DownloadStatus_Text = "Downloading..."
	Local $DownloadStatus_Data = $DownloadStatus_Text & " " & _GetShortName($LastLogDownloadedName) & ", [" & $GetDownPrecent & "]"
	
	If $ShowHideDet_Label_Text = "Show Details" Then
		If $StatusBar_GetText <> $DownloadStatus_Data Then SetStatusData($DownloadStatus_Data, -1)
	Else
		If $StatusBar_GetText <> $DownloadStatus_Text Then SetStatusData($DownloadStatus_Text, -1)
	EndIf
	
	GUICtrlSetData($Speed_Data_Label, Round($SpeedByBytes / 1024, 1))
	GUICtrlSetData($Remained_Data_Label, $RemainedTime)
	GUICtrlSetData($Ready_Data_Label, _
		"[Ready: " & _GetDisplaySize($InetGetBytesRead) & " of " & $Inet_Display_Size & "], " & $GetDownPrecent)
	
	Local $sTrayTip_FName = _UTF8ToUnicode($LastLogDownloadedName)
	
	TraySetToolTip("Ready: " & $GetDownPrecent & @LF & "Downloading: " & _GetShortName($sTrayTip_FName))
	
	If $Animate_Tray_Icon = 1 And Not WinIsVisible($GUI) Then
		If $AnimateIconMark = 1 Then
			$AnimateIconMark = 0
			TraySetIcon($YouTube_Anim_1_IconPath)
		Else
			$AnimateIconMark = 1
			TraySetIcon($YouTube_Anim_2_IconPath)
		EndIf
	EndIf
	
	If Not @InetGetActive Then
		$AnimateIconMark = 1
		
		If Not WinIsVisible($GUI) Then TraySetIcon($YouTube_IconPath)
		
		EndDownloading(0)
		SetStatusData("Done!", 10)
		
		Return
	EndIf
EndFunc

Func EndDownloading($OnExit=0, $Aborted=0)
	If $Play_Done_Sound = 1 And $OnExit = 0 Then
		SoundSetWaveVolume(100)
		SoundPlay($Done_Sound_Path, 0)
	EndIf
	
	_DllCallBack_Free($Timer_Proc_Download)
	DllCall("user32.dll", "int", "KillTimer", "hwnd", 0, "uint", $iTimer_Download)
	$Timer_Proc_Download = 0
	$iTimer_Download = 0
	
	If Not WinIsVisible($GUI) Then TraySetToolTip($AppName & " - " & $AppVer)
	
	ToggleEnableElements(0)
	TrayItemSetState($Monitor_Browser_TrayItem, $GUI_ENABLE)
	GUICtrlSetState($Monitor_Browser_MenuItem, $GUI_ENABLE)
	
	If GUICtrlRead($ChangeName_Button) = "OK" Then ConfirmChangeNameProc()
	
	GUICtrlSetOnEvent($ChangeName_Button, "")
	GUICtrlSetState($ChangeName_Button, $GUI_HIDE)
	GUICtrlSetStyle($Downloading_Data_Edit, $ES_READONLY+$ES_AUTOHSCROLL, 0x990)
	
	GUICtrlSetData($Speed_Data_Label, "0")
	GUICtrlSetData($Remained_Data_Label, _SecsToTime(0))
	
	GUICtrlSetData($Download_Button, "Download")
	GUICtrlSetOnEvent($Download_Button, "MainEvents")
	
	Local $Read_New_Name = GUICtrlRead($Downloading_Data_Edit)
	
	If StringCompare($Read_New_Name, $LastDownloadedName, 1) <> 0 Then
		If $Read_New_Name <> $LastDownloadedName Then
			;To prevent renaming the same file with (1) sufix
			$Read_New_Name = _GetNewFileName($Read_New_Name, $LastDownloadPath)
			FileMove($LastDownloadPath & "\" & $LastDownloadedName, $LastDownloadPath & "\" & $Read_New_Name)
		Else
			;In this case the file names should be differend only by case sensitive, so we move the file twice (3.2.8.1 bug)
			FileMove($LastDownloadPath & "\" & $LastDownloadedName, $LastDownloadPath & "\" & $Read_New_Name & ".tmp")
			FileMove($LastDownloadPath & "\" & $Read_New_Name & ".tmp", $LastDownloadPath & "\" & $Read_New_Name)
		EndIf
		
		$LastDownloadedName = $Read_New_Name
		$LastLogDownloadFileName = $Read_New_Name
		
		WriteToLog("Renaming Video File to [" & $Read_New_Name & "]...")
	EndIf
	
	Local $DestFullPath = $LastDownloadPath & "\" & $LastDownloadedName
	Local $LogDestFullPath = StringToUTF($LastDownloadPath) & "\" & $LastLogDownloadedName
	
	If $Aborted Then
		GUICtrlSetData($Ready_Data_Label, GUICtrlRead($Ready_Data_Label) & ' (Aborted)')
		WriteToLog("Complete Downloading [" & $LogDestFullPath & "]" & @CRLF & _
			"Warning: Aborted by User" & @CRLF & "Full file size: " & _GetDisplaySize(FileGetSize($DestFullPath)))
	Else
		WriteToLog("Complete Downloading [" & $LogDestFullPath & "]" & @CRLF & _
			"Full file size: " & _GetDisplaySize(FileGetSize($DestFullPath)))
		OnCompleteDownEvent($DestFullPath, $LastDownloadPath)
	EndIf
	
	_ReduceMemory(@AutoItPID)
EndFunc

Func OnCompleteDownEvent($FullVideoPath, $PathToVideo)
	If $CallEventOnComplDown = "No Special Events" Then Return
	Sleep(1200)
	Switch $CallEventOnComplDown
		Case "Play Video in default Player"
			_Execute($FullVideoPath, "", $PathToVideo)
		Case "Play Video and Close [" & $AppName & "]"
			_Execute($FullVideoPath, "", $PathToVideo)
			Quit()
		Case "Close [" & $AppName & "]"
			Quit()
		Case "Shutdown Computer"
			Shutdown(1 + 4) ;Force Shutdown
			Quit() ;Not sure if this will be called, but just in case if it will ;)
		Case "Reboot Computer"
			Shutdown(2 + 4) ;Force Reboot
			Quit()
	EndSwitch
EndFunc

Func AbortDownload()
	Local $AskExit = _MsgBox(262144+256+52, "Attention!", "Downloading will be aborted if you press Yes, are you sure?", $GUI)
	If $AskExit = 6 Then
		InetGet("abort")
		SetStatusData("Aborted!", 5)
		EndDownloading(0, 1)
	EndIf
EndFunc

Func InitializeCallBack($FuncName, ByRef $Timer_Proc, ByRef $iTimer, $Call_Timer)
	$Timer_Proc = _DllCallBack($FuncName, "hwnd;uint;uint;dword")
	$iTimer = DllCall("user32.dll", "uint", "SetTimer", "hwnd", 0, "uint", 0, "int", $Call_Timer, "ptr", $Timer_Proc)
	$iTimer = $iTimer[0]
EndFunc

Func ChangeNameProc()
	GUICtrlSendMsg($Downloading_Data_Edit, $EM_SETREADONLY, False, 0)
	GUICtrlSetStyle($Downloading_Data_Edit, $GUI_SS_DEFAULT_EDIT, $WS_EX_STATICEDGE)
	GUICtrlSetData($ChangeName_Button, "OK")
	
	GUICtrlSetOnEvent($ChangeName_Button, "ConfirmChangeNameProc")
EndFunc

Func ConfirmChangeNameProc()
	Local $New_File_Name = _StrReplaceUnsupported(GUICtrlRead($Downloading_Data_Edit))
	
	If $New_File_Name = "" Then
		$New_File_Name = $LastDownloadedName
		GUICtrlSetData($Downloading_Data_Edit, $New_File_Name)
	EndIf
	
	If StringRight($New_File_Name, 4) <> ".flv" Then GUICtrlSetData($Downloading_Data_Edit, $New_File_Name & ".flv")
	
	GUICtrlSendMsg($Downloading_Data_Edit, $EM_SETSEL, 0, 0)
	GUICtrlSendMsg($Downloading_Data_Edit, $EM_SCROLLCARET, 0, 0)
	
	ControlFocus($GUI, "", $ChangeName_Button)
	
	GUICtrlSendMsg($Downloading_Data_Edit, $EM_SETREADONLY, True, 0)
	GUICtrlSetStyle($Downloading_Data_Edit, $ES_READONLY+$ES_AUTOHSCROLL, 0x990)
	GUICtrlSetData($ChangeName_Button, "Change...")
	GUICtrlSetOnEvent($ChangeName_Button, "ChangeNameProc")
EndFunc

Func ToggleMonitoringState($ToggleFromTray=0)
	If GUICtrlRead($Monitor_Browser_MenuItem) = 65 Or TrayItemGetState($Monitor_Browser_TrayItem) = 65 Then
		TrayItemSetState($Monitor_Browser_TrayItem, 4)
		GUICtrlSetState($Monitor_Browser_MenuItem, 4)
		_DllCallBack_Free($Timer_Proc_Monitor)
		DllCall("user32.dll", "int", "KillTimer", "hwnd", 0, "uint", $iTimer_Monitor)
		$Monitor_Detected[0] = False
		$Timer_Proc_Monitor = 0
		$iTimer_Monitor = 0
	Else
		TrayItemSetState($Monitor_Browser_TrayItem, 1)
		GUICtrlSetState($Monitor_Browser_MenuItem, 1)
		InitializeCallBack("Monitor_Proc", $Timer_Proc_Monitor, $iTimer_Monitor, 1500)
	EndIf
EndFunc

Func ToggleDetailsProc($Flag=0, $PlayClick=1)
	If $PlayClick Then SoundPlay($Clicked_Sound_Path, 0)
	
	Local $GUIPos = WinGetPos($GUI)
	Local $TrayPos = WinGetPos("[CLASS:Shell_TrayWnd]")
	Local $NewHeight
	Local $ShowHideData = GUICtrlRead($ShowHideDetails_Label)
	
	If $Flag = 1 Then
		If $ShowHideData = "Show Details" Then Return
		$ShowHideData = "Hide Details"
	EndIf
	
	If $Flag = 2 Then
		If $ShowHideData = "Hide Details" Then Return
		$ShowHideData = "Show Details"
	EndIf
	
	If $ShowHideData = "Show Details" Then
		$NewHeight = $GUIPos[3] + 190
		$ShowHideData = "Hide Details"
	Else
		$NewHeight = $GUIPos[3] - 190
		$ShowHideData = "Show Details"
	EndIf
	
	If ($GUIPos[1] + $NewHeight) > (@DesktopHeight - $TrayPos[3]) Then $GUIPos[1] = @DesktopHeight - $TrayPos[3] - $NewHeight
	WinMove($GUI, "", $GUIPos[0], $GUIPos[1], $GUIPos[2], $NewHeight)
	GUICtrlSetData($ShowHideDetails_Label, $ShowHideData)
	_GUICtrlStatusBarResize($StatusBar)
	
	Local $GuiRetCoords[2] = [$GUIPos[0], $GUIPos[1] + $NewHeight - 250]
	Return $GuiRetCoords
EndFunc

Func ToggleEnableElements($Flag=0, $DownBtn=1)
	Local $State = 64
	If $Flag = 1 Then $State = 128
	
	If $DownBtn = 1 Then GUICtrlSetState($Download_Button, $State)
	
	GUICtrlSetState($URL_Combo, $State)
	GUICtrlSetState($SelectPath_Button, $State)
	GUICtrlSetState($Search_Button, $State)
	GUICtrlSetState($OpenLinkInBrowser_Button, $State)
	GUICtrlSetState($Show_Info_Button, $State)
	GUICtrlSetState($ShowHideDetails_Label, $State)
EndFunc

Func ToggleEnableSrchElements($Flag=0, $ID1=-1, $ID2=-1, $ID3=-1, $ID4=-1, $ID5=-1, $ID6=-1, $ID7=-1, $ID8=-1, $ID9=-1, $ID10=-1)
	Local $State = 64, $CurrentID
	If $Flag = 1 Then $State = 128
	
	For $i = 1 To @NumParams
		$CurrentID = Eval("ID" & $i)
		If $CurrentID <> -1 Then GUICtrlSetState($CurrentID, $State)
	Next
EndFunc

Func SilentDownload()
	Local $WriteLog = Number(_GetCmdLine('/WriteLog') <> '')
	Local $URL_ID = _GetCmdLine('/YT_URL_ID=')
	Local $DestPath = _GetCmdLine('/Path=')
	$DestPath = _StringStripChars($DestPath, '"', 3)
	If $DestPath = '' Then $DestPath = _GetMyVideosPath()
	
	If $DestPath = '' Or (Not PathIsDir($DestPath) And Not DirCreate($DestPath)) Then
		WriteToLog("Can not create destination path / Invalid Path", "Silent Download", -1, $WriteLog)
		Quit(0)
	EndIf
	
	WriteToLog("Collecting Download Information...", "Silent Download", -1, $WriteLog)
	Local $YouTubeDataArr = GetYouTubeDownloadData($URL_ID, 2)
	
	Switch @error
		Case 1, 2
			If _InetIsNotConnected() Then
				Local $ConnectErrMsg = "Please make sure that you are connected to the internet"
				WriteToLog($ConnectErrMsg, "Silent Download", -1, $WriteLog)
			Else
				WriteToLog("The URL contained a malformed video id / Incorrect ID", "Silent Download", -1, $WriteLog)
			EndIf
			Quit(0)
		Case 3
			WriteToLog("This video has been removed", "Silent Download", -1, $WriteLog)
			Quit(0)
		Case 4
			WriteToLog("Error to get Download link - Unknown error (" & @error & ")", "Silent Download", -1, $WriteLog)
			Quit(0)
	EndSwitch
	
	Local $Down_URL = $YouTubeDataArr[0]
	Local $Video_Name = $YouTubeDataArr[1]
	
	$Video_Name = _GetNewFileName($Video_Name, $DestPath)
	$Video_Name = _StrReplaceUnsupported($Video_Name)
	
	Local $DestFullPath = $DestPath & "\" & $Video_Name
	
	WriteToLog("Start Downloading of [" & $Video_Name & "]", "Silent Download", -1, $WriteLog)
	
	InetGet($Down_URL, $DestFullPath, 1)
	
	WriteToLog("Complete Downloading [" & $DestFullPath & "]" & @CRLF & _
		"Full file size: " & _GetDisplaySize(FileGetSize($DestFullPath)), "Silent Download", -1, $WriteLog)
	
	Quit(0)
EndFunc

Func DeleteDuplicatesInStr($String, $Direction=-1, $Delim="|")
	$StrArray = StringSplit($String, $Delim)
	If @error Then Return $String
	
	Local $NewStr = ""
	Local $For = 1, $To = $StrArray[0], $Step = 1
	If $Direction = 1 Then Local $For = $StrArray[0], $To = 1, $Step = -1
	
	For $i = $For To $To Step $Step
		If Not StringInStr($NewStr, $Delim & $StrArray[$i] & $Delim) Then
			$NewStr &= $Delim & $StrArray[$i] & $Delim
		EndIf
	Next
	$NewStr = StringRegExpReplace($NewStr, '\A\|+|\|+\z', '')
	Return StringRegExpReplace($NewStr, '\|+', '|')
EndFunc

Func _StrReplaceUnsupported($String, $Patern='[*?\\/|:<>"]', $Replace="_")
	If StringLen($String) = 0 Then Return $String
	$String = StringRegExpReplace($String, $Patern, $Replace)
	Return StringRegExpReplace($String, '(' & $Replace & '+)', $Replace)
EndFunc

Func _StringStripChars($String, $SubString, $Flag=0, $Count=0)
	If StringLen($String) = 0 Then Return SetError(1, 0, $String)
	
	Local $GroupChar_a = '(', $GroupChar_b = ')'
	If $Count < 0 Then Local $GroupChar_a = '[', $GroupChar_b = ']'
	
	$SubString = StringRegExpReplace($SubString, '([][{}()|.?+*\\^])', '\\\1')
	Local $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b, $sCnt = '{1,'& $Count &'}'
	
	If $Count <= 0 Then $sCnt = '+'
	If $Flag <> 0 Then $Count = 0
	If $Flag = 1 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt
	If $Flag = 2 Then $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	If $Flag = 3 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '|' & _
		$GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	Return StringRegExpReplace($String, $Pattern, '', $Count)
EndFunc

Func _GetNewFileName($sFile, $dDir, $Delim1 = " (", $Delim2 = ")")
	If Not FileExists($dDir & "\" & _UTF8ToUnicode($sFile)) Then Return $sFile
	
	$dDir = StringRegExpReplace($dDir, "\\ *$", "")
	
	Local $sName = StringRegExpReplace($sFile, "\.[^.]*$", "")
	Local $sExtn = StringMid($sFile, StringLen($sName) +1)
	Local $i = 1, $dFile = $sFile
	
	While FileExists($dDir & "\" & _UTF8ToUnicode($dFile))
		$dFile = $sName & $Delim1 & $i & $Delim2 & $sExtn
		$i += 1
	WEnd
	
	Return $dFile
EndFunc

Func _GetShortName($sString, $iMax_Ret_Lenght=120)
	If StringLen($sString) < $iMax_Ret_Lenght Then Return $sString
	
	If $iMax_Ret_Lenght <= 4 Then $iMax_Ret_Lenght = 5
	Local $iSide_Lenght = Round(($iMax_Ret_Lenght / 2) - 2, 0)
	
	Local $sLeft_Side = StringStripWS(StringLeft($sString, $iSide_Lenght), 3)
	Local $sRight_Side = StringStripWS(StringRight($sString, $iSide_Lenght), 3)
	
	Return $sLeft_Side & "...." & $sRight_Side
EndFunc

Func _GetComasNumber($iNumber)
	$iNumber = Number($iNumber)
	If $iNumber <= 1000 Then Return $iNumber
	
	Local $iLength = StringLen($iNumber)
	Local $RetStr = '', $iN
	
	For $i = 1 To $iLength
		$iN = StringMid($iNumber, $i, 1)
		If IsInt(($iLength - $i) / 3) And ($iLength - $i) / 3 > 0 Then
			$RetStr &= $iN & ','
		Else
			$RetStr &= $iN
		EndIf
	Next
	Return $RetStr
EndFunc

Func _GetCmdLine($aArgument, $bArgument='', $CmdDelim="/")
	Local $RetCmd = _GetMidleString($CmdLineRaw, $aArgument, ' ')
	If $RetCmd = '' Then $RetCmd = _GetMidleString($CmdLineRaw, $aArgument, ' ' & $CmdDelim)
	If $RetCmd = '' Then $RetCmd = _GetMidleString($CmdLineRaw, $aArgument, '$')
	If $RetCmd = '' Then $RetCmd = _GetMidleString($CmdLineRaw, $aArgument, $bArgument)
	Return StringStripWS($RetCmd, 3)
EndFunc

Func _GetMidleString($sString, $sStart, $sEnd, $iCase=-1, $iRetType=0)
	Local $iCaseSence = ''
	If $iCase = -1 Then $iCaseSence = '(?i)'
	
	Local $aArray = StringRegExp($sString, '(?s)' & $iCaseSence & $sStart & '(.*?)' & $sEnd, 3)
	Local $IsArrayCheck = IsArray($aArray)
	
	If $IsArrayCheck And $iRetType = 1 Then Return $aArray
	If $IsArrayCheck And $iRetType = 2 Then
		Local $iUbound = UBound($aArray)
		If Not StringInStr($aArray[$iUbound-1], "Next") Then Return $aArray[$iUbound-1]
		If ($iUbound - 2) >= 0 Then Return $aArray[$iUbound-2]
		Return $aArray[$iUbound-1]
	EndIf
	
	If $IsArrayCheck Then Return $aArray[0]
	Return SetError(1, 0, "")
EndFunc

Func _GetDisplaySize($iSize, $iPlaces=1)
	Local $aBytesArr[5] = [' Bytes', ' KB', ' MB', ' GB', ' TB']
	For $i = 4 To 1 Step -1
		If $iSize >= 1024 ^ $i Then Return Round($iSize / 1024 ^ $i, $iPlaces) & $aBytesArr[$i]
	Next
	Return $iSize & ' Bytes'
EndFunc

Func _GetMyVideosPath()
	Local $sRegReadMVPath = RegRead("HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders", "My Video")
	If PathIsDir($sRegReadMVPath) Then Return $sRegReadMVPath
	
	Local $sRetPath = ""
	Local $oShell = ObjCreate("Shell.Application")
	
	If IsObj($oShell) Then
		Local $oNameSpace = $oShell.NameSpace(0xE)
		If Not @error Then
			Local $oSelf = $oNameSpace.Self
			If Not @error Then $sRetPath = $oSelf.Path
			If PathIsDir($sRetPath) Then Return $sRetPath
		EndIf
	EndIf
	
	Return @MyDocumentsDir
EndFunc

Func OpenUrlInOpera($URL)
	If ProcessExists("Opera.exe") Then
		OpenGetURL($URL, 0, 0, "Opera")
		If @error Then Return SetError(1, 0, "")
		Return
	EndIf
	
	Local $OperaDir = @ScriptDir
	If Not FileExists($OperaDir & "\Opera.exe") Then
		Local $OperaDirRegRead = RegRead("HKEY_CURRENT_USER\Software\Opera Software", "Last CommandLine v2")
		Local $OperaDirArr = StringSplit($OperaDirRegRead, "\opera.exe ", 1)
		If UBound($OperaDirArr)-1 > 0 Then $OperaDir = $OperaDirArr[1]
		
		If Not FileExists($OperaDir & "\Opera.exe") Then $OperaDir = StringTrimRight($OperaDirRegRead, 10)
		If Not FileExists($OperaDir & "\Opera.exe") Then $OperaDir = @ProgramFilesDir & "\Opera 9"
		If Not FileExists($OperaDir & "\Opera.exe") Then Return SetError(2, 0, "")
	EndIf
	
	ShellExecute($OperaDir & "\Opera.exe", $URL, $OperaDir)
	If @error Then Return SetError(3, 0, "")
EndFunc

Func IsCompatible_Flash_Version($Version=9)
	If Number($Version) <= 0 Then Return SetExtended($Version, False)
	
	Local $sSource = _HTTPGetSource("www.adobe.com", "/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash")
	If @error Then Return SetError(1, 0, False)
	
	Local $InetFlashVersion = StringRegExpReplace($sSource, '(?i)(?s).*?<h\d+>Adobe Flash Player version(.*?)<br />.*', '\1')
	
	$InetFlashVersion = StringStripWS($InetFlashVersion, 3)
	$InetFlashVersion = StringLeft($InetFlashVersion, 1)
	
	If Number($InetFlashVersion) > Number($Version) Then Return SetExtended($Version, False)
	
	Return SetExtended($Version, True)
EndFunc

Func GetFlashVersion()
	Local $oSwf, $sVersion
	$oSwf = ObjCreate("ShockwaveFlash.ShockwaveFlash")
	If @error Then Return 0 ; No flash at all
	$oSwf.AllowScriptAccess = "always"
	$sVersion = $oSwf.GetVariable("$Version")
	If @error Then
		$oSwf = ObjCreate("ShockwaveFlash.ShockwaveFlash.3")
		If @error Then
			$oSwf = ObjCreate("ShockwaveFlash.ShockwaveFlash.2")
			If @error Then Return 0
			Return 2
		EndIf
		Return 3
	EndIf
	Return Number(StringRegExpReplace($sVersion, "(?i).*\s(.*?),.*", "\1"))
EndFunc

Func FadeWindow($hWin, $Mode=0, $iStep=5)
	Local $For = 254, $To = 0, $Step = -$iStep
	
	If $Mode <> 0 Then Local $For = 0, $To = 254, $Step = $iStep
	
	For $i = $For To $To Step $Step
		WinSetTrans($hWin, "", $i)
		Sleep(1)
	Next
EndFunc

Func WinIsVisible($Title)
	Return BitAND(WinGetState($Title), 2)
EndFunc

Func WriteToLog($sLine, $sSilentData="", $sLog_File=-1, $iWriteLog_Opt=-1)
	Local $iWriteLog = $WriteLog_When_Download
	If $iWriteLog_Opt <> -1 Then $iWriteLog = $iWriteLog_Opt
	
	If $iWriteLog = 0 Then Return
	
	If $sLog_File = -1 Then $sLog_File = $Log_File_Path
	
	Local $hLogFile
	Local $sGetDateTime = @HOUR & ":" & @MIN & ":" & @SEC & ", " & @MDAY & "/" & @MON & "/" & @YEAR
	
	If $sSilentData <> "" And FileExists($sLog_File) Then $sGetDateTime &= "; " & $sSilentData
	
	If Not FileExists($sLog_File) Then
		$hLogFile = FileOpen($sLog_File, 17)
		FileWrite($hLogFile, _
			"========================================================================" & @CRLF & _
			"Log File for <" & $AppName & "> started at: " & $sGetDateTime & @CRLF & _
			"========================================================================" & @CRLF & @CRLF)
	Else
		$hLogFile = FileOpen($sLog_File, 17)
	EndIf
	
	FileWriteLine($hLogFile, "[" & $sGetDateTime & "]" & @CRLF)
	FileWriteLine($hLogFile, ">> " & $sLine & @CRLF & @CRLF)
	
	FileClose($hLogFile)
EndFunc

Func ResizeControl($CtrlID, $Ctrl_2_ID, $hWnd)
	Local $CtrlPos = ControlGetPos($hWnd, "", $CtrlID)
	Local $Ctrl2Pos = ControlGetPos($hWnd, "", $Ctrl_2_ID)
	
	If Not IsArray($CtrlPos) Or Not IsArray($Ctrl2Pos) Then Return
	
	GUICtrlSetPos($CtrlID, $CtrlPos[0], $CtrlPos[1], $Ctrl2Pos[2]-80, $Ctrl2Pos[3]-40)
EndFunc

Func Correct_Content($sString, $iCorrect=-1)
	Local $aCorrects_Arr = _Array2DCreate('&quot;|&amp;|&#39;|&apos;|&gt;|&lt;|&nbsp;', '"|&|''|''|>|<| ')
	
	Local $sRet_Content = StringRegExpReplace($sString, '(?s)(?i)<.?a>|<.?b>|<.?i>|<.?u>|<hr>', '')
	$sRet_Content = StringStripWS($sRet_Content, 3)
	$sRet_Content = StringReplace($sRet_Content, "|", "_")
	
	For $i = 1 To $aCorrects_Arr[0][0]
		$sRet_Content = StringReplace($sRet_Content, $aCorrects_Arr[$i][0], $aCorrects_Arr[$i][1])
	Next
	
	If $iCorrect = 1 Then Return $sRet_Content
	Local $sReplStr = '\\n '
	If $iCorrect = 2 Then $sReplStr = @LF
	
	$sRet_Content = StringRegExpReplace($sRet_Content, '(?i)</br>|<br/>|<br />|\n|\r|\r\n', $sReplStr)
	
	Local $iCheckSpanPos = StringInStr($sRet_Content, '</s>')
	If $iCheckSpanPos > 0 Then $sRet_Content = StringTrimLeft($sRet_Content, $iCheckSpanPos)
	
	Return $sRet_Content
EndFunc

Func _Array2DCreate($1DStr, $2DStr, $Delim="|")
	Local $2DArray[1][1], $iUbound
	Local $BiggestArray = StringSplit($1DStr, $Delim)
	Local $SmallestArray = StringSplit($2DStr, $Delim)
	
	If UBound($SmallestArray) > UBound($BiggestArray) Then
		Local $TempArray = $BiggestArray
		$BiggestArray = $SmallestArray
		$SmallestArray = $TempArray
	EndIf
	
	ReDim $SmallestArray[UBound($BiggestArray)]
	
	For $i = 1 To UBound($BiggestArray)-1
		$iUbound = UBound($2DArray)
		ReDim $2DArray[$iUbound+1][2]
		$2DArray[$iUbound][0] = $BiggestArray[$i]
		If $SmallestArray[$i] <> "" Then $2DArray[$iUbound][1] = $SmallestArray[$i]
	Next
	$2DArray[0][0] = $iUbound
	Return $2DArray
EndFunc

Func OnCompleteDownloadDialog($hWnd=0)
	Local $OldOpt = Opt("GuiOnEventMode", 0)
	WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $OnComplDown_GUI = GUICreate($AppName & " - Complete Download Event...", 310, 140, -1, -1, _
		$WS_MINIMIZEBOX+$WS_SYSMENU, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW, $hWnd)
	
	GUISetBkColor(0xFFFFFF)
	
	GUICtrlCreateLabel("Select the event that will be called when" & @LF & _
		"video downloading is complete:", 20, 10, -1, 30, -1, $GUI_WS_EX_PARENTDRAG)
	Local $EventOnDown_Combo = GUICtrlCreateCombo("", 20, 40, 270, 20, $CBS_DROPDOWNLIST)
	GUICtrlSetData(-1, "No Special Event|Play Video in default Player|Play Video and Close [" & $AppName & "]" & _
		"|Close [" & $AppName & "]|Shutdown Computer|Reboot Computer" & "", $CallEventOnComplDown)
	
	Local $OK_Button = GUICtrlCreateButton("OK", 75, 80, 60, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 175, 80, 60, 20)
	
	GUISetState(@SW_SHOW, $OnComplDown_GUI)
	
	While 1
		Switch GUIGetMsg()
			Case -3, $Cancel_Button
				ExitLoop
			Case $OK_Button
				$CallEventOnComplDown = GUICtrlRead($EventOnDown_Combo)
				
				If Not FileExists($ConfigFile) Then FileClose(FileOpen($ConfigFile, 8 + 1 + 32))
				IniWrite($ConfigFile, "Main Prefs", "Call Event When Complete Downloading", $CallEventOnComplDown)
				
				ExitLoop
		EndSwitch
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($OnComplDown_GUI)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $OldOpt)
EndFunc

Func SetAppProxy_Dialog($hWnd)
	Local $OldOpt = Opt("GuiOnEventMode", 0)
	WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $SetProxy_GUI = GUICreate($AppName & " - Set Proxy Settings", 400, 290, -1, -1, _
		$WS_MINIMIZEBOX+$WS_SYSMENU, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW, $hWnd)
	
	GUISetBkColor(0xFFFFFF)
	
	GUICtrlCreateLabel("Please set Proxy Settings", 20, 10, 400)
	GUICtrlSetFont(-1, 12, 800)
	
	Local $Use_IE_Proxy_Radio = GUICtrlCreateRadio("Use Internet Explorer settings", 20, 40)
	GUICtrlSetState(-1, $GUI_CHECKED)
	
	Local $Use_Direct_Access_Radio = GUICtrlCreateRadio("Use direct access (no proxy)", 20, 60)
	If $Use_Proxy = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	Local $Use_Specified_Proxy_Radio = GUICtrlCreateRadio("Use specified Proxy settings", 20, 80)
	If $Use_Proxy = 2 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	GUICtrlCreateLabel("Proxy address:", 20, 110)
	Local $HttpProxy_Address_Input = GUICtrlCreateInput($HttpProxy_Address, 20, 130, 270, 20, -1, $WS_EX_DLGMODALFRAME)
	
	GUICtrlCreateLabel(":", 296, 131)
	GUICtrlSetFont(-1, 9, 800)
	
	GUICtrlCreateLabel("Port:", 306, 110)
	Local $HttpProxy_Port_Input = GUICtrlCreateInput($HttpProxy_Port, 306, 130, 70, 20, _
		BitOR($ES_LEFT, $ES_AUTOHSCROLL, $ES_NUMBER), $WS_EX_DLGMODALFRAME)
	
	GUICtrlCreateLabel("User Name:", 20, 170)
	Local $HttpProxy_UserName_Input = GUICtrlCreateInput($HttpProxy_UserName, 20, 190, 140, 20, -1, $WS_EX_DLGMODALFRAME)
	
	GUICtrlCreateLabel("Password:", 190, 170)
	Local $HttpProxy_Password_Input = GUICtrlCreateInput($HttpProxy_Password, 190, 190, 185, 20, $ES_PASSWORD, $WS_EX_DLGMODALFRAME)
	
	If $Use_Proxy <> 2 Then
		For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
			GUICtrlSetState($i, $GUI_DISABLE)
		Next
	EndIf
	
	Local $OK_Button = GUICtrlCreateButton("OK", 20, 230, 60, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 100, 230, 60, 20)
	GUICtrlSetTip(-1, "") ;Prevent a bug with deactivated main window
	
	GUISetState(@SW_SHOW, $SetProxy_GUI)
	
	While 1
		$nMsg = GUIGetMsg()
		
		Switch $nMsg
			Case -3, $Cancel_Button
				ExitLoop
			Case $Use_IE_Proxy_Radio, $Use_Direct_Access_Radio, $Use_Specified_Proxy_Radio
				If $nMsg = $Use_Specified_Proxy_Radio Then
					For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
						GUICtrlSetState($i, $GUI_ENABLE)
					Next
				Else
					For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
						GUICtrlSetState($i, $GUI_DISABLE)
					Next
				EndIf
			Case $OK_Button
				If GUICtrlRead($Use_IE_Proxy_Radio) = $GUI_CHECKED Then $Use_Proxy = 0
				If GUICtrlRead($Use_Direct_Access_Radio) = $GUI_CHECKED Then $Use_Proxy = 1
				If GUICtrlRead($Use_Specified_Proxy_Radio) = $GUI_CHECKED Then $Use_Proxy = 2
				
				$HttpProxy_Address 					= GUICtrlRead($HttpProxy_Address_Input)
				$HttpProxy_UserName 				= GUICtrlRead($HttpProxy_UserName_Input)
				$HttpProxy_Password 				= GUICtrlRead($HttpProxy_Password_Input)
				$HttpProxy_Port 					= GUICtrlRead($HttpProxy_Port_Input)
				
				If Not FileExists($ConfigFile) Then FileClose(FileOpen($ConfigFile, 8 + 1 + 32))
				
				IniWrite($ConfigFile, "Proxy Prefs", "Proxy Settings", 	$Use_Proxy)
				IniWrite($ConfigFile, "Proxy Prefs", "Proxy Address", 	$HttpProxy_Address)
				IniWrite($ConfigFile, "Proxy Prefs", "Proxy User Name", $HttpProxy_UserName)
				IniWrite($ConfigFile, "Proxy Prefs", "Proxy Password",	$HttpProxy_Password)
				IniWrite($ConfigFile, "Proxy Prefs", "Proxy Port", 		$HttpProxy_Port)
				
				SetAppProxy_Proc()
				
				ExitLoop
		EndSwitch
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($SetProxy_GUI)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $OldOpt)
EndFunc

Func Search_Dialog($hWnd=0)
	Local $ReturnStr = -1
	Local $SrchMsg, $Previewed_URL = "", $Previewed_Name = ""
	Local $SearchSource
	Local $Preview_Pic
	
	Local $OldOpt = Opt("GuiOnEventMode", 0)
	WinSetState($hWnd, "", @SW_DISABLE)
	
	$Search_GUI = GUICreate($AppName & " - Search Videos Tool", 550, 490, -1, -1, _
		$WS_MINIMIZEBOX+$WS_SYSMENU, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW, $hWnd)
	GUISwitch($Search_GUI)
	
	Local $FeelingLucky_CheckBox = GUICtrlCreateCheckbox("I am feeling lucky ;)", 20, 5)
	GUICtrlSetTip(-1, "This option will search for one random video")
	If $FeelingLucky = 1 Then GUICtrlSetState(-1, 1)
	
	GUICtrlCreateLabel("Sort by:", 255, 5, -1, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $SortBy_Combo = GUICtrlCreateCombo("", 300, 3, 150, 20, $CBS_DROPDOWNLIST)
	GUICtrlSetData(-1, "Relevance|Date Added|View Count|Rating", $SearchDefaultSortBy)
	
	GUICtrlCreateLabel("Type Search Request:", 20, 27, -1, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $Search_Combo = GUICtrlCreateCombo("", 140, 25, 310, 20)
	$SearchKeyWordsHistory = DeleteDuplicatesInStr($SearchKeyWordsHistory)
	GUICtrlSetData(-1, $SearchKeyWordsHistory, $LastSearchKeyWords)
	GUICtrlSetState(-1, $GUI_FOCUS)
	
	Local $Load_Avi = GUICtrlCreateAvi($Load_Avi_Path, 0, 485, 5)
	Local $sSearch_Button = GUICtrlCreateButton("Search", 460, 25, 70, 20, $BS_DEFPUSHBUTTON)
	
	$Search_ListView = GUICtrlCreateListView("Video Name|Description|YouTube URL", _
		20, 50, 510, 290, $LVS_NOSORTHEADER+$LVS_SINGLESEL)
	GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
	
	Local $Preview_Button = GUICtrlCreateButton("Preview", 20, 385, 80, 20)
	GUICtrlSetTip(-1, "Preview Video Image in New Window (Double Click on Selected Video)")
	
	Local $Select_Button = GUICtrlCreateButton("Select", 20, 410, 80, 20)
	GUICtrlSetTip(-1, "Set selected video as Download YouTube URL")
	
	Local $Cancel_Button = GUICtrlCreateButton("Close", 120, 410, 80, 20)
	GUICtrlSetTip(-1, "Close current window")
	
	Local $OpenSelectedInBrowser_Button = GUICtrlCreateButton("Open in Browser", 220, 410, 110, 20)
	GUICtrlSetTip(-1, "Open Selected Video In Default Browser")
	
	#Region Navigation
	GUICtrlCreateGroup("Navigation Controls:", 20, 345, 510, 40)
	
	GUICtrlCreateLabel("Pages: ", 30, 362, 40, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 9, 800)
	
	Local $Back_Label = GUICtrlCreateLabel("<< Back", 90, 362)
	GUICtrlSetState(-1, 128)
	GUICtrlSetFont(-1, 9, 800, 4)
	GUICtrlSetColor(-1, 0x0000FF)
	GUICtrlSetCursor(-1, 0)
	
	Local $Navigate_To_Page = 0
	Local $Nav_Labels_Arr[16]
	Local $Nav_Labels_Left = 150
	
	For $i = 1 To 15
		$Nav_Labels_Arr[$i] = GUICtrlCreateLabel($i, $Nav_Labels_Left, 362, 13, 15)
		GUICtrlSetFont(-1, 9, 800, 4)
		GUICtrlSetState(-1, $GUI_HIDE)
		GUICtrlSetCursor(-1, 0)
		$Nav_Labels_Left += 18
	Next
	
	Local $More_Nav_Label = GUICtrlCreateLabel("....", 300, 363, 15, 15)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlSetState(-1, $GUI_HIDE)
	
	Local $Next_Label = GUICtrlCreateLabel("Next >>", 180, 362)
	GUICtrlSetState(-1, 128)
	GUICtrlSetFont(-1, 9, 800, 4)
	GUICtrlSetColor(-1, 0x0000FF)
	GUICtrlSetCursor(-1, 0)
	#EndRegion Navigation
	;
	
	Local $Search_StatusBar = _GUICtrlStatusBarCreate($Search_GUI, "", "")
	_GUICtrlStatusBarSetSimple($Search_StatusBar, True)
	_GUICtrlStatusBarSetIcon($Search_StatusBar, 255, "Shell32.dll", 221)
	
	GUISetState(@SW_SHOW, $Search_GUI)
	
	While 1
		$SrchMsg = GUIGetMsg(1)
		
		If $DoubleClicked Then
			$DoubleClicked = False
			$SrchMsg[0] = $Preview_Button
		EndIf
		
		If $SrchMsg[0] = $GUI_EVENT_PRIMARYDOWN And $SrchMsg[1] = $Search_GUI Then
			$Cursor_Info = GUIGetCursorInfo($Search_GUI)
			
			If IsArray($Cursor_Info) Then
				For $i = 1 To 15
					If $i <> $Search_Current_Page And $Cursor_Info[4] = $Nav_Labels_Arr[$i] Then
						$Navigate_To_Page = $i
						ExitLoop
					EndIf
				Next
			EndIf
		EndIf
		
		Select
			Case $SrchMsg[0] = $Cancel_Button Or $SrchMsg[0] = $GUI_EVENT_CLOSE
				If IsHWnd($Preview_GUI) And $SrchMsg[1] = $Preview_GUI Then
					;FadeWindow($Preview_GUI, 0)
					GUISetState(@SW_HIDE, $Preview_GUI)
					GUISwitch($Search_GUI)
					WinActivate($hWnd)
					ControlFocus($Search_GUI, "", $Search_ListView)
					ContinueLoop
				EndIf
				
				If IsHWnd($Preview_GUI) And WinIsVisible($Preview_GUI) Then
					WinActivate($hWnd)
					GUISwitch($Search_GUI)
				EndIf
				
				ExitLoop
			Case $SrchMsg[0] = $sSearch_Button Or $SrchMsg[0] = $Next_Label Or $SrchMsg[0] = $Back_Label Or $Navigate_To_Page <> 0
				SoundPlay($Clicked_Sound_Path, 0)
				
				Local $Search_Combo_Read = ControlGetText($Search_GUI, "", $Search_Combo)
				Local $SortBy_Str = "relevance" ;Default
				
				Switch ControlGetText($Search_GUI, "", $SortBy_Combo)
					Case "Date Added"
						$SortBy_Str = "video_date_uploaded"
					Case "View Count"
						$SortBy_Str = "video_view_count"
					Case "Rating"
						$SortBy_Str = "video_avg_rating"
					Case Else
						$SortBy_Str = "relevance"
				EndSwitch
				
				If $SrchMsg[0] = $sSearch_Button Then
					If $Search_Combo_Read = "" Then
						SetStatusData("Please type Search Request", 4, $Search_StatusBar)
						ContinueLoop
					EndIf
					
					$LastSearchKeyWords = $Search_Combo_Read
				EndIf
				
				GUICtrlSetState($Load_Avi, 1)
				GUICtrlSendMsg($Search_ListView, $LVM_DELETEALLITEMS, 0, 0)
				
				SetStatusData("Please wait, Searching...", -1, $Search_StatusBar)
				ToggleEnableSrchElements(1, $sSearch_Button, $Preview_Button, _
					$Select_Button, $Cancel_Button, $OpenSelectedInBrowser_Button)
				
				If $SrchMsg[0] = $sSearch_Button Then
					For $i = 1 To 15
						GUICtrlSetState($Nav_Labels_Arr[$i], $GUI_HIDE)
						GUICtrlSetFont($Nav_Labels_Arr[$i], 9, 800, 4)
						GUICtrlSetColor($Nav_Labels_Arr[$i], 0x0000FF)
						GUICtrlSetTip($Nav_Labels_Arr[$i], "")
					Next
					
					GUICtrlSetPos($Next_Label, 180, 362)
					GUICtrlSetState($More_Nav_Label, $GUI_HIDE)
					
					$LastSearchKeyWords = $Search_Combo_Read
					Local $ComboGetList = _GUICtrlComboGetList($Search_Combo)
					
					If $LastSearchKeyWords <> "" And _
						Not StringInStr("|" & $ComboGetList & "|", "|" & $LastSearchKeyWords & "|") Then
						$SearchKeyWordsHistory = $ComboGetList & "|" & $LastSearchKeyWords
						_GUICtrlComboAddString($Search_Combo, $LastSearchKeyWords)
					EndIf
				Else
					For $i = 1 To 15
						GUICtrlSetState($Nav_Labels_Arr[$i], $GUI_DISABLE)
					Next
				EndIf
				
				GUICtrlSetState($Back_Label, $GUI_DISABLE)
				GUICtrlSetState($Next_Label, $GUI_DISABLE)
				
				;Seach Procedure...
				Local $KeyWords = _URLEncode($Search_Combo_Read)
				Local $Page = "/results?search_query=" & $KeyWords & "&search_sort=" & $SortBy_Str & "&search=Search"
				$FeelingLucky = GUICtrlRead($FeelingLucky_CheckBox)
				
				If $Search_Current_Page <> 0 And $SrchMsg[0] <> $sSearch_Button Then
					$Page = "/results?search_type=search_videos&search_query=" & $KeyWords & _
						"&search_sort=" & $SortBy_Str & "&search_category=0&search=Search&v=&uploaded=&page="
					
					If $SrchMsg[0] = $Next_Label Then
						$Page &= ($Search_Current_Page + 1)
					ElseIf $SrchMsg[0] = $Back_Label Then
						$Page &= ($Search_Current_Page - 1)
					Else
						$Page &= $Navigate_To_Page
					EndIf
					
					$Navigate_To_Page = 0
					$FeelingLucky = 0
				EndIf
				
				Local $SearchSource = SearchEngine($Page, $FeelingLucky)
				Local $Founded = @extended ;Now used only to check if there was videos found at all
				
				If Not $Founded Then
					If _InetIsNotConnected() Then
						Local $ConnectErrMsg = "Please make sure that you are connected to the internet"
						_MsgBox(16, $AppName & " - No Internet Connection", $ConnectErrMsg, $Search_GUI)
						SetStatusData("")
					Else
						SetStatusData("Videos Not Found!", 5, $Search_StatusBar)
					EndIf
				Else
					If StringInStr($SearchSource, 'class="pagerCurrent">') Then
						Local $Total_Pages = _GetMidleString($SearchSource, 'class=".*?Current">', '</', -1, 2)
						Local $IsNavigate = False
						Local $Max_Nav_Labels_Show = $Total_Pages
						
						If $Total_Pages < 0 Then $Total_Pages = 1
						If $Total_Pages > 15 Then $Max_Nav_Labels_Show = 15
						
						$Search_Current_Page = _GetMidleString($SearchSource, 'class="pagerCurrent">', '</')
						If $Search_Current_Page = '' Then $Search_Current_Page = 0
						
						If StringInStr($SearchSource, 'class="pagerNotCurrent">' & $Search_Current_Page+1 & '</') And _
							$Search_Current_Page+1 <= 15 Then
							GUICtrlSetState($Next_Label, 64)
							GUICtrlSetTip($Next_Label, "Navigate to Page " & $Search_Current_Page+1)
							GUICtrlSetPos($Next_Label, 150 + ($Max_Nav_Labels_Show * 18) + 25, 362)
							$IsNavigate = True
						Else
							GUICtrlSetState($Next_Label, 128)
							GUICtrlSetState($More_Nav_Label, $GUI_HIDE)
						EndIf
						
						If StringRegExp($SearchSource, '[\t|\n|\r\s]+\.\.\.[\t|\n|\r\s]+') And _
								$Search_Current_Page+1 <= 15 And $Total_Pages >= 7 And $Max_Nav_Labels_Show < 15 Then
							GUICtrlSetPos($More_Nav_Label, 150 + ($Max_Nav_Labels_Show * 18), 363)
							GUICtrlSetState($More_Nav_Label, $GUI_SHOW)
						Else
							GUICtrlSetState($More_Nav_Label, $GUI_HIDE)
						EndIf
						
						If $Search_Current_Page > 1 Then
							GUICtrlSetState($Back_Label, $GUI_ENABLE)
							GUICtrlSetTip($Back_Label, "Navigate to Page " & $Search_Current_Page-1)
							$IsNavigate = True
						Else
							GUICtrlSetState($Back_Label, $GUI_DISABLE)
						EndIf
						
						If $IsNavigate Then
							For $i = 1 To 15
								GUICtrlSetState($Nav_Labels_Arr[$i], $GUI_HIDE)
								GUICtrlSetState($Nav_Labels_Arr[$i], $GUI_ENABLE)
								GUICtrlSetFont($Nav_Labels_Arr[$i], 9, 800, 4)
								GUICtrlSetColor($Nav_Labels_Arr[$i], 0x0000FF)
								GUICtrlSetCursor($Nav_Labels_Arr[$i], 0)
							Next
							
							For $i = 1 To Number($Max_Nav_Labels_Show)
								GUICtrlSetState($Nav_Labels_Arr[$i], $GUI_SHOW)
								
								If $i <> $Search_Current_Page Then
									GUICtrlSetTip($Nav_Labels_Arr[$i], "Navigate to Page " & $i)
								Else
									GUICtrlSetTip($Nav_Labels_Arr[$i], "Current Page")
									GUICtrlSetFont($Nav_Labels_Arr[$i], 9, 800, 0)
									GUICtrlSetColor($Nav_Labels_Arr[$i], 0x0)
									GUICtrlSetCursor($Nav_Labels_Arr[$i], -1)
								EndIf
							Next
						EndIf
					Else
						$Search_Current_Page = 0
					EndIf
					
					Local $iFound_Init = Number(Execute($Founded / $Founded))
					Local $About_TotalVideos = StringRegExpReplace($SearchSource, _
						'(?i)(?s).*<strong>\d+ - \d+</strong> of .*<strong>(.*)</strong>.*', '\1')
					
					If @extended = 0 Or (Number($About_TotalVideos) < $Founded And _
						StringRegExp($About_TotalVideos, "\A\d+") And _
						Not StringInStr($About_TotalVideos, ",")) Then $About_TotalVideos = $Founded
					
					Local $sVideosFound_String = _
						StringFormat("%i - %i of about %s videos found", $iFound_Init, $Founded, $About_TotalVideos)
					
					If Not StringRegExp($About_TotalVideos, "\A\d+") Then _
						$sVideosFound_String = StringReplace($sVideosFound_String, "about ", "")
					
					SetStatusData($sVideosFound_String, 8, $Search_StatusBar)
					
					GUICtrlSendMsg($Search_ListView, $LVM_SETCOLUMNWIDTH, 0, -1)
					GUICtrlSendMsg($Search_ListView, $LVM_SETCOLUMNWIDTH, 1, -1)
					GUICtrlSendMsg($Search_ListView, $LVM_SETCOLUMNWIDTH, 2, -1)
				EndIf
				
				GUICtrlSetState($Load_Avi, 0)
				ToggleEnableSrchElements(0, $sSearch_Button, $Preview_Button, _
					$Select_Button, $Cancel_Button, $OpenSelectedInBrowser_Button)
			Case $SrchMsg[0] = $Preview_Pic
				If $Previewed_URL = "" Then ContinueLoop
				
				If _IsPressed(11) Then
					ClickHandlerProc($Preview_Pic, $Previewed_URL, $Preview_GUI)
				Else
					Local $GetCurInfo = GUIGetCursorInfo($Preview_GUI)
					
					While $GetCurInfo[2] = 1
						$GetCurInfo = GUIGetCursorInfo($Preview_GUI)
						Sleep(10)
					WEnd
					
					If $GetCurInfo[4] = $Preview_Pic Then
						SoundPlay($Clicked_Sound_Path, 0)
						PreviewVideo_GUI($Previewed_Name, $Previewed_URL, $Preview_GUI, $Search_GUI)
						
						Switch @error
							Case 1
								SetStatusData("There was an error to get access to the video", 5, $Search_StatusBar)
							Case 2
								SetStatusData("There was an error to Handle Shell.Explorer Object", 7, $Search_StatusBar)
							Case 3
								GUISetState(@SW_DISABLE, $Search_GUI)
								
								Local $Ask_SW_Install = _MsgBox(52, $AppName & " - Error", _
									"It seems that Shockwave Flash Player not installed properly on your system." & @LF & _
									"Would you like to install Shockwave Flash Player?", $Preview_GUI)
								
								GUISetState(@SW_ENABLE, $Search_GUI)
								
								If $Ask_SW_Install = 6 Then ShellExecute("http://www.adobe.com/shockwave/download/")
							Case Else
								SetStatusData("", -1, $Search_StatusBar)
						EndSwitch
					EndIf
				EndIf
			Case $SrchMsg[0] = $Preview_Button
				If GUICtrlRead(GUICtrlRead($Search_ListView)) = "" Then
					SetStatusData("Please select Video.", 3, $Search_StatusBar)
					ContinueLoop
				EndIf
				
				Local $Selected_ID = _GUICtrlListViewGetItemText($Search_ListView, -1, 2)
				
				If $Selected_ID = $Previewed_URL And WinIsVisible($Preview_GUI) Then
					SetStatusData("You already preview this video", 5, $Search_StatusBar)
					WinActivate($Preview_GUI)
					WinFlash($Preview_GUI, "", 4, 300)
					ContinueLoop
				EndIf
				
				SetStatusData("Please wait...", -1, $Search_StatusBar)
				
				Local $CheckSrc = _HTTPGetRespones($Main_YT_Host, '/watch?v=' & GetYT_ID($Selected_ID))
				
				If @error = 1 Then
					SetStatusData("There was an error while trying connecting to the server", 7, $Search_StatusBar)
					ContinueLoop
				EndIf
				
				If StringInStr($CheckSrc, "Location: /index?&session") Then
					SetStatusData("This video has been removed", 5, $Search_StatusBar)
					ContinueLoop
				EndIf
				
				If Not IsHWnd($Preview_GUI) Then
					$Preview_GUI = GUICreate("Preview YouTube Video [Image]", 480, 480, -1, -1, _
						$WS_MINIMIZEBOX+$WS_SYSMENU+$WS_SIZEBOX, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW, $Search_GUI)
					GUISwitch($Preview_GUI)
					
					GUIRegisterMsg($WM_EXITSIZEMOVE, "WM_EXITSIZEMOVE")
					GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")
					GUIRegisterMsg($WM_GETMINMAXINFO, "WM_GETMINMAXINFO")
					
					Local $Img_Preview_Group = GUICtrlCreateGroup("Preview Image", 10, 5, 460, 240)
					$Preview_Pic = GUICtrlCreatePic("", 50, 25, 380, 200, -1, $WS_EX_CLIENTEDGE+$WS_EX_DLGMODALFRAME)
					GUICtrlSetCursor(-1, 0)
					
					Local $Info_Group = GUICtrlCreateGroup("Info For Video", 10, 255, 460, 190)
					GUICtrlCreateLabel("From:", 20, 273, 120)
					GUICtrlCreateLabel("Views:", 20, 296, 120)
					GUICtrlCreateLabel("Added:", 20, 319, 120)
					GUICtrlCreateLabel("Video Duration:", 20, 342, 120)
					GUICtrlCreateLabel("Description:", 20, 360, 120, 18)
					
					For $i = $Info_Group+1 To $Info_Group+5
						GUICtrlSetFont($i, 9, 800)
					Next
					
					Local $From_Label = GUICtrlCreateLabel("", 160, 273, 300, 18)
					Local $Views_Label = GUICtrlCreateLabel("", 160, 296, 300, 18)
					Local $Added_Label = GUICtrlCreateLabel("", 160, 319, 300, 18)
					Local $Duration_Label = GUICtrlCreateLabel("", 160, 342, 300, 18)
					
					For $i = $Info_Group+1 To $Duration_Label
						GUICtrlSetStyle($i, -1, $GUI_WS_EX_PARENTDRAG)
						If $i >= $From_Label Then GUICtrlSetColor($i, 0x676767)
					Next
					
					Local $Description_Edit = GUICtrlCreateEdit("", 20, 385, 440, 55, _
						BitOr($ES_WANTRETURN, $WS_VSCROLL, $ES_AUTOVSCROLL, $ES_READONLY))
					GUICtrlSetFont(-1, 9, 800)
					GUICtrlSetColor(-1, 0x3E7B7B)
					
					For $i = $Img_Preview_Group To $Description_Edit
						GUICtrlSetResizing($i, $GUI_DOCKAUTO)
					Next
				EndIf
				
				$Previewed_URL = $Selected_ID
				$Previewed_Name = _GUICtrlListViewGetItemText($Search_ListView, -1, 0)
				
				$Selected_ID = StringTrimLeft($Selected_ID, StringInStr($Selected_ID, "=", 0, -1))
				
				Local $Selected_Descript = _GUICtrlListViewGetItemText($Search_ListView, -1, 1)
				$Selected_Descript = StringReplace(StringStripWS($Selected_Descript, 3), "\n ", @CRLF)
				
				If @InetGetActive Then
					RunWait(@AutoItExe & ' /AutoIt3ExecuteLine "InetGet(''http://img.youtube.com/vi/' & $Selected_ID & _
						'/default.jpg'', ''' & @TempDir & '\YTD_default.jpg'', 1)"')
				Else
					InetGet("http://img.youtube.com/vi/" & $Selected_ID & "/default.jpg", @TempDir & "\YTD_default.jpg", 1)
				EndIf
				
				SetStatusData("", -1, $Search_StatusBar)
				
				WinSetTitle($Preview_GUI, "", "Preview YouTube Video [Image] - " & _GetShortName($Previewed_Name, 50))
				GUICtrlSetTip($Preview_Pic, $Previewed_URL & @LF & @LF & _
					"* Click on image to Play Video in Built-In Viewer."  & @LF & _
					"* Hold down CTRL Key and Click on image to Play this Video in your Default Browser.", $Previewed_Name, 1, 1)
				GUICtrlSetData($Info_Group, "Info For Video [" & _GetShortName($Previewed_Name, 50) & "]")
				GUICtrlSetData($Description_Edit, $Selected_Descript)
				
				Local $ID_Part = _GetMidleString($SearchSource, _
					'id="BeginvidDesc' & $Selected_ID & '">', '</div> <!-- end vEntry -->')
				Local $From = _GetMidleString($ID_Part, 'From:</span><span class=".*"><a href=".*">', '</a></span></div>')
				Local $Views = _GetMidleString($ID_Part, 'Views:</span>', '<br/>')
				Local $Added = _GetMidleString($ID_Part, 'Added:</span>', '<br/>')
				Local $Time = _GetMidleString($ID_Part, '<div class="runtime">', '</div>')
				
				GUICtrlSetData($From_Label, StringStripWS($From, 3))
				GUICtrlSetData($Views_Label, StringStripWS($Views, 3))
				GUICtrlSetData($Added_Label, StringStripWS($Added, 3))
				GUICtrlSetData($Duration_Label, StringStripWS($Time, 3))
				
				If FileGetSize(@TempDir & "\YTD_default.jpg") > 0 Then
					GUICtrlSetImage($Preview_Pic, @TempDir & "\YTD_default.jpg")
					FileDelete(@TempDir & "\YTD_default.jpg")
				Else
					GUICtrlSetImage($Preview_Pic, $YT_Img_Not_Available)
				EndIf
				
				If Not WinIsVisible($Preview_GUI) Then
					;WinSetTrans($Preview_GUI, "", 0)
					GUISetState(@SW_SHOW, $Preview_GUI)
					;FadeWindow($Preview_GUI, 1)
					GUISwitch($Search_GUI)
				Else
					ResizeControl($Preview_Pic, $Img_Preview_Group, $Preview_GUI)
				EndIf
			Case $SrchMsg[0] = $OpenSelectedInBrowser_Button
				Local $SelectedItem = _GUICtrlListViewGetItemText($Search_ListView, -1, 2)
				If $SelectedItem = "" Then
					SetStatusData("Please select Video.", 3, $Search_StatusBar)
					ContinueLoop
				EndIf
				_Execute($SelectedItem)
			Case $SrchMsg[0] = $Select_Button
				Local $SelectedItem = _GUICtrlListViewGetItemText($Search_ListView, -1, 2)
				If $SelectedItem = "" Then
					SetStatusData("Please select Video.", 3, $Search_StatusBar)
					ContinueLoop
				EndIf
				ControlSetText($GUI, "", $URL_Combo, $SelectedItem)
				ExitLoop
		EndSelect
		
		If $StatusTimer <> -1 And TimerDiff($StatusTimer) >= $StatusWaitTime*1000 Then SetStatusData("", -1, $Search_StatusBar)
	WEnd
	
	$LastSearchKeyWords = ControlGetText($Search_GUI, "", $Search_Combo)
	Local $ComboGetList = _GUICtrlComboGetList($Search_Combo)
		If $LastSearchKeyWords <> "" And Not StringInStr("|" & $ComboGetList & "|", "|" & $LastSearchKeyWords & "|") Then _
			$SearchKeyWordsHistory = $ComboGetList & "|" & $LastSearchKeyWords
	
	$SearchDefaultSortBy = ControlGetText($Search_GUI, "", $SortBy_Combo)
	$FeelingLucky = (GUICtrlRead($FeelingLucky_CheckBox) - 3) < 0
	
	WinSetState($hWnd, "", @SW_ENABLE)
	
	GUIDelete($Search_GUI)
	If IsHWnd($Preview_GUI) Then GUIDelete($Preview_GUI)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $OldOpt)
	
	$Search_GUI = 0
	$Preview_GUI = 0
	
	GUIRegisterMsg($WM_EXITSIZEMOVE, "")
	GUIRegisterMsg($WM_SYSCOMMAND, "")
	GUIRegisterMsg($WM_GETMINMAXINFO, "")
	GUIRegisterMsg($WM_NOTIFY, "")
EndFunc

Func SearchEngine($Page, $SearchMode=0)
	Local $SearchSource = _HTTPGetSource($Main_YT_Host, $Page)
	
	Local $IDs_Array = StringRegExp($SearchSource, _
		'(?i)<div class=".*"><div class=".*"><a href="(.*)" ><img src=".*".*alt=".*"></a>', 3)
	Local $Descripts_Array = StringRegExp($SearchSource, _
		'(?i)(?s)<div  class="vldesc">\s*(?:<span  id="BeginvidDesc[^">]*">)?\s*(.*?)\s*(?:</span>|</div>)', 3)
	Local $Titles_Array = StringRegExp($SearchSource, _
		'(?i)<a href=".*" ><img src=".*".*class=".*" title="(.*)" alt=".*"></a>', 3)
	
	Local $iRandom, $CurrentName, $CurrentDescript, $CurrentID
	Local $Founded = 0
	
	If $SearchMode = 1 Then ;"I am feeling lucky" mode :)
		If UBound($IDs_Array) > 0 Then
			If IsArray($Titles_Array) And UBound($Titles_Array) < UBound($IDs_Array) Then ReDim $Titles_Array[UBound($IDs_Array)+1]
			If IsArray($Descripts_Array) And UBound($Descripts_Array) < UBound($IDs_Array) Then _
				ReDim $Descripts_Array[UBound($IDs_Array)+1]
			
			$iRandom = Random(0, UBound($IDs_Array)-1, 1)
			$CurrentName = Correct_Content($Titles_Array[$iRandom], 1)
			$CurrentDescript = Correct_Content($Descripts_Array[$iRandom])
			$CurrentID = "http://youtube.com" & $IDs_Array[$iRandom]
			
			If Not StringRegExp($CurrentName, '(?i)[-a-z]') Then
				$CurrentName = _UTF8ToAnsi($CurrentName)
			Else
				$CurrentName = _UTF8ToUnicode($CurrentName)
			EndIf
			
			If StringRegExp($CurrentDescript, '(?i)[-a-z]') Then
				$CurrentDescript = _UTF8ToAnsi($CurrentDescript)
			Else
				$CurrentDescript = _UTF8ToUnicode($CurrentDescript)
			EndIf
			
			If StringStripWS($CurrentName, 8) = "" Then $CurrentName = "YouTube_Video"
			
			GUICtrlCreateListViewItem($CurrentName, $Search_ListView)
			GUICtrlSetImage(-1, $YouTube_Item_IconPath, 0)
			_GUICtrlListViewSetItemText($Search_ListView, 0, 1, $CurrentDescript)
			_GUICtrlListViewSetItemText($Search_ListView, 0, 2, $CurrentID)
			$Founded += 1
		EndIf
	ElseIf UBound($Titles_Array) > 0 Then
		If IsArray($IDs_Array) And UBound($Titles_Array) > UBound($IDs_Array) Then ReDim $IDs_Array[UBound($Titles_Array)+1]
		If IsArray($Descripts_Array) And UBound($Titles_Array) > UBound($Descripts_Array) Then _
			ReDim $Descripts_Array[UBound($Titles_Array)+1]
		
		Local $IDsArr_IsArray = IsArray($IDs_Array)
		Local $DescArr_IsArray = IsArray($Descripts_Array)
		
		For $i = 0 To UBound($Titles_Array)-1
			$CurrentID = ""
			$CurrentDescript = ""
			$CurrentName = Correct_Content($Titles_Array[$i], 1)
			
			If $IDsArr_IsArray Then $CurrentID = "http://youtube.com" & $IDs_Array[$i]
			If $DescArr_IsArray Then $CurrentDescript = Correct_Content($Descripts_Array[$i])
			
			If Not StringRegExp($CurrentName, '(?i)[-a-z]') Then
				$CurrentName = _UTF8ToAnsi($CurrentName)
			Else
				$CurrentName = _UTF8ToUnicode($CurrentName)
			EndIf
			
			If StringRegExp($CurrentDescript, '(?i)[-a-z]') Then
				$CurrentDescript = _UTF8ToAnsi($CurrentDescript)
			Else
				$CurrentDescript = _UTF8ToUnicode($CurrentDescript)
			EndIf
			
			GUICtrlCreateListViewItem($CurrentName, $Search_ListView)
			GUICtrlSetImage(-1, $YouTube_Item_IconPath, 0)
			_GUICtrlListViewSetItemText($Search_ListView, $i, 1, $CurrentDescript)
			_GUICtrlListViewSetItemText($Search_ListView, $i, 2, $CurrentID)
			$Founded += 1
		Next
	EndIf
	
	Return SetExtended($Founded, $SearchSource)
EndFunc

Func PreviewVideo_GUI($Video_Name, $Video_URL, $hWnd_1, $hWnd_2)
	Local $FlashVersion = GetFlashVersion()
	
	If @error Or $FlashVersion <= 7 Then
		Local $FlashIsCompatible = IsCompatible_Flash_Version($FlashVersion)
		If @error Or Not $FlashIsCompatible Then Return SetError(3)
	EndIf
	
	Local $iRetErr = 0
	
	Local $Video_ID = GetYT_ID($Video_URL)
	Local $Get_URL_Value = Get_URL_Value(-1, $Video_URL)
	If @error Then Return SetError(1)
	
	Local $Watch_Video_URL = 'http://youtube.com/watch_fullscreen?video_id=' & $Video_ID & '&t=' & $Get_URL_Value
	Local $Shell_Explorer_Obj = ObjCreate("Shell.Explorer.2")
	If @error Or Not IsObj($Shell_Explorer_Obj) Then Return SetError(2)
	
	GUIRegisterMsg($WM_NOTIFY, "")
	
	GUISetState(@SW_DISABLE, $hWnd_1)
	GUISetState(@SW_DISABLE, $hWnd_2)
	
	$Watch_Video_GUI = GUICreate($AppName & " - Watch Video - " & $Video_Name, _
		800, 600, -1, -1, $WS_OVERLAPPEDWINDOW, $WS_EX_TOPMOST, $hWnd_1)
	GUISwitch($Watch_Video_GUI)
	Local $ShellObj = GUICtrlCreateObj($Shell_Explorer_Obj, 10, 10, 780, 580)
	GUICtrlSetResizing(-1, 1)
	
	GUISetState(@SW_SHOW, $Watch_Video_GUI)
	$Shell_Explorer_Obj.Navigate($Watch_Video_URL)
	If @error Then $iRetErr = 1
	
	Local $SizeTimer = TimerInit()
	While 1
		If TimerDiff($SizeTimer) >= 10000 Then ExitLoop
		If String($Shell_Explorer_Obj.ReadyState) = "Complete" Or $Shell_Explorer_Obj.ReadyState = 4 Then ExitLoop
		Sleep(100)
	WEnd
	
	Local $CurrenPos = WinGetPos($Watch_Video_GUI)
	WinMove($Watch_Video_GUI, "", $CurrenPos[0], $CurrenPos[1], 780, 580)
	
	While GUIGetMsg() <> -3
	Wend
	
	GUISetState(@SW_ENABLE, $hWnd_1)
	GUISetState(@SW_ENABLE, $hWnd_2)
	GUIDelete($Watch_Video_GUI)
	GUISwitch($hWnd_2)
	GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
	If $iRetErr > 0 Then Return SetError(3)
	Return SetError(0)
EndFunc

;This is a path for the latest YouTube changes :( (not for all descriptions the same tags)
;Ok, not needed(?) anymore....
Func _Get_Descriptions_Proc($sSource)
	Local $avDesc_Array = StringRegExp($sSource, '(?i)(?s)<div  class="vldesc">.*?[<span  id="BeginvidDesc.*?">|](.*?)</span>', 3)
	
	For $i = 0 To UBound($avDesc_Array)-1
		$avDesc_Array[$i] = StringRegExpReplace($avDesc_Array[$i], '(?s)(?i)\Aspan  id="BeginvidDesc.*?">|</div>.*?$', '')
	Next
	
	Return $avDesc_Array
EndFunc

Func _GUICtrlStatusBarSetTextEx($h_StatusBar, $s_Data = "", $i_Part = 0, $iCode = 0)
	If Not IsHWnd($h_StatusBar) Then $h_StatusBar = HWnd($h_StatusBar)
	If Not _IsClassName($h_StatusBar, "msctls_statusbar32") Then Return SetError(-1, -1, False)
	
	Local $aRet = DllCall("Kernel32.dll", "int", "MultiByteToWideChar", _
			"int", $iCode, "int", 0, _
			"str", $s_Data, "int", -1, _
			"ptr", 0, "int", 0)
	
	If $aRet[0] = 0 Then Return SetError(-1, -1, 0)
	
	Local $struct_String = DllStructCreate("byte[" & $aRet[0] * 2 + 2 & "]")
	Local $sBuffer_pointer = DllStructGetPtr($struct_String)
	Local $struct_MemMap
	Local $Memory_pointer = _MemInit($h_StatusBar, DllStructGetSize($struct_String), $struct_MemMap)
	
	If @error Then
		_MemFree($struct_MemMap)
		Return SetError(-1, -1, 0)
	EndIf
	
	$aRet = DllCall("Kernel32.dll", "int", "MultiByteToWideChar", _
			"int", $iCode, "int", 0, _
			"str", $s_Data, "int", -1, _
			"ptr", DllStructGetPtr($struct_String), "int", $aRet[0])
	
	If $aRet[0] = 0 Then
		_MemFree($struct_MemMap)
		Return SetError(-1, -1, 0)
	EndIf
	
	_MemWrite($struct_MemMap, $sBuffer_pointer)
	
	If @error Then
		_MemFree($struct_MemMap)
		Return SetError(-1, -1, 0)
	EndIf
	
	$aRet = _SendMessage($h_StatusBar, $SB_SETTEXT + 10, $i_Part, $Memory_pointer)
	
	If @error Then
		_MemFree($struct_MemMap)
		Return SetError(-1, -1, 0)
	EndIf
	
	_MemFree($struct_MemMap)
	Return $aRet
EndFunc

Func _MsgBox($sMsgBoxType, $sMsgBoxTitle, $sMsgBoxText, $hWnd)
	Local $aRet = DllCall ("user32.dll", "int", "MessageBox", _
			"hwnd", $hWnd, _
			"str", $sMsgBoxText , _
			"str", $sMsgBoxTitle, _
			"int", $sMsgBoxType)
	Return $aRet[0]
EndFunc

Func _Execute($sCmd, $Args="", $sFolder="", $Verb="", $rState=@SW_SHOWNORMAL)
	Local $Old_REF = Opt("RunErrorsFatal", 0)
	Local $sCmdPid = Run($sCmd, $sFolder, $rState)
	Local $sRunError = @error
	Opt("RunErrorsFatal", $Old_REF)
	If Not $sRunError Then Return SetError(0, 0, 1)
	
	If StringRight($sCmd, 3) = "lnk" Then
		Local $iShortcutInfo = FileGetShortcut($sCmd)
		If IsArray($iShortcutInfo) Then $sCmd = $iShortcutInfo[0]
	EndIf
	
	Local $aRet = DllCall("shell32.dll", "long", "ShellExecute", _
		"hwnd", 0, _
		"string", $Verb, _
		"string", $sCmd, _
		"string", $Args, _
		"string", $sFolder, _
		"int", $rState)
	If @error Then Return SetError(1, 0, 0)
	
	Local $RetVal = $aRet[0]
	If $RetVal > 32 Then Return SetError(0, 0, 1)
	Return SetError(1, 0, 0)
EndFunc

Func ShowMenu($hWnd, $nContextID)
	Local $hMenu = GUICtrlGetHandle($nContextID)
	Local $arPos = MouseGetPos()
	Local $x = $arPos[0]
	Local $y = $arPos[1]
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $x, "int", $y, "hwnd", $hWnd, "ptr", 0)
EndFunc

Func WM_GETMINMAXINFO($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $Preview_GUI Then Return $GUI_RUNDEFMSG
	Local $minmaxinfo = DllStructCreate("int;int;int;int;int;int;int;int;int;int",$lParam)
	Local $MINGuiX = 400, $MINGuiY = 400, $MAXGuiX = 800, $MAXGuiY = 600
	DllStructSetData($minmaxinfo, 7, $MINGuiX) ; min X
	DllStructSetData($minmaxinfo, 8, $MINGuiY) ; min Y
	Return 0
EndFunc

Func DRAG_COMMAND($HWnd, $Command, $wParam, $lParam)
	If BitAND(WinGetState($HWnd), 32) Then Return $GUI_RUNDEFMSG
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $HWnd, "int", $WM_SYSCOMMAND, "int", 0xF009, "int", 0)
EndFunc

Func WM_NOTIFY($hWnd, $MsgID, $wParam, $lParam)
	If $hWnd <> $Search_GUI Then Return $GUI_RUNDEFMSG
	Local $TagNMHDR = DllStructCreate("int;int;int", $lParam)
	If @error Then Return
	Local $EventCode = DllStructGetData($TagNMHDR, 3)
	If $wParam = $Search_ListView And $EventCode = -3 Then $DoubleClicked = True
	If $wParam = $Search_ListView And $EventCode = 0xFFFFFF93 Then Return ;Prevent Items Draging
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_SYSCOMMAND($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $Preview_GUI And $hWnd <> $Watch_Video_GUI Then Return $GUI_RUNDEFMSG
	Switch BitAND($wParam, 0xFFF0)
		Case $SC_SIZE
			DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", 0, "ptr", 0, "int", 2)
	EndSwitch
EndFunc

Func WM_EXITSIZEMOVE($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $Preview_GUI And $hWnd <> $Watch_Video_GUI Then Return $GUI_RUNDEFMSG
	Local $Old_Toggle_Show_Content_Param = RegRead("HKEY_CURRENT_USER\Control Panel\Desktop", "DragFullWindows")
	DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", $Old_Toggle_Show_Content_Param, "ptr", 0, "int", 2)
EndFunc

Func _ReduceMemory($i_PID = -1)
	If $i_PID <> - 1 Then
		Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
		DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
	Else
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	EndIf
	Return $ai_Return[0]
EndFunc

Func Main_COM_Events_Func()
	Local $iErr = $oMainErrHandler.Number
	If $iErr = 0 Then $iErr = -1
	SetError($iErr)
EndFunc

Func Quit($Silent=0)
	If $Silent <> 0 And @InetGetActive Then
		$AskExit = _MsgBox(262144+256+52, "Attention!", _
			"Downloading will be aborted if you exit now, are you sure?", $App_Main_Hwnd)
		If $AskExit <> 6 Then Return
		EndDownloading(1, 1)
	EndIf
	
	If StringInStr($CmdLineRaw, '/Silent') And StringInStr($CmdLineRaw, '/YT_URL_ID=') Then Exit
	
	GUISetState(@SW_HIDE, $App_Main_Hwnd)
	
	$LastHistoryURL 			= ControlGetText($GUI, "", $URL_Combo)
	$URLsHistory 				= _GUICtrlComboGetList($URL_Combo)
	$URLsHistory 				= _StringStripChars(DeleteDuplicatesInStr($URLsHistory), "|", 3)
	$SearchKeyWordsHistory 		= _StringStripChars(DeleteDuplicatesInStr($SearchKeyWordsHistory), "|", 3)
	$LastDownloadPath 			= GUICtrlRead($DownloadPath_Input)
	$Download_With_Def_Brows 	= Number(GUICtrlRead($Down_With_Def_Brows_CB) = $GUI_CHECKED)
	$Show_Details 				= Number(GUICtrlRead($ShowHideDetails_Label) = "Hide Details")
	$Monitor_Browsers 			= Number(GUICtrlRead($Monitor_Browser_MenuItem) = 65)
	
	;If _StringIsUTF8Format($LastDownloadedName) Then $LastDownloadedName = _UTF8ToUnicode($LastDownloadedName)
	;If _StringIsUTF8Format($LastDownloadPath) Then $LastDownloadPath = _UTF8ToUnicode($LastDownloadPath)
	;If _StringIsUTF8Format($LastSearchKeyWords) Then $LastSearchKeyWords = _UTF8ToUnicode($LastSearchKeyWords)
	;If _StringIsUTF8Format($SearchKeyWordsHistory) Then $SearchKeyWordsHistory = _UTF8ToUnicode($SearchKeyWordsHistory)
	
	If Not FileExists($ConfigFile) Then FileClose(FileOpen($ConfigFile, 8 + 1 + 32))
	
	IniWrite($ConfigFile, "Main Prefs", "Autorename Existing Videos", $AutoRenameFile)
	IniWrite($ConfigFile, "Main Prefs", "Get File From Local Cache", $ReloadFromInet)
	IniWrite($ConfigFile, "Main Prefs", "Write Log When Downloading Video", $WriteLog_When_Download)
	IniWrite($ConfigFile, "Main Prefs", "Last Downloaded Video Name", $LastDownloadedName)
	IniWrite($ConfigFile, "Main Prefs", "Last Download Path", $LastDownloadPath)
	IniWrite($ConfigFile, "Main Prefs", "Show Details", $Show_Details)
	IniWrite($ConfigFile, "Main Prefs", "Download With Default Browser", $Download_With_Def_Brows)
	IniWrite($ConfigFile, "Main Prefs", "Monitor Browsers", $Monitor_Browsers)
	IniWrite($ConfigFile, "Main Prefs", "Animate Tray Icon When Monitoring", $Animate_Tray_Icon)
	IniWrite($ConfigFile, "Main Prefs", "Minimize To Tray", $Minimize_To_Tray)
	
	IniWrite($ConfigFile, "URLs History", "Last URL", $LastHistoryURL)
	IniWrite($ConfigFile, "URLs History", "Data", $URLsHistory)
	
	IniWrite($ConfigFile, "Search Prefs", "Default Sort By", $SearchDefaultSortBy)
	IniWrite($ConfigFile, "Search Prefs", "Feeling Lucky", $FeelingLucky)
	IniWrite($ConfigFile, "Search Prefs", "Last Search KeyWords", $LastSearchKeyWords)
	IniWrite($ConfigFile, "Search Prefs", "Search History Data", $SearchKeyWordsHistory)
	
	If $Timer_Proc_Monitor <> 0 Then
		_DllCallBack_Free($Timer_Proc_Monitor)
		DllCall("user32.dll", "int", "KillTimer", "hwnd", 0, "uint", $iTimer_Monitor)
	EndIf
	
	Exit
EndFunc
