// ==UserScript==
// @name          grabScroller
// @author        splondike with drag-drop fix by shoust
// @ujs:modified  2007-04-28
// ==/UserScript==
// This script reproducet the behaviour of the 'Scrollbar anywhere' firefox extension
// It also allows you to reproduce the grab-and-drag behaviour of acrobat reader et. al.
// Hold down the ctrl key and use the left mouse button to drag the page

(function(){
//Set this to the number of the button you want to use; left = 0, middle = 1, right = 2
var scrollButton = 0;
var allowTextSelect = false;
var useModifier = true;
//These represent the multiplier for the horiz and vert scrolling
//Grab and scroll (like acrobat reader), you also need to comment out the code under 
//Scrollbar anywhere style if you want this to work
var scaleX = 2;
var scaleY = 2;

//Deals with scaling and making sure the context menu blocker works
var resise = function(){
	if(scrWidth == document.documentElement.scrollWidth && scrHeight == document.documentElement.scrollHeight){return ;}
	scrWidth = document.documentElement.scrollWidth;
	scrHeight = document.documentElement.scrollHeight;

	//Scrollbar anywhere style
	var sbHeight = window.innerHeight * window.innerHeight / scrHeight;
	var sbWidth = window.innerWidth * window.innerWidth / scrWidth;
	scaleX = -1 * scrWidth / (window.innerWidth - sbWidth);
	scaleY = -1 * scrHeight / (window.innerHeight - sbHeight);

	//Horrible hack to block the right-click context menu (slows scrolling down a bit)
	if(scrollButton == 2){
		if(!bl){
			bl = document.createElement("input");
			bl.type = "button";
			bl.style = "position:absolute;top:0px;left:0px;border:0;background:none;visibility:hidden;";
			bl = document.documentElement.appendChild(bl);
		}
		bl.style.width = scrWidth + "px";
		bl.style.height = scrHeight + "px";
	}
}
var bl = false; 

//Internal variables
var clickX;
var clickY;
var origScX;
var origScY;
var scrWidth;
var scrHeight;

var moveScroll = function(e){
	var newX = e.pageX - document.documentElement.scrollLeft;
	var newY = e.pageY - document.documentElement.scrollTop;

	window.scrollTo(origScX + scaleX * (clickX - newX), origScY + scaleY * (clickY - newY));
	if(bl)bl.style.visibility = "visible";
}

var mouseup = function(e){
	removeEventListener("mousemove", moveScroll, false); 
	removeEventListener("mouseup", mouseup, false);
	if(bl)bl.style.visibility = "hidden";
}

//Use BeforeEvent to circumvert the opera mousedown = no link drag bug
opera.addEventListener("BeforeEvent.mousedown", function(e){
	if((scrollButton==0 && (e.event.target.tagName=='A' || e.event.target.tagName=='IMG' || e.event.srcElement.tagName=='IMG' || e.event.srcElement.tagName=='A' || e.event.srcElement.parentNode.tagName=='A' || e.event.srcElement.parentNode.tagName=='IMG' || e.event.target.parentNode.tagName=='A' || e.event.target.parentNode.tagName=='IMG')) || (e.event.button != scrollButton || (useModifier && !e.event.ctrlKey)))
{/* Makes sure image and link sections are draggable when left click is used to drag*/}
	else{
		clickX = e.event.pageX - document.documentElement.scrollLeft;
		clickY = e.event.pageY - document.documentElement.scrollTop;
		origScX = document.documentElement.scrollLeft;
		origScY = document.documentElement.scrollTop;
		addEventListener("mousemove", moveScroll, false); 
		addEventListener("mouseup", mouseup, false);

		//Stop text from getting selected, if that's what we want
		if(!allowTextSelect && scrollButton == 0)e.event.preventDefault();
		//Check if the window sise has been changed
		resise();
	}
}, false);
})();
