// ==UserScript==
// @name		Textarea Resizer (by motive of forum.ru-board.com scripts, adapted by Joo Eiras)
// @version		1.1
// @date		2007-09-16
// @author		Joo Eiras (based on Mike Samokhvalov <mikivanch@gmail.com>)
// @exclude		http://forum.ru-board.com/*
// ==/UserScript==

(function( opera ){

	function get_y(obj){
		var y = 0;
		do{y += obj.offsetTop;
		}while(obj=obj.offsetParent);
		return y;
	}
	function get_x(obj){
		var x = 0;
		do{x += obj.offsetLeft;
		}while(obj=obj.offsetParent);
		return x;
	}

	var imgResizer, canHide = true;
	
	function textareaHover(e){
		var textarea = e.event.target;
		if( !canHide || !(textarea instanceof HTMLTextAreaElement) )
			return; 
			
		if(!imgResizer){
			imgResizer = document.createElement('img');
			imgResizer.src = 'data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAYAAAAfSC3RAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAVElEQVQokZ3PywkAIAxEwfRfiIKdidhCFFHwFzXrIZDLwD5iIoKPOX0haxwIG8LggIKPSrggXaOA3lMP6A4v6Nz4QHKjAu1TlWiGAOqNIKqNH6j8GRf5wjIdNsbvAAAAAElFTkSuQmCC';
			imgResizer.setAttribute('style', 'z-index: 9999 !important; position: absolute !important; '+
				'width: 14px! important; height: 14px!important; border: none; cursor: se-resize !important; '+
				' padding: 0 !important; margin: 0 0 0 0 !important;');
			imgResizer.title = 'Drag to resize this textarea';
			
			//imgResizer.src = 'data:image/gif;base64,R0lGODlhAQABAIABAAAAAP///yH5BAEAAAEALAAAAAABAAEAAAICTAEAOw==';
			//imgResizer.setAttribute('style', 'z-index: 9999 !important; position: absolute !important; '+
			//	'width: 14px! important; height: 14px!important; border: none; cursor: se-resize !important; '+
			//	' padding: 0 !important; margin: 0 0 0 0 !important;background: -o-skin("Resizer");');
			//imgResizer.title = 'Drag to resize this textarea';
			
			function f_onmousemove(e){
				var textarea = imgResizer.resizingtextarea;
				var styles=getComputedStyle(textarea,'');
				imgResizer.style.top = (get_y(textarea)+parseInt(styles.height)-15)+'px !important';
				imgResizer.style.left = (get_x(textarea)+parseInt(styles.width)-15)+'px !important';
				
				var w = e.clientX - get_x(textarea) + window.pageXOffset;
				var h = e.clientY - get_y(textarea) + window.pageYOffset;
				
				if(w > 50) textarea.style.width = w + 'px !important';
				if(h > 50) textarea.style.height = h + 'px !important'
		
				return false;
			};
			function f_onmouseup(ev){
				canHide = true;
				document.removeEventListener('mousemove',f_onmousemove,true);
				document.removeEventListener('mouseup',f_onmouseup,true);
			};
				
			imgResizer.onmousedown = function(){
				canHide = false;
				document.addEventListener('mousemove',f_onmousemove,true);
				document.addEventListener('mouseup',f_onmouseup,true);
				return false;
			};
			
			document.documentElement.appendChild(imgResizer);
		}
		var styles=getComputedStyle(textarea,'');
		imgResizer.style.top = (get_y(textarea)+parseInt(styles.height)-15)+'px !important';
		imgResizer.style.left = (get_x(textarea)+parseInt(styles.width)-15)+'px !important';
		imgResizer.style.display = 'block';
		imgResizer.resizingtextarea = textarea;
		
	};
	function textareaOut(e){	
		if(e.event.relatedTarget == imgResizer)
			return;
			
		if( imgResizer && canHide && e.event.target instanceof HTMLTextAreaElement ){
			imgResizer.style.display='none';
		}
	};
	opera.addEventListener('BeforeEvent.mouseover',textareaHover,false);
	opera.addEventListener('BeforeEvent.mouseout',textareaOut,false);
	
})( window.opera );			