;Simple program for kids to solve/learn basic math tasks
;by G.Sandler


#NoTrayIcon
#include <GuiConstants.au3>
#include <MSAgentLib.au3>
;

Global Const $WM_SYSCOMMAND  = 0x0112
Global Const $WM_LBUTTONDOWN = 0x0201

Global $Wins 			= 0
Global $Loses 			= 0

Global $Names 			= ""

Global $Lowset 			= 1
Global $Biggest 		= 15
Global $Top				= 60

Global $BUTTONSCOLOR 		= 0xFFFFFF
Global $BUTTONSBKCOLOR 		= 0x0000FF
Global $GUI_BK_COLOR		= 0x0
Global $CTRL_TEXT_COLOR		= 0xFFFFFF
Global $STATUS_COLOR		= 0xFFFFFF

Global $Label[11]
Global $Input[11]

Global $MultiplTableGui, $MultiplTableCloseButton = -1
Global $InputsArr[170], $CurrentInput = 0

Global $AppTitle 	= "Math Tasks"
Global $AppVersion	= "v1.0"

$Gui = GUICreate($AppTitle & " - " & $AppVersion, 350, 450)
GUIRegisterMsg($WM_LBUTTONDOWN, "DRAG_COMMAND")
GUISetBkColor($GUI_BK_COLOR)

$MultiplyingTableButton = GUICtrlCreateButton(">", 330, 80, 15, 120)
GUICtrlSetTip(-1, "Show Multiplying Table")

GUICtrlCreateLabel("Level: ", 20, 18)
GUICtrlSetColor(-1, $CTRL_TEXT_COLOR)
$LevelCombo = GUICtrlCreateCombo("", 60, 15, 50, 20, 0x0003)
GUICtrlSetData(-1, "1|2|3|4|5", "1")

GUICtrlCreateLabel("Operation: ", 200, 18)
GUICtrlSetColor(-1, $CTRL_TEXT_COLOR)
$OperationCombo = GUICtrlCreateCombo("", 260, 15, 50, 20, 0x0003)
GUICtrlSetData(-1, "+|-|/|*", "+")

For $i = 1 To 10
	$Num_1 = Random($Lowset, $Biggest, 1)
	$Num_2 = Random($Lowset, $Biggest, 1)
	
	GUICtrlCreateLabel(" = ", 160, $Top+2, -1, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetColor(-1, $CTRL_TEXT_COLOR)
	
	GUICtrlCreateLabel($i & ") ", 60, $Top+2, -1, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 9, 600, 0, "Tahoma")
	GUICtrlSetColor(-1, 0xEE0000)
	
	$Label[$i] = GUICtrlCreateLabel($Num_1 & " + " & $Num_2, 90, $Top+3, 75, 15, -1, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetColor(-1, $CTRL_TEXT_COLOR)
	$Input[$i] = GUICtrlCreateInput("", 185, $Top, 60, 20, $ES_NUMBER+$ES_AUTOHSCROLL)
	
	$Top += 30
Next

$Generate = GUICtrlCreateButton("Generate", 20, 400, 60)
$Check = GUICtrlCreateButton("Check", 120, 400, 60)
$Exit = GUICtrlCreateButton("EXIT", 270, 400, 60)

$DummyMenu   	= GUICtrlCreateDummy()
$ContextMenu 	= GUICtrlCreateContextMenu($DummyMenu)

$CopyMenuItem = GUICtrlCreateMenuItem("Copy", $ContextMenu)

$StatusLabel = GUICtrlCreateLabel("Loses/Wins Count: 0:0", 2, 435, 348, -1, $SS_SIMPLE+$SS_SUNKEN)
GUICtrlSetColor(-1, $STATUS_COLOR)

GUISetState(@SW_SHOW, $Gui)

$MultiplTableGui = GUICreate("Multiplying Table", 370, 320, -1, -1, $WS_BORDER+$WS_POPUP, -1, $Gui)
GUIRegisterMsg(0x0003, "Win_Move")
GUISetBkColor($GUI_BK_COLOR)

$TitleLabel = GUICtrlCreateLabel("Multiplying Table", 0, 0, 350, 20, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetColor(-1, $CTRL_TEXT_COLOR)
GUICtrlSetFont(-1, 11, 800)

CreateMultiplyingTable()

$MultiplTableCloseButton = GUICtrlCreateButton("Close", 20, 290, 80, 22)

GUISetState(@SW_HIDE, $MultiplTableGui)

While 1
	$iMsg = GUIGetMsg(1)
	Select
		Case $iMsg[0] = -3 Or $iMsg[0] = $Exit
			Exit
		Case $iMsg[1] = $MultiplTableGui And $iMsg[0] = $GUI_EVENT_SECONDARYDOWN
			Local $CurInfo = GUIGetCursorInfo($MultiplTableGui)
			For $i = 1 To 169
				If $CurInfo[4] = $InputsArr[$i] Then
					$CurrentInput = $InputsArr[$i]
					ShowMenu($MultiplTableGui, $ContextMenu)
					ExitLoop
				EndIf
			Next
		Case $iMsg[0] = $MultiplyingTableButton Or $iMsg[0] = $MultiplTableCloseButton
			If BitAND(WinGetState($MultiplTableGui), 2) Then
				GUISetState(@SW_HIDE, $MultiplTableGui)
				GUICtrlSetData($MultiplyingTableButton, ">")
				GUICtrlSetTip($MultiplyingTableButton, "Show Multiplying Table")
				ContinueLoop
			EndIf
			
			GUICtrlSetData($MultiplyingTableButton, "<")
			GUICtrlSetTip($MultiplyingTableButton, "Hide Multiplying Table")
			
			$ParentPosArr = WinGetPos($Gui)
			
			If $ParentPosArr[0]+$ParentPosArr[2]+370 > @DesktopWidth Then
				WinMove($Gui, "", @DesktopWidth-($ParentPosArr[2]+375), $ParentPosArr[1])
				WinMove($MultiplTableGui, "", @DesktopWidth-375, $ParentPosArr[1])
			EndIf
			
			If $ParentPosArr[1]+320 > @DesktopHeight Then
				$ParentPosArr = WinGetPos($Gui)
				$ShellTrayPosArr = WinGetPos("[CLASS:Shell_TrayWnd]")
				WinMove($Gui, "", $ParentPosArr[0], @DesktopHeight-$ShellTrayPosArr[3]-323)
				WinMove($MultiplTableGui, "", $ParentPosArr[0]+$ParentPosArr[2], @DesktopHeight-$ShellTrayPosArr[3]-323)
			EndIf
			
			GUISetState(@SW_SHOW, $MultiplTableGui)
		Case $iMsg[0] = $Generate Or $iMsg[0] = $OperationCombo
			Generate()
		Case $iMsg[0] = $Check
			Local $MsgBoxHwnd = $Gui
			If IsHWnd($MultiplTableGui) And WinExists($MultiplTableGui) Then
				$MsgBoxHwnd = $MultiplTableGui
				GUISetState(@SW_DISABLE, $Gui)
			EndIf
			
			$EmptyInputs = ""
			$ErrorInputs = ""
			$FirstErrInput = 0
			$CheckMsg = ""
			For $i = 1 To 10
				$CurrentQuestion = GUICtrlRead($Label[$i], 1)
				$CurrentAnswer = GUICtrlRead($Input[$i])
				$Operation = GUICtrlRead($OperationCombo)
				$NumArr = StringSplit(StringReplace($CurrentQuestion, "=", ""), $Operation)
				$FirstNum = Number($NumArr[1])
				$SecondNum = Number($NumArr[2])
				
				$TaskIsIncorrect = False
				Switch $Operation
					Case "+"
						If $FirstNum + $SecondNum <> $CurrentAnswer Then $TaskIsIncorrect = True
					Case "-"
						If $FirstNum - $SecondNum <> $CurrentAnswer Then $TaskIsIncorrect = True
					Case "/"
						If $FirstNum / $SecondNum <> $CurrentAnswer Then $TaskIsIncorrect = True
					Case "*"
						If $FirstNum * $SecondNum <> $CurrentAnswer Then $TaskIsIncorrect = True
				EndSwitch
				
				If ($TaskIsIncorrect And $CurrentAnswer <> "") Or $CurrentAnswer = "" Then
					If $CurrentAnswer = "" Then
						$EmptyInputs &= "[" & $i & "], "
					Else
						$ErrorInputs &= "[" & $i & "], "
					EndIf
					If $FirstErrInput = 0 Then $FirstErrInput = $i
				EndIf
			Next
			
			If $EmptyInputs <> "" Then $CheckMsg = "* Please type answer in following input(s): " & _
				StringTrimRight($EmptyInputs, 2) & @LF & @LF
			If $ErrorInputs <> "" Then $CheckMsg &= "* Incorrect answer in filed(s): " & StringTrimRight($ErrorInputs, 2)
			
			$CheckMsg = StringStripWS($CheckMsg, 3)
			
			If $CheckMsg <> "" Then
				If $EmptyInputs <> "[1], [2], [3], [4], [5], [6], [7], [8], [9], [10], " And $ErrorInputs <> "" Then
					$Loses += 1
					GUICtrlSetData($StatusLabel, "Loses/Wins Count: " & $Loses & ":" & $Wins)
				EndIf
				_MsgBox(48, "Attention", $CheckMsg, $MsgBoxHwnd)
				GUICtrlSetState($Input[$FirstErrInput], $GUI_FOCUS)
			Else
				$Wins += 1
				GUICtrlSetData($StatusLabel, "Loses/Wins Count: " & $Loses & ":" & $Wins)
				$oChar = _RandomCharacters()
				_MsgBox(64, "Done!", "Congratulations!!! All correct :)", $MsgBoxHwnd)
				_MAQuitChar($oChar, 0)
				Generate()
			EndIf
			GUISetState(@SW_ENABLE, $Gui)
		Case $iMsg[0] = $LevelCombo
			Switch GUICtrlRead($LevelCombo)
				Case 1
					$Lowset = 1
					$Biggest = 15
				Case 2
					$Lowset = 20
					$Biggest = 50
				Case 3
					$Lowset = 60
					$Biggest = 1000
				Case 4
					$Lowset = 200
					$Biggest = 5000
				Case 5
					$Lowset = 500
					$Biggest = 10000
			EndSwitch
			Generate()
		Case $iMsg[0] = $CopyMenuItem
			ClipPut(GUICtrlRead($CurrentInput))
	EndSelect
WEnd

Func CreateMultiplyingTable()
	Local $Left = 20, $Top = 20
	For $i = 1 To 169
		$InputsArr[$i] = GUICtrlCreateInput("", $Left, $Top, 25, -1, $ES_READONLY)
		If $i = 1 Then
			GUICtrlSetData(-1, "X")
			GUICtrlSetState(-1, 128)
			GUICtrlSetFont(-1, 9, 800)
		EndIf
		
		$Left += 25
		If $Left >= (25*13) Then
			$Left = 20
			$Top += 20
		EndIf
	Next
	
	For $i = 2 To 13
		GUICtrlSetData($InputsArr[$i], $i-1)
		GUICtrlSetFont($InputsArr[$i], 9, 800)
		GUICtrlSetColor($InputsArr[$i], 0x0000FF)
	Next
	
	$Counter = 1
	For $i = 1 To 169 Step 13
		If $i > 1 Then
			GUICtrlSetData($InputsArr[$i], $Counter)
			GUICtrlSetFont($InputsArr[$i], 9, 800)
			GUICtrlSetColor($InputsArr[$i], 0x0000FF)
			$Counter += 1
		EndIf
	Next
	
	$Counter = 1
	For $i = 15 To 26
		GUICtrlSetData($InputsArr[$i], $Counter)
		$Counter += 1
	Next
	
	$Counter = 1
	For $i = 15 To 169 Step 13
		GUICtrlSetData($InputsArr[$i], $Counter)
		$Counter += 1
	Next
	
	$OldCounter = 4
	$Counter = 4
	$SubCounter = 2
	$iVal = 29
	$ToVal = 39
	While 1
		For $i = $iVal To $ToVal
			GUICtrlSetData($InputsArr[$i], $OldCounter)
			$OldCounter += $SubCounter
		Next
		$Counter += 2
		$OldCounter = $Counter
		$SubCounter += 1
		$iVal += 13
		$ToVal += 13
		If $iVal >= 169 Then ExitLoop
	WEnd
EndFunc

Func Generate()
	GUICtrlSetColor($StatusLabel, 0xFF0000)
	GUICtrlSetData($StatusLabel, "Please wait...")
	For $i = 1 To 10
		$Num_1 = Random($Lowset, $Biggest, 1)
		$Num_2 = Random($Lowset, $Biggest, 1)
		$Operation = GUICtrlRead($OperationCombo)
		
		Switch $Operation
			Case "-"
				While $Num_1 < $Num_2
					$Num_1 = Random($Lowset, $Biggest, 1)
					$Num_2 = Random($Lowset, $Biggest, 1)
				WEnd
			Case "/"
				While $Num_1 < $Num_2 Or Not IsInt($Num_1 / $Num_2) Or $Num_1 = $Num_2
					$Num_1 = Random($Lowset, $Biggest, 1)
					$Num_2 = Random($Lowset, $Biggest, 1)
				WEnd
			Case "*", "+"
				While Not IsInt($Num_1 * $Num_2)
					$Num_1 = Random($Lowset, $Biggest, 1)
					$Num_2 = Random($Lowset, $Biggest, 1)
				WEnd
		EndSwitch
		GUICtrlSetData($Label[$i], $Num_1 & " " & $Operation & " " & $Num_2)
		GUICtrlSetData($Input[$i], "")
	Next
	GUICtrlSetData($StatusLabel, "Loses/Wins Count: " & $Loses & ":" & $Wins)
	GUICtrlSetColor($StatusLabel, $STATUS_COLOR)
EndFunc

Func ShowMenu($hWnd, $nContextID)
	Local $hMenu = GUICtrlGetHandle($nContextID)
	Local  $arPos = MouseGetPos()
	Local $x = $arPos[0]
	Local $y = $arPos[1]
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $x, "int", $y, "hwnd", $hWnd, "ptr", 0)
EndFunc

Func _RandomCharacters()
	$FiguresArr = _FiguresListToArray()
	If Not IsArray($FiguresArr) Then Return SetError(1)
	$RandomFigure = Random(1, $FiguresArr[0], 1)
	$FigurePath = $FiguresArr[$RandomFigure]
	If Not FileExists($FigurePath) Then Return SetError(2)
	$FigureName = StringTrimRight(StringRegExpReplace($FigurePath, '^.*\\', ''), 4)
	If Not FileExists($FigurePath) Then Return SetError(2)
	If Not StringInStr($Names, "|" & $FigureName & "|") Then
		$hCharacter = _MALoadCharacter($FigurePath, $FigureName)
	Else
		Return SetError(3)
	EndIf
	$Names &= "|" & $FigureName & "|"
	$CharsActionsArr = _MAListCharAnimations($hCharacter)
	$MovexX = Random(150, @DesktopWidth-150, 1)
	$MoveY = Random(150, @DesktopHeight-150, 1)
	$hCharacter.MoveTo($MovexX, $MoveY, 0)
	$hCharacter.Show
	$hCharacter.Speak ("Congratulations!!! All correct :)")
	$Request = _MACharPlayAnim($hCharacter, $CharsActionsArr[Random(1, $CharsActionsArr[0], 1)])
	Return $hCharacter
EndFunc

Func _FiguresListToArray()
	$FiguresPath1 = @WindowsDir & "\MSAGENT\CHARS\"
	$FiguresPath2 = @WindowsDir & "\srchasst\chars\"
	$FiguresPath3 = @WindowsDir & "\oobe\images\"
	
	If Not FileExists($FiguresPath1) And _
		Not FileExists($FiguresPath2) And Not FileExists($FiguresPath3) Then Return SetError(1)
	Local $FiguresArr[1]
	Local $FigureFind1 = FileFindFirstFile($FiguresPath1 & "*.acs")
	If $FigureFind1 <> -1 Then
		While 1
			$CurrentFigure = FileFindNextFile($FigureFind1)
			If @error Then ExitLoop
			ReDim $FiguresArr[UBound($FiguresArr)+1]
			$FiguresArr[0] += 1
			$FiguresArr[UBound($FiguresArr)-1] = $FiguresPath1 & $CurrentFigure
		WEnd
	EndIf
	FileClose($FigureFind1)
	Local $FigureFind2 = FileFindFirstFile($FiguresPath2 & "*.acs")
	If $FigureFind2 <> -1 Then
		While 1
			$CurrentFigure = FileFindNextFile($FigureFind2)
			If @error Then ExitLoop
			ReDim $FiguresArr[UBound($FiguresArr)+1]
			$FiguresArr[0] += 1
			$FiguresArr[UBound($FiguresArr)-1] = $FiguresPath2 & $CurrentFigure
		WEnd
	EndIf
	FileClose($FigureFind2)
	Local $FigureFind3 = FileFindFirstFile($FiguresPath3 & "*.acs")
	If $FigureFind3 <> -1 Then
		While 1
			$CurrentFigure = FileFindNextFile($FigureFind3)
			If @error Then ExitLoop
			ReDim $FiguresArr[UBound($FiguresArr)+1]
			$FiguresArr[0] += 1
			$FiguresArr[UBound($FiguresArr)-1] = $FiguresPath3 & $CurrentFigure
		WEnd
	EndIf
	FileClose($FigureFind3)
	Return $FiguresArr
EndFunc

Func _MsgBox($MsgType, $MsgTitle, $MsgText, $hWnd)
	$Result = DllCall("user32.dll", "int", "MessageBox", "hwnd", $hWnd, "str", $MsgText, "str", $MsgTitle, "int", $MsgType)
	Return $Result
EndFunc

Func Win_Move($hWndGUI)
    If $hWndGUI = $Gui Then
        $ParentPosArr = WinGetPos($Gui)
        WinMove($MultiplTableGui, "", $ParentPosArr[0]+$ParentPosArr[2], $ParentPosArr[1])
    Else
        $ChildPosArr = WinGetPos($MultiplTableGui)
		WinMove($Gui, "", $ChildPosArr[0]-$ChildPosArr[2]+17, $ChildPosArr[1])
    EndIf
EndFunc

Func DRAG_COMMAND($HWnd,$command,$wParam,$lParam)
	If BitAND(WinGetState($HWnd), 32) Then Return
	DllCall("user32.dll","long","SendMessage","hwnd",$HWnd,"int",$WM_SYSCOMMAND,"int",0xF009,"int",0)
EndFunc

