;	<Check File Size> by G.Sandler
;	Program checks file size on the internet (http://creator-lab.ucoz.ru/load/4-1-0-37).
;	Source code for AutoIt v3.2.8.1

;

#NoTrayIcon
#include <GuiConstants.au3>
#include <.\Resources\GUICtrlSetOnHover_UDF.au3>
#include <.\Resources\FileSelectFolder_Incl.au3>
#include <.\Resources\Clipboard_Incl.au3>
#include <.\Resources\Opera_Library.au3>
#include <.\Resources\TCP_Incl.au3>
#include <.\Resources\About_Incl.au3>
;

#Region Declaration and Options
Global Const $WM_WINDOWPOSCHANGING 	= 0x0046
Global Const $WM_SYSCOMMAND 		= 0x0112
Global Const $WM_TIMER 				= 0x0113
Global Const $WM_LBUTTONDOWN 		= 0x0201
Global Const $WM_ENTERMENULOOP 		= 0x0211
Global Const $WM_ENTERSIZEMOVE 		= 0x0231
Global Const $WM_EXITSIZEMOVE 		= 0x0232
Global Const $SC_MOVE 				= 0xF010
Global Const $SC_SIZE 				= 0xF000

Global $Config_File 				= @ScriptDir & "\CheckFileSize.ini"
Global $a_Messages					= Get_Translation_Values($Config_File, "Main Prefs")

Global $AppIsOnTop 					= IniRead($Config_File, "Window Prefs", "Window On Top", 1)
Global $StickToScreen 				= IniRead($Config_File, "Window Prefs", "Stick To Screen", 1)
Global $StickToAllWin 				= IniRead($Config_File, "Window Prefs", "Stick To All", 0)
Global $StickRange 					= IniRead($Config_File, "Window Prefs", "Stick Range", 20)

Global $Use_Proxy					= IniRead($Config_File, "Proxy Prefs", "Use Proxy", 0)
Global $HttpProxy_Address			= IniRead($Config_File, "Proxy Prefs", "Http Proxy Address", "")
Global $HttpProxy_Port				= IniRead($Config_File, "Proxy Prefs", "Http Proxy Port", "8080")
Global $HttpProxy_UserName			= IniRead($Config_File, "Proxy Prefs", "Http Proxy Login", "")
Global $HttpProxy_Password			= IniRead($Config_File, "Proxy Prefs", "Http Proxy Password", "")

Global $Download_Manager 			= IniRead($Config_File, "Main Prefs", "Download Manager", "")
Global $DM_CmdLine 					= IniRead($Config_File, "Main Prefs", "DM Command Line", "%l %u")
Global $HTTPUserAgent 				= IniRead($Config_File, "Main Prefs", "User Agent", "Opera/9.27 (Windows NT 5.1; U; en)")
Global $Response_TimeOut 			= IniRead($Config_File, "Main Prefs", "Response Timout", 10000)

Global $Response_TimeOutOver 		= False
Global $GET_RESPONSE 				= ""
Global $iStatusExpire 				= 5000
Global $nStatusExp_Timer 			= -1

Global $AppName 					= "Check File Size"
Global $AppVersion					= "1.12"
Global $sApp_Title 					= "[TITLE:" & $AppName & " v" & $AppVersion & "; CLASS:AutoIt v3 GUI]"

Global $sMain_URL 					= _StringStripChars(_GetCmdLine("/URL="), '"', 3)
Global $Main_GUI					= -1
Global $Options_GUI					= -1

Global $GUI_BK_COLOR				= Default ;0xCCCCCC
Global $GUI_WIDTH 					= 390
Global $GUI_HEIGHT 					= 430
Global $GUI_LEFT 					= IniRead($Config_File, "Window Prefs", "Left", -1)
Global $GUI_TOP 					= IniRead($Config_File, "Window Prefs", "Top", -1)

FileInstall(".\CheckFileSize.ini", $Config_File)
Opt("RunErrorsFatal", 0)
Opt("TCPTimeout", $Response_TimeOut)

If _App_Instance_Runing(@ScriptFullPath) Then
	If Not StringInStr($CmdLineRaw, "/ToolTip=") Then
		$hApp_Win = _AppWinIsVisible($sApp_Title)
		
		If $hApp_Win Then
			$sApp_Title = $hApp_Win
			WinActivate($sApp_Title)
		EndIf
		
		While Not ControlCommand($sApp_Title, "", "Edit1", "IsEnabled")
			Sleep(100)
		WEnd
		
		If $sMain_URL <> "" Then ControlSetText($sApp_Title, "", "Edit1", $sMain_URL)
		
		If StringInStr($CmdLineRaw, "/AutoCheck") Then
			$hSysTab = ControlGetHandle($sApp_Title, "", "SysTabControl321")
			DllCall("user32.dll", "long", "SendMessage", "hwnd", $hSysTab, "int", 0x1300 + 48, "int", 0, "int", 0)
			ControlClick($sApp_Title, "", "Button2")
		EndIf
		
		If $hApp_Win Then Exit
	Else
		$hApp_Win = _AppWinIsUnVisible($sApp_Title)
		If $hApp_Win Then ControlSetText($hApp_Win, "", "Static1", "tooltips_class32")
	EndIf
EndIf
#EndRegion Declaration and Options
;

#Region GUI and Main Controls
$Main_GUI = GUICreate($AppName & " v" & $AppVersion, $GUI_WIDTH, $GUI_HEIGHT, $GUI_LEFT, $GUI_TOP, -1, _
	$WS_EX_CLIENTEDGE + $WS_EX_DLGMODALFRAME)

GUISetBkColor($GUI_BK_COLOR)
If $AppIsOnTop = 1 Then WinSetOnTop($Main_GUI, "", 1)

$Dummy_Ctrl = GUICtrlCreateLabel("Dummy", -100, -100)

$Options_MenuItem = GUICtrlCreateMenuItem($a_Messages[1], -1)
$About_MenuItem = GUICtrlCreateMenuItem($a_Messages[2], -1)

$Main_Tab_Ctrl = GUICtrlCreateTab(5, 5, $GUI_WIDTH - 10, $GUI_HEIGHT - 80)

#Region General Tab
$General_TabItem = GUICtrlCreateTabItem($a_Messages[62])
_GUICtrlTabSetBkColor($Main_GUI, $Main_Tab_Ctrl, 0xFFFFFF)

GUICtrlCreateGroup($a_Messages[3], 15, 30, $GUI_WIDTH - 30, 60)

$URL_Input = GUICtrlCreateInput($sMain_URL, 30, 50, $GUI_WIDTH - 120, 23, _
	$ES_AUTOHSCROLL + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)

$Check_Button = GUICtrlCreateButton($a_Messages[4], $GUI_WIDTH - 80, 50, 60, 23)
GUICtrlSetFont(-1, 8)

GUICtrlCreateGroup($a_Messages[6], 15, 100, $GUI_WIDTH - 30, 245)

GUISetFont(9, 800)

GUICtrlCreateLabel($a_Messages[7], 30, 130)
GUICtrlCreateLabel($a_Messages[8], 30, 150)
GUICtrlCreateLabel($a_Messages[9], 30, 180)
GUICtrlSetColor(-1, 0x6F0000)
GUICtrlCreateLabel($a_Messages[10], 30, 250)
GUICtrlCreateLabel($a_Messages[11], 30, 280)
GUICtrlCreateLabel($a_Messages[63], 30, 310)

GUISetFont(9, 400)

$FileName_Input = GUICtrlCreateInput("", 150, 131, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)

$FileType_Input = GUICtrlCreateInput("", 150, 151, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)

$FileSize_Bytes_Input = GUICtrlCreateInput("", 150, 181, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)
GUICtrlSetColor(-1, 0x6F0000)

$FileSize_KBytes_Input = GUICtrlCreateInput("", 150, 201, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)
GUICtrlSetColor(-1, 0x6F0000)

$FileSize_MBytes_Input = GUICtrlCreateInput("", 150, 221, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)
GUICtrlSetColor(-1, 0x6F0000)

$Last_Modified_Input = GUICtrlCreateInput("", 150, 251, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)

$ResponseTime_Input = GUICtrlCreateInput("", 150, 281, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)

$DownloadResume_Input = GUICtrlCreateInput("", 150, 311, $GUI_WIDTH - 170, 15, $ES_READONLY + $ES_AUTOHSCROLL, $WS_EX_TRANSPARENT)
GUICtrlSetBkColor(-1, $GUI_BK_COLOR)
#EndRegion General Tab
;

#Region Details Tab
$Details_TabItem = GUICtrlCreateTabItem($a_Messages[12])

GUICtrlCreateGroup($a_Messages[16], 15, 30, $GUI_WIDTH - 30, $GUI_HEIGHT - 115)

$Response_Edit = GUICtrlCreateEdit(StringStripWS($GET_RESPONSE, 3), 30, 55, $GUI_WIDTH - 60, $GUI_HEIGHT - 155, _
	$ES_WANTRETURN+$WS_VSCROLL+$ES_AUTOVSCROLL+$ES_READONLY)
#EndRegion Details Tab
;

GUICtrlCreateTabItem("")

$Download_Button = GUICtrlCreateButton($a_Messages[13], 5, $GUI_HEIGHT - 70, 70, 20)
GUICtrlSetState(-1, $GUI_DISABLE)
If $Download_Manager <> "" Then
	Local $DM_Name = StringRegExpReplace($Download_Manager, "^.*\\", "")
	GUICtrlSetTip(-1, StringFormat($a_Messages[14], $DM_Name))
EndIf

$Status_Label = GUICtrlCreateLabel("", 2, $GUI_HEIGHT - 38, $GUI_WIDTH - 4, 18, $SS_SIMPLE + $SS_SUNKEN)
GUICtrlSetColor(-1, 0x0000FF)
#EndRegion GUI and Main Controls
;

_Initialize_RegisterMsg()
_Reduce_App_Memory()

_CmdLine_Parser($CmdLineRaw)

GUISetState(@SW_SHOW, $Main_GUI)

While 1
	$aMsg = GUIGetMsg(1)
	Switch $aMsg[0]
		Case $GUI_EVENT_CLOSE
			QuitApp()
		Case $Check_Button
			GUIRegisterMsg($WM_ENTERMENULOOP, "WM_ENTERMENULOOP")
			Check_URL_Size_Proc()
			GUIRegisterMsg($WM_ENTERMENULOOP, "")
			_Reduce_App_Memory()
		Case $Download_Button
			GUISetState(@SW_DISABLE, $Main_GUI)
			
			Local $DM_WorkDir = StringRegExpReplace($Download_Manager, "\\[^\\]*$", "")
			Local $Read_URL_Input = GUICtrlRead($URL_Input)
			Local $sReferrer = _GetCmdLine("/Referrer=")
			
			Local $sDM_CmdLine = StringReplace($DM_CmdLine, "%l", $Read_URL_Input)
			$sDM_CmdLine = StringReplace($sDM_CmdLine, "%u", $sReferrer)
			
			If $Download_Manager <> "" Then
				_ShellExecuteEx($Download_Manager, $sDM_CmdLine, $DM_WorkDir)
			Else
				SetError(1)
			EndIf
			
			If @error Then
				Local $DM_Name = StringRegExpReplace($Download_Manager, "^.*\\", "")
				Local $Status_Data = StringFormat($a_Messages[15], $DM_Name)
				If $Download_Manager = "" Then $Status_Data = StringReplace($Status_Data, "<>", "")
				SetStatusData_Proc($Status_Data)
			EndIf
			
			GUISetState(@SW_ENABLE, $Main_GUI)
			_Reduce_App_Memory()
		Case $Options_MenuItem
			Options_Dialog()
			_Reduce_App_Memory()
		Case $About_MenuItem
			About_Box($Main_GUI, $AppName, $AppVersion)
			_Reduce_App_Memory()
	EndSwitch
WEnd

Func Get_Translation_Values($sTrans_File, $sInfoSection="Info")
	Local $iTotal_Values = 73
	Local $a_Messages[$iTotal_Values+1]
	$a_Messages[0] = $iTotal_Values
	
	#Region Translation Values
	$a_Messages[1] = "Options"
	$a_Messages[2] = "About"
	$a_Messages[3] = "URL Input"
	$a_Messages[4] = "Check"
	$a_Messages[5] = "Stop"
	$a_Messages[6] = "Main Information"
	$a_Messages[7] = "File Name:"
	$a_Messages[8] = "File Type:"
	$a_Messages[9] = "File Size:"
	$a_Messages[10] = "Last Modified:"
	$a_Messages[11] = "Response Time:"
	$a_Messages[12] = "Details..."
	$a_Messages[13] = "Download"
	$a_Messages[14] = "Download with <%s>"
	$a_Messages[15] = "Error: Can not Execute external program <%s>"
	$a_Messages[16] = "Response Details"
	$a_Messages[17] = "Options"
	$a_Messages[18] = "Time Out and User Agent"
	$a_Messages[19] = "Response Timeout [seconds]:"
	$a_Messages[20] = "User Agent:"
	$a_Messages[21] = "Download Manager:"
	$a_Messages[22] = "Select Download Manager"
	$a_Messages[23] = "Command Line:"
	$a_Messages[24] = "View Options"
	$a_Messages[25] = "On Top"
	$a_Messages[26] = "Stick to screen edges"
	$a_Messages[27] = "Stick to edges of all windows"
	$a_Messages[28] = "Stick Range:"
	$a_Messages[29] = "Integration Options"
	$a_Messages[30] = "Integrate to Opera Browser"
	$a_Messages[31] = "Integrate to Internet Explorer"
	$a_Messages[32] = "OK"
	$a_Messages[33] = "Cancel"
	$a_Messages[34] = "Select Download Manager"
	$a_Messages[35] = "Please Select Opera Dir"
	$a_Messages[36] = "Can not find Opera files (Opera.exe), please select folder with Opera Browser..."
	$a_Messages[37] = "Error!"
	$a_Messages[38] = "Attention!"
	$a_Messages[39] = "Done!"
	$a_Messages[40] = "Unable to locate Opera Profile Dir."
	$a_Messages[41] = "Please close Opera Browser before continue.."
	$a_Messages[42] = "Integration to Opera Browser completed."
	$a_Messages[43] = "Unable to locate Internet Explorer."
	$a_Messages[44] = "You should restart All Internet Explorer windows."
	$a_Messages[45] = "Integration to Internet Explorer completed."
	$a_Messages[46] = "FTP protocol: Can not get header from an FTP protocol."
	$a_Messages[47] = "Error:"
	$a_Messages[48] = "Response wait time is over"
	$a_Messages[49] = "Error Connecting to the Server (%d)"
	$a_Messages[50] = "Can not Find Server"
	$a_Messages[51] = "Checking URL..."
	$a_Messages[52] = "%s seconds"
	$a_Messages[53] = "%s Bytes"
	$a_Messages[54] = "%s KB"
	$a_Messages[55] = "%s MB"
	$a_Messages[56] = "%s GB"
	$a_Messages[57] = "%s TB"
	$a_Messages[58] = "It is necessary to restart the application, restart now?"
	$a_Messages[59] = "Web-Page"
	$a_Messages[60] = "Aborted by user."
	$a_Messages[61] = "No URL Input"
	$a_Messages[62] = "Main"
	$a_Messages[63] = "Download Resume:"
	$a_Messages[64] = "Not Supported"
	$a_Messages[65] = "Supported"
	$a_Messages[66] = "Proxy Configuration"
	$a_Messages[67] = "Use <Internet Explorer> settings"
	$a_Messages[68] = "Use direct accesss (No Proxy)"
	$a_Messages[69] = "Use specific proxy settings"
	$a_Messages[70] = "Proxy address:"
	$a_Messages[71] = "Port:"
	$a_Messages[72] = "User Name:"
	$a_Messages[73] = "Password:"
	#EndRegion Translation Values
	;
	
	If FileExists($sTrans_File) Then
		$sTranslation = IniRead($sTrans_File, $sInfoSection, "Language", "English")
		If _SectionExists($sTrans_File, "Translation_" & $sTranslation) Then
			For $i = 1 To $iTotal_Values
				$a_Messages[$i] = IniRead($sTrans_File, "Translation_" & $sTranslation, "00" & $i, $a_Messages[$i])
				$a_Messages[$i] = StringReplace($a_Messages[$i], "\n", @CRLF)
			Next
		EndIf
	EndIf
	
	Return $a_Messages
EndFunc   ;==>Get_Translation_Values

Func _Initialize_RegisterMsg()
	_InitAsClipViewer($Main_GUI, 			"WM_DRAWCLIPBOARD")
	GUIRegisterMsg($WM_LBUTTONDOWN, 		"WM_LBUTTONDOWN")
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, 	"WM_WINDOWPOSCHANGING")
	GUIRegisterMsg($WM_SYSCOMMAND, 			"WM_SYSCOMMAND")
	GUIRegisterMsg($WM_EXITSIZEMOVE,		"WM_EXITSIZEMOVE")
EndFunc   ;==>_Initialize_RegisterMsg

Func _CmdLine_Parser($sCmdLine)
	If $sMain_URL = "" Then Return
	Select
		Case StringInStr($sCmdLine, "/ToolTip=")
			$sEnableBTips_RegKey = "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced"
			$iEnableBTips = RegRead($sEnableBTips_RegKey, "EnableBalloonTips")
			
			If $iEnableBTips = 0 Then
				RegWrite($sEnableBTips_RegKey, "EnableBalloonTips", "REG_DWORD", 1)
				RestartApp_Proc($CmdLineRaw & ' /_EnableBTips_/')
			EndIf
			
			$aMPos = MouseGetPos()
			$iWaitToolTip = Number(_GetCmdLine("/ToolTip=")) * 1000
			If $iWaitToolTip < 1000 Then $iWaitToolTip = 5000
			
			ToolTip($a_Messages[51], $aMPos[0], $aMPos[1], $AppName, 1, 5)
			
			$FileSize_Bytes = Check_URL_Size_Proc()
			$FileName = GUICtrlRead($FileName_Input, 1)
			If $FileName = "N/A" Or $FileName = "" Then $FileName = GUICtrlRead($FileType_Input, 1)
			
			If Number($FileSize_Bytes) <= 0 Then
				$FileSize_Bytes = "N/A"
			Else
				$FileSize_Bytes = $a_Messages[9] & " " & _GetDisplaySize($FileSize_Bytes)
			EndIf
			
			ToolTip("[" & $FileName & "]" & @CRLF & $FileSize_Bytes, $aMPos[0], $aMPos[1], $AppName, 1, 5)
			
			If StringInStr($CmdLineRaw, "/_EnableBTips_/") Then
				RegWrite($sEnableBTips_RegKey, "EnableBalloonTips", "REG_DWORD", 0)
				EnvUpdate()
			EndIf
			
			$iWaitToolTip_Timer = TimerInit()
			$PMouse_IsPressed = 0
			
			While TimerDiff($iWaitToolTip_Timer) < $iWaitToolTip
				Sleep(100)
				
				If GUICtrlRead($Dummy_Ctrl) <> "Dummy" Then Exit
				
				While __IsPressed("01")
					Sleep(100)
					$PMouse_IsPressed = 1
					If TimerDiff($iWaitToolTip_Timer) >= $iWaitToolTip Then ExitLoop
					If GUICtrlRead($Dummy_Ctrl) <> "Dummy" Then Exit
				WEnd
				
				If $PMouse_IsPressed = 1 Then
					$PMouse_IsPressed = 0
					$hHovered_Hwnd = WindowFromPoint(MouseGetPos(0), MouseGetPos(0))
					
					If WinActive($hHovered_Hwnd) Then
						WinClose($hHovered_Hwnd)
						ExitLoop
					EndIf
				EndIf
			WEnd
		Case StringInStr($sCmdLine, "/AutoCheck")
			GUISetState()
			ControlClick($Main_GUI, "", $Check_Button)
			Return
		Case Else
			Return
	EndSelect
	QuitApp()
EndFunc   ;==>_CmdLine_Parser

Func Options_Dialog()
	Local $aParentGUI_Pos, $Options_GUI, $Response_TimeOut_Input, $UserAgent_Input
	Local $Opt_DManager = $Download_Manager
	Local $Opt_UserAgent = $HTTPUserAgent
	Local $DM_Input, $DM_Select_Button, $DM_CmdLine_Input, $OnTop_CB
	Local $StickToScreen_CB, $StickToAllWin_CB, $StickRange_Input, $StickRange_UpDown
	Local $Use_IE_Proxy_Radio, $Use_Direct_Access_Radio, $Use_Specified_Proxy_Radio
	Local $HttpProxy_Address_Input, $HttpProxy_Port_Input, $HttpProxy_UserName_Input, $HttpProxy_Password_Input
	Local $Integrate_To_Opera_Button, $Integrate_To_IE_Button
	Local $Lang_Label, $Language_Combo
	Local $OperaIconFile
	Local $OK_Button, $Cancel_Button
	
	Local $Old_AppIsOnTop = $AppIsOnTop
	Local $Old_StickRange = $StickRange
	Local $Old_StickToScreen = $StickToScreen
	Local $Old_StickToAllWin = $StickToAllWin
	
	Local $sDeff_Translation = IniRead($Config_File, "Main Prefs", "Language", "English")
	If Not _SectionExists($Config_File, "Translation_" & $sDeff_Translation) Then $sDeff_Translation = "English"
	
	GUISetState(@SW_DISABLE, $Main_GUI)
	
	$aParentGUI_Pos = WinGetPos($Main_GUI)
	$Options_GUI = GUICreate($AppName & " - " & $a_Messages[17], 380, 555, _
		$aParentGUI_Pos[0] - ((380 - $GUI_WIDTH) / 2) + 3, $aParentGUI_Pos[1] + (($GUI_HEIGHT - 565) / 2), _
		$WS_SYSMENU + $WS_CAPTION, $WS_EX_CLIENTEDGE + $WS_EX_TOOLWINDOW, $Main_GUI)
	
	GUISetBkColor($GUI_BK_COLOR)
	
	;TimeOut and User Agent
	GUICtrlCreateGroup($a_Messages[18], 5, 10, 370, 85)
	
	GUICtrlCreateLabel($a_Messages[19], 20, 34)
	$Response_TimeOut_Input = GUICtrlCreateInput(Round($Response_TimeOut / 1000, 1), 260, 30, 100, 23, _
		$ES_AUTOHSCROLL + $ES_READONLY + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateUpdown(-1, $UDS_ARROWKEYS + $UDS_ALIGNRIGHT)
	GUICtrlSetLimit(-1, 60, 1)
	
	GUICtrlCreateLabel($a_Messages[20], 20, 63)
	
	If $Opt_UserAgent <> "" And __StringIsUTF8Format($Opt_UserAgent) Then $Opt_UserAgent = __UTF8ToAnsi($Opt_UserAgent)
	$UserAgent_Input = GUICtrlCreateInput($Opt_UserAgent, 90, 60, 270, 23, _
		$ES_AUTOHSCROLL + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)
	
	;Proxy Configuration
	GUICtrlCreateGroup($a_Messages[66], 5, 95, 370, 160)
	
	$Use_IE_Proxy_Radio = GUICtrlCreateRadio($a_Messages[67], 20, 110, -1, 15)
	GUICtrlSetState(-1, $GUI_CHECKED)
	
	$Use_Direct_Access_Radio = GUICtrlCreateRadio($a_Messages[68], 20, 125, -1, 15)
	If $Use_Proxy = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$Use_Specified_Proxy_Radio = GUICtrlCreateRadio($a_Messages[69], 20, 140, -1, 15)
	If $Use_Proxy = 2 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	GUICtrlCreateLabel($a_Messages[70], 20, 160, -1, 15)
	$HttpProxy_Address_Input = GUICtrlCreateInput($HttpProxy_Address, 20, 175, 280, 22, _
		$ES_AUTOHSCROLL+$WS_BORDER, $WS_EX_CLIENTEDGE+$WS_EX_STATICEDGE)
	
	GUICtrlCreateLabel(":", 304, 177)
	GUICtrlSetFont(-1, 9, 800)
	
	GUICtrlCreateLabel($a_Messages[71], 310, 160, -1, 15)
	$HttpProxy_Port_Input = GUICtrlCreateInput($HttpProxy_Port, 310, 175, 50, 22, _
		$ES_AUTOHSCROLL+$WS_BORDER+$ES_NUMBER, $WS_EX_CLIENTEDGE+$WS_EX_STATICEDGE)
	
	GUICtrlCreateLabel($a_Messages[72], 20, 205, -1, 15)
	$HttpProxy_UserName_Input = GUICtrlCreateInput($HttpProxy_UserName, 20, 220, 140, 22, _
		$ES_AUTOHSCROLL+$WS_BORDER, $WS_EX_CLIENTEDGE+$WS_EX_STATICEDGE)
	
	GUICtrlCreateLabel($a_Messages[73], 220, 205)
	$HttpProxy_Password_Input = GUICtrlCreateInput($HttpProxy_Password, 220, 220, 140, 22, _
		$ES_AUTOHSCROLL+$WS_BORDER+$ES_PASSWORD, $WS_EX_CLIENTEDGE+$WS_EX_STATICEDGE)
	
	If $Use_Proxy <> 2 Then
		For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
			GUICtrlSetState($i, $GUI_DISABLE)
		Next
	EndIf
	
	;Download Manager
	GUICtrlCreateGroup($a_Messages[21], 5, 255, 370, 85)
	
	If $Opt_DManager <> "" And __StringIsUTF8Format($Opt_DManager) Then $Opt_DManager = __UTF8ToAnsi($Opt_DManager)
	$DM_Input = GUICtrlCreateInput($Opt_DManager, 20, 275, 315, 22, _
		$ES_AUTOHSCROLL + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)
	$DM_Select_Button = GUICtrlCreateButton("...", 338, 275, 22, 22)
	GUICtrlSetTip(-1, $a_Messages[22])
	
	GUICtrlCreateLabel($a_Messages[23], 20, 308)
	$DM_CmdLine_Input = GUICtrlCreateInput(__UTF8ToAnsi($DM_CmdLine), 130, 305, 230, 22, _
		$ES_AUTOHSCROLL + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)
	
	;View Options
	GUICtrlCreateGroup($a_Messages[24], 5, 340, 370, 90)
	
	$OnTop_CB = GUICtrlCreateCheckbox($a_Messages[25], 20, 360)
	If $AppIsOnTop = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$StickToScreen_CB = GUICtrlCreateCheckbox($a_Messages[26], 20, 380)
	If $StickToScreen = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$StickToAllWin_CB = GUICtrlCreateCheckbox($a_Messages[27], 20, 400)
	If $StickToAllWin = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	GUICtrlCreateLabel($a_Messages[28], 285, 375)
	$StickRange_Input = GUICtrlCreateInput($StickRange, 285, 395, 80, 22, _
		$ES_AUTOHSCROLL + $ES_READONLY + $WS_BORDER, $WS_EX_CLIENTEDGE + $WS_EX_STATICEDGE)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	$StickRange_UpDown = GUICtrlCreateUpdown(-1, $UDS_ARROWKEYS + $UDS_ALIGNRIGHT)
	GUICtrlSetLimit(-1, 50, 5)
	
	;Integration Options
	GUICtrlCreateGroup($a_Messages[29], 5, 430, 370, 70)
	
	GUICtrlCreateLabel($a_Messages[30], 60, 448)
	$Integrate_To_Opera_Button = GUICtrlCreateButton(" ", 20, 445, 22, 22, $BS_ICON)
	
	$OperaIconFile = _OperaGetDir() & "\Opera.exe"
	If @error Then $OperaIconFile = @AutoItExe
	GUICtrlSetImage(-1, $OperaIconFile, 0, 0)
	
	GUICtrlCreateLabel($a_Messages[31], 60, 473)
	$Integrate_To_IE_Button	= GUICtrlCreateButton(" ", 20, 470, 22, 22, $BS_ICON)
	GUICtrlSetImage(-1, @ProgramFilesDir & "\Internet Explorer\IExplore.exe", -1, 0)
	
	GUICtrlCreateLabel("", 10, 510, 360, 4, -1, $WS_EX_STATICEDGE)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	$Lang_Label = GUICtrlCreateLabel("Language:", 170, 523)
	$Language_Combo = GUICtrlCreateCombo("", 240, 520, 130, 20, $CBS_DROPDOWNLIST)
	GUICtrlSetData(-1, _Get_Translations_String($Config_File), $sDeff_Translation)
	
	$OK_Button = GUICtrlCreateButton($a_Messages[32], 20, 520, 60, 20)
	$Cancel_Button = GUICtrlCreateButton($a_Messages[33], 90, 520, 60, 20)
	
	GUISetState(@SW_SHOW, $Options_GUI)
	
	While 1
		$aOptMsg = GUIGetMsg(1)
		Switch $aOptMsg[0]
			Case $GUI_EVENT_CLOSE, $Cancel_Button
				$AppIsOnTop = $Old_AppIsOnTop
				$StickRange = $Old_StickRange
				$StickToScreen = $Old_StickToScreen
				$StickToAllWin = $Old_StickToAllWin
				WinSetOnTop($Main_GUI, "", $AppIsOnTop)
				ExitLoop
			Case $Use_IE_Proxy_Radio, $Use_Direct_Access_Radio
				For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
					_GUICtrlSetState($i, $GUI_DISABLE)
				Next
			Case $Use_Specified_Proxy_Radio
				For $i = $HttpProxy_Address_Input-1 To $HttpProxy_Password_Input
					_GUICtrlSetState($i, $GUI_ENABLE)
				Next
			Case $DM_Select_Button
				Local $Selected_DM_Path = _FileOpenDialog($a_Messages[34], "", _
					"Program Files (*.exe)|*.exe", 0, "", "", 1, $Options_GUI)
				If @error Then ContinueLoop
				
				GUICtrlSetData($DM_Input, $Selected_DM_Path)
			Case $OnTop_CB
				If GUICtrlRead($OnTop_CB) = $GUI_CHECKED Then
					$AppIsOnTop = 1
				Else
					$AppIsOnTop = 0
				EndIf
				WinSetOnTop($Main_GUI, "", $AppIsOnTop)
			Case $StickToScreen_CB
				$StickToScreen = Number((GUICtrlRead($StickToScreen_CB) - 3) < 0)
			Case $StickToAllWin_CB
				$StickToAllWin = Number((GUICtrlRead($StickToAllWin_CB) - 3) < 0)
			Case $StickRange_UpDown
				$StickRange = GUICtrlRead($StickRange_Input)
			Case $Integrate_To_Opera_Button
				Local $OperaDir = _OperaSelectFolder_Proc($a_Messages[35], $a_Messages[36], _OperaGetDir(), 0, $Options_GUI)
				If @error Then ContinueLoop
				
				Local $OperaMenuFile = _OperaGetConfigFile("Menu", $OperaDir)
				If @error Then
					_MsgBox(48, $AppName & " - " & $a_Messages[37], $a_Messages[40], $Options_GUI)
					ContinueLoop
				EndIf
				
				Local $iCheck = 0, $iError = 0
				
				While _OperaIsRuning($OperaDir)
					$iCheck = _MsgBox(49, $AppName & " - " & $a_Messages[38], $a_Messages[41], $Options_GUI)
					If $iCheck = 2 Then
						$iError = 1
						ExitLoop
					EndIf
				WEnd
				
				If $iError Then ContinueLoop
				
				Local $App_Path = __StringToUTF(@ScriptFullPath)
				
				IniWrite($OperaMenuFile, 'Link Popup Menu', '-----CFS', '')
				IniWrite($OperaMenuFile, 'Link Popup Menu', 'Item, "Check File Size"', _
					'Execute program, "' & $App_Path & '", "/URL=%l /Referrer=%u /AutoCheck",, "Attachment Archives"')
					
				IniWrite($OperaMenuFile, 'Image Popup Menu', '-----CFS', '')
				IniWrite($OperaMenuFile, 'Image Popup Menu', 'Item, "Check Image Size"', _
					'Copy Image Address,,,, "Attachment Images" & Execute program, "' & _
					$App_Path & '", "/URL=%c /Referrer=%u /AutoCheck"')
					
				IniWrite($OperaMenuFile, 'Image Link Popup Menu', '-----CFS', '')
				IniWrite($OperaMenuFile, 'Image Link Popup Menu', 'Item, "Check File Size"', _
					'Execute program, "' & $App_Path & '", "/URL=%l /Referrer=%u /AutoCheck",, "Attachment Archives"')
				IniWrite($OperaMenuFile, 'Image Link Popup Menu', 'Item, "Check Image Size"', _
					'Copy Image Address,,,, "Attachment Images" & Execute program, "' & _
					$App_Path & '", "/URL=%c /Referrer=%u /AutoCheck"')
				
				IniWrite($OperaMenuFile, 'Hotclick Popup Menu', '-----CFS', '')
				IniWrite($OperaMenuFile, 'Hotclick Popup Menu', 'Item, "Check File Size"', _
					'Execute program, "' & $App_Path & '", "/URL=%T /Referrer=%u /AutoCheck",, "Attachment Archives"')
				
				If FileGetVersion($OperaDir & "\Opera.exe") >= "9.5.9937" Then
					IniWrite($OperaMenuFile, 'Link Selection Popup Menu', '-----CFS', '')
					IniWrite($OperaMenuFile, 'Link Selection Popup Menu', 'Item, "Check File Size"', _
						'Execute program, "' & $App_Path & '", "/URL=%l /Referrer=%u /AutoCheck",, "Attachment Archives"')
				EndIf
				
				_MsgBox(64, $AppName & " - " & $a_Messages[39], $a_Messages[42], $Options_GUI)
			Case $Integrate_To_IE_Button
				Local $VBS_Html = @ProgramFilesDir & "\Internet Explorer\Plugins\CheckFileSize.htm"
				Local $hHtml = FileOpen($VBS_Html, 10)
				
				If $hHtml = -1 Then
					_MsgBox(48, $AppName & " - " & $a_Messages[37], $a_Messages[43], $Options_GUI)
					ContinueLoop
				EndIf
				
				RegWrite("HKCU\Software\Microsoft\Internet Explorer\MenuExt\Check File Size", "", "REG_SZ", $VBS_Html)
				RegWrite("HKCU\Software\Microsoft\Internet Explorer\MenuExt\Check File Size", "contexts", "REG_DWORD", 0x33)
				
				FileWrite($hHtml, _GetIEIntegrateHtml(FileGetShortName(@ScriptFullPath)))
				FileClose($hHtml)
				
				$sIERestartMsg = ""
				If ProcessExists("IExplore.exe") Then $sIERestartMsg = @LF & @LF & $a_Messages[44]
				
				_MsgBox(64, $AppName & " - " & $a_Messages[39], $a_Messages[45] & $sIERestartMsg, $Options_GUI)
			Case $Language_Combo
				If GUICtrlRead($Language_Combo) <> $sDeff_Translation Then
					GUICtrlSetColor($Lang_Label, 0xFF0000)
					GUICtrlSetData($Lang_Label, "Language*:")
				Else
					GUICtrlSetColor($Lang_Label, 0x0)
					GUICtrlSetData($Lang_Label, "Language:")
				EndIf
			Case $OK_Button
				$Response_TimeOut = Number(GUICtrlRead($Response_TimeOut_Input) * 1000)
				If Not IsNumber($Response_TimeOut) Then $Response_TimeOut = 10000
				
				$Use_Proxy = 0
				If GUICtrlRead($Use_Direct_Access_Radio) = $GUI_CHECKED Then $Use_Proxy = 1
				If GUICtrlRead($Use_Specified_Proxy_Radio) = $GUI_CHECKED Then $Use_Proxy = 2
				
				$HttpProxy_Address = GUICtrlRead($HttpProxy_Address_Input)
				$HttpProxy_Port = GUICtrlRead($HttpProxy_Port_Input)
				$HttpProxy_UserName = GUICtrlRead($HttpProxy_UserName_Input)
				$HttpProxy_Password = GUICtrlRead($HttpProxy_Password_Input)
				
				$Download_Manager = GUICtrlRead($DM_Input)
				$DM_CmdLine = GUICtrlRead($DM_CmdLine_Input)
				$HTTPUserAgent = GUICtrlRead($UserAgent_Input)
				$sTranslation = GUICtrlRead($Language_Combo)
				
				Local $Ini_Download_Manager = $Download_Manager
				Local $Ini_DM_CmdLine = $DM_CmdLine
				Local $Ini_HTTPUserAgent = $HTTPUserAgent
				Local $Ini_sTranslation = $sTranslation
				
				Opt("TCPTimeout", $Response_TimeOut)
				_SetAppProxy_Proc()
				
				IniWrite($Config_File, "Proxy Prefs", "Use Proxy", $Use_Proxy)
				IniWrite($Config_File, "Proxy Prefs", "Http Proxy Address", $HttpProxy_Address)
				IniWrite($Config_File, "Proxy Prefs", "Http Proxy Port", $HttpProxy_Port)
				IniWrite($Config_File, "Proxy Prefs", "Http Proxy Login", $HttpProxy_UserName)
				IniWrite($Config_File, "Proxy Prefs", "Http Proxy Password", $HttpProxy_Password)
				
				IniWrite($Config_File, "Window Prefs", "Window On Top", $AppIsOnTop)
				IniWrite($Config_File, "Window Prefs", "Stick To Screen", $StickToScreen)
				IniWrite($Config_File, "Window Prefs", "Stick To All", $StickToAllWin)
				IniWrite($Config_File, "Window Prefs", "Stick Range", $StickRange)
				
				IniWrite($Config_File, "Main Prefs", "Download Manager", $Ini_Download_Manager)
				IniWrite($Config_File, "Main Prefs", "DM Command Line", $Ini_DM_CmdLine)
				
				IniWrite($Config_File, "Main Prefs", "User Agent", $Ini_HTTPUserAgent)
				IniWrite($Config_File, "Main Prefs", "Response Timout", $Response_TimeOut)
				
				If $Download_Manager <> "" Then
					Local $DM_Name = StringRegExpReplace($Download_Manager, "^.*\\", "")
					GUICtrlSetTip($Download_Button, StringFormat($a_Messages[14], $DM_Name))
				EndIf
				
				If $sTranslation <> $sDeff_Translation Then
					IniWrite($Config_File, "Main Prefs", "Language", $Ini_sTranslation)
					
					$sRestart_Msg_Native = "It is necessary to restart the application, restart now?"
					$sRestart_Msg = $a_Messages[58] & @LF & @LF & $sRestart_Msg_Native
					
					If $sRestart_Msg = "" Or $sRestart_Msg_Native = $a_Messages[58] Then $sRestart_Msg = $a_Messages[58]
					
					$iAsk_Restart = _MsgBox(52, $a_Messages[38], $sRestart_Msg, $Options_GUI)
					If $iAsk_Restart = 6 Then RestartApp_Proc()
				EndIf
				
				ExitLoop
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $Main_GUI)
	GUIDelete($Options_GUI)
EndFunc   ;==>Options_Dialog

Func _OperaSelectFolder_Proc($sTitle, $sErrMsgText, $sOpDir = "", $iInputID = 0, $hWnd = 0)
	Local $sSelectOpDir, $sInitDir = $sOpDir
	
	While 1
		$sSelectOpDir = _FileSelectFolder($sTitle, 0, _
			BitOR($BIF_NEWDIALOGSTYLE, $BIF_NONEWFOLDERBUTTON, $BIF_RETURNONLYFSDIRS, $BIF_EDITBOX), $sInitDir, $hWnd)
		If @error Then Return SetError(1, 0, $sOpDir)
		
		If Not __PathIsOperaDir($sSelectOpDir) Then
			_MsgBox(48, "Attention", $sErrMsgText, $hWnd)
			$sInitDir = $sSelectOpDir
			ContinueLoop
		EndIf
		
		If $iInputID > 0 Then GUICtrlSetData($iInputID, $sSelectOpDir)
		Return $sSelectOpDir
	WEnd
EndFunc   ;==>_OperaSelectFolder_Proc

Func SetStatusData_Proc($sData = "", $iStatusExp = 5000)
	$iStatusExpire = $iStatusExp
	$nStatusExp_Timer = TimerInit()
	GUICtrlSetData($Status_Label, $sData)
	_AdlibEnable("CheckStatusExpire_Proc", 100, $Main_GUI)
EndFunc   ;==>SetStatusData_Proc

Func CheckStatusExpire_Proc()
	If $nStatusExp_Timer <> -1 And TimerDiff($nStatusExp_Timer) >= $iStatusExpire Then
		_AdlibDisable($Main_GUI)
		$nStatusExp_Timer = -1
		GUICtrlSetData($Status_Label, "")
	EndIf
EndFunc   ;==>CheckStatusExpire_Proc

Func Check_URL_Size_Proc()
	Local $Read_URL_Input = GUICtrlRead($URL_Input)
	
	If $Read_URL_Input = "" Then
		SetStatusData_Proc($a_Messages[61])
		Return
	EndIf
	
	$Read_URL_Input = _CorrectURL($Read_URL_Input)
	
	_AdlibDisable($Main_GUI)
	$nStatusExp_Timer = -1
	Local $iDownload_Button_State = GUICtrlGetState($Download_Button)
	GUICtrlSetData($Status_Label, $a_Messages[51])
	
	GUICtrlSetData($URL_Input, $Read_URL_Input)
	GUICtrlSendMsg($URL_Input, $EM_SETSEL, 0, 0)
	
	GUICtrlSetState($Options_MenuItem, $GUI_DISABLE)
	GUICtrlSetState($About_MenuItem, $GUI_DISABLE)
	GUICtrlSetState($URL_Input, $GUI_DISABLE)
	GUICtrlSetState($Download_Button, $GUI_DISABLE)
	
	Opt("GuiOnEventMode", 1)
	GUICtrlSetData($Check_Button, $a_Messages[5])
	GUICtrlSetOnEvent($Check_Button, "Check_Stop_Event")
	
	Local $Check_Response = Response_Parser($Read_URL_Input)
	
	If $TCP_Aborted Then
		$TCP_Aborted = False
		$GET_RESPONSE = $a_Messages[60]
		
		GUICtrlSetState($Options_MenuItem, $GUI_ENABLE)
		GUICtrlSetState($About_MenuItem, $GUI_ENABLE)
		GUICtrlSetState($URL_Input, $GUI_ENABLE)
		
		If BitAND($iDownload_Button_State, $GUI_ENABLE) Then GUICtrlSetState($Download_Button, $GUI_ENABLE)
		
		Opt("GuiOnEventMode", 0)
		GUICtrlSetData($Response_Edit, $GET_RESPONSE)
		GUICtrlSetData($Check_Button, $a_Messages[4])
		GUICtrlSetData($Status_Label, "")
		Return
	EndIf
	
	$GET_RESPONSE = $Check_Response[0]
	Local $sDownload_Resume = $a_Messages[64]
	Local $Response_Time = $Check_Response[1]
	Local $sHost = $Check_Response[2]
	Local $sPage = $Check_Response[3]
	
	If IsNumber($Response_Time) Then $Response_Time = StringFormat($a_Messages[52], Round($Response_Time / 1000, 2))
	
	If StringInStr($GET_RESPONSE, "HTTP/1.1 206 Partial Content") Or _
		StringInStr($GET_RESPONSE, "Accept-Ranges:") Then $sDownload_Resume = $a_Messages[65]
	
	Local $FileName = StringRegExpReplace(_HexURLToString($sPage), "^.*/|[\?&;=\^%@#!/;'<>].*$", "")
	If $FileName = "" Then $FileName = "N/A"
	
	If StringInStr($GET_RESPONSE, 'filename="') Then $FileName = StringStripWS(_GetMidleString($GET_RESPONSE, 'filename="', '"'), 3)
	
	Local $FileType = _GetFileType($FileName)
	If $FileType = "N/A" And _
		StringRegExp($GET_RESPONSE, "(?i)Content-Type:.*(html|xml|shtml|dhtml)") Then $FileType = $a_Messages[59]
	
	Local $FileSize_Bytes = Number(_GetMidleString($GET_RESPONSE, "Content-Length: ", "(\n|$)"))
	
	If $FileSize_Bytes = 0 And StringInStr($GET_RESPONSE, "Location: ") Then
		$FileSize_Bytes = InetGetSize(StringStripWS(_GetMidleString($GET_RESPONSE, "Location: ", "(\n|$)"), 3))
		$sDownload_Resume = "N/A"
	EndIf
	
	Local $FileSize_KBytes = Round($FileSize_Bytes / 1024, 2)
	Local $FileSize_MBytes = Round($FileSize_KBytes / 1024, 2)
	
	Local $Last_Modified = _GetMidleString($GET_RESPONSE, "Last-Modified: ", "(\n|$)")
	If $Last_Modified = "" Then $Last_Modified = "N/A"
	
	GUICtrlSetData($FileName_Input, $FileName)
	GUICtrlSetData($FileType_Input, $FileType)
	GUICtrlSetData($FileSize_Bytes_Input, StringFormat($a_Messages[53], $FileSize_Bytes))
	GUICtrlSetData($FileSize_KBytes_Input, StringFormat($a_Messages[54], $FileSize_KBytes))
	GUICtrlSetData($FileSize_MBytes_Input, StringFormat($a_Messages[55], $FileSize_MBytes))
	GUICtrlSetData($Last_Modified_Input, StringStripWS($Last_Modified, 3))
	GUICtrlSetData($ResponseTime_Input, $Response_Time)
	GUICtrlSetData($DownloadResume_Input, $sDownload_Resume)
	GUICtrlSetData($Response_Edit, $GET_RESPONSE)
	
	GUICtrlSetState($Options_MenuItem, $GUI_ENABLE)
	GUICtrlSetState($About_MenuItem, $GUI_ENABLE)
	GUICtrlSetState($URL_Input, $GUI_ENABLE)
	GUICtrlSetState($Download_Button, $GUI_ENABLE)
	
	Opt("GuiOnEventMode", 0)
	GUICtrlSetData($Check_Button, $a_Messages[4])
	
	Return $FileSize_Bytes
EndFunc   ;==>Check_URL_Size_Proc

Func Check_Stop_Event()
	_HTTPClose()
	$TCP_Aborted = True
EndFunc   ;==>Check_Close_Event

Func ClickHandler_Proc($CtrlID, $URL, $hWnd, $SetCtrlID = -1)
	Local $GetCurInfo = GUIGetCursorInfo($hWnd)
	While $GetCurInfo[2] = 1
		$GetCurInfo = GUIGetCursorInfo($hWnd)
		Sleep(10)
	WEnd
	If $GetCurInfo[4] = $CtrlID Or ($SetCtrlID <> -1 And $GetCurInfo[4] = $SetCtrlID) Then ShellExecute($URL)
EndFunc   ;==>ClickHandler_Proc

Func Response_Parser($sURL)
	Local $sURI_Referrer = _GetCmdLine("/Referrer=")
	If $sURI_Referrer = "" Then $sURI_Referrer = StringRegExpReplace($sURL, "/[^/]*$", "")
	
	Local $aHostPage = _GetHostAndPage($sURL)
	Local $iTimer = TimerInit()
	Local $iLocationCount = 0
	Local $iCheckErr = 0
	Local $Response_Time = 0
	Local $Check_Response = ""
	
	If StringLeft($sURL, 3) = "ftp" Then
		Local $FileSize_Bytes = InetGetSize($sURL)
		$Check_Response = $a_Messages[46]
		If $FileSize_Bytes > 0 Then $Check_Response &= @CRLF & "Content-Length: " & $FileSize_Bytes
		
		GUICtrlSetData($Status_Label, "")
		
		Local $aRet[4] = [$Check_Response, TimerDiff($iTimer), $aHostPage[0], $aHostPage[1]]
		Return $aRet
	EndIf
	
	$Check_Response = _HTTPGetResponse($aHostPage[0], $aHostPage[1], "HEAD", $sURI_Referrer)
	$iCheckErr = @error
	
	If StringRegExp($Check_Response, "(?i)Content-Type:(.*?)html") Then
		$Check_Response = _HTTPGetResponse($aHostPage[0], $aHostPage[1], "GET", $sURI_Referrer)
		$iCheckErr = @error
	EndIf
	
	If StringInStr($Check_Response, @CRLF & @CRLF) Then
		Local $sMetaRedirect_URL = ""
		
		If StringRegExp($Check_Response, '(?i)(?s).*<meta.*="Refresh" content="\d+; URL=.*"') Then
			$sMetaRedirect_URL = StringRegExpReplace($Check_Response, _
				'(?i)(?s).*<meta.*?="Refresh" content="\d+; URL=(.*)".*', '\1')
			
			If $sMetaRedirect_URL <> "" And $sMetaRedirect_URL <> $Check_Response Then
				$aHostPage = _GetHostAndPage($sMetaRedirect_URL)
				$Check_Response = _HTTPGetResponse($aHostPage[0], $aHostPage[1], "HEAD", $sURI_Referrer)
				GUICtrlSetData($URL_Input, $sMetaRedirect_URL)
			EndIf
		EndIf
		
		$Check_Response = StringRegExpReplace($Check_Response, "(?i)(?s)" & @CRLF & @CRLF & ".*$", "")
	EndIf
	
	For $i = 1 To 2
		If StringInStr($Check_Response, "Location:") Then
			Local $sNewLocation = StringStripWS(_GetMidleString($Check_Response, "Location: ", "(\n|$)"), 3)
			
			If $sNewLocation <> "" Then
				$sNewLocation = StringReplace($sNewLocation, " ", "%20")
				If StringLeft($sNewLocation, 1) = "/" Then $sNewLocation = $aHostPage[0] & $sNewLocation
				
				GUICtrlSetData($URL_Input, $sNewLocation)
				GUICtrlSendMsg($URL_Input, $EM_SETSEL, 0, 0)
				
				$aHostPage = _GetHostAndPage($sNewLocation)
				
				If StringRegExp($aHostPage[0], ":\d+$") Then
					$HTTP_TCP_Port = Number(StringRegExpReplace($aHostPage[0], ".*?:", ""))
					$aHostPage[0] = StringLeft($aHostPage[0], StringInStr($aHostPage[0], ":")-1)
				EndIf
				
				$Check_Response_Tmp = _HTTPGetResponse($aHostPage[0], $aHostPage[1], "HEAD", $sURI_Referrer)
				$iCheckErr = @error
		
				If StringLeft($Check_Response_Tmp, 6) <> "<html>" And Not $iCheckErr Then $Check_Response = $Check_Response_Tmp
			EndIf
		EndIf
	Next
	
	$HTTP_TCP_Port = $HTTP_TCP_Def_Port
	
	$Response_Time = TimerDiff($iTimer)
	
	If StringInStr($Check_Response, @CRLF & @CRLF) Then _
		$Check_Response = StringRegExpReplace($Check_Response, "(?i)(?s)" & @CRLF & @CRLF & ".*", "")
	
	If Not StringRegExp($Check_Response, "(?i)HTTP/[0-9.]+ [0-9]+ (OK|Found)") Then
		If StringInStr($Check_Response, "400 Bad Request") Then
			$Check_Response = "HTTP/1.1 400 Bad Request"
			$aHostPage[1] = $a_Messages[47] & " 400 Bad Request"
		ElseIf StringInStr($Check_Response, "403 Forbidden") Then
			$Check_Response = "HTTP/1.1 403 Forbidden"
			$aHostPage[1] = $a_Messages[47] & " 403 Forbidden"
		ElseIf StringInStr($Check_Response, "404 Not Found") Then
			$Check_Response = "HTTP/1.1 404 Not Found"
			$aHostPage[1] = $a_Messages[47] & " 404 Not Found"
		ElseIf $Response_TimeOutOver Then
			$Response_TimeOutOver = False
			$Check_Response = $a_Messages[48]
			$Response_Time = "N/A"
		ElseIf $iCheckErr Then
			$Check_Response = StringFormat($a_Messages[49], $iCheckErr)
			$Response_Time = "N/A"
		Else
			$Check_Response = $a_Messages[50]
			$aHostPage[1] = ""
		EndIf
		SetStatusData_Proc($Check_Response)
	Else
		GUICtrlSetData($Status_Label, "")
	EndIf
	
	$Check_Response = StringStripWS($Check_Response, 3)
	$aHostPage[0] = StringStripWS($aHostPage[0], 3)
	$aHostPage[1] = StringStripWS($aHostPage[1], 3)
	
	Local $aRet[4] = [$Check_Response, $Response_Time, $aHostPage[0], $aHostPage[1]]
	Return $aRet
EndFunc   ;==>Response_Parser

Func _Get_Translations_String($sTrans_File)
	Local $aReadSectNames = IniReadSectionNames($sTrans_File)
	Local $sRet_String = ""
	
	For $i = 1 To UBound($aReadSectNames)-1
		If StringRegExp($aReadSectNames[$i], "(?i)\ATranslation_.*$") Then
			$sRet_String &= __UTF8ToAnsi(StringTrimLeft($aReadSectNames[$i], 12)) & "|"
		EndIf
	Next
	
	If $sRet_String = "" Then $sRet_String = "English"
	
	Return _StringStripChars($sRet_String, "|", 2)
EndFunc   ;==>_Get_Translations_String

Func _GetHostAndPage($sURL)
	Local $aHostPage[2]
	
	$aHostPage[0] = StringRegExpReplace($sURL, "\A.*?//", "")
	$aHostPage[0] = _GetMidleString($aHostPage[0], "\A", "/|.*")
	$aHostPage[0] = StringRegExpReplace($aHostPage[0], "/+$", "")
	
	$aHostPage[1] = _GetMidleString($sURL, $aHostPage[0], "$")
	If StringLeft($aHostPage[1], 1) <> "/" Then $aHostPage[1] = "/" & $aHostPage[1]
	
	$aHostPage[0] = StringStripWS($aHostPage[0], 3)
	$aHostPage[1] = StringStripWS($aHostPage[1], 3)
	
	Return $aHostPage
EndFunc   ;==>_GetHostAndPage

Func _GetMidleString($sString, $sStart, $sEnd, $iCase = -1, $iRetType = 0)
	Local $iCaseSence = ''
	If $iCase = -1 Then $iCaseSence = '(?i)'
	
	Local $aArray = StringRegExp($sString, '(?s)' & $iCaseSence & $sStart & '(.*?)' & $sEnd, 3)
	Local $IsArrayCheck = IsArray($aArray)
	
	If $IsArrayCheck And $iRetType = 1 Then Return $aArray
	
	If $IsArrayCheck Then Return $aArray[0]
	Return SetError(1, 0, "")
EndFunc   ;==>_GetMidleString

Func _GetCmdLine($sArgument)
	If $CmdLine[0] = 0 Then Return SetError(1, 0, "")
	If Not StringInStr($CmdLineRaw, $sArgument) Then Return SetError(2, 0, "")
	
	Local $RetCmd = StringRegExp($CmdLineRaw, '(?i)' & $sArgument & '(.*?)\s', 3)
	If Not IsArray($RetCmd) Or $RetCmd[0] = '' Then $RetCmd = StringRegExp($CmdLineRaw, '(?i)' & $sArgument & '(.*?)$', 3)
	If IsArray($RetCmd) Then $RetCmd = $RetCmd[0]
	$RetCmd = StringStripWS($RetCmd, 3)
	Return $RetCmd
EndFunc   ;==>_GetCmdLine

Func _GetDisplaySize($iSize, $iPlaces = 1)
	Local $aBytes[5] = [$a_Messages[53], $a_Messages[54], $a_Messages[55], $a_Messages[56], $a_Messages[57]]
	For $i = 4 To 1 Step - 1
		If $iSize >= 1024 ^ $i Then
			Return StringFormat($aBytes[$i], Round($iSize / 1024 ^ $i, $iPlaces))
		EndIf
	Next
	Return StringFormat($a_Messages[53], $iSize)
EndFunc   ;==>_GetDisplaySize

Func _GetFileType($sFile)
	Local $sRegDefault = "", $sRegType = "N/A"
	
	Local $sExt = StringRegExpReplace($sFile, "^.*\.", "")
	Local $sRegDefault = RegRead("HKCR\." & $sExt, "")
	If $sRegDefault <> "" Then $sRegType = RegRead("HKCR\" & $sRegDefault, "")
	
	Return $sRegType
EndFunc   ;==>_GetFileType

Func _GetIEIntegrateHtml($App_Path)
	$sRet_Html = '<SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript1.2">' & @CRLF & @CRLF
	
	$sRet_Html &= 'var CFSEvent = external.menuArguments.event;' & @CRLF
	$sRet_Html &= 'var CFSDoc = external.menuArguments.document;' & @CRLF & @CRLF
	
	$sRet_Html &= 'var CFSElement = CFSDoc.elementFromPoint(CFSEvent.clientX, CFSEvent.clientY);' & @CRLF
	$sRet_Html &= 'var CFSAnchor = CFSElement;' & @CRLF
	$sRet_Html &= 'var URL = "";' & @CRLF
	$sRet_Html &= 'var sText = "";' & @CRLF & @CRLF
	
	$sRet_Html &= 'while(CFSAnchor.tagName!="HTML" && CFSAnchor.tagName!="A" && CFSAnchor.tagName!="AREA")' & @CRLF
	$sRet_Html &= '	{' & @CRLF
	$sRet_Html &= '		CFSAnchor=CFSAnchor.parentElement;' & @CRLF
	$sRet_Html &= '	}' & @CRLF & @CRLF
	
	$sRet_Html &= 'if(CFSEvent.type=="MenuExtUnknown" || CFSEvent.type=="MenuExtImage" || CFSEvent.type=="MenuExtAnchor")' & @CRLF
	$sRet_Html &= '	{' & @CRLF & @CRLF
	
	$sRet_Html &= '		var oSelect = CFSDoc.selection;' & @CRLF
	$sRet_Html &= '		var oSelectRange = oSelect.createRange();' & @CRLF
	$sRet_Html &= '		sText = oSelectRange.text;' & @CRLF & @CRLF
	
	$sRet_Html &= '		if(CFSAnchor.tagName=="A" || CFSAnchor.tagName=="AREA") {URL = CFSAnchor.href;}' & @CRLF
	$sRet_Html &= '		if(CFSElement.tagName=="IMG" && CFSAnchor.tagName=="HTML") {URL = CFSElement.src;}' & @CRLF & @CRLF
	
	$sRet_Html &= '		if(sText!="" && URL=="") {URL = sText;}' & @CRLF
	$sRet_Html &= '	}' & @CRLF & @CRLF
	
	$sRet_Html &= 'if(URL!="")' & @CRLF
	$sRet_Html &= '	{' & @CRLF
	$sRet_Html &= '		var referrerURL = external.menuArguments.document.URL;' & @CRLF
	$sRet_Html &= '	}' & @CRLF
	$sRet_Html &= '</SCRIPT>' & @CRLF & @CRLF
	
	$sRet_Html &= '<SCRIPT LANGUAGE="VBScript">' & @CRLF
	$sRet_Html &= '	Set oCheckFSize = CreateObject("WScript.Shell")' & @CRLF
	$sRet_Html &= '	oCheckFSize.Run ("' & $App_Path & ' /URL=" & URL & " /AutoCheck /Referrer=" & referrerURL)' & @CRLF
	$sRet_Html &= '</SCRIPT>' & @CRLF
	Return $sRet_Html
EndFunc   ;==>_GetIEIntegrateHtml

Func _CorrectURL($sURL)
	If StringRight($sURL, 3) = "://" Then Return $sURL
	
	Local $sOriginal_URL = $sURL
	$sURL = StringRegExpReplace($sURL, '(?i)\A[^a-z\d]+|[^a-z\d]+$', "")
	
	Local $sURL_Hold = StringRegExpReplace($sURL, "(?i)(\A.*?(/|\\|:)+[^a-z\d]+|[^a-z\d]+$)", "")
	$sURL_Hold = StringReplace(StringReplace($sURL_Hold, " ", "%20"), "\", "/")
	
	If StringLeft($sURL, 4) = "ftp." Then Return "ftp://" & $sURL_Hold
	
	Local $sProtocol = StringRegExpReplace($sURL, "\A.*?(.{1,5}:/).*", "\1/")
	
	If StringLen($sProtocol) <= 5 Then
		If $sProtocol = StringLeft($sOriginal_URL, StringLen($sProtocol)) = $sProtocol Then Return "http://"
		Return "http://" & $sURL_Hold
	EndIf
	
	$sProtocol = StringRegExpReplace($sProtocol, "(?i)\A(h..p|h..|h.tp|ht..|..tp|.ttp|[-]{1,4})://+", "http://", 1)
	If @extended > 0 Then Return $sProtocol & $sURL_Hold
	
	$sProtocol = StringRegExpReplace($sProtocol, "(?i)\A(f.p|f.|f..|.tp|[-]{1,3})://+", "ftp://", 1)
	If @extended > 0 Then Return $sProtocol & $sURL_Hold
	
	$sProtocol = StringRegExpReplace($sProtocol, "(?i)\A(h..ps|..tps|.t.ps|[-]{1,5})://+", "https://")
	If @extended > 0 Then Return $sProtocol & $sURL_Hold
	
	If Not _StringIsURL($sProtocol) Then $sProtocol = "http://"
	
	Return $sProtocol & $sURL_Hold
EndFunc   ;==>_CorrectURL

Func _EncodeURL($sURL)
	Local $BinaryString = StringReplace(StringToBinary($sURL, 4), '0x', '', 1)
	Local $UniBinLen = StringLen($BinaryString)
	Local $EncodedString, $UniBinChar
	
	For $i = 1 To $UniBinLen Step 2
		$UniBinChar = StringMid($BinaryString, $i, 2)
		If StringRegExp(BinaryToString('0x' & $UniBinChar, 4), '(?i)[a-z0-9]|-|_|\.|^/') Then
			$EncodedString &= BinaryToString('0x' & $UniBinChar)
		Else
			$EncodedString &= '%' & $UniBinChar
		EndIf
	Next
	Return $EncodedString
EndFunc   ;==>_EncodeURL

Func _HexURLToString($URLHex)
	Local $StrArray = StringSplit($URLHex, "")
	Local $RetString = "", $iDec
	Local $Ubound = UBound($StrArray)
	
	For $i = 1 To $Ubound-1
		If $StrArray[$i] = "%" And $i+2 <= $Ubound-1 Then
			$i += 2
			$iDec = Dec($StrArray[$i-1] & $StrArray[$i])
			If Not @error Then
				$RetString &= Chr($iDec)
			Else
				$RetString &= $StrArray[$i-2]
			EndIf
		Else
			$RetString &= $StrArray[$i]
		EndIf
	Next
	Return $RetString
EndFunc   ;==>_HexURLToString

Func _StringIsURL($sString)
	Return StringRegExp($sString, "(?i)\A(http|https|ftp)://+")
EndFunc   ;==>_StringIsURL

Func _StringStripChars($String, $SubString, $Flag = 0, $Count = 0)
	If StringLen($String) = 0 Then Return SetError(1, 0, $String)
	
	Local $GroupChar_a = '(', $GroupChar_b = ')'
	If $Count < 0 Then Local $GroupChar_a = '[', $GroupChar_b = ']'
	
	$SubString = StringRegExpReplace($SubString, '([][{}()|.?+*\\^])', '\\\1')
	Local $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b, $sCnt = '{1,' & $Count & '}'
	
	If $Count <= 0 Then $sCnt = '+'
	If $Flag <> 0 Then $Count = 0
	If $Flag = 1 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt
	If $Flag = 2 Then $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	If $Flag = 3 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '|' & _
		$GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	Return StringRegExpReplace($String, $Pattern, '', $Count)
EndFunc   ;==>_StringStripChars

Func _ShellExecuteEx($sCmd, $Args = "", $sFolder = "", $Verb = "", $rState = @SW_SHOWNORMAL, $hWnd = 0)
	Local $struINFO = DllStructCreate("long;long;long;ptr;ptr;ptr;ptr;long;long;long;ptr;long;long;long;long")
	Local $struVerb = DllStructCreate("char[15];char")
	Local $struPath = DllStructCreate("char[255];char")
	Local $struArgs = DllStructCreate("char[255];char")
	Local $struWDir = DllStructCreate("char[255];char")
	
	DllStructSetData($struVerb, 1, $Verb)
	If StringRight($sCmd, 3) = "lnk" Then
		Local $aShortcutInfo = FileGetShortcut($sCmd)
		If IsArray($aShortcutInfo) Then
			DllStructSetData($struPath, 1, $aShortcutInfo[0])
			DllStructSetData($struWDir, 1, $aShortcutInfo[1])
			DllStructSetData($struArgs, 1, $aShortcutInfo[2])
			$rState = $aShortcutInfo[6]
		Else
			Return 0
		EndIf
	Else
		DllStructSetData($struPath, 1, $sCmd)
		DllStructSetData($struWDir, 1, $sFolder)
		DllStructSetData($struArgs, 1, $Args)
	EndIf

	DllStructSetData($struINFO, 1, DllStructGetSize($struINFO))
	DllStructSetData($struINFO, 2, BitOR(0xC, 0x40, 0x400))
	DllStructSetData($struINFO, 3, $hWnd)
	DllStructSetData($struINFO, 4, DllStructGetPtr($struVerb))
	DllStructSetData($struINFO, 5, DllStructGetPtr($struPath))
	DllStructSetData($struINFO, 6, DllStructGetPtr($struArgs))
	DllStructSetData($struINFO, 7, DllStructGetPtr($struWDir))
	DllStructSetData($struINFO, 8, $rState)

	Local $iRet = DllCall("shell32.dll", "int", "ShellExecuteEx", "ptr", DllStructGetPtr($struINFO))
	If Not IsArray($iRet) Or $iRet[0] <= 0 Then Return SetError(1, 0, 0)
	Return $iRet[0]
EndFunc   ;==>_ShellExecuteEx

Func _SectionExists($sIniFile, $sSectName)
	If FileExists($sIniFile) Then
		Local $aSectNames = IniReadSectionNames($sIniFile)
		If @error Then Return False
		
		For $i = 1 To $aSectNames[0]
			If $aSectNames[$i] = $sSectName Then Return True
		Next
	EndIf
	Return False
EndFunc   ;==>_SectionExists

Func _WinIsVisible($sTitle)
	Return BitAND(WinGetState($sTitle), 2)
EndFunc   ;==>_WinIsVisible

Func _AppWinIsVisible($sApp_Title)
	Local $aAppWinList = WinList($sApp_Title)
	For $i = 1 To UBound($aAppWinList)-1
		If _WinIsVisible($aAppWinList[$i][1]) Then Return $aAppWinList[$i][1]
	Next
	Return False
EndFunc   ;==>_AppWinIsVisible

Func _AppWinIsUnVisible($sApp_Title)
	Local $aAppWinList = WinList($sApp_Title)
	For $i = 1 To UBound($aAppWinList)-1
		If Not _WinIsVisible($aAppWinList[$i][1]) Then Return $aAppWinList[$i][1]
	Next
	Return False
EndFunc   ;==>_AppWinIsUnVisible

Func _AdlibEnable($sFunction, $iTime = 250, $hWnd = 0)
	Local Const $WM_TIMER = 0x0113
	If Not IsHWnd($hWnd) Then $hWnd = GUICreate("hCallBack_AdlibEnable")
	GUIRegisterMsg($WM_TIMER, $sFunction)
	Local $aRet = DllCall("User32.dll", "int", "SetTimer", "hwnd", $hWnd, "int", 50, "int", $iTime, "int", 0)
	Return $hWnd
EndFunc   ;==>_AdlibEnable

Func _AdlibDisable($hWnd = 0)
	Local Const $WM_TIMER = 0x0113
	GUIRegisterMsg($WM_TIMER, "")
	Local $aRet = DllCall("user32.dll", "int", "KillTimer", "hwnd", $hWnd, "int_ptr", 50)
	Return Number(IsArray($aRet) And $aRet[0])
EndFunc   ;==>_AdlibDisable

Func _FileOpenDialog($sTitle, $sInitDir, $sFilter='All (*.*)|*.*', $iOpt=0, $sDefFile='', $sDefExt='', $iDefFilter=1, $hwnd=0)
	Local $iFileLen = 65536 ; Max chars in returned string
	
	; API flags prepare
	Local $iFlag = BitOR( _
		BitShift(BitAND($iOpt, 1), -12), BitShift(BitAND($iOpt, 2), -10), BitShift(BitAND($iOpt, 4), -7), _
		BitShift(BitAND($iOpt, 8), -10), BitShift(BitAND($iOpt, 4), -17))
	
	; Filter string to array convertion
	If Not StringInStr($sFilter, '|') Then $sFilter &= '|*.*'
	$sFilter = StringRegExpReplace($sFilter, '|+', '|')
	
	Local $asFLines = StringSplit($sFilter, '|')
	Local $i, $suFilter = ''

	For $i = 1 To $asFLines[0] Step 2
		If $i < $asFLines[0] Then _
			$suFilter &= 'wchar[' & StringLen($asFLines[$i]) + 1 & '];wchar[' & StringLen($asFLines[$i + 1]) + 1 & '];'
	Next
	
	; Create API structures
	Local $uOFN = DllStructCreate('dword;int;int;ptr;ptr;dword;dword;ptr;dword' & _
		';ptr;int;ptr;ptr;dword;short;short;ptr;ptr;ptr;ptr;ptr;dword;dword')
	Local $usTitle = DllStructCreate('wchar[' & StringLen($sTitle) + 1 & ']')
	Local $usInitDir = DllStructCreate('wchar[' & StringLen($sInitDir) + 1 & ']')
	Local $usFilter = DllStructCreate($suFilter & 'wchar')
	Local $usFile = DllStructCreate('wchar[' & $iFileLen & ']')
	Local $usExtn = DllStructCreate('wchar[' & StringLen($sDefExt) + 1 & ']')
	
	For $i = 1 To $asFLines[0]
		DllStructSetData($usFilter, $i, $asFLines[$i])
	Next
	
	; Set Data of API structures
	DllStructSetData($usTitle, 1, $sTitle)
	DllStructSetData($usInitDir, 1, $sInitDir)
	DllStructSetData($usFile, 1, $sDefFile)
	DllStructSetData($usExtn, 1, $sDefExt)
	DllStructSetData($uOFN, 1, DllStructGetSize($uOFN))
	DllStructSetData($uOFN, 2, $hwnd)
	DllStructSetData($uOFN, 4, DllStructGetPtr($usFilter))
	DllStructSetData($uOFN, 7, $iDefFilter)
	DllStructSetData($uOFN, 8, DllStructGetPtr($usFile))
	DllStructSetData($uOFN, 9, $iFileLen)
	DllStructSetData($uOFN, 12, DllStructGetPtr($usInitDir))
	DllStructSetData($uOFN, 13, DllStructGetPtr($usTitle))
	DllStructSetData($uOFN, 14, $iFlag)
	DllStructSetData($uOFN, 17, DllStructGetPtr($usExtn))
	DllStructSetData($uOFN, 23, BitShift(BitAND($iOpt, 32), 5))
	
	; Call API function
	Local $aRet = DllCall('comdlg32.dll', 'int', 'GetOpenFileNameW', 'ptr', DllStructGetPtr($uOFN))
	If Not IsArray($aRet) Or Not $aRet[0] Then Return SetError(1, 0, "")
	
	If BitAND($iOpt, 4) Then
		$i = 1
		
		While 1
			If Binary(DllStructGetData($usFile, 1, $i)) = 0 Then
				If Binary(DllStructGetData($usFile, 1, $i + 1)) = 0 Then ExitLoop
				DllStructSetData($usFile, 1, '|', $i)
			EndIf
			
			$i += 1
		WEnd
	EndIf
	
	Local $sRet = StringStripWS(DllStructGetData($usFile, 1), 3)
	Return SetExtended(DllStructGetData($uOFN, 7), $sRet)
EndFunc   ;==>_FileOpenDialog

Func _MsgBox($sMsgBoxType, $sMsgBoxTitle, $sMsgBoxText, $hWnd)
	Local $aRet = DllCall ("user32.dll", "int", "MessageBoxW", _
			"hwnd", $hWnd, _
			"wstr", $sMsgBoxText , _
			"wstr", $sMsgBoxTitle, _
			"int", $sMsgBoxType)
	Return $aRet[0]
EndFunc   ;==>_MsgBox

Func __IsPressed($sHexKey)
	Local $a_R = DllCall("user32.dll", "int", "GetAsyncKeyState", "int", '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc  ;==>__IsPressed

Func _GUICtrlSetState($iCtrlID, $iState)
	If Not BitAND(GUICtrlGetState($iCtrlID), $iState) Then GUICtrlSetState($iCtrlID, $iState)
EndFunc  ;==>_GUICtrlSetState

Func _GUICtrlTabSetBkColor($hWnd, $hSysTab32, $sBkColor)
    ;Disabled Label to hold the color
    Local $aTabPos = ControlGetPos($hWnd, "", $hSysTab32)
    
    GUICtrlCreateLabel("", $aTabPos[0]+2, $aTabPos[1]+23, $aTabPos[2]-5, $aTabPos[3]-26)
    GUICtrlSetState(-1, $GUI_DISABLE)
    GUICtrlSetBkColor(-1, $sBkColor)
EndFunc  ;==>_GUICtrlTabSetBkColor

Func WM_ENTERMENULOOP($hWndGUI, $MsgID, $WParam, $LParam)
	ControlClick($Main_GUI, "", $Dummy_Ctrl)
EndFunc   ;==>WM_ENTERMENULOOP

Func WM_DRAWCLIPBOARD($hWndGUI, $MsgID, $wParam, $lParam)
	Switch $MsgID
		Case $WM_DRAWCLIPBOARD
			Local $sClipBoard_Content = ClipGet()
			
			If GUICtrlRead($URL_Input) = "" And _StringIsURL($sClipBoard_Content) Then
				GUICtrlSetData($URL_Input, $sClipBoard_Content)
				GUICtrlSendMsg($URL_Input, $EM_SETSEL, 0, 0)
			EndIf
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc   ;==>ClipBoard_Proc

Func WM_LBUTTONDOWN($hWnd, $iMsg, $wParam, $lParam)
	If BitAND(WinGetState($hWnd), 32) Then Return $GUI_RUNDEFMSG
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $hWnd, "int", $WM_SYSCOMMAND, "int", 0xF009, "int", 0)
EndFunc   ;==>WM_LBUTTONDOWN

Func WM_WINDOWPOSCHANGING($hWnd, $Msg, $wParam, $lParam)
	If $StickToScreen = 0 And $StickToAllWin = 0 Then Return $GUI_RUNDEFMSG
	
	Local $stWinPos 		= DllStructCreate("uint;uint;int;int;int;int;uint", $lParam)
	Local $nLeft 			= DllStructGetData($stWinPos, 3)
	Local $nTop 			= DllStructGetData($stWinPos, 4)
	
	Local $aCurWinPos 		= WinGetPos($hWnd)
	Local $aWorkArea 		= _GetWorkingArea()
	
	If $StickToScreen = 1 Then
		;Left
		If Abs($aWorkArea[0] - $nLeft) <= $StickRange Then DllStructSetData($stWinPos, 3, $aWorkArea[0])
		
		;Right
		If Abs($nLeft + $aCurWinPos[2] - $aWorkArea[2]) <= $StickRange Then _
			DllStructSetData($stWinPos, 3, $aWorkArea[2] - $aCurWinPos[2])
		
		;Top
		If Abs($aWorkArea[1] - $nTop) <= $StickRange Then DllStructSetData($stWinPos, 4, $aWorkArea[1])
		
		;Bottom
		If Abs($nTop + $aCurWinPos[3] - $aWorkArea[3]) <= $StickRange Then _
			DllStructSetData($stWinPos, 4, $aWorkArea[3] - $aCurWinPos[3])
	EndIf
	
	If $StickToAllWin <> 1 Then Return 0
	
	Local $ahWnd = WinList()
	Local $aStickWinPos, $XPoint, $YPoint
	
	For $i = 1 To UBound($ahWnd) - 1
		If $ahWnd[$i][1] = $hWnd Or Not BitAND(WinGetState($ahWnd[$i][1]), 2) Then ContinueLoop
		
		$aStickWinPos = WinGetPos($ahWnd[$i][1])
		If UBound($aStickWinPos) < 3 Then ContinueLoop
		
		$XPoint = $aStickWinPos[0] + 15
		$YPoint = $aStickWinPos[1] + 15
		
		If $XPoint < 0 Then $XPoint = 5
		If $YPoint < 0 Then $YPoint = 5
		
		If $aCurWinPos[1] + $aCurWinPos[3] >= $aStickWinPos[1] And $aCurWinPos[1] <= $aStickWinPos[1] + $aStickWinPos[3] Then
			;Left
			If Abs(($aStickWinPos[0] + $aStickWinPos[2]) - $nLeft) <= $StickRange And _
				WindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then _
					DllStructSetData($stWinPos, 3, $aStickWinPos[0] + $aStickWinPos[2])
			
			;Right
			If Abs($nLeft + $aCurWinPos[2] - $aStickWinPos[0]) <= $StickRange And _
				WindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then _
					DllStructSetData($stWinPos, 3, $aStickWinPos[0] - $aCurWinPos[2])
		EndIf
		
		If $aCurWinPos[0] + $aCurWinPos[2] >= $aStickWinPos[0] And $aCurWinPos[0] <= $aStickWinPos[0] + $aStickWinPos[2] Then
			;Top
			If Abs(($aStickWinPos[1] + $aStickWinPos[3]) - $nTop) <= $StickRange And _
				WindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then _
					DllStructSetData($stWinPos, 4, $aStickWinPos[1] + $aStickWinPos[3])
			
			;Bottom
			If Abs($nTop + $aCurWinPos[3] - $aStickWinPos[1]) <= $StickRange And _
				WindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then _
					DllStructSetData($stWinPos, 4, $aStickWinPos[1] - $aCurWinPos[3])
		EndIf
	Next
	
	Return 0
EndFunc   ;==>WM_WINDOWPOSCHANGING

Func WM_SYSCOMMAND($hWnd, $Msg, $wParam, $lParam)
	Switch BitAND($wParam, 0xFFF0)
		Case $SC_SIZE, $SC_MOVE
			DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", 1, "ptr", 0, "int", 2)
	EndSwitch
EndFunc   ;==>WM_SYSCOMMAND

Func WM_EXITSIZEMOVE($hWnd, $Msg, $wParam, $lParam)
	Local $Old_Show_Content_Param = RegRead("HKEY_CURRENT_USER\Control Panel\Desktop", "DragFullWindows")
	DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", $Old_Show_Content_Param, "ptr", 0, "int", 2)
EndFunc   ;==>WM_EXITSIZEMOVE

Func WindowFromPoint($XPoint, $YPoint)
	Local $aResult = DllCall("User32.dll", "hwnd", "WindowFromPoint", "int", $XPoint, "int", $YPoint)
	If @error Then Return SetError(1, 0, -1)
	
	Return $aResult[0]
EndFunc   ;==>WindowFromPoint

Func _GetWorkingArea()
	Local Const $SPI_GETWORKAREA = 48
	Local $stRECT = DllStructCreate("long; long; long; long")
	Local $SPIRet = DllCall("User32.dll", "int", "SystemParametersInfo", _
			"uint", $SPI_GETWORKAREA, "uint", 0, "ptr", DllStructGetPtr($stRECT), "uint", 0)
	If @error Then Return 0
	If $SPIRet[0] = 0 Then Return 0
	
	Local $sLeftArea = DllStructGetData($stRECT, 1)
	Local $sTopArea = DllStructGetData($stRECT, 2)
	Local $sRightArea = DllStructGetData($stRECT, 3)
	Local $sBottomArea = DllStructGetData($stRECT, 4)
	
	Local $aRet[4] = [$sLeftArea, $sTopArea, $sRightArea, $sBottomArea]
	Return $aRet
EndFunc   ;==>_GetWorkingArea

Func _SetAppProxy_Proc()
	Switch $Use_Proxy
		Case 1
			HttpSetProxy(1) ;Direct access
			FtpSetProxy(1)
		Case 2
			HttpSetProxy(2, $HttpProxy_Address & ":" & $HttpProxy_Port, $HttpProxy_UserName, $HttpProxy_Password)
			FtpSetProxy(2, $HttpProxy_Address & ":" & $HttpProxy_Port, $HttpProxy_UserName, $HttpProxy_Password)
		Case Else
			HttpSetProxy(0) ;IE Settings
			FtpSetProxy(0)
	EndSwitch
EndFunc   ;==>_SetAppProxy_Proc()

Func _Reduce_App_Memory($i_PID = @AutoItPID)
	If $i_PID <> - 1 Then
		Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
		DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
	Else
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	EndIf
	Return $ai_Return[0]
EndFunc   ;==>_Reduce_App_Memory

Func _App_Instance_Runing($sOccurenceName)
	Local $ERROR_ALREADY_EXISTS = 183
	Local $ahKernel = DllCall("kernel32.dll", "int", "CreateMutex", _
		"int", 0, _
		"long", 1, _
		"str", StringReplace($sOccurenceName, "\", ""))
	Local $aLastError = DllCall("kernel32.dll", "int", "GetLastError")
	If IsArray($aLastError) And $aLastError[0] = $ERROR_ALREADY_EXISTS Then Return SetError($aLastError[0], 0, 1)
	Return 0
EndFunc   ;==>_App_Instance_Runing

Func RestartApp_Proc($sCmdLine='')
	Local $sRestart_Path = @ScriptFullPath
	If Not @Compiled Then $sRestart_Path = @AutoItExe & ' "' & @ScriptFullPath & '"'
	
	If $sCmdLine <> '' Then $sCmdLine = ' ' & $sCmdLine
	
	Run($sRestart_Path & $sCmdLine, @WorkingDir)
	QuitApp()
EndFunc   ;==>RestartApp_Proc

Func QuitApp()
	$aGUI_Pos = WinGetPos($Main_GUI)
	
	IniWrite($Config_File, "Window Prefs", "Left", $aGUI_Pos[0])
	IniWrite($Config_File, "Window Prefs", "Top", $aGUI_Pos[1])
	
	_StopAsClipViewer($Main_GUI)
	
	Exit
EndFunc   ;==>QuitApp
