#include-once

;Thanks to Diamond for the round shape of this "About dialog"! ;)

Func About_Box($HWnd, $AppName, $Version, $Img_Path="")
	Local $Old_GOEM = Opt("GuiOnEventMode", 0)
	
	Local $ExStyle = -1
	Local $Width = 480
	Local $Height = 430
	
	Local $Parent_Pos = WinGetPos($HWnd)
	Local $xParent = $Parent_Pos[0] + ($Parent_Pos[2]-$Width) / 2
	Local $yParent = ($Parent_Pos[1] + ($Parent_Pos[3]-$Height) / 2)
	Local $Back_Color = 0xFFFFFF
	
	Local $GuiHelp = GUICreate("About - " & $AppName, $Width+1, $Height+1, $xParent, $yParent, $WS_POPUP, $ExStyle, $HWnd)
	GUISetBkColor($Back_Color)
	
	Local $GraphicHelp = GUICtrlCreateGraphic(0, 0, 0, 0)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	DRAW_BACKGROUND($GraphicHelp, $Back_Color)
	_GuiRoundCorners($GuiHelp, 0, 0, $Width, $Width)
	
	Local $AppVer_Label = GUICtrlCreateLabel($AppName & " - v" & $Version, 120, 70, _
		$Width-240, 20, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 14, 800, 4)
	
	Local $WWW_Label = GUICtrlCreateLabel("www: ", 145, 110, 50, 15, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlSetColor(-1, 0x0000FF)
	
	Local $Web_Label = GUICtrlCreateLabel("creator-lab.ucoz.ru", 195, 111, 110, 15, $SS_CENTER)
	GUICtrlSetTip(-1, "Visit Author's Home Page [www.creator-lab.ucoz.ru]")
	GUICtrlSetFont(-1, 9, 800, 4)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetColor(-1, 0x676767)
	GUICtrlSetOnHover(-1, "OnLabelHover_Proc", "OnLabelLeaveHover_Proc")
	
	GUICtrlCreateGraphic(70, 130, $Width-140, 3, $SS_ETCHEDFRAME+$SS_CENTER)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $Thanks_Label = GUICtrlCreateLabel("Thanks:" & @LF & _
		"* To AutoIt Developers!" & @LF & _
		"* To all AutoIt community!", _
		50, 200, $Width-100, 60, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlSetColor(-1, 0x800000)
	
	GUICtrlCreateGraphic(70, 320, $Width-140, 3, $SS_ETCHEDFRAME+$SS_CENTER)
	GUICtrlSetColor(-1, 0x676767)
	
	Local $Author_Label = GUICtrlCreateLabel("Copyright  2008 G.Sandler. All rights reserved.", _
		100, 335, $Width-200, 15, $SS_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 8, 800)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	Local $Close_About_Button = GUICtrlCreateButton("Close", 190, 370, $Width-380, 20, $SS_CENTER)
	
	For $i = $AppVer_Label To $Web_Label+1
		GUICtrlSetBkColor($i, $Back_Color)
	Next
	
	GUISetState(@SW_DISABLE, $Hwnd)
	GUISetState(@SW_SHOW, $GuiHelp)
	
	While 1
		Switch GUIGetMsg()
			Case -3, $Close_About_Button
				ExitLoop
			Case $Web_Label
				ClickHandler_Proc($Web_Label, "http://creator-lab.ucoz.ru", $GuiHelp)
		EndSwitch
	WEnd
	
	Opt("GuiOnEventMode", $Old_GOEM)
	
	GUISetState(@SW_ENABLE, $HWnd)
	GUIDelete($GuiHelp)
	GUISwitch($HWnd)
EndFunc

Func OnLabelHover_Proc($CtrlID)
	GUICtrlSetColor($CtrlID, 0x0000FF)
EndFunc

Func OnLabelLeaveHover_Proc($CtrlID)
	GUICtrlSetColor($CtrlID, 0x676767)
EndFunc

Func DRAW_BACKGROUND($CtrlID, $sBack_Color)
	Local $GrArr[10] = [300, 419, 226, 231, 235, 238, 241, 242, 243, 247]
	Local $iShift = 430, $x = 0
	Local $iColor, $j = 0
	GUICtrlSetGraphic($CtrlID, $GUI_GR_PENSIZE, 2)
	For $i = 0 To 19
		If $i > 9 Then 
			$j = 19 - $i
			$iColor = "0x" & Hex($GrArr[$j]-($i-5), 2) & Hex($GrArr[$j]-($i-5), 2) & Hex($GrArr[$j]-($i-5), 2)
		Else
			$j = $i
			$iColor = "0x" & Hex($GrArr[$j],2) & Hex($GrArr[$j], 2) & Hex($GrArr[$j], 2)
		EndIf
		For $q = 1 To 2
			GUICtrlSetGraphic($CtrlID, $GUI_GR_COLOR, $iColor, $sBack_Color)
			GUICtrlSetGraphic($CtrlID, $GUI_GR_ELLIPSE, $x, $x, $iShift+50, $iShift)
			If IsInt($i / 2) Then $x += 1
			$iShift -= 1
		Next
	Next
EndFunc

Func _GuiRoundCorners($HWnd, $i_x1, $i_y1, $i_x3, $i_y3)
	Local $aWinPos = WinGetPos($HWnd)
	If Not IsArray($aWinPos) Then Return 0
	
	Local $aRetVal1 = DllCall("gdi32.dll", "long", "CreateRoundRectRgn", _
		"long", $i_x1, "long", $i_y1, "long", $aWinPos[2], "long", $aWinPos[3], "long", $i_x3,  "long", $i_y3)
	If IsArray($aRetVal1) And $aRetVal1[0] Then
		Local $aRetVal2 = DllCall("user32.dll", "long", "SetWindowRgn", "hwnd", $HWnd, "long", $aRetVal1[0], "int", 1)
		If IsArray($aRetVal2) And $aRetVal2[0] Then
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return 0
	EndIf
EndFunc
