;Based on Clipboard notification udf - by Steve Podhajecki [eltorro] steve@ocotillo.sytes.net

#include-once
#Include <GuiConstants.au3>
#Include <Constants.au3>

Global Const $WM_CHANGECBCHAIN = 0x030D
Global Const $WM_DRAWCLIPBOARD = 0x0308
Global $hWnd_NEXT_IN_CLIP_CHAIN
Global $bInChain  ;Flag to indicate app is in the notification chain.

; Author: Stephen Podhajecki [eltorro] steve@ocotillo.sytes.net
Func _InitAsClipViewer($hWndA, $sClipProc_FuncName)
	If $hWndA <> 0 Then
		; Register Clipboard 'viewer' notification messages
		GUIRegisterMsg($WM_DRAWCLIPBOARD, $sClipProc_FuncName)
		GUIRegisterMsg($WM_CHANGECBCHAIN, $sClipProc_FuncName)
		
		; Add this app to clipboard viewer notification chain
		Local $avRet = DllCall("user32", "int", "SetClipboardViewer", "hwnd", $hWndA)
		If IsArray($avRet) Then
			$hWnd_NEXT_IN_CLIP_CHAIN = $avRet[0]
			$bInChain = True
			Return 1
		EndIf
	EndIf
	Return 0
EndFunc   ;==>_InitAsClipViewer

; Author: Stephen Podhajecki [eltorro] steve@ocotillo.sytes.net
Func _StopAsClipViewer($hWndA)
	If $bInChain And $hWndA <> 0 Then
		;Release handle from chain
		DllCall("user32.dll", "int", "ChangeClipboardChain", "hwnd", $hWndA, "hwnd", $hWnd_NEXT_IN_CLIP_CHAIN)
		; UnRegister clipboard messages:
		GUIRegisterMsg($WM_CHANGECBCHAIN, "")
		GUIRegisterMsg($WM_DRAWCLIPBOARD, "")
	EndIf
EndFunc   ;==>_StopAsClipViewer
