#include-once

Global $TCP_Aborted			= False
Global $HTTPUserAgent		= "Opera/9.27 (Windows NT 5.1; U; en)"
Global $Limit_TimeOut		= 10000
Global $HTTP_TCP_Def_Port	= 80
Global $HTTP_TCP_Port		= $HTTP_TCP_Def_Port
Global $LAST_SOCKET			= -1

Func _HTTPConnect($Host)
	TCPStartup()
	Local $Name_To_IP = TCPNameToIP($Host)
	Local $Socket = TCPConnect($Name_To_IP, $HTTP_TCP_Port)
	
	If $Socket = -1 Then
		TCPCloseSocket($Socket)
		Return SetError(1, 0, "")
	EndIf
	
	$LAST_SOCKET = $Socket
	Return $Socket
EndFunc

Func _HTTPGetResponse($Host, $Page, $sRequest="GET", $sReferrer="")
	Local $Socket = _HTTPConnect($Host)
	If @error Then Return SetError(1, 0, "")
	
	_HTTPGet($Host, $Page, $Socket, $sRequest, $sReferrer)
	If @error Then
		_HTTPClose($Socket)
		Return SetError(2, 0, "")
	EndIf
	
	Local $Recv = "", $CurrentRecv
	Local $iTimer = TimerInit()
	
	While 1
		$CurrentRecv = TCPRecv($Socket, 100)
		If @error <> 0 Then ExitLoop
		If $CurrentRecv <> "" Then $Recv &= $CurrentRecv
		
		If TimerDiff($iTimer) >= $Limit_TimeOut Then
			$Limit_TimeOutOver = True
			ExitLoop
		EndIf
	WEnd
	
	_HTTPClose($Socket)
	
	Return $Recv
EndFunc

Func _HTTPGet($Host, $Page, $Socket, $sRequest="GET", $sReferrer="")
	Local $Command = $sRequest & " " & $Page & " HTTP/1.1" & @CRLF
	$Command &= "Host: " & $Host & @CRLF
	$Command &= "User-Agent: " & $HTTPUserAgent & @CRLF
	$Command &= "Referer: " & $sReferrer & @CRLF
	$Command &= "Connection: close" & @CRLF & @CRLF
	
	Local $BytesSent = TCPSend($Socket, $Command)
	If $BytesSent = 0 Then Return SetError(1, @error, 0)
	Return $BytesSent
EndFunc

Func _HTTPClose($Socket=-1)
	TCPCloseSocket($Socket)
	TCPShutdown()
	Return 1
EndFunc
