#Region Header

#CS
		Toggle (Supper)Hidden Files / Files Extension program v1.5.2 - This is AutoIt source code (AutoIt vesrion 3.2.8.1+).
		Required FEShlExt.dll (http://thesoftpro.tripod.com/downloads/fe/index.htm).
		
		Author: G.Sandler a.k.a CreatoR - www.creator-lab.ucoz.ru, www.autoit-script.ru
#CE

#NoTrayIcon
#RequireAdmin

#Include <GUIConstantsEx.au3>
#Include <WindowsConstants.au3>
#Include <ButtonConstants.au3>

#EndRegion

#Region Main Global Variables

Global $sLang_File 					= @ScriptDir & "\TogHidFiles_Files_Ext_Lang.ini"
Global $sLanguage					= IniRead($sLang_File, "Main", "Language", "Eng")

Global $sFastExplorer_File 			= @ScriptDir & "\FastExplorer.ini"

Global $sIcons_File 				= @ScriptFullPath
If Not @Compiled Then $sIcons_File = @ScriptDir & "\Toggle Files&Extension.bin"

Global $sAppTitle					= IniRead($sLang_File, "Translation_" & $sLanguage, "Main Title", "Toggle (Supper) Hidden Files&Folders / Files Extension - Integration")

Global $sToggle_Hid_Files_Capt		= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Hidden Files Caption", "Toggle Hidden Files && Folders")
Global $sToggle_Hid_Files_Hint 		= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Hidden Files Hint", "Hide/Show Files and Folders")

Global $sToggle_SupHid_Files_Capt 	= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Supper Hidden Files Caption", "Toggle Supper Hidden Files && Folders")
Global $sToggle_SupHid_Files_Hint 	= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Supper Hidden Files Hint", "Hide/Show System Files and Folders")

Global $sToggle_FilesExt_Capt 		= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Files Extension Caption", "Toggle Files Extension")
Global $sToggle_FilesExt_Hint 		= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Files Extension Hint", "Hide/Show Extesnsion of the Files")

Global $sPrompt_Msg					= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Prompt Messages", "Select modules to install into Explorer's context menu")

Global $sCreateShortCut_Msg 		= IniRead($sLang_File, "Translation_" & $sLanguage, "Create ShCut Msg", "Create ShortCut")

Global $sCreate_Lnk_TogHidFil_Tip = IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Hidden Files ShCut Msg", "Create a shortcut for toggling hidden files and folders")
Global $sCreate_Lnk_TogSHidFil_Tip 	= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Supper Hidden Files ShCut Msg", "Create a shortcut for toggling supper hidden files and folders")
Global $sCreate_Lnk_TogFilesExt_Tip	= IniRead($sLang_File, "Translation_" & $sLanguage, _
	"Toggle Files Ext ShCut Msg", "Create a shortcut for toggling files extension")

Global $sOk_Msg						= IniRead($sLang_File, "Translation_" & $sLanguage, "OK Msg", "OK")
Global $sCancel_Msg					= IniRead($sLang_File, "Translation_" & $sLanguage, "Cancel Msg", "Cancel")

#EndRegion Main Global Variables

#Region Integration

If $CmdLine[0] = 0 Then
	If _Integrate_App_Dialog($sAppTitle) Then
		;MsgBox(266144+64, "Done!", "Registration is completed!" & @LF & "Check context menu of the Explorer")
		ControlSend("[CLASS:Progman]", "", "SysListView321", "+{F10}")
	EndIf
	
	Exit
ElseIf $CmdLine[1] = "/Silent" Then
	Dim $aControls[4] = [3, StringInStr($CmdLineRaw, "/HiddenFiles"), StringInStr($CmdLineRaw, "/SupperHiddenFiles"), StringInStr($CmdLineRaw, "/FilesExtension")]
	_AppIntegrate_Proc($aControls, 1)
	
	Exit
EndIf

#EndRegion Integration

#Region Command Line

;Toggling Process
Global $Main_RegKey = "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced"

Switch $CmdLine[1]
	Case "/ToggleHiddenFiles"
		If RegRead($Main_RegKey, "Hidden") = 1 Then
			RegWrite($Main_RegKey, "Hidden", "REG_DWORD", 2)
		Else
			RegWrite($Main_RegKey, "Hidden", "REG_DWORD", 1)
		EndIf
	Case "/ToggleSupperHiddenFiles"
		If RegRead($Main_RegKey, "ShowSupperHidden") = 1 Then
			RegWrite($Main_RegKey, "SupperHidden", "REG_DWORD", 1)
			RegWrite($Main_RegKey, "ShowSupperHidden", "REG_DWORD", 0)
		Else
			RegWrite($Main_RegKey, "SupperHidden", "REG_DWORD", 0)
			RegWrite($Main_RegKey, "ShowSupperHidden", "REG_DWORD", 1)
		EndIf
	Case "/ToggleFilesExtension"
		If RegRead($Main_RegKey, "HideFileExt") Then
			RegWrite($Main_RegKey, "HideFileExt", "REG_DWORD", 0)
		Else
			RegWrite($Main_RegKey, "HideFileExt", "REG_DWORD", 1)
		EndIf
	Case Else
		Exit
EndSwitch

_UpdateExplorer()

#EndRegion Command Line

#Region Program Functions

Func _UpdateExplorer()
	Local $aWinFViewExpListArr = _ExplFViewWinGetList()
	
	If IsArray($aWinFViewExpListArr) Then
		For $i = 1 To $aWinFViewExpListArr[0]
			WinActivate($aWinFViewExpListArr[$i])
			ControlSend($aWinFViewExpListArr[$i], "FolderView", "", "{F5}")
		Next
	EndIf
	
	Local $aWinExpListArr = _ExplWinGetList()
	Local $hDll = DllOpen("user32.dll")
	
	If $hDll = -1 Then
		MsgBox(16, "Error", "There was an error to refresh explorer." & @LF & _
			"This can caused by the memory full, and also you might want to check file user32.dll (in your system dir), " & @LF & _
			"it must exists for this operation." & @LF & @LF & _
			"You can refresh the explorer windows by pressing F5 key in each needed window," & @LF & _
			"or call the context menu of the folder (SHIFT F10), and click on 'Refresh' item." & @LF & _
			"OK   --->   EXIT")
		Exit
	EndIf
	
	If IsArray($aWinExpListArr) Then
		For $i = 1 To $aWinExpListArr[0]
			DllCall($hDll, "long", "SendMessage", "hwnd", $aWinExpListArr[$i], "int", 0x111, "int", 28931, "int", 0)
		Next
	EndIf
	
	DllClose($hDll)
EndFunc

Func _ExplFViewWinGetList()
	Local $aWinFViewList = WinList("[CLASS:#32770]", "FolderView")
	Local $aRetWinListArr[1], $iUbound = 0
	
	If IsArray($aWinFViewList) Then
		For $i = 1 To $aWinFViewList[0][0]
			$iUbound = UBound($aRetWinListArr)
			ReDim $aRetWinListArr[$iUbound+1]
			$aRetWinListArr[$iUbound] = $aWinFViewList[$i][0]
		Next
	EndIf
	
	$aRetWinListArr[0] = UBound($aRetWinListArr)-1
	Return $aRetWinListArr
EndFunc

Func _ExplWinGetList()
	Local $aWinCabinetList = WinList("[CLASS:CabinetWClass]")
	Local $aWinFViewList = WinList("[CLASS:#32770]", "FolderView")
	
	Local $iUbound = 0
	Local $aRetWinListArr[2] = [1, WinGetHandle("[CLASS:Progman]")]
	
	If IsArray($aWinCabinetList) Then
		For $i = 1 To $aWinCabinetList[0][0]
			$iUbound = UBound($aRetWinListArr)
			ReDim $aRetWinListArr[$iUbound+1]
			$aRetWinListArr[$iUbound] = $aWinCabinetList[$i][1]
		Next
	EndIf
	
	If IsArray($aWinFViewList) Then
		For $i = 1 To $aWinFViewList[0][0]
			$iUbound = UBound($aRetWinListArr)
			ReDim $aRetWinListArr[$iUbound+1]
			$aRetWinListArr[$iUbound] = $aWinFViewList[$i][1]
		Next
	EndIf
	
	$aRetWinListArr[0] = UBound($aRetWinListArr)-1
	Return $aRetWinListArr
EndFunc

Func _Integrate_App_Dialog($sTitle, $hWnd=0)
	If $hWnd <> 0 Then WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $iToggleHiddenFiles_Checked = IniRead($sFastExplorer_File, "Dynamic Items", "Checked1", 0)
	Local $iToggleSupperHiddenFiles_Checked = IniRead($sFastExplorer_File, "Dynamic Items", "Checked2", 0)
	Local $iToggleFilesExtension_Checked = IniRead($sFastExplorer_File, "Dynamic Items", "Checked3", 0)
	
	Local $iToggle_OKButton = True
	Local $IsIntegrated = False
	
	Local $hGUI = GUICreate($sTitle, 480, 300, -1, -1, BitOR($WS_CAPTION, $WS_POPUP, $WS_SYSMENU), $WS_EX_TOPMOST, $hWnd)
	
	If Not @Compiled Then
		GUISetIcon(@ScriptDir & "\Icon.ico")
	EndIf
	
	GUICtrlCreateIcon('user32.dll', -5, 10, 10)
	GUICtrlCreateLabel($sPrompt_Msg, 70, 15, 400, 30)
	GUICtrlSetFont(-1, 10, 800)
	
	Local $ToggleHiddenFiles_CB = _GUICtrlCreateCheckbox($sToggle_Hid_Files_Capt, "", 1, 20, 80, -1, 15, $BS_ICON)
	GUICtrlSetImage($ToggleHiddenFiles_CB[0], $sIcons_File, -2, 0)
	If $iToggleHiddenFiles_Checked = 1 Then GUICtrlSetState($ToggleHiddenFiles_CB[0], $GUI_CHECKED)
	
	Local $ToggleSupperHiddenFiles_CB = _GUICtrlCreateCheckbox($sToggle_SupHid_Files_Capt, "", 1, 20, 120, -1, 15, $BS_ICON)
	GUICtrlSetImage($ToggleSupperHiddenFiles_CB[0], $sIcons_File, -1, 0)
	If $iToggleSupperHiddenFiles_Checked = 1 Then GUICtrlSetState($ToggleSupperHiddenFiles_CB[0], $GUI_CHECKED)
	
	Local $ToggleFilesExtension_CB = _GUICtrlCreateCheckbox($sToggle_FilesExt_Capt, "", 1, 20, 160, -1, 15, $BS_ICON)
	GUICtrlSetImage($ToggleFilesExtension_CB[0], $sIcons_File, -3, 0)
	If $iToggleFilesExtension_Checked = 1 Then GUICtrlSetState($ToggleFilesExtension_CB[0], $GUI_CHECKED)
	
	Local $CreateShortcut_For_ToglHidFiles_Btn = GUICtrlCreateButton($sCreateShortCut_Msg, 320, 80, 100, 20)
	GUICtrlSetTip(-1, $sCreate_Lnk_TogHidFil_Tip)
	
	Local $CreateShortcut_For_ToglSupHidFiles_Btn = GUICtrlCreateButton($sCreateShortCut_Msg, 320, 120, 100, 20)
	GUICtrlSetTip(-1, $sCreate_Lnk_TogSHidFil_Tip)
	
	Local $CreateShortcut_For_ToglFilesExt_Btn = GUICtrlCreateButton($sCreateShortCut_Msg, 320, 160, 100, 20)
	GUICtrlSetTip(-1, $sCreate_Lnk_TogFilesExt_Tip)
	
	Local $OK_Button = GUICtrlCreateButton($sOk_Msg, 20, 260, 70, 20)
	GUICtrlSetState(-1, $GUI_DEFBUTTON)
	
	If $iToggleHiddenFiles_Checked = 0 And $iToggleSupperHiddenFiles_Checked = 0 And $iToggleFilesExtension_Checked = 0 Then
		GUICtrlSetState(-1, BitOR($GUI_DISABLE, $GUI_DEFBUTTON))
	Else
		GUICtrlSetState(-1, $GUI_DEFBUTTON)
		$iToggle_OKButton = False
	EndIf
	
	Local $Cancel_Button = GUICtrlCreateButton($sCancel_Msg, 110, 260, 70, 20)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$nMsg = GUIGetMsg()
		
		Switch $nMsg
			Case $CreateShortcut_For_ToglHidFiles_Btn
				Local $sDefault_FileName = StringReplace($sToggle_Hid_Files_Capt, "&&", "&")
				
				_Create_Shortcut_Proc("/ToggleHiddenFiles", $sToggle_Hid_Files_Hint, $sDefault_FileName, _
					$sIcons_File, 1, $hGUI)
			Case $CreateShortcut_For_ToglSupHidFiles_Btn
				Local $sDefault_FileName = StringReplace($sToggle_SupHid_Files_Capt, "&&", "&")
				
				_Create_Shortcut_Proc("/ToggleSupperHiddenFiles", $sToggle_SupHid_Files_Hint, $sDefault_FileName, _
					$sIcons_File, 0, $hGUI)
			Case $CreateShortcut_For_ToglFilesExt_Btn
				Local $sDefault_FileName = StringReplace($sToggle_FilesExt_Capt, "&&", "&")
				
				_Create_Shortcut_Proc("/ToggleFilesExtension", $sToggle_FilesExt_Hint, $sDefault_FileName, _
					$sIcons_File, 2, $hGUI)
			Case $ToggleHiddenFiles_CB[0] To $ToggleFilesExtension_CB[1]
				If $nMsg = $ToggleHiddenFiles_CB[1] Or $nMsg = $ToggleSupperHiddenFiles_CB[1] Or _
					$nMsg = $ToggleFilesExtension_CB[1] Then
					
					For $i = $ToggleHiddenFiles_CB[0] To $ToggleFilesExtension_CB[1]
						If $nMsg = $i Then
							If GUICtrlRead($i-1) = $GUI_CHECKED Then
								GUICtrlSetState($i-1, $GUI_UNCHECKED)
							Else
								GUICtrlSetState($i-1, $GUI_CHECKED)
							EndIf
							
							ExitLoop
						EndIf
					Next
				EndIf
				
				If $iToggle_OKButton Then
					If AllCheckBoxes_UnChecked($ToggleHiddenFiles_CB[0], $ToggleFilesExtension_CB[1]) Then
						GUICtrlSetState($OK_Button, $GUI_DISABLE)
					Else
						GUICtrlSetState($OK_Button, $GUI_ENABLE)
					EndIf
				EndIf
			Case $OK_Button
				If $iToggle_OKButton And AllCheckBoxes_UnChecked($ToggleHiddenFiles_CB[0], $ToggleFilesExtension_CB[1]) Then ContinueLoop
				
				Local $aControls[4] = [3, $ToggleHiddenFiles_CB[0], $ToggleSupperHiddenFiles_CB[0], $ToggleFilesExtension_CB[0]]
				
				_AppIntegrate_Proc($aControls, 0)
				
				$IsIntegrated = True
				ExitLoop
			Case $Cancel_Button, $GUI_EVENT_CLOSE
				ExitLoop
		EndSwitch
	Wend
	
	If $hWnd <> 0 Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($hGUI)
	
	Return $IsIntegrated
EndFunc

Func _AppIntegrate_Proc($aControls, $iFlag)
	FileInstall(".\FEShlExt.dll", @ScriptDir & "\", 1)
	
	Local $aIconIndex[4] = [3, 1, 0, 2]
	Local $aArguments[4] = [3, "/ToggleHiddenFiles", "/ToggleSupperHiddenFiles", "/ToggleFilesExtension"]
	Local $aToggle_Caption[4] = [3, $sToggle_Hid_Files_Capt, $sToggle_SupHid_Files_Capt, $sToggle_FilesExt_Capt]
	Local $aToggle_Caption_Hint[4] = [3, $sToggle_Hid_Files_Hint, $sToggle_SupHid_Files_Hint, $sToggle_FilesExt_Hint]
	
	IniDelete($sFastExplorer_File, "Dynamic Items")
	
	For $i = 1 To 3
		If ($iFlag = 0 And GUICtrlRead($aControls[$i]) = $GUI_CHECKED) Or ($iFlag = 1 And $aControls[$i] > 0) Then
			IniWrite($sFastExplorer_File, "Dynamic Items", "Count", 3)
			IniWrite($sFastExplorer_File, "Dynamic Items", "Application" & $i, FileGetShortName(@AutoItExe))
			IniWrite($sFastExplorer_File, "Dynamic Items", "Parameters" & $i, $aArguments[$i])
			IniWrite($sFastExplorer_File, "Dynamic Items", "Caption" & $i, $aToggle_Caption[$i])
			IniWrite($sFastExplorer_File, "Dynamic Items", "Hint" & $i, $aToggle_Caption_Hint[$i])
			IniWrite($sFastExplorer_File, "Dynamic Items", "IconFile" & $i, $sIcons_File)
			IniWrite($sFastExplorer_File, "Dynamic Items", "IconIndex" & $i, $aIconIndex[$i])
			IniWrite($sFastExplorer_File, "Dynamic Items", "Checked" & $i, 1)
			IniWrite($sFastExplorer_File, "Dynamic Items", "FileType" & $i, "Directory\Background")
		EndIf
	Next
	
	RunWait(@SystemDir & '\regsvr32.exe /S "' & FileGetShortName(@ScriptDir) & '\FEShlExt.dll"')
EndFunc

Func _Create_Shortcut_Proc($sArguments, $sCaptionHint="", $sDefault_FileName="", $iIconFile="", $iIconIndex=0, $hGUI=0)
	;GUISetState(@SW_HIDE)
	
	Local $sSelected_File = FileSaveDialog("Save as shortcut", @DesktopDir, "Shortcut Files (*.lnk)", 18, $sDefault_FileName, $hGUI)
	
	If Not @error Then _
		FileCreateShortcut(@ScriptFullPath, $sSelected_File, @ScriptDir, $sArguments, $sCaptionHint, $iIconFile, "", $iIconIndex)
	
	;GUISetState(@SW_SHOW)
EndFunc

Func _GUICtrlCreateCheckbox($sText, $sDirection, $iMode, $Left, $Top, $Width=Default, $Height=Default, $Style=-1, $exStyle=-1)
	Local $aRetArr[2]
	Local $rLeft = $Left, $rTop = $Top
	
	Switch $sDirection
		Case "Bottom"
			$Top += 20
		Case "Top"
			$rTop += 18
		Case "Left"
			If $Width = Default Or $Width = -1 Then Return SetError(1, 0, 0)
			$Width -= 10
			$rLeft += $Width
			$Top += 3
		Case Else
			$Left += 36
			$Top += 3
	EndSwitch
	
	If $iMode = 0 Then
		$aRetArr[0] = GUICtrlCreateRadio("", $rLeft, $rTop, 35, 20, $Style, $exStyle)
	Else
		$aRetArr[0] = GUICtrlCreateCheckbox("", $rLeft, $rTop, 35, 20, $Style, $exStyle)
	EndIf
	
	$aRetArr[1] = GUICtrlCreateLabel($sText, $Left, $Top, $Width, $Height, $Style, $exStyle)
	
	Return $aRetArr
EndFunc

Func AllCheckBoxes_UnChecked($nStartCtrlID, $nEndCtrlID)
	For $i = $nStartCtrlID To $nEndCtrlID
		If GUICtrlRead($i) = $GUI_CHECKED Then Return False
	Next
	
	Return True
EndFunc

#EndRegion Program Functions
