/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import libs.WindowClosingAdapter;
import libs.dialogs.WindowStartbildschirm;
import libs.file.ConfigProperties;
import libs.file.IniReader;
import libs.file.Messages;
import libs.file.ReadLanguageFile;
import libs.file.Resourcing;
import libs.komponenten.TableHauptfenster;
import libs.mainMenuAndToolbar.MainMenuToolbar;
import statischeVariablen.StaticProgramName;
import statischeVariablen.StaticVariables;

public class SearchEdit
extends JFrame {
    static Thread threadStartbildschirm = null;

    public SearchEdit() {
        super(StaticProgramName.getProgramNamePlusVersionWithoutBuild());
        JPanel hauptFenster = new JPanel();
        hauptFenster.setLayout(new BorderLayout());
        hauptFenster.add(this.getStatuspanel(), "South");
        hauptFenster.add(this.getArbeitspanel(), "Center");
        this.setContentPane(hauptFenster);
        this.pack();
        MainMenuToolbar menuToolbar = new MainMenuToolbar();
        menuToolbar.setFrame(this);
        this.setJMenuBar(menuToolbar.getMenu());
        hauptFenster.add((Component)menuToolbar.getToolbar(), "North");
        this.addWindowListener(new WindowClosingAdapter(true));
    }

    private Component getArbeitspanel() {
        JPanel arbeitsPanel = new JPanel();
        arbeitsPanel.setLayout(new BorderLayout());
        arbeitsPanel.add(this.getTablePanel(), "Center");
        return arbeitsPanel;
    }

    private Component getTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        TableHauptfenster table = new TableHauptfenster();
        tablePanel.add((Component)table.getTable(), "Center");
        return tablePanel;
    }

    private Component getStatuspanel() {
        JPanel statusPanel = new JPanel();
        StaticVariables.labelStatuszeile = new JLabel();
        StaticVariables.labelStatuszeile.setText(Messages.getString("SearchEdit.0"));
        StaticVariables.labelStatuszeile.setHorizontalAlignment(2);
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder(0));
        statusPanel.add((Component)StaticVariables.labelStatuszeile, "North");
        return statusPanel;
    }

    private static void starting(final JFrame frame) {
        if (ConfigProperties.SearchEditProps.getProperty("startbildschirm", "1").equals("1")) {
            threadStartbildschirm = new Thread(){

                public void run() {
                    frame.setCursor(new Cursor(3));
                    new WindowStartbildschirm(StaticProgramName.getProgramNamePlusVersionAndBuild(), 2000, frame);
                    frame.toFront();
                    frame.setCursor(new Cursor(0));
                }
            };
            threadStartbildschirm.start();
        }
        ReadLanguageFile.readOperaLanguageFile();
    }

    private static void frameLocation(SearchEdit frame) {
        if (!(ConfigProperties.SearchEditProps.getProperty("MainWindowX", "").equals("") || ConfigProperties.SearchEditProps.getProperty("MainWindowY", "").equals("") || ConfigProperties.SearchEditProps.getProperty("MainWindowHeight", "").equals("") || ConfigProperties.SearchEditProps.getProperty("MainWindowWidth", "").equals(""))) {
            frame.setLocation(new Point(Integer.valueOf(ConfigProperties.SearchEditProps.getProperty("MainWindowX")), Integer.valueOf(ConfigProperties.SearchEditProps.getProperty("MainWindowY"))));
            frame.setSize(Integer.valueOf(ConfigProperties.SearchEditProps.getProperty("MainWindowWidth")), Integer.valueOf(ConfigProperties.SearchEditProps.getProperty("MainWindowHeight")));
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            if (d.width >= 640 && d.height >= 480) {
                frame.setSize(640, 480);
            }
            frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        }
    }

    private static void kommandozeilenParameter(String filename, SearchEdit frame) {
        File file = new File(filename);
        if (file.exists()) {
            IniReader reader = new IniReader();
            reader.openFromConsole(frame, file);
            StaticVariables.activateDeactivateMenuToolboxbar();
        } else {
            JOptionPane.showMessageDialog(frame, file + " " + Messages.getString("SearchEdit.18"), Messages.getString("SearchEdit.19"), 0);
            System.out.println(Messages.getString("SearchEdit.20"));
            System.out.println(file + " " + Messages.getString("SearchEdit.22"));
        }
    }

    public static void main(String[] args) {
        ConfigProperties.readSearchEditConfig();
        Messages.getActualLanguage();
        System.out.println(Messages.getString("SearchEdit.23"));
        SearchEdit frame = new SearchEdit();
        frame.setResizable(true);
        SearchEdit.starting(frame);
        SearchEdit.frameLocation(frame);
        Resourcing icon = new Resourcing();
        frame.setIconImage(icon.loadImageResource("resource", "Opera_find16.png"));
        icon = null;
        if (threadStartbildschirm != null) {
            while (threadStartbildschirm.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    System.out.println(e.toString());
                }
            }
        }
        frame.setVisible(true);
        frame.setDefaultCloseOperation(0);
        System.out.println(Messages.getString("SearchEdit.26"));
        if (StaticVariables.labelStatuszeile.getText().equals(Messages.getString("SearchEdit.27"))) {
            StaticVariables.labelStatuszeile.setText(Messages.getString("SearchEdit.28"));
        }
        if (args.length > 0) {
            SearchEdit.kommandozeilenParameter(args[0], frame);
        }
    }
}

