/*
 * Decompiled with CFR 0.152.
 */
package libs;

import java.io.IOException;
import libs.file.ConfigProperties;
import libs.file.Messages;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static String unixPath = "";
    private static String[] BROWSER = new String[]{"opera", "konqueror", "firefox", "mozilla", "netscape", "galeon"};
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) {
        block8: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Runtime.getRuntime().exec(cmd);
                    break block8;
                }
                unixPath = ConfigProperties.SearchEditProps.getProperty("BrowserPath");
                Process p = null;
                cmd = String.valueOf(unixPath) + ' ' + UNIX_FLAG + '(' + url + ')';
                p = BrowserControl.checkBrowser(cmd, unixPath);
                if (p != null) {
                    int exitCode = BrowserControl.startBrowser(url, unixPath, cmd, p);
                    break block8;
                }
                System.out.println(Messages.getString("BrowserControl.14"));
                int i = 0;
                while (i <= BROWSER.length - 1) {
                    String UNIX_FLAGtemp;
                    unixPath = BROWSER[i];
                    if (BROWSER[i].equals("opera")) {
                        UNIX_FLAGtemp = "-newpage";
                        cmd = String.valueOf(unixPath) + ' ' + UNIX_FLAGtemp + ' ' + url;
                    } else {
                        UNIX_FLAGtemp = UNIX_FLAG;
                        cmd = String.valueOf(unixPath) + ' ' + UNIX_FLAGtemp + '(' + url + ')';
                    }
                    p = BrowserControl.checkBrowser(cmd, unixPath);
                    if (p != null) {
                        int exitCode = BrowserControl.startBrowser(url, unixPath, cmd, p);
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                System.err.println(String.valueOf(Messages.getString("BrowserControl.17")) + "=" + cmd);
                System.err.println(String.valueOf(Messages.getString("BrowserControl.19")) + " " + e);
            }
        }
    }

    private static Process checkBrowser(String cmd, String unix_path2) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            System.out.println(String.valueOf(Messages.getString("BrowserControl.21")) + " " + unix_path2 + " " + Messages.getString("BrowserControl.24"));
        }
        return p;
    }

    private static int startBrowser(String url, String pfad, String cmd, Process p) throws IOException {
        int exitCode = 1;
        try {
            exitCode = p.waitFor();
            if (exitCode != 0) {
                cmd = String.valueOf(pfad) + " " + url;
                p = Runtime.getRuntime().exec(cmd);
            }
        }
        catch (InterruptedException e) {
            System.err.println(String.valueOf(Messages.getString("BrowserControl.26")) + "'" + cmd + "'");
            System.err.println("Fehler: " + e);
        }
        return exitCode;
    }

    public static boolean isWindowsPlatform() {
        boolean retVal = false;
        String os = System.getProperty("os.name");
        retVal = os != null && os.startsWith(WIN_ID);
        return retVal;
    }
}

