/*
 * Decompiled with CFR 0.152.
 */
package libs;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import libs.file.ConfigProperties;
import libs.file.IniWriter;
import libs.file.Messages;
import statischeVariablen.StaticVariables;

public class WindowClosingAdapter
extends WindowAdapter {
    private boolean exitSystem;

    public WindowClosingAdapter(boolean exitSystem) {
        this.exitSystem = exitSystem;
    }

    public WindowClosingAdapter() {
        this(false);
    }

    public void windowClosing(WindowEvent event) {
        if (this.exitSystem) {
            int retVal = -1;
            if (StaticVariables.isFilechanged()) {
                String abfragetext = null;
                abfragetext = StaticVariables.filename == null || StaticVariables.filename.equals("") ? Messages.getString("WindowClosingAdapter.1") : String.valueOf(Messages.getString("WindowClosingAdapter.2")) + " " + StaticVariables.filename + " " + Messages.getString("WindowClosingAdapter.5");
                retVal = JOptionPane.showConfirmDialog(event.getWindow(), abfragetext);
            }
            if (retVal == 2) {
                return;
            }
            if (retVal == 0) {
                IniWriter write = new IniWriter();
                write.fileSave((JFrame)event.getWindow());
                return;
            }
            if (!StaticVariables.isFilechanged() || retVal == 1 && this.exitSystem) {
                System.out.println(Messages.getString("WindowClosingAdapter.6"));
                ConfigProperties.setPropertiesOnClose((JFrame)event.getWindow());
                ConfigProperties.writeSearchEditConfig();
                System.out.println(Messages.getString("WindowClosingAdapter.7"));
                event.getWindow().setVisible(false);
                event.getWindow().dispose();
                System.exit(0);
            }
        } else {
            event.getWindow().setVisible(false);
            event.getWindow().dispose();
        }
    }
}

