/*
 * Decompiled with CFR 0.152.
 */
package libs.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import libs.BrowserControl;
import libs.FileChooserListOrDetailView;
import libs.WindowClosingAdapter;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import libs.file.ReadLanguageFile;
import libs.file.Resourcing;
import statischeVariablen.StaticVariables;

public class WindowsConfig
extends JDialog
implements ActionListener,
MouseListener {
    private boolean spracheGeaendert = false;
    private int firstLanguage;
    private String firstExternLanguage;
    private JButton OKButton;
    private JButton AbbrechenButton;
    private JComboBox languageComboBox;
    private JTextField textfeldLanguageFile;
    private JButton buttonFilechooser;
    private JTextField textfeldBrowserPath;
    private JButton buttonFilechooser2;
    private JLabel labelURL;
    private JTextField textfeldOperaLanguageFile;
    private JButton buttonFilechooser3;
    private JCheckBox checkboxStartbildschirm;

    public WindowsConfig(JFrame owner) {
        super(owner, Messages.getString("WindowsConfig1.0"), true);
        this.addWindowListener(new WindowClosingAdapter(false));
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        JPanel fenster = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 2;
        contentPane.setLayout(new GridBagLayout());
        fenster.setLayout(new GridBagLayout());
        fenster.add((Component)this.panel1(), constraints);
        fenster.add((Component)this.panel2(), constraints);
        contentPane.add((Component)fenster, constraints);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel panel1() {
        JPanel ret = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        ret.setLayout(new GridBagLayout());
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.ipady = 0;
        constraints.insets = new Insets(10, 5, 10, 5);
        constraints.weighty = 0.0;
        JPanel panelTab1 = new JPanel();
        panelTab1.setLayout(new GridBagLayout());
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.ipady = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        JTabbedPane tp = new JTabbedPane();
        panelTab1.setLayout(new GridBagLayout());
        tp.setTabPlacement(2);
        tp.addTab(Messages.getString("WindowsConfig1.1"), this.getPanelTab1());
        tp.addTab(Messages.getString("WindowsConfig2.0"), this.getPanelTab2());
        constraints.insets = new Insets(5, 5, 5, 5);
        ret.add((Component)tp, constraints);
        Border bd1 = BorderFactory.createEtchedBorder();
        ret.setBorder(bd1);
        return ret;
    }

    private JPanel getPanelTab1() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 0.0;
        JPanel panelTab1 = new JPanel();
        panelTab1.setLayout(new GridBagLayout());
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.ipady = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        panelTab1.setLayout(new GridBagLayout());
        constraints.gridwidth = 0;
        constraints.insets = new Insets(15, 10, 5, 10);
        JLabel c = new JLabel("<html><b><u>" + Messages.getString("WindowsConfig2.2") + ":</u></b></html>", 2);
        panelTab1.add((Component)c, constraints);
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.anchor = 18;
        constraints.fill = 2;
        panelTab1.add((Component)new JSeparator(), constraints);
        constraints.fill = 13;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 5, 5, 5);
        c = new JLabel(String.valueOf(Messages.getString("WindowsConfig1.2")) + ":", 2);
        panelTab1.add((Component)c, constraints);
        constraints.gridwidth = 0;
        this.languageComboBox = new JComboBox<Object>(new Object[]{"English", "Deutsch", "Fran\u00e7ais", "L\u00ebtzebuergesch"});
        this.languageComboBox.setToolTipText(Messages.getString("WindowsConfig1.4"));
        this.languageComboBox.setMaximumRowCount(5);
        if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").endsWith("_en_GB")) {
            this.languageComboBox.setSelectedIndex(0);
        } else if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").endsWith("_de_DE")) {
            this.languageComboBox.setSelectedIndex(1);
        } else if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").endsWith("_fr_FR")) {
            this.languageComboBox.setSelectedIndex(2);
        } else if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").endsWith("_lb_LU")) {
            this.languageComboBox.setSelectedIndex(3);
        }
        this.languageComboBox.addActionListener(this);
        this.firstLanguage = this.languageComboBox.getSelectedIndex();
        panelTab1.add((Component)this.languageComboBox, constraints);
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 5, 5, 5);
        c = new JLabel(String.valueOf(Messages.getString("WindowsConfig1.9")) + ":", 2);
        panelTab1.add((Component)c, constraints);
        constraints.gridwidth = 2;
        this.textfeldLanguageFile = new JTextField("", 20);
        this.textfeldLanguageFile.setToolTipText(Messages.getString("WindowsConfig1.12"));
        this.textfeldLanguageFile.setText(ConfigProperties.SearchEditProps.getProperty("SearchEditLanguageFile", ""));
        this.firstExternLanguage = ConfigProperties.SearchEditProps.getProperty("SearchEditLanguageFile", "");
        panelTab1.add((Component)this.textfeldLanguageFile, constraints);
        constraints.gridwidth = 0;
        this.buttonFilechooser = new JButton(" ... ");
        this.buttonFilechooser.addActionListener(this);
        panelTab1.add((Component)this.buttonFilechooser, constraints);
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.gridwidth = 1;
        constraints.anchor = 10;
        constraints.gridwidth = 0;
        this.labelURL = new JLabel("<html> <a href=\"http://my.opera.com/SearchEdit/forums/forum.dml?id=10851\">" + Messages.getString("WindowsConfig2.5") + "</a></html>", 2);
        this.labelURL.setCursor(new Cursor(12));
        this.labelURL.setFont(new Font("SansSerif", 0, 11));
        this.labelURL.addMouseListener(this);
        panelTab1.add((Component)this.labelURL, constraints);
        constraints.insets = new Insets(2, 80, 2, 80);
        constraints.anchor = 18;
        constraints.fill = 2;
        JSeparator sep = new JSeparator();
        sep.setForeground(Color.lightGray);
        panelTab1.add((Component)sep, constraints);
        constraints.insets = new Insets(5, 10, 5, 10);
        constraints.fill = 13;
        constraints.anchor = 18;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(15, 5, 5, 5);
        c = new JLabel(String.valueOf(Messages.getString("WindowsConfig1.18")) + ":", 2);
        panelTab1.add((Component)c, constraints);
        constraints.gridwidth = 2;
        this.textfeldBrowserPath = new JTextField("", 20);
        this.textfeldBrowserPath.setToolTipText(Messages.getString("WindowsConfig1.21"));
        this.textfeldBrowserPath.setText(ConfigProperties.SearchEditProps.getProperty("BrowserPath", ""));
        panelTab1.add((Component)this.textfeldBrowserPath, constraints);
        constraints.gridwidth = 0;
        this.buttonFilechooser2 = new JButton(" ... ");
        this.buttonFilechooser2.addActionListener(this);
        panelTab1.add((Component)this.buttonFilechooser2, constraints);
        constraints.insets = new Insets(2, 80, 2, 80);
        constraints.anchor = 18;
        constraints.fill = 2;
        JSeparator sep1 = new JSeparator();
        sep1.setForeground(Color.lightGray);
        panelTab1.add((Component)sep1, constraints);
        constraints.insets = new Insets(5, 10, 5, 10);
        constraints.fill = 13;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 5, 5, 5);
        c = new JLabel("", 2);
        panelTab1.add((Component)c, constraints);
        constraints.gridwidth = 0;
        this.checkboxStartbildschirm = new JCheckBox(Messages.getString("WindowsConfig2.7"));
        if (ConfigProperties.SearchEditProps.getProperty("startbildschirm", "1").equals("1")) {
            this.checkboxStartbildschirm.setSelected(true);
        } else {
            this.checkboxStartbildschirm.setSelected(false);
        }
        this.checkboxStartbildschirm.setToolTipText(Messages.getString("WindowsConfig2.11"));
        this.checkboxStartbildschirm.setFont(new Font("SansSerif", 0, 12));
        panelTab1.add((Component)this.checkboxStartbildschirm, constraints);
        return panelTab1;
    }

    private JPanel getPanelTab2() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 0.0;
        JPanel panelTab2 = new JPanel();
        panelTab2.setLayout(new GridBagLayout());
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.ipady = 0;
        panelTab2.setLayout(new GridBagLayout());
        constraints.gridwidth = 0;
        constraints.insets = new Insets(15, 10, 5, 10);
        JLabel c = new JLabel("<html><b><u>" + Messages.getString("WindowsConfig2.13") + ":</u></b></html>", 2);
        panelTab2.add((Component)c, constraints);
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.anchor = 18;
        constraints.fill = 2;
        panelTab2.add((Component)new JSeparator(), constraints);
        constraints.fill = 13;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 5, 5, 5);
        c = new JLabel(String.valueOf(Messages.getString("WindowsConfig2.15")) + ":", 2);
        panelTab2.add((Component)c, constraints);
        constraints.gridwidth = 2;
        this.textfeldOperaLanguageFile = new JTextField("", 20);
        this.textfeldOperaLanguageFile.setToolTipText(Messages.getString("WindowsConfig2.17"));
        this.textfeldOperaLanguageFile.setText(ConfigProperties.SearchEditProps.getProperty("OperaLanguageFile", ""));
        panelTab2.add((Component)this.textfeldOperaLanguageFile, constraints);
        constraints.gridwidth = 0;
        this.buttonFilechooser3 = new JButton(" ... ");
        this.buttonFilechooser3.addActionListener(this);
        panelTab2.add((Component)this.buttonFilechooser3, constraints);
        return panelTab2;
    }

    private JPanel panel2() {
        JPanel ret = new JPanel();
        Resourcing icon = new Resourcing();
        GridBagConstraints constraints = new GridBagConstraints();
        ret.setLayout(new GridBagLayout());
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.weightx = 1.0;
        this.OKButton = new JButton(Messages.getString("WindowsConfig1.25"));
        this.OKButton.setIcon(new ImageIcon(icon.loadImageResource("resource", "button_ok.png")));
        this.OKButton.addActionListener(this);
        ret.add((Component)this.OKButton, constraints);
        constraints.anchor = 12;
        this.AbbrechenButton = new JButton(Messages.getString("WindowsConfig1.28"));
        this.AbbrechenButton.setIcon(new ImageIcon(icon.loadImageResource("resource", "remove.png")));
        this.AbbrechenButton.addActionListener(this);
        ret.add((Component)this.AbbrechenButton, constraints);
        Border bd1 = BorderFactory.createEtchedBorder();
        ret.setBorder(bd1);
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            String file;
            if (e.getSource() == this.AbbrechenButton) {
                this.setVisible(false);
                this.dispose();
            }
            if (e.getSource() == this.OKButton) {
                this.save();
                this.setVisible(false);
                this.dispose();
            }
            if (e.getSource() == this.buttonFilechooser && (file = this.fileChooser(this)) != null) {
                this.textfeldLanguageFile.setText(file);
            }
            if (e.getSource() == this.buttonFilechooser2 && (file = this.fileChooser(this)) != null) {
                this.textfeldBrowserPath.setText(file);
            }
            if (e.getSource() == this.buttonFilechooser3 && (file = this.fileChooser(this)) != null) {
                this.textfeldOperaLanguageFile.setText(file);
            }
        }
        if (e.getSource() instanceof JComboBox && e.getSource() == this.languageComboBox) {
            this.textfeldLanguageFile.setText("");
        }
    }

    private void save() {
        if (this.firstLanguage != this.languageComboBox.getSelectedIndex()) {
            this.getLanguageProperty();
            this.spracheGeaendert = true;
        }
        if (!this.firstExternLanguage.equals(this.textfeldLanguageFile.getText())) {
            ConfigProperties.SearchEditProps.setProperty("SearchEditLanguageFile", this.textfeldLanguageFile.getText());
            this.spracheGeaendert = true;
        }
        ConfigProperties.SearchEditProps.setProperty("BrowserPath", this.textfeldBrowserPath.getText());
        if (this.checkboxStartbildschirm.isSelected()) {
            ConfigProperties.SearchEditProps.setProperty("startbildschirm", "1");
        } else {
            ConfigProperties.SearchEditProps.setProperty("startbildschirm", "0");
        }
        if (!ConfigProperties.SearchEditProps.getProperty("OperaLanguageFile", "").equals(this.textfeldOperaLanguageFile.getText())) {
            ConfigProperties.SearchEditProps.setProperty("OperaLanguageFile", this.textfeldOperaLanguageFile.getText());
            Thread t1 = new Thread(){

                public void run() {
                    ReadLanguageFile.refreshLanguageFile();
                    ReadLanguageFile.readOperaLanguageFile();
                }
            };
            t1.setPriority(1);
            t1.start();
        }
    }

    private void getLanguageProperty() {
        switch (this.languageComboBox.getSelectedIndex()) {
            case 0: {
                ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_en_GB");
                break;
            }
            case 1: {
                ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_de_DE");
                break;
            }
            case 2: {
                ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_fr_FR");
                break;
            }
            case 3: {
                ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_lb_LU");
                break;
            }
            default: {
                ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_en_GB");
            }
        }
    }

    private String fileChooser(JDialog dialog) {
        File filename = null;
        String ret = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("WindowsConfig1.44"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        if (chooser.showOpenDialog(dialog) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                filename = filetemp;
            } else {
                filename = null;
                System.out.println(filetemp + " " + Messages.getString("WindowsConfig1.46"));
                JOptionPane.showMessageDialog(dialog, filetemp + " " + Messages.getString("WindowsConfig1.48"), Messages.getString("WindowsConfig1.49"), 0);
            }
            ret = filename.toString();
        }
        detail.testAndSaveView(chooser.getComponents());
        return ret;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    public boolean isSpracheGeaendert() {
        return this.spracheGeaendert;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.labelURL) {
            BrowserControl.displayURL("http://my.opera.com/SearchEdit/forums/forum.dml?id=10851");
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

