/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import statischeVariablen.StaticVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOpenSearch {
    private String encoding = "";
    private String isPost = "";
    private String query = "";

    public void fileSaveAs(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.export(filename.toString(), frame);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("ExportOpenSearch2.3"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"xml"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.xml   " + Messages.getString("ExportOpenSearch2.4") + " XML";
            }
        });
        if (chooser.showSaveDialog(frame) == 0) {
            String dateiname = null;
            dateiname = chooser.getSelectedFile().toString().toLowerCase().endsWith(".xml") ? chooser.getSelectedFile().toString() : chooser.getSelectedFile() + ".xml";
            File filetemp = new File(dateiname);
            if (filetemp.exists()) {
                int retVal = JOptionPane.showConfirmDialog(frame, String.valueOf(Messages.getString("ExportOpenSearch2.8")) + " \"" + filetemp + "\" " + Messages.getString("ExportOpenSearch2.11"));
                if (retVal != 2) {
                    filename = retVal == 0 ? filetemp : this.fileChooser(frame);
                }
            } else {
                filename = filetemp;
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    private void export(String filename, JFrame frame) {
        int actualRow = StaticVariables.table.getSelectedRow();
        if (actualRow < 0) {
            return;
        }
        this.restlichePropsAuslesen(actualRow);
        Document doc = new Document();
        Format format = Format.getPrettyFormat();
        XMLOutputter xmlOut = new XMLOutputter(format);
        Namespace ns = Namespace.getNamespace("http://a9.com/-/spec/opensearch/1.1/");
        Element root = new Element("OpenSearchDescription");
        doc.setRootElement(root);
        root.setNamespace(ns);
        Element name = new Element("ShortName", ns);
        name.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 0));
        root.addContent(name);
        Element descript = new Element("Description", ns);
        descript.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 0));
        root.addContent(descript);
        Element url = new Element("Url", ns);
        url.setAttribute("type", "text/html");
        if (this.isPost != null && this.isPost.length() > 0) {
            url.setAttribute("method", this.isPost);
        }
        url.setAttribute("template", this.replace((String)StaticVariables.tableModel.getValueAt(actualRow, 3), "%s", "{searchTerms}"));
        if (this.query != null && this.query.length() > 0) {
            String[] value;
            Vector<Object> vec = new Vector();
            vec = this.prepareQuery(this.query);
            String[] names = (String[])vec.firstElement();
            if (names.length == (value = (String[])vec.lastElement()).length) {
                int i = 0;
                while (i < value.length) {
                    Element param = new Element("Param", ns);
                    param.setAttribute("name", names[i]);
                    param.setAttribute("value", value[i]);
                    url.addContent(param);
                    ++i;
                }
            } else {
                String arg0 = Messages.getString("ExportOpenSearch2.26");
                System.out.println(arg0);
                StaticVariables.labelStatuszeile.setText(arg0);
            }
        }
        root.addContent(url);
        if (this.encoding != null && this.encoding.length() > 0) {
            Element encode = new Element("InputEncoding", ns);
            encode.setText(this.encoding);
            root.addContent(encode);
        }
        try {
            xmlOut.output(doc, (OutputStream)new FileOutputStream(filename));
            StaticVariables.labelStatuszeile.setText(String.valueOf(Messages.getString("ExportOpenSearch2.28")) + " " + filename + " " + Messages.getString("ExportOpenSearch2.31"));
            System.out.println(String.valueOf(Messages.getString("ExportOpenSearch2.32")) + " " + filename + " " + Messages.getString("ExportOpenSearch2.35"));
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
            StaticVariables.labelStatuszeile.setText(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
            StaticVariables.labelStatuszeile.setText(e.toString());
        }
    }

    private void restlichePropsAuslesen(int aktuelleZeile) {
        Enumeration<String> enumera = StaticVariables.tableModel.getRestlicheProperties(aktuelleZeile).elements();
        while (enumera.hasMoreElements()) {
            int index;
            String prop = enumera.nextElement().toString();
            if (prop.startsWith("Encoding=")) {
                index = prop.indexOf(61);
                this.encoding = prop.substring(index + 1).toUpperCase();
            }
            if (prop.startsWith("Query=")) {
                index = prop.indexOf(61);
                this.query = prop.substring(index + 1);
            }
            if (!prop.startsWith("Is post=")) continue;
            index = prop.indexOf(61);
            if (prop.length() < index) continue;
            this.isPost = prop.substring(index + 1).equals("1") ? "POST" : "GET";
        }
    }

    private Vector<String[]> prepareQuery(String query) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.replace(query, "%s", "{searchTerms}"));
        Pattern attrib = Pattern.compile("&");
        String[] pieces = attrib.split(sb);
        Vector<String[]> vec = new Vector<String[]>();
        if (pieces.length > 1) {
            String[] name = new String[pieces.length];
            String[] value = new String[pieces.length];
            int i = 0;
            while (i < pieces.length) {
                attrib = Pattern.compile("=");
                String[] variab = attrib.split(pieces[i]);
                if (variab.length == 2) {
                    name[i] = variab[0];
                    value[i] = variab[1];
                } else if (variab.length == 1) {
                    name[i] = variab[0];
                    value[i] = "";
                } else {
                    name[i] = "";
                    value[i] = "";
                    System.out.println(Messages.getString("ExportOpenSearch2.49"));
                }
                ++i;
            }
            vec.add(name);
            vec.add(value);
        } else if (pieces.length == 1) {
            String[] name = new String[1];
            String[] value = new String[1];
            name[0] = pieces[0];
            value[0] = "";
            vec.add(name);
            vec.add(value);
        } else if (pieces.length == 0) {
            String[] name = new String[1];
            String[] value = new String[1];
            name[0] = "";
            value[0] = "";
            vec.add(name);
            vec.add(value);
        }
        return vec;
    }

    private String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
}

