/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.DateTime;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import statischeVariablen.StaticProgramName;
import statischeVariablen.StaticVariables;

public class ExportSearchEditFormat {
    public void fileSaveAs(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.export(filename.toString(), frame);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("ExportSearchEditFormat2.0"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"se"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.se   " + Messages.getString("ExportSearchEditFormat2.2") + " SE";
            }
        });
        if (chooser.showSaveDialog(frame) == 0) {
            String dateiname = null;
            dateiname = chooser.getSelectedFile().toString().toLowerCase().endsWith(".se") ? chooser.getSelectedFile().toString() : chooser.getSelectedFile() + ".se";
            File filetemp = new File(dateiname);
            if (filetemp.exists()) {
                int retVal = JOptionPane.showConfirmDialog(frame, String.valueOf(Messages.getString("ExportSearchEditFormat2.6")) + " \"" + filetemp + "\" " + Messages.getString("ExportSearchEditFormat2.9"));
                if (retVal != 2) {
                    filename = retVal == 0 ? filetemp : this.fileChooser(frame);
                }
            } else {
                filename = filetemp;
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    private void export(String filename, JFrame frame) {
        int actualRow = StaticVariables.table.getSelectedRow();
        if (actualRow < 0) {
            return;
        }
        DateTime date = new DateTime();
        Document doc = new Document();
        Format format = Format.getPrettyFormat();
        XMLOutputter xmlOut = new XMLOutputter(format);
        doc.addContent(new Comment("Diese Datei wurde mit " + StaticProgramName.getProgramNamePlusVersionAndBuild() + " erstellt."));
        doc.addContent(new Comment(String.valueOf(StaticProgramName.getProgramName()) + " steht unter GPL."));
        doc.addContent(new Comment("Download: http://my.opera.com/SearchEdit/"));
        Element root = new Element("SearchEdit");
        doc.setRootElement(root);
        root.setAttribute("PROGRAMSTRING", StaticProgramName.getProgramName());
        root.setAttribute("VERSION", StaticProgramName.getVersion());
        root.setAttribute("BUILD", StaticProgramName.getBuild());
        root.setAttribute("FILEVERSION", StaticProgramName.getSearchEditFileVersion());
        root.setAttribute("SAVED", date.getDateTime());
        Element name = new Element("name");
        name.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 0));
        root.addContent(name);
        Element nameid = new Element("nameid");
        nameid.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 1));
        root.addContent(nameid);
        Element key = new Element("key");
        key.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 2));
        root.addContent(key);
        Element url = new Element("url");
        url.setText((String)StaticVariables.tableModel.getValueAt(actualRow, 3));
        root.addContent(url);
        Element delete = new Element("deleted");
        if (StaticVariables.tableModel.getValueAt(actualRow, 4).toString().equals("false")) {
            delete.setText("0");
        } else {
            delete.setText("1");
        }
        root.addContent(delete);
        Element sep = new Element("separator");
        if (StaticVariables.tableModel.getValueAt(actualRow, 5).toString().equals("false")) {
            sep.setText("0");
        } else {
            sep.setText("1");
        }
        root.addContent(sep);
        this.restlicheProps(root, actualRow);
        try {
            xmlOut.output(doc, (OutputStream)new FileOutputStream(filename));
            StaticVariables.labelStatuszeile.setText(String.valueOf(Messages.getString("ExportSearchEditFormat2.32")) + " " + filename + " " + Messages.getString("ExportSearchEditFormat2.35"));
            System.out.println(String.valueOf(Messages.getString("ExportSearchEditFormat2.36")) + " " + filename + " " + Messages.getString("ExportSearchEditFormat2.39"));
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
            StaticVariables.labelStatuszeile.setText(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
            StaticVariables.labelStatuszeile.setText(e.toString());
        }
    }

    private void restlicheProps(Element root, int aktuelleZeile) {
        Enumeration<String> enumera = StaticVariables.tableModel.getRestlicheProperties(aktuelleZeile).elements();
        int zaehler = 0;
        while (enumera.hasMoreElements()) {
            String prop = enumera.nextElement().toString();
            if (prop.startsWith("ID=")) {
                root.addContent(new Comment(Messages.getString("ExportSearchEditFormat2.41")));
            }
            Element child = new Element("node");
            child.setAttribute("NAME", prop);
            root.addContent(child);
            ++zaehler;
        }
    }
}

