/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libs.file.Messages;

public class FileHandling {
    public String currentdir(String dateipfad) {
        File fil = new File(dateipfad);
        return String.valueOf(String.valueOf(fil.getAbsolutePath())) + File.separator;
    }

    public void copyFile(File src, File dest, boolean force) throws IOException {
        int bufSize = 1000;
        if (dest.exists()) {
            if (force) {
                dest.delete();
            } else {
                throw new IOException(String.valueOf(Messages.getString("FileHandling.0")) + ":  " + dest.getName());
            }
        }
        byte[] buffer = new byte[bufSize];
        int read = 0;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                finally {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
    }
}

