/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import libs.komponenten.TableMaxID;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import statischeVariablen.StaticVariables;

public class ImportOpenSearch {
    private int IDMax = -1;

    public void open(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.importOpenSearch(frame, filename);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("ImportOpenSearch2.0"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"xml"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.xml   " + Messages.getString("ImportOpenSearch2.1") + " XML";
            }
        });
        if (chooser.showOpenDialog(frame) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                filename = filetemp;
            } else {
                filename = null;
                System.out.println(filetemp + " " + Messages.getString("ImportOpenSearch2.4"));
                JOptionPane.showMessageDialog(frame, filetemp + " " + Messages.getString("ImportOpenSearch2.6"), Messages.getString("ImportOpenSearch2.7"), 0);
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private void importOpenSearch(JFrame frame, File filename) {
        StaticVariables.table.removeEditor();
        int actualRow = StaticVariables.tableModel.getRowCount();
        String name = "";
        String encode = "";
        String url = "";
        String post = "";
        String query = "";
        Object saxDriverClass = null;
        Element rootElement = null;
        try {
            SAXBuilder builder = null;
            builder = saxDriverClass == null ? new SAXBuilder() : new SAXBuilder("");
            Document doc = builder.build(filename);
            rootElement = doc.getRootElement();
        }
        catch (Exception e) {
            System.out.println("initXml Exception: " + e.toString());
            JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("ImportOpenSearch2.17"), Messages.getString("ImportOpenSearch2.18"), 0);
            StaticVariables.labelStatuszeile.setText(Messages.getString("ImportOpenSearch2.19"));
            return;
        }
        if (rootElement != null) {
            Element LongNameElement;
            if (rootElement.getName() != "OpenSearchDescription") {
                JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("ImportOpenSearch2.22"), Messages.getString("ImportOpenSearch2.23"), 0);
                System.out.println(filename + "  " + Messages.getString("ImportOpenSearch2.25"));
                StaticVariables.labelStatuszeile.setText(Messages.getString("ImportOpenSearch2.26"));
                return;
            }
            Namespace ns = rootElement.getNamespace();
            if (!ns.getURI().equals("http://a9.com/-/spec/opensearch/1.1/")) {
                JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("ImportOpenSearch2.29"), Messages.getString("ImportOpenSearch2.30"), 0);
                System.out.println(filename + "  " + Messages.getString("ImportOpenSearch2.32"));
                StaticVariables.labelStatuszeile.setText(Messages.getString("ImportOpenSearch2.33"));
                return;
            }
            Element nameElement = rootElement.getChild("ShortName", ns);
            name = nameElement == null ? ((LongNameElement = rootElement.getChild("LongName", ns)) == null ? "" : LongNameElement.getText()) : nameElement.getText();
            Element encodeElement = rootElement.getChild("InputEncoding", ns);
            encode = encodeElement == null ? "" : encodeElement.getText().toLowerCase();
            TableMaxID max = new TableMaxID();
            this.IDMax = max.setIDMax();
            List elementList = rootElement.getChildren();
            for (Element element : elementList) {
                Vector<String> hauptProps = new Vector<String>();
                Vector<String> restlicheProps = new Vector<String>();
                if (element.getName() != "Url" || element.getAttribute("type") == null || !element.getAttribute("type").getValue().toLowerCase().equals("text/html")) continue;
                url = element.getAttribute("template") != null ? element.getAttribute("template").getValue() : (element.getText() != null ? element.getText().toLowerCase() : "");
                if (element.getChildren() != null) {
                    List urlList = element.getChildren();
                    for (Element currentElement : urlList) {
                        if (!currentElement.getName().equals("Param") || currentElement.getAttribute("name") == null || currentElement.getAttribute("value") == null) continue;
                        query = query.length() == 0 ? String.valueOf(currentElement.getAttribute("name").getValue()) + "=" + currentElement.getAttribute("value").getValue() : String.valueOf(query) + "&" + currentElement.getAttribute("name").getValue() + "=" + currentElement.getAttribute("value").getValue();
                    }
                }
                post = element.getAttribute("method") != null ? (element.getAttribute("method").getValue().toLowerCase().equals("post") ? "1" : "0") : "0";
                url = this.modifyURL(url);
                query = this.modifyURL(query);
                if (name != null) {
                    hauptProps.add(name);
                } else {
                    hauptProps.add("");
                }
                hauptProps.add("0");
                hauptProps.add("");
                hauptProps.add(url);
                hauptProps.add("0");
                hauptProps.add("0");
                restlicheProps.add("Query=" + query);
                restlicheProps.add("ID=" + (this.IDMax + 1));
                ++this.IDMax;
                restlicheProps.add("Is post=" + post);
                if (encode != null) {
                    restlicheProps.add("Encoding=" + encode);
                } else {
                    restlicheProps.add("Encoding=");
                }
                restlicheProps.add("Verbtext=0");
                restlicheProps.add("Search Type=0");
                restlicheProps.add("Position=-1");
                StaticVariables.tableModel.add(hauptProps);
                StaticVariables.tableModel.addRestlicheProperties(restlicheProps);
            }
            if (StaticVariables.tableModel.getRowCount() > actualRow) {
                StaticVariables.table.setRowSelectionInterval(actualRow, actualRow);
            }
            JOptionPane.showMessageDialog(frame, String.valueOf(Messages.getString("ImportOpenSearch2.75")) + "\n" + Messages.getString("ImportOpenSearch2.77"), Messages.getString("ImportOpenSearch2.78"), 1);
        }
    }

    private String modifyURL(String url) {
        if (url != null && url.length() > 0) {
            StringBuffer sb = new StringBuffer(1000);
            sb.append(this.replace(url, "{searchTerms}", "%s"));
            String newUrl = null;
            Pattern attrib = Pattern.compile("\\{");
            String[] pieces = attrib.split(sb);
            if (pieces.length > 1) {
                attrib = null;
                attrib = Pattern.compile("&amp;");
                pieces = null;
                pieces = attrib.split(sb);
                if (pieces.length > 1) {
                    newUrl = this.killKlammerTeile(pieces, "&amp;");
                } else {
                    attrib = null;
                    attrib = Pattern.compile("&");
                    pieces = null;
                    pieces = attrib.split(sb);
                    newUrl = pieces.length > 1 ? this.killKlammerTeile(pieces, "&") : pieces[0];
                }
            }
            if (newUrl != null) {
                sb.delete(0, sb.length());
                sb.append(newUrl);
            }
            return sb.toString();
        }
        return "";
    }

    private String killKlammerTeile(String[] pieces, String trenner) {
        boolean index = false;
        StringBuffer sb = new StringBuffer(1000);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].indexOf("{") < 0) {
                sb.append(String.valueOf(pieces[i]) + trenner);
            }
            ++i;
        }
        if (sb.length() > trenner.length()) {
            sb.delete(sb.length() - trenner.length(), sb.length());
        }
        return sb.toString();
    }

    private String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }
}

