/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import libs.komponenten.TableMaxID;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import statischeVariablen.StaticVariables;

public class ImportSearchEditFormat {
    private int IDMax = -1;

    public void open(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.importSearchEdit(frame, filename);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("ImportSearchEditFormat2.0"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"se"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.se   " + Messages.getString("ImportSearchEditFormat2.1") + " SE";
            }
        });
        if (chooser.showOpenDialog(frame) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                filename = filetemp;
            } else {
                filename = null;
                System.out.println(filetemp + " " + Messages.getString("ImportSearchEditFormat2.4"));
                JOptionPane.showMessageDialog(frame, filetemp + " " + Messages.getString("ImportSearchEditFormat2.6"), Messages.getString("ImportSearchEditFormat2.7"), 0);
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private void importSearchEdit(JFrame frame, File filename) {
        StaticVariables.table.removeEditor();
        int actualRow = StaticVariables.tableModel.getRowCount();
        Object saxDriverClass = null;
        Element rootElement = null;
        try {
            SAXBuilder builder = null;
            builder = saxDriverClass == null ? new SAXBuilder() : new SAXBuilder("");
            Document doc = builder.build(filename);
            rootElement = doc.getRootElement();
        }
        catch (Exception e) {
            System.out.println("initXml Exception: " + e.toString());
            JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("ImportSearchEditFormat2.11"), Messages.getString("ImportSearchEditFormat2.12"), 0);
            StaticVariables.labelStatuszeile.setText(Messages.getString("ImportSearchEditFormat2.13"));
            return;
        }
        if (rootElement != null) {
            if (rootElement.getName() != "SearchEdit") {
                JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("ImportSearchEditFormat2.16"), Messages.getString("ImportSearchEditFormat2.17"), 0);
                System.out.println(filename + " " + Messages.getString("ImportSearchEditFormat2.19"));
                StaticVariables.labelStatuszeile.setText(Messages.getString("ImportSearchEditFormat2.20"));
                return;
            }
            Vector<String> hauptProps = new Vector<String>();
            Vector<String> restlicheProps = new Vector<String>();
            Element el = rootElement.getChild("name");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            el = rootElement.getChild("nameid");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            el = rootElement.getChild("key");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            el = rootElement.getChild("url");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            el = rootElement.getChild("deleted");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            el = rootElement.getChild("separator");
            if (el != null) {
                hauptProps.add(el.getText());
            } else {
                hauptProps.add("");
            }
            TableMaxID max = new TableMaxID();
            this.IDMax = max.setIDMax();
            List queriesList = rootElement.getChildren("node");
            if (queriesList != null && queriesList.size() > 0) {
                for (Element currentElement : queriesList) {
                    if (!currentElement.getName().equals("node") || currentElement.getAttribute("NAME") == null) continue;
                    if (currentElement.getAttribute("NAME").getValue().startsWith("ID=")) {
                        restlicheProps.add("ID=" + (this.IDMax + 1));
                        ++this.IDMax;
                        continue;
                    }
                    restlicheProps.add(currentElement.getAttribute("NAME").getValue());
                }
            }
            StaticVariables.tableModel.add(hauptProps);
            StaticVariables.tableModel.addRestlicheProperties(restlicheProps);
            if (StaticVariables.tableModel.getRowCount() > actualRow) {
                StaticVariables.table.setRowSelectionInterval(actualRow, actualRow);
            }
            StaticVariables.labelStatuszeile.setText(filename + " " + Messages.getString("ImportSearchEditFormat2.41"));
            System.out.println(filename + " " + Messages.getString("ImportSearchEditFormat2.43"));
        }
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }
}

