/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import statischeVariablen.StaticSystemProperties;
import statischeVariablen.StaticVariables;

public class IniReader {
    public void open(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.iniLesen(frame, filename);
        }
    }

    public void openFromConsole(JFrame frame, File file) {
        if (file != null && !file.toString().equals("")) {
            this.iniLesen(frame, file);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("IniReader.2"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"ini"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.ini   " + Messages.getString("IniReader.6");
            }
        });
        if (chooser.showOpenDialog(frame) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                filename = filetemp;
            } else {
                filename = null;
                System.out.println(filetemp + " " + Messages.getString("IniReader.8"));
                JOptionPane.showMessageDialog(frame, filetemp + " " + Messages.getString("IniReader.10"), Messages.getString("IniReader.11"), 0);
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    private void iniLesen(JFrame frame, File filename) {
        StaticVariables.setReadCanceled = true;
        StaticVariables.tableModel.clear(false);
        String name = "";
        String nameid = "";
        String key = "";
        String url = "";
        String geloescht = "";
        String endsep = "";
        String line = null;
        Vector<String> properties = new Vector<String>();
        int zeile = 0;
        StaticVariables.fileHeader.setLength(0);
        StaticVariables.fileVersion.setLength(0);
        InputStreamReader in = null;
        BufferedReader f = null;
        try {
            Vector<String> row;
            in = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8");
            f = new BufferedReader(in);
            while ((line = f.readLine()) != null) {
                ++zeile;
                if ((line = line.trim()).equals("")) continue;
                if (line.length() >= 26 && (line.substring(0, 25).equals("Opera Preferences version") || line.substring(1, 26).equals("Opera Preferences version"))) {
                    StaticVariables.fileHeader.append(line.toString());
                    StaticVariables.fileHeader.append(StaticSystemProperties.linesep);
                    continue;
                }
                if (zeile == 1) {
                    System.out.println(String.valueOf(Messages.getString("IniReader.25")) + filename);
                    JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("IniReader.27"), Messages.getString("IniReader.28"), 0);
                    StaticVariables.labelStatuszeile.setText(" ");
                    throw new IOException(Messages.getString("IniReader.30"));
                }
                if (line.startsWith(";")) {
                    StaticVariables.fileHeader.append(line);
                    StaticVariables.fileHeader.append(StaticSystemProperties.linesep);
                    continue;
                }
                if (line.length() >= 9 && line.substring(0, 8).equals("[Version")) {
                    StaticVariables.fileVersion.append(line);
                    StaticVariables.fileVersion.append(StaticSystemProperties.linesep);
                    continue;
                }
                if (line.length() >= 13 && line.substring(0, 12).equals("File Version")) {
                    StaticVariables.fileVersion.append(line);
                    StaticVariables.fileVersion.append(StaticSystemProperties.linesep);
                    continue;
                }
                if (line.length() >= 15 && line.substring(0, 14).equals("[Search Engine")) {
                    row = new Vector();
                    row.addElement(name);
                    row.addElement(nameid);
                    row.addElement(key);
                    row.addElement(url);
                    row.addElement(geloescht);
                    row.addElement(endsep);
                    StaticVariables.tableModel.add(row);
                    StaticVariables.tableModel.addRestlicheProperties(properties);
                    name = "";
                    nameid = "";
                    key = "";
                    url = "";
                    geloescht = "";
                    endsep = "";
                    properties = null;
                    properties = new Vector();
                    continue;
                }
                int index = line.indexOf(61);
                if (index < 0) {
                    System.out.println(String.valueOf(Messages.getString("IniReader.41")) + " =: " + line);
                    throw new IOException(Messages.getString("IniReader.43"));
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Name")) {
                    name = line.substring(index + 1);
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Nameid")) {
                    nameid = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("URL")) {
                    url = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Key")) {
                    key = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Deleted")) {
                    geloescht = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Has endseparator")) {
                    endsep = line.substring(index + 1).trim();
                    continue;
                }
                properties.add(line);
            }
            row = new Vector<String>();
            row.addElement(name);
            row.addElement(nameid);
            row.addElement(key);
            row.addElement(url);
            row.addElement(geloescht);
            row.addElement(endsep);
            StaticVariables.tableModel.add(row);
            StaticVariables.tableModel.addRestlicheProperties(properties);
            StaticVariables.tableModel.deleteRow(0);
            if (StaticVariables.tableModel.getRowCount() > 0) {
                StaticVariables.table.setRowSelectionInterval(0, 0);
            }
            StaticVariables.filename = null;
            StaticVariables.filename = filename.toString();
            StaticVariables.clearFilechanged();
            StaticVariables.labelStatuszeile.setText(filename + " " + Messages.getString("IniReader.51"));
            System.out.println(filename + " " + Messages.getString("IniReader.53"));
            StaticVariables.setReadCanceled = false;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

