/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import libs.komponenten.TableMaxID;
import statischeVariablen.StaticVariables;

public class IniReaderInsert {
    private int IDMax = -1;

    public void open(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.iniLesen(frame, filename);
        }
    }

    public void openFromConsole(JFrame frame, File file) {
        if (file != null && !file.toString().equals("")) {
            this.iniLesen(frame, file);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("IniReaderInsert1.2"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"ini"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.ini   " + Messages.getString("IniReaderInsert1.6");
            }
        });
        if (chooser.showOpenDialog(frame) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                filename = filetemp;
            } else {
                filename = null;
                System.out.println(filetemp + " " + Messages.getString("IniReaderInsert1.8"));
                JOptionPane.showMessageDialog(frame, filetemp + " " + Messages.getString("IniReaderInsert1.10"), Messages.getString("IniReaderInsert1.11"), 0);
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    private void iniLesen(JFrame frame, File filename) {
        TableMaxID max = new TableMaxID();
        this.IDMax = max.setIDMax();
        int actualRow = StaticVariables.tableModel.getRowCount();
        String name = "";
        String nameid = "";
        String key = "";
        String url = "";
        String geloescht = "";
        String endsep = "";
        String line = null;
        Vector<String> properties = new Vector<String>();
        int zeile = 0;
        InputStreamReader in = null;
        BufferedReader f = null;
        try {
            Vector<String> row;
            in = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8");
            f = new BufferedReader(in);
            while ((line = f.readLine()) != null) {
                ++zeile;
                if ((line = line.trim()).equals("") || line.length() >= 26 && (line.substring(0, 25).equals("Opera Preferences version") || line.substring(1, 26).equals("Opera Preferences version"))) continue;
                if (zeile == 1) {
                    System.out.println(String.valueOf(Messages.getString("IniReaderInsert1.24")) + " " + filename);
                    JOptionPane.showMessageDialog(frame, filename + " " + Messages.getString("IniReaderInsert1.27"), Messages.getString("IniReaderInsert1.28"), 0);
                    StaticVariables.labelStatuszeile.setText(" ");
                    throw new IOException(Messages.getString("IniReaderInsert1.30"));
                }
                if (line.startsWith(";") || line.length() >= 9 && line.substring(0, 8).equals("[Version") || line.length() >= 13 && line.substring(0, 12).equals("File Version")) continue;
                if (line.length() >= 15 && line.substring(0, 14).equals("[Search Engine")) {
                    row = new Vector();
                    row.addElement(name);
                    row.addElement(nameid);
                    row.addElement(key);
                    row.addElement(url);
                    row.addElement(geloescht);
                    row.addElement(endsep);
                    StaticVariables.tableModel.add(row);
                    StaticVariables.tableModel.addRestlicheProperties(properties);
                    name = "";
                    nameid = "";
                    key = "";
                    url = "";
                    geloescht = "";
                    endsep = "";
                    properties = null;
                    properties = new Vector();
                    continue;
                }
                int index = line.indexOf(61);
                if (index < 0) {
                    System.out.println(String.valueOf(Messages.getString("IniReaderInsert1.41")) + " =: " + line);
                    throw new IOException(Messages.getString("IniReaderInsert1.43"));
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Name")) {
                    name = line.substring(index + 1);
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Nameid")) {
                    nameid = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("URL")) {
                    url = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Key")) {
                    key = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Deleted")) {
                    geloescht = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("Has endseparator")) {
                    endsep = line.substring(index + 1).trim();
                    continue;
                }
                if (line.length() >= index && line.substring(0, index).trim().equals("ID")) {
                    int id = Integer.valueOf(line.substring(index + 1));
                    if (id > this.IDMax) {
                        this.IDMax = id;
                        line = "ID=" + id;
                    } else {
                        line = "ID=" + (this.IDMax + 1);
                        ++this.IDMax;
                    }
                }
                properties.add(line);
            }
            row = new Vector<String>();
            row.addElement(name);
            row.addElement(nameid);
            row.addElement(key);
            row.addElement(url);
            row.addElement(geloescht);
            row.addElement(endsep);
            StaticVariables.tableModel.add(row);
            StaticVariables.tableModel.addRestlicheProperties(properties);
            if (StaticVariables.tableModel.getRowCount() > actualRow) {
                StaticVariables.tableModel.deleteRow(actualRow);
                StaticVariables.table.setRowSelectionInterval(actualRow, actualRow);
            }
            StaticVariables.labelStatuszeile.setText(filename + " " + Messages.getString("IniReaderInsert1.51"));
            System.out.println(filename + " " + Messages.getString("IniReaderInsert1.53"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

