/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import libs.FileChooserListOrDetailView;
import libs.file.ConfigProperties;
import libs.file.FileHandling;
import libs.file.Messages;
import statischeVariablen.StaticSystemProperties;
import statischeVariablen.StaticVariables;

public class IniWriter {
    public void fileSave(JFrame frame) {
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            this.fileSaveAs(frame);
            return;
        }
        File filetemp = new File(StaticVariables.filename);
        if (!filetemp.exists()) {
            this.fileSaveAs(frame);
            return;
        }
        FileHandling filehand = new FileHandling();
        boolean fileExist = true;
        int i = 0;
        File filenew = null;
        while (fileExist) {
            filenew = new File(String.valueOf(StaticVariables.filename) + ++i + ".bak");
            if (filenew.exists()) continue;
            fileExist = false;
        }
        try {
            filehand.copyFile(filetemp, filenew, false);
        }
        catch (IOException e) {
            System.out.println(Messages.getString("IniWriter.2"));
            System.out.println(e.toString());
        }
        this.speichern(StaticVariables.filename, frame);
    }

    public void fileSaveAs(JFrame frame) {
        File filename = null;
        filename = this.fileChooser(frame);
        if (filename != null && !filename.toString().equals("")) {
            this.speichern(filename.toString(), frame);
        }
    }

    private File fileChooser(JFrame frame) {
        File filename = null;
        JFileChooser chooser = new JFileChooser(this.getStartPath());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("IniWriter.1"));
        chooser.setFileHidingEnabled(false);
        FileChooserListOrDetailView detail = new FileChooserListOrDetailView();
        if (ConfigProperties.SearchEditProps.getProperty("FileChooserDetailListView", "0").equals("0")) {
            detail.showDetailsView(chooser.getComponents());
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String[] extensions = new String[]{"ini"};
                if (file.isDirectory()) {
                    return true;
                }
                boolean found = false;
                int index = 0;
                while (!found && index < extensions.length) {
                    found = file.getName().toUpperCase().endsWith("." + extensions[index].toUpperCase());
                    ++index;
                }
                return found;
            }

            public String getDescription() {
                return "*.ini   " + Messages.getString("IniWriter.8");
            }
        });
        if (chooser.showSaveDialog(frame) == 0) {
            File filetemp = chooser.getSelectedFile();
            if (filetemp.exists()) {
                int retVal = JOptionPane.showConfirmDialog(frame, String.valueOf(Messages.getString("IniWriter.9")) + " \"" + filetemp + "\" " + Messages.getString("IniWriter.12"));
                if (retVal != 2) {
                    filename = retVal == 0 ? filetemp : this.fileChooser(frame);
                }
            } else {
                filename = filetemp;
            }
        }
        detail.testAndSaveView(chooser.getComponents());
        return filename;
    }

    private String getStartPath() {
        String path = null;
        if (StaticVariables.filename == null || StaticVariables.filename.equals("")) {
            path = ConfigProperties.SearchEditProps.getProperty("FileChooserPath", "");
        } else {
            FileHandling getPath = new FileHandling();
            path = getPath.currentdir(StaticVariables.filename);
        }
        return path;
    }

    private void speichern(String filename, JFrame frame) {
        StringBuffer sb = this.getContent(frame);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
            out.write(sb.toString());
            ((Writer)out).close();
            StaticVariables.filename = null;
            StaticVariables.filename = filename.toString();
            StaticVariables.clearFilechanged();
            StaticVariables.labelStatuszeile.setText(String.valueOf(filename) + " " + Messages.getString("IniWriter.18"));
            System.out.println(String.valueOf(filename) + " " + Messages.getString("IniWriter.20"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private StringBuffer getContent(JFrame frame) {
        StaticVariables.table.removeEditor();
        if (!this.testKey()) {
            JOptionPane.showMessageDialog(frame, Messages.getString("IniWriter2.0"), Messages.getString("IniWriter2.1"), 2);
        }
        StringBuffer sb = new StringBuffer(10000);
        sb.append(StaticVariables.fileHeader.toString());
        sb.append(StaticSystemProperties.linesep);
        sb.append(StaticVariables.fileVersion.toString());
        sb.append(StaticSystemProperties.linesep);
        if (StaticVariables.tableModel.getRowCount() > 0) {
            int i = 0;
            while (StaticVariables.tableModel.getRowCount() > i) {
                sb.append("[Search Engine " + (i + 1) + "]");
                sb.append(StaticSystemProperties.linesep);
                Vector<String> daten = null;
                daten = StaticVariables.tableModel.getRowValues(i);
                String name = daten.get(0).toString();
                String nameid = daten.get(1).toString();
                String key = daten.get(2).toString();
                String url = daten.get(3).toString();
                String geloescht = daten.get(4).toString();
                String seperator = daten.get(5).toString();
                sb.append("Name=");
                sb.append(name);
                sb.append(StaticSystemProperties.linesep);
                sb.append("URL=");
                sb.append(url);
                sb.append(StaticSystemProperties.linesep);
                sb.append("Key=");
                sb.append(key);
                sb.append(StaticSystemProperties.linesep);
                Enumeration<String> enumera2 = null;
                enumera2 = StaticVariables.tableModel.getRestlicheProperties(i).elements();
                while (enumera2.hasMoreElements()) {
                    sb.append((Object)enumera2.nextElement());
                    sb.append(StaticSystemProperties.linesep);
                }
                if (seperator == null || seperator.equals("")) {
                    seperator = "0";
                }
                sb.append("Has endseparator=");
                sb.append(seperator);
                sb.append(StaticSystemProperties.linesep);
                sb.append("Nameid=");
                sb.append(nameid);
                sb.append(StaticSystemProperties.linesep);
                if (geloescht == null || geloescht.equals("")) {
                    geloescht = "0";
                }
                sb.append("Deleted=");
                sb.append(geloescht);
                sb.append(StaticSystemProperties.linesep);
                if (StaticVariables.tableModel.getRowCount() - 1 > i) {
                    sb.append(StaticSystemProperties.linesep);
                }
                ++i;
            }
        }
        return sb;
    }

    private boolean testKey() {
        boolean ret = true;
        if (StaticVariables.tableModel.getRowCount() == 0) {
            ret = true;
        } else {
            int i = 0;
            while (i < StaticVariables.tableModel.getRowCount()) {
                if (StaticVariables.tableModel.getValueAt(i, 2) == null || StaticVariables.tableModel.getValueAt(i, 2).equals("")) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }
}

