/*
 * Decompiled with CFR 0.152.
 */
package libs.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import libs.file.ConfigProperties;

public class Messages {
    private static final String BUNDLE_NAME = "resource.languages.language_de_DE";
    private static Properties languageProps;
    private static String languageFile;

    static {
        languageFile = ConfigProperties.SearchEditProps.getProperty("SearchEditLanguageFile", "");
    }

    public static void getActualLanguage() {
        Messages.readSearchEditConfig();
    }

    public static String getString(String key) {
        String ret = languageProps.getProperty(key, null);
        if (ret == null) {
            ret = Messages.getEnglishProp(key);
        }
        if (ret == null) {
            ret = String.valueOf('!') + key + '!';
        }
        return ret;
    }

    private static String getEnglishProp(String key) {
        Properties tempProps = new Properties();
        try {
            InputStream propIn = Messages.class.getResourceAsStream("/resource/languages/language_en_GB.properties");
            tempProps.load(propIn);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        return tempProps.getProperty(key, null);
    }

    public static void readSearchEditConfig() {
        Object props = null;
        languageProps = new Properties();
        boolean ladeVonIntern = false;
        if (languageFile == null || languageFile.equals("")) {
            ladeVonIntern = true;
        } else {
            File file = new File(languageFile);
            if (!file.exists()) {
                ladeVonIntern = true;
            }
        }
        if (ladeVonIntern) {
            InputStream propIn = null;
            try {
                propIn = Messages.class.getResourceAsStream("/" + ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "resource/languages/language_en_GB") + ".properties");
                languageProps.load(propIn);
                if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").length() < 1) {
                    ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_en_GB");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e.toString());
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        } else {
            FileInputStream propInFile = null;
            try {
                try {
                    propInFile = new FileInputStream(languageFile);
                    languageProps.load(propInFile);
                    if (ConfigProperties.SearchEditProps.getProperty("SearchEditLanguage", "").length() < 1) {
                        ConfigProperties.SearchEditProps.setProperty("SearchEditLanguage", "resource/languages/language_en_GB");
                    }
                }
                catch (FileNotFoundException e1) {
                    System.out.println(e1.toString());
                    try {
                        propInFile.close();
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                    }
                }
                catch (IOException e1) {
                    System.out.println(e1.toString());
                    try {
                        propInFile.close();
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                    }
                }
            }
            finally {
                try {
                    propInFile.close();
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
            }
        }
    }

    public static void setLanguageFile(String languageFile) {
        Messages.languageFile = languageFile;
    }
}

