/*
 * Decompiled with CFR 0.152.
 */
package libs.komponenten;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import libs.file.Messages;
import libs.file.ReadLanguageFile;
import libs.komponenten.MyTableModel;
import statischeVariablen.StaticVariables;

public class TableHauptfenster {
    private int dragTargetRow = -1;
    private int dragFirstRow = -1;

    public JScrollPane getTable() {
        StaticVariables.tableModel = new MyTableModel();
        StaticVariables.table = new JTable(StaticVariables.tableModel);
        StaticVariables.table.setDefaultRenderer(Object.class, new TableRenderer());
        JTableHeader header = StaticVariables.table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumn col = StaticVariables.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(30);
        col = StaticVariables.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(30);
        col = StaticVariables.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(5);
        col = StaticVariables.table.getColumnModel().getColumn(3);
        col.setPreferredWidth(250);
        col = StaticVariables.table.getColumnModel().getColumn(4);
        col.setPreferredWidth(20);
        col = StaticVariables.table.getColumnModel().getColumn(5);
        col.setPreferredWidth(20);
        StaticVariables.table.setSelectionMode(0);
        StaticVariables.table.setDragEnabled(true);
        DropTarget dropTarget = new DropTarget(StaticVariables.table, new RowDropTargetListener());
        this.dragTargetRow = -1;
        JScrollPane sp = new JScrollPane(StaticVariables.table);
        sp.setPreferredSize(new Dimension(390, 190));
        SelectionListener listener = new SelectionListener(StaticVariables.table);
        StaticVariables.table.getSelectionModel().addListSelectionListener(listener);
        StaticVariables.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.setKeyAktion(40);
        this.setKeyAktion(38);
        this.setKeyAktion(10);
        return sp;
    }

    private void setKeyAktion(final int vk_down) {
        InputMap im = StaticVariables.table.getInputMap(1);
        KeyStroke taste = KeyStroke.getKeyStroke(vk_down, 0);
        Object tasteFunktion = im.get(taste);
        final Action alteTasteAktion = StaticVariables.table.getActionMap().get(tasteFunktion);
        AbstractAction tasteAktion = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                alteTasteAktion.actionPerformed(e);
                int zeile = StaticVariables.table.getSelectedRow();
                if ((vk_down == 38 || vk_down == 40 || vk_down == 10) && StaticVariables.table.getSelectedRow() >= 0 && StaticVariables.table.getValueAt(StaticVariables.table.getSelectedRow(), 0) != null) {
                    StaticVariables.labelStatuszeile.setText(TableHauptfenster.this.getLabelText(StaticVariables.table, StaticVariables.table.getSelectedRow()));
                }
            }
        };
        StaticVariables.table.getActionMap().put(tasteFunktion, tasteAktion);
    }

    public String getLabelText(JTable table, int row) {
        String SuMa = (String)table.getValueAt(row, 0);
        String ret = "";
        if (table.getValueAt(row, 1).toString().equals("0")) {
            ret = "";
        } else {
            ret = ReadLanguageFile.operaLanguageProperties.getProperty(table.getValueAt(row, 1).toString(), "");
            if (ret != null && ret.length() > 0 && ret.startsWith("\"", 0) && ret.endsWith("\"")) {
                ret = ret.substring(1, ret.length() - 1);
            }
        }
        String retString = SuMa.length() > 0 && ret.length() > 0 ? String.valueOf(SuMa) + " (" + Messages.getString("TableHauptfenster2.7") + ": " + ret + ")" : (SuMa.length() > 0 ? SuMa : (ret.length() > 0 ? String.valueOf(Messages.getString("TableHauptfenster2.10")) + ": " + ret : ""));
        String zeile = String.valueOf(Messages.getString("TableHauptfenster2.13")) + ": " + (row + 1);
        retString = retString.length() > 0 ? String.valueOf(zeile) + " - " + retString : zeile;
        return retString;
    }

    private class RowDropTargetListener
    implements DropTargetListener {
        private RowDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            int targetRow = StaticVariables.table.rowAtPoint(dtde.getLocation());
            int selectedRow = StaticVariables.table.getSelectedRow();
            if (!(StaticVariables.table.hasFocus() && targetRow >= 0 || selectedRow >= 0)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(1);
            TableHauptfenster.this.dragFirstRow = StaticVariables.table.getSelectedRow();
            if (TableHauptfenster.this.dragFirstRow < 0) {
                TableHauptfenster.this.dragFirstRow = StaticVariables.table.rowAtPoint(dtde.getLocation());
            }
        }

        public void dragExit(DropTargetEvent dte) {
            TableHauptfenster.this.dragTargetRow = -1;
            StaticVariables.table.repaint();
            StaticVariables.table.setCursor(new Cursor(0));
            if (StaticVariables.table.getSelectedRow() >= 0 && StaticVariables.table.getValueAt(StaticVariables.table.getSelectedRow(), 0) != null) {
                StaticVariables.labelStatuszeile.setText(TableHauptfenster.this.getLabelText(StaticVariables.table, StaticVariables.table.getSelectedRow()));
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            int targetRow = StaticVariables.table.rowAtPoint(dtde.getLocation());
            int dragRow = StaticVariables.table.rowAtPoint(dtde.getLocation());
            if (TableHauptfenster.this.dragTargetRow != dragRow) {
                TableHauptfenster.this.dragTargetRow = dragRow;
                StaticVariables.table.repaint();
            }
            if (dragRow != TableHauptfenster.this.dragFirstRow) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable tr = dtde.getTransferable();
            try {
                if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(1);
                    Vector<String> data = StaticVariables.tableModel.getRowValues(TableHauptfenster.this.dragFirstRow);
                    int newRow = StaticVariables.table.rowAtPoint(dtde.getLocation());
                    StaticVariables.tableModel.dataSwap(TableHauptfenster.this.dragFirstRow, newRow);
                    StaticVariables.table.setRowSelectionInterval(newRow, newRow);
                    StaticVariables.table.repaint();
                    StaticVariables.table.updateUI();
                    dtde.getDropTargetContext().dropComplete(true);
                    TableHauptfenster.this.dragFirstRow = -1;
                }
            }
            catch (RuntimeException e) {
                System.out.println(e.toString());
            }
            TableHauptfenster.this.dragTargetRow = -1;
            if (StaticVariables.table.getSelectedRow() >= 0 && StaticVariables.table.getValueAt(StaticVariables.table.getSelectedRow(), 0) != null) {
                StaticVariables.labelStatuszeile.setText(TableHauptfenster.this.getLabelText(StaticVariables.table, StaticVariables.table.getSelectedRow()));
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        private JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            int row;
            if (!e.getValueIsAdjusting() && (row = this.table.getSelectedRow()) >= 0 && StaticVariables.tableModel.getRowCount() - 1 >= row && this.table.getValueAt(row, 0) != null) {
                StaticVariables.labelStatuszeile.setText(TableHauptfenster.this.getLabelText(this.table, row));
            }
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        TableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color spalte1 = new Color(231, 231, 255);
            Color selected = new Color(204, 204, 255);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                this.setForeground(Color.BLUE);
                this.setBackground(spalte1);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            if (isSelected) {
                this.setBackground(selected);
            }
            if (row == TableHauptfenster.this.dragTargetRow && TableHauptfenster.this.dragTargetRow != TableHauptfenster.this.dragFirstRow) {
                this.setBackground(new Color(204, 255, 204));
            }
            return this;
        }
    }
}

