#include <Winamp_Library.au3>

_Winamp_Example()

Func _Winamp_Example()
	;This example will start winamp, check if there is some songs in the list, if not, 
	;will show "Select File" dialog to add some song(s),
	;then will hit the Play button on some random song, set winamp's volume to 100%,
	;and set song position to halth of the total song lenght.
	
	_Winamp_Start(-1, 5)
	
	If @error Then
		MsgBox(16, "Error", StringFormat("There was an error (%d) executing Winamp Player.", @error) & _
			@CRLF & @CRLF & "OK   ===>   EXIT")
		
		Exit
	EndIf
	
	Local $aTracksList = _Winamp_GetPlayListToArray()
	Local $iTotalSongs = UBound($aTracksList)-1
	
	If $iTotalSongs < 1 Then
		Local $sSelectedSong = FileOpenDialog("Select Song", "C:\", "Media files (*.mp3;*.wav;*.mdi)", 7)
		If @error Then Exit
		
		If StringInStr($sSelectedSong, "|") Then
			Local $aSelectedSongs = StringSplit($sSelectedSong, "|")
			$iTotalSongs = 0
			
			For $i = 2 To UBound($aSelectedSongs)-1
				_Winamp_AddFile($aSelectedSongs[1] & "\" & $aSelectedSongs[$i])
				$iTotalSongs += 1
			Next
		Else
			_Winamp_AddFile($sSelectedSong)
			$iTotalSongs = 1
		EndIf
	EndIf
	
	Local $iRandom_Song = Random(0, $iTotalSongs-1, 1)
	
	_Winamp_Play($iRandom_Song)
	_Winamp_SetVolume(255)
	
	;We wait untill the song starting to play...
	While _Winamp_GetCurrentTrackPlayStatus() <> 1
		Sleep(100)
	WEnd
	
	Sleep(100)
	
	Local $iTrack_Lenght = _Winamp_GetCurrentTrackOutputTime(1)
	
	Sleep(100)
	
	_Winamp_Seek(Ceiling($iTrack_Lenght/2))
EndFunc
