#CS
Name: Simple Text Switcher -       -     (  Ctrl+`).
Author: Copyright  2008 - 2010 CreatoR's Lab (G.Sandler). All rights reserved.

AutoIt version: 3.2.8.1+

==========================================================================================================
: "Ghbdtn vbh"    " " ( ).

       (Simple_Txt_Switcher.ini)   Convert HotKey=,    ,    ( .).     (  Ctrl+Shift+`)    .  ( Exit HotKey=).

 Limit Window=   (  )      .
==========================================================================================================
#CE

#NoTrayIcon
#include <Misc.au3>

_Singleton("Simple_Txt_Switcher")

Opt("SendKeyDelay", 1)
Opt("SendKeyDownDelay", 1)

Global $sCharsTable_File 	= @ScriptDir & "\Chars_Table.txt"
Global $sConfig_File 		= StringTrimRight(@ScriptFullPath, 3) & "ini"

Global $sExit_HK 			= IniRead($sConfig_File, "Main", "Exit HotKey", "Ctrl Shift `")
Global $sConvert_HK 		= IniRead($sConfig_File, "Main", "Convert HotKey", "Ctrl `")

_Convert_HotKeys_Proc($sExit_HK)
_Convert_HotKeys_Proc($sConvert_HK)

HotKeySet($sConvert_HK, "_Convert_MainProc")
HotKeySet($sExit_HK, "_Quit_Proc")

While 1
	Sleep(1000)
WEnd

Func _Convert_MainProc()
	Local $sTmp_Exit_HK = IniRead($sConfig_File, "Main", "Exit HotKey", "Ctrl Shift `")
	Local $sTmp_Convert_HK = IniRead($sConfig_File, "Main", "Convert HotKey", "Ctrl `")
	Local $iLimit_Window = IniRead($sConfig_File, "Main", "Limit Window", "")
	
	_Convert_HotKeys_Proc($sTmp_Exit_HK)
	_Convert_HotKeys_Proc($sTmp_Convert_HK)
	
	If $sTmp_Exit_HK <> $sExit_HK Then
		HotKeySet($sExit_HK)
		
		$sExit_HK = $sTmp_Exit_HK
		_Convert_HotKeys_Proc($sExit_HK)
		
		HotKeySet($sExit_HK, "_Quit_Proc")
	EndIf
	
	If $sTmp_Convert_HK <> $sConvert_HK Then
		HotKeySet($sConvert_HK)
		
		$sConvert_HK = $sTmp_Convert_HK
		_Convert_HotKeys_Proc($sConvert_HK)
		
		HotKeySet($sConvert_HK, "_Convert_MainProc")
	EndIf
	
	If $iLimit_Window <> "" Then
		$sActiveWin_ClassName = _WinGetClassName(WinGetHandle("[ACTIVE]"))
		
		If $sActiveWin_ClassName <> $iLimit_Window And WinGetTitle("[ACTIVE]") <> $iLimit_Window Then
			Return
		EndIf
	EndIf
	
	Local $sOld_Clip = ClipGet()
	
	ClipPut("")
	_SendEx("^{Insert}")
	
	Local $sSelected_Text = ClipGet()
	Local $iTimer = TimerInit()
	
	While $sSelected_Text = "" And TimerDiff($iTimer) < 2000
		$sSelected_Text = ClipGet()
		Sleep(1)
	WEnd
	
	If $sSelected_Text = "" Then
		HotKeySet(@HotKeyPressed)
		_SendEx(@HotKeyPressed)
		HotKeySet($sConvert_HK, "_Convert_MainProc")
	Else
		Local $sNew_Clip = _ConvertText_Proc($sSelected_Text)
		
		ClipPut($sNew_Clip)
		_SendEx("+{Insert}")
		
		_RestoreSelection_Proc($sNew_Clip)
		
		ClipPut($sOld_Clip)
	EndIf
EndFunc

;If $iMode = 0 Then Russian language used
;If $iMode = 1 Then English language used
;If $iMode = -1 Then String Inverted
Func _ConvertText_Proc($sText, $iMode=-1)
	Local $iStringIsUpper = 0, $sTextRet = ""
	Local $aSplitTextArr = StringSplit($sText, "")
	Local $aLettersArr = _GetCharsTableArray_Proc($sCharsTable_File)
	
	For $i = 1 To $aSplitTextArr[0]
		Local $i_0 = 1, $i_1 = 0
		
		$iStringIsUpper = 0
		If StringIsUpper($aSplitTextArr[$i]) Then $iStringIsUpper = 1
		
		If $iMode = 0 Or ($iMode = -1 And StringIsASCII($sText)) Then
			$i_0 = 0
			$i_1 = 1
		EndIf
		
		For $j = 1 To $aLettersArr[0][0]
			If $aSplitTextArr[$i] = $aLettersArr[$j][$i_0] Then
				$aSplitTextArr[$i] = $aLettersArr[$j][$i_1]
				ExitLoop
			EndIf
		Next
		
		If $iStringIsUpper = 1 Then
			$aSplitTextArr[$i] = StringUpper($aSplitTextArr[$i])
		EndIf
		
		$sTextRet &= $aSplitTextArr[$i]
	Next
	
	Return $sTextRet
EndFunc

Func _RestoreSelection_Proc($sText)
	Local $iShifts = _GetStartShift_Proc($sText)
	
	Send("^+{LEFT " & $iShifts & "}")
	Send("^{Insert}")
	
	Local $sNewSelText = ClipGet()
	
	If StringLen($sNewSelText) > StringLen($sText) Then
		Send("+{RIGHT " & StringLen($sNewSelText) - StringLen($sText) & "}")
	EndIf
EndFunc

Func _GetStartShift_Proc($sText)
	StringRegExpReplace($sText, '\n', '')
	Local $iExtended = @extended
	
	$sText = StringStripWS($sText, 3)
	$sText = StringRegExpReplace($sText, '\s+|\t+', ' ')
	$sText = StringRegExpReplace($sText, '~|`|!|#|%|\^|&|\*|\(|\)|-|\+|=|\{|\}|''|"|;|:|/|\\|<|>|\?|,|\[|\]||||', '|')
	$sText = StringRegExpReplace($sText, '\|+', '|')
	
	Local $aWordsCountArr = StringRegExp($sText, "[\s\.:;,]*([--a-zA-Z0-9-_]+)[\s\.:;,]*", 3)
	
	StringRegExpReplace($sText, '\|', '')
	$iExtended += @extended + UBound($aWordsCountArr)
	
	Return $iExtended
EndFunc

Func _GetCharsTableArray_Proc($sCharsTable_File="Chars_Table.txt")
	Local $sAnsiStr = ".?"
	Local $sAsciiStr = "`qwertyuiop[]asdfghjkl;'zxcvbnm,./&"
	
	If FileExists($sCharsTable_File) Then
		Local $sRead_CharsTable = StringStripWS(FileRead($sCharsTable_File), 3)
		Local $aLettersArr = _Array2DCreate($sRead_CharsTable, @CRLF, "=")
		
		If Not @error Then
			Return $aLettersArr
		EndIf
	EndIf
	
	Local $iStrLenght = StringLen($sAnsiStr)
	
	Local $aLettersArr[$iStrLenght+1][2]
	$aLettersArr[0][0] = $iStrLenght
	
	For $i = 1 To $iStrLenght
		$aLettersArr[$i][0] = StringMid($sAsciiStr, $i, 1)
		$aLettersArr[$i][1] = StringMid($sAnsiStr, $i, 1)
	Next
	
	Return $aLettersArr
EndFunc

Func _SendEx($sSend_Data)
	Local $hUser32DllOpen = DllOpen("User32.dll")
	
	While _IsPressed("10", $hUser32DllOpen) Or _IsPressed("11", $hUser32DllOpen) Or _IsPressed("12", $hUser32DllOpen)
		Sleep(10)
	WEnd
	
	Send($sSend_Data)
	
	DllClose($hUser32DllOpen)
EndFunc

Func _Array2DCreate($sString, $s2D_Delim=@CRLF, $sData_Delim="|")
	Local $a2D_RetArr[1][1]
	Local $a2D_SplitArr = StringSplit($sString, $s2D_Delim)
	Local $aData_SplitArr
	
	For $i = 1 To $a2D_SplitArr[0]
		$aData_SplitArr = StringSplit($a2D_SplitArr[$i], $sData_Delim)
		
		If @error Or $aData_SplitArr[0] < 2 Then
			ContinueLoop
		EndIf
		
		$a2D_RetArr[0][0] += 1
		ReDim $a2D_RetArr[$a2D_RetArr[0][0]+1][2]
		
		$a2D_RetArr[$a2D_RetArr[0][0]][0] = StringStripWS($aData_SplitArr[1], 3)
		$a2D_RetArr[$a2D_RetArr[0][0]][1] = StringStripWS($aData_SplitArr[2], 3)
	Next
	
	If $a2D_RetArr[0][0] = 0 Then
		SetError(1)
	EndIf
	
	Return $a2D_RetArr
EndFunc

Func _Convert_HotKeys_Proc(ByRef $sHotKey_String)
	$sHotKey_String = StringReplace($sHotKey_String, "Ctrl", "^")
	$sHotKey_String = StringReplace($sHotKey_String, "Shift", "+")
	$sHotKey_String = StringReplace($sHotKey_String, "Alt", "!")
	$sHotKey_String = StringStripWS($sHotKey_String, 8)
	$sHotKey_String = StringLower($sHotKey_String)
EndFunc

Func _WinGetClassName($hWnd)
	Local $aClassName = DLLCall("user32.dll", "int", "GetClassName", "hWnd", $hWnd, "str", "", "int", 256)
	
	If Not @error And $aClassName[0] <> 0 Then
		Return $aClassName[2]
	EndIf
	
	Return @error
EndFunc

Func _Quit_Proc()
	Exit
EndFunc
